<?php

class Service {

	protected $post_type = 'service';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'posts_related_args', [ $this, 'posts_related_args' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Услуги', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Услуга', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Услуги', 'wescle' ),
			'name_admin_bar'     => __( 'Услугу', 'wescle' ),
			'all_items'          => __( 'Все услуги', 'wescle' ),
			'add_new_item'       => __( 'Добавить новую услугу', 'wescle' ),
			'add_new'            => __( 'Добавить услугу', 'wescle' ),
			'new_item'           => __( 'Новая услуга', 'wescle' ),
			'edit_item'          => __( 'Редактировать услугу', 'wescle' ),
			'update_item'        => __( 'Обновить услугу', 'wescle' ),
			'view_item'          => __( 'Просмотреть услугу', 'wescle' ),
			'search_items'       => __( 'Найти услугу', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'               => __( 'Услуга', 'wescle' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments' ),
			'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'menu_position'       => 5,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'menu_icon'           => 'dashicons-open-folder',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );

		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => _x( 'Категории услуг', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Категория услуги', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
				'new_item_name' => __( 'Новая категория услуги', 'wescle' ),
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => 'service-category' ),
		);
		$args_tax = apply_filters( 'wescle_cpt_service_cat_args', $args_tax, 'service_cat' );

		register_taxonomy(
			'service_cat',
			array( $this->post_type ),
			$args_tax
		);
	}

	public function posts_related_args( $args ) {
		global $post;

		$taxonomy = 'service_cat';

		if ( $post->post_type == $this->post_type ) {
			$terms = get_the_terms( $post, $taxonomy );
			if ( $terms ) {
				$args['tax_query'] = [
					[
						'taxonomy' => $taxonomy,
						'terms'    => wp_list_pluck( $terms, 'term_id' )
					]
				];
			}
		}

		return $args;
	}
}