<?php

class Review {

	protected $post_type = 'review';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Отзывы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Отзыв', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Отзывы', 'wescle' ),
			'name_admin_bar'     => __( 'Отзыв', 'wescle' ),
			'all_items'          => __( 'Все отзывы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый отзыв', 'wescle' ),
			'add_new'            => __( 'Добавить отзыв', 'wescle' ),
			'new_item'           => __( 'Новый отзыв', 'wescle' ),
			'edit_item'          => __( 'Редактировать отзыв', 'wescle' ),
			'update_item'        => __( 'Обновить отзыв', 'wescle' ),
			'view_item'          => __( 'Просмотреть отзыв', 'wescle' ),
			'search_items'       => __( 'Найти отзыв', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Отзыв', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail' ),
			//'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-buddicons-pm',
		);

		register_post_type( $this->post_type, $args );

		$labels = array(
			'name'               => _x( 'Видео-отзывы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Видео-отзыв', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Видео-отзывы', 'wescle' ),
			'name_admin_bar'     => __( 'Видео-отзыв', 'wescle' ),
			'all_items'          => __( 'Все видео-отзывы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый видео-отзыв', 'wescle' ),
			'add_new'            => __( 'Добавить видео-отзыв', 'wescle' ),
			'new_item'           => __( 'Новый видео-отзыв', 'wescle' ),
			'edit_item'          => __( 'Редактировать видео-отзыв', 'wescle' ),
			'update_item'        => __( 'Обновить видео-отзыв', 'wescle' ),
			'view_item'          => __( 'Просмотреть видео-отзыв', 'wescle' ),
			'search_items'       => __( 'Найти видео-отзыв', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Видео-отзыв', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
			//'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-video-alt',
		);

		register_post_type( 'videoreview', $args );
	}
}