<?php

class Program {

	protected $post_type = 'program_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Программы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Программа', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Программы и модули', 'wescle' ),
			'name_admin_bar'     => __( 'Программу', 'wescle' ),
			'all_items'          => __( 'Все программы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новую программу', 'wescle' ),
			'add_new'            => __( 'Добавить программу', 'wescle' ),
			'new_item'           => __( 'Новая программа', 'wescle' ),
			'edit_item'          => __( 'Редактировать программу', 'wescle' ),
			'update_item'        => __( 'Обновить программу', 'wescle' ),
			'view_item'          => __( 'Просмотреть программу', 'wescle' ),
			'search_items'       => __( 'Найти программу', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Программа', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'page-attributes' ),
			'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-schedule',
		);

		register_post_type( $this->post_type, $args );

		$labels = array(
			'name'               => _x( 'Спикеры', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Спикер', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Спикеры', 'wescle' ),
			'name_admin_bar'     => __( 'Спикера', 'wescle' ),
			'all_items'          => __( 'Спикеры', 'wescle' ),
			'add_new_item'       => __( 'Добавить нового спикера', 'wescle' ),
			'add_new'            => __( 'Добавить спикера', 'wescle' ),
			'new_item'           => __( 'Новый спикер', 'wescle' ),
			'edit_item'          => __( 'Редактировать спикера', 'wescle' ),
			'update_item'        => __( 'Обновить спикера', 'wescle' ),
			'view_item'          => __( 'Просмотреть спикера', 'wescle' ),
			'search_items'       => __( 'Найти спикера', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Спикер', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => 'edit.php?post_type=program_wescle',
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);

		register_post_type( 'speaker_program', $args );
	}
}