<?php

class Product {

	protected $post_type = 'product_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'posts_related_args', [ $this, 'posts_related_args' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Товары', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Товар', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Товары / Услуги', 'wescle' ),
			'name_admin_bar'     => __( 'Товар', 'wescle' ),
			'all_items'          => __( 'Все товары', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый товар', 'wescle' ),
			'add_new'            => __( 'Добавить товар', 'wescle' ),
			'new_item'           => __( 'Новый товар', 'wescle' ),
			'edit_item'          => __( 'Редактировать товар', 'wescle' ),
			'update_item'        => __( 'Обновить товар', 'wescle' ),
			'view_item'          => __( 'Просмотреть товар', 'wescle' ),
			'search_items'       => __( 'Найти товар', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'               => __( 'Товар', 'wescle' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments', 'page-attributes' ),
			'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'        => false,
			'public'              => true,
			'rewrite'             => array( 'slug' => 'prod_wescle' ),
			'show_ui'             => true,
			'show_in_menu'        => true,
			'menu_position'       => 5,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );

		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => _x( 'Категории товаров', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Категория товара', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
				'new_item_name' => __( 'Новая категория товара', 'wescle' ),
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => Helper::is_woocommerce_active() ? array( 'slug' => 'wescle-prod' ) : array( 'slug' => 'prod-category' ),
		);
		$args_tax = apply_filters( 'wescle_cpt_productcat_wescle_args', $args_tax, 'productcat_wescle' );

		register_taxonomy(
			'productcat_wescle',
			array( $this->post_type ),
			$args_tax
		);
	}

	public function posts_related_args( $args ) {
		global $post;

		$taxonomy = 'productcat_wescle';

		if ( $post->post_type == $this->post_type ) {
			$terms = get_the_terms( $post, $taxonomy );
			if ( $terms ) {
				$args['tax_query'] = [
					[
						'taxonomy' => $taxonomy,
						'terms'    => wp_list_pluck( $terms, 'term_id' )
					]
				];
			}
		}

		return $args;
	}
}