<?php

class PricePackage {

	protected $post_type = 'pricepackage_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Пакеты', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Пакет', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Пакеты', 'wescle' ),
			'name_admin_bar'     => __( 'Пакет', 'wescle' ),
			'all_items'          => __( 'Все пакеты', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый пакет', 'wescle' ),
			'add_new'            => __( 'Добавить пакет', 'wescle' ),
			'new_item'           => __( 'Новый пакет', 'wescle' ),
			'edit_item'          => __( 'Редактировать пакет', 'wescle' ),
			'update_item'        => __( 'Обновить пакет', 'wescle' ),
			'view_item'          => __( 'Просмотреть пакет', 'wescle' ),
			'search_items'       => __( 'Найти пакет', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Пакет', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'page-attributes' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-list-view',
		);

		register_post_type( $this->post_type, $args );

		$labels = array(
			'name'               => _x( 'Опции', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Опция', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Что входит в пакет', 'wescle' ),
			'name_admin_bar'     => __( 'Опция', 'wescle' ),
			'all_items'          => __( 'Что входит в пакет', 'wescle' ),
			'add_new_item'       => __( 'Добавить новую опцию', 'wescle' ),
			'add_new'            => __( 'Добавить опцию', 'wescle' ),
			'new_item'           => __( 'Новая опция', 'wescle' ),
			'edit_item'          => __( 'Редактировать опцию', 'wescle' ),
			'update_item'        => __( 'Обновить опцию', 'wescle' ),
			'view_item'          => __( 'Просмотреть опцию', 'wescle' ),
			'search_items'       => __( 'Найти опцию', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Опция', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'page-attributes' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => 'edit.php?post_type=pricepackage_wescle',
			'menu_position'     => 40,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);

		register_post_type( 'optionpackage_wescle', $args );
	}
}