<?php

class Price {

	protected $post_type = 'price_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Прайсы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Прайс', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Прайсы', 'wescle' ),
			'name_admin_bar'     => __( 'Прайс', 'wescle' ),
			'all_items'          => __( 'Все прайсы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый прайс', 'wescle' ),
			'add_new'            => __( 'Добавить прайс', 'wescle' ),
			'new_item'           => __( 'Новый прайс', 'wescle' ),
			'edit_item'          => __( 'Редактировать прайс', 'wescle' ),
			'update_item'        => __( 'Обновить прайс', 'wescle' ),
			'view_item'          => __( 'Просмотреть прайс', 'wescle' ),
			'search_items'       => __( 'Найти прайс', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Прайс', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'page-attributes' ),
			'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-list-view',
		);

		register_post_type( $this->post_type, $args );
	}
}