<?php

class Portfolio {

	protected $post_type = 'portfolio_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'posts_related_args', [ $this, 'posts_related_args' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Портфолио работ', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Портфолио', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Портфолио работ', 'wescle' ),
			'name_admin_bar'     => __( 'Портфолио', 'wescle' ),
			'all_items'          => __( 'Все портфолио работ', 'wescle' ),
			'add_new_item'       => __( 'Добавить новое портфолио', 'wescle' ),
			'add_new'            => __( 'Добавить портфолио', 'wescle' ),
			'new_item'           => __( 'Новое портфолио', 'wescle' ),
			'edit_item'          => __( 'Редактировать портфолио', 'wescle' ),
			'update_item'        => __( 'Обновить портфолио', 'wescle' ),
			'view_item'          => __( 'Просмотреть портфолио', 'wescle' ),
			'search_items'       => __( 'Найти портфолио', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'               => __( 'Портфолио', 'wescle' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments' ),
			'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'menu_position'       => 5,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'rewrite'             => array( 'slug' => 'portfolio' ),
			'menu_icon'           => 'dashicons-images-alt2',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );

		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => _x( 'Метки портфолио', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Метки портфолио', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новую метку', 'wescle' ),
				'new_item_name' => __( 'Новая метка', 'wescle' ),
				'view_item '    => __( 'Просмотреть метку', 'wescle' ),
				'edit_item'     => __( 'Изменить метку', 'wescle' ),
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => 'portfolio-tag' ),
		);
		$args_tax = apply_filters( 'wescle_cpt_portfolio_tag_args', $args_tax, 'portfolio_tag' );

		register_taxonomy(
			'portfolio_tag',
			array( $this->post_type ),
			$args_tax
		);
	}

	public function posts_related_args( $args ) {
		global $post;

		$taxonomy = 'portfolio_tag';

		if ( $post->post_type == $this->post_type ) {
			$terms = get_the_terms( $post, $taxonomy );
			if ( $terms ) {
				$args['tax_query'] = [
					[
						'taxonomy' => $taxonomy,
						'terms'    => wp_list_pluck( $terms, 'term_id' )
					]
				];
			}
		}

		return $args;
	}
}