<?php

class Popup {

	protected $post_type = 'popup_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter('manage_'. $this->post_type .'_posts_columns', array( $this, 'edit_posts_columns') );
		add_action('manage_'. $this->post_type .'_posts_custom_column', array( $this, 'custom_columns_data') );
	}

	public function register_post_type() {

		$labels = array(
			'name'                  => _x( 'Попапы', 'Post Type General Name', 'wescle' ),
			'singular_name'         => _x( 'Попап', 'Post Type Singular Name', 'wescle' ),
			'menu_name'             => __( 'Попапы', 'wescle' ),
			'name_admin_bar'        => __( 'Попап', 'wescle' ),
			'all_items'             => __( 'Все попапы', 'wescle' ),
			'add_new_item'          => __( 'Добавить новый попап', 'wescle' ),
			'add_new'               => __( 'Добавить попап', 'wescle' ),
			'new_item'              => __( 'Новый попап', 'wescle' ),
			'edit_item'             => __( 'Редактировать попап', 'wescle' ),
			'update_item'           => __( 'Обновить попап', 'wescle' ),
			'view_item'             => __( 'Просмотреть попап', 'wescle' ),
			'search_items'          => __( 'Найти попап', 'wescle' ),
			'not_found'             => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash'    => __( 'В корзине пусто', 'wescle' ),
			'featured_image'        => __( 'Изображение для попапа', 'wescle' ),
			'set_featured_image'    => __( 'Выбрать изображение', 'wescle' ),
			'remove_featured_image' => __( 'Удалить изображение', 'wescle' ),
			'use_featured_image'    => __( 'Установить изображение', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Попап', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-table-row-delete',
		);

		register_post_type( $this->post_type, $args );
	}

	function edit_posts_columns( $columns ) {
		$new_columns = [];

		foreach ( $columns as $key => $label ) {
			if ( $key == 'date' ) {
				$new_columns[ 'count_views' ] = __('Открытие попапа', 'wescle');
			}

			$new_columns[ $key ] = $label;
		}

		return $new_columns;
	}

	function custom_columns_data( $column ) {
		global $post;
		switch($column)
		{
			case 'count_views':
				echo intval( get_post_meta( $post->ID, 'count_views', 1 ) );
				break;
		}
	}
}