<?php

class Partner {

	protected $post_type = 'partner_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {
		$labels = array(
			'name'                  => _x( 'Партнеры', 'Post Type General Name', 'wescle' ),
			'singular_name'         => _x( 'Партнер', 'Post Type Singular Name', 'wescle' ),
			'menu_name'             => __( 'Партнеры', 'wescle' ),
			'name_admin_bar'        => __( 'Партнер', 'wescle' ),
			'all_items'             => __( 'Все партнеры', 'wescle' ),
			'add_new_item'          => __( 'Добавить нового партнера', 'wescle' ),
			'add_new'               => __( 'Добавить партнера', 'wescle' ),
			'new_item'              => __( 'Новый партнер', 'wescle' ),
			'edit_item'             => __( 'Редактировать партнера', 'wescle' ),
			'update_item'           => __( 'Обновить партнера', 'wescle' ),
			'view_item'             => __( 'Просмотреть партнера', 'wescle' ),
			'search_items'          => __( 'Найти партнера', 'wescle' ),
			'not_found'             => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash'    => __( 'В корзине пусто', 'wescle' ),
			'featured_image'        => __( 'Изображение для партнера', 'wescle' ),
			'set_featured_image'    => __( 'Выбрать изображение', 'wescle' ),
			'remove_featured_image' => __( 'Удалить изображение', 'wescle' ),
			'use_featured_image'    => __( 'Установить изображение', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Партнер', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			//'menu_icon'         => 'dashicons-table-row-delete',
		);

		register_post_type( $this->post_type, $args );

		register_taxonomy(
			'partnercat_wescle',
			array( $this->post_type ),
			array(
				'hierarchical'      => true,
				'labels'            => array(
					'name'          => _x( 'Категории партнеров', 'taxonomy general name', 'wescle' ),
					'singular_name' => _x( 'Категория партнеров', 'taxonomy singular name', 'wescle' ),
					'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
					'new_item_name' => __( 'Новая категория партнеров', 'wescle' ),
				),
				'public'            => false,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'query_var'         => true,
				'rewrite'           => array( 'slug' => 'partner-category' ),
				'show_admin_column' => true,
			)
		);
	}
}