<?php

class Mosaic {

	protected $post_type = 'mosaic_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'          => _x( 'Плитки-мозаика', 'Post Type General Name', 'wescle' ),
			'singular_name' => _x( 'Плитка-мозаика', 'Post Type Singular Name', 'wescle' ),
			'menu_name'     => __( 'Плитки-мозаика', 'wescle' ),
		);

		$args = array(
			'labels'            => $labels,
			'supports'          => array( 'title', 'page-attributes', 'thumbnail' ),
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 15,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );


		register_taxonomy(
			'mosaiccat_wescle',
			array( $this->post_type ),
			array(
				'hierarchical'      => true,
				'labels'            => array(
					'name'          => _x( 'Категории плиток', 'taxonomy general name', 'wescle' ),
					'singular_name' => _x( 'Категория плитки', 'taxonomy singular name', 'wescle' ),
					'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
					'new_item_name' => __( 'Новая категория', 'wescle' ),
				),
				'public'            => false,
				'show_ui'           => true,
				'show_in_rest'      => false,
				'show_admin_column' => true,
			)
		);
	}
}

new Mosaic();