<?php

class Licenses {

	protected $post_type = 'license_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Лицензии', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Лицензия', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Лицензии', 'wescle' ),
			'name_admin_bar'     => __( 'Лицензию', 'wescle' ),
			'all_items'          => __( 'Все лицензии', 'wescle' ),
			'add_new_item'       => __( 'Добавить новую лицензию', 'wescle' ),
			'add_new'            => __( 'Добавить лицензию', 'wescle' ),
			'new_item'           => __( 'Новая лицензия', 'wescle' ),
			'edit_item'          => __( 'Редактировать лицензию', 'wescle' ),
			'update_item'        => __( 'Обновить лицензию', 'wescle' ),
			'view_item'          => __( 'Просмотреть лицензию', 'wescle' ),
			'search_items'       => __( 'Найти лицензию', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Лицензия', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'page-attributes' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-money-alt',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args );

		register_post_type( $this->post_type, $args );

		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => _x( 'Категории лицензий', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Категория лицензий', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
				'new_item_name' => __( 'Новая категория лицензий', 'wescle' ),
			),
			'public'            => false,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'license-category' ),
			'show_admin_column' => true,
		);
		$args_tax = apply_filters( 'wescle_cpt_licensecat_wescle_args', $args_tax );

		register_taxonomy(
			'licensecat_wescle',
			array( $this->post_type ),
			$args_tax
		);
	}
}