<?php

class InfoTab {

	protected $post_type = 'infotab_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Инфо-табы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Инфо-таб', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Инфо-табы', 'wescle' ),
			'all_items'          => __( 'Все табы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый таб', 'wescle' ),
			'add_new'            => __( 'Добавить таб', 'wescle' ),
			'new_item'           => __( 'Новый таб', 'wescle' ),
			'edit_item'          => __( 'Редактировать таб', 'wescle' ),
			'update_item'        => __( 'Обновить таб', 'wescle' ),
			'view_item'          => __( 'Просмотреть таб', 'wescle' ),
			'search_items'       => __( 'Найти таб', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Инфо-таб', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'page-attributes' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 15,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );
	}
}

new InfoTab();