<?php

class Gallery {

	protected $post_type = 'gallery_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {
		$labels = array(
			'name'               => _x( 'Галереи', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Галерея', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Галереи', 'wescle' ),
			'name_admin_bar'     => __( 'Галерею', 'wescle' ),
			'all_items'          => __( 'Все галереи', 'wescle' ),
			'add_new_item'       => __( 'Добавить новую галерею', 'wescle' ),
			'add_new'            => __( 'Добавить галерею', 'wescle' ),
			'new_item'           => __( 'Новая галерея', 'wescle' ),
			'edit_item'          => __( 'Редактировать галерею', 'wescle' ),
			'update_item'        => __( 'Обновить галерею', 'wescle' ),
			'view_item'          => __( 'Просмотреть галерею', 'wescle' ),
			'search_items'       => __( 'Найти галерею', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Галерея', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-format-image',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args );

		register_post_type( $this->post_type, $args );

		register_taxonomy(
			'gallerycat_wescle',
			array( $this->post_type ),
			array(
				'hierarchical'      => true,
				'labels'            => array(
					'name'          => _x( 'Категории галереи', 'taxonomy general name', 'wescle' ),
					'singular_name' => _x( 'Категория галереи', 'taxonomy singular name', 'wescle' ),
					'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
					'new_item_name' => __( 'Новая категория галереи', 'wescle' ),
				),
				'public'            => false,
				'show_ui'           => true,
				'query_var'         => true,
				'show_admin_column' => true,
			)
		);
	}
}