<?php

class FAQ {

	protected $post_type = 'faq_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Инструкции', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Инструкция', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Инструкции', 'wescle' ),
			'name_admin_bar'     => __( 'Инструкцию', 'wescle' ),
			'all_items'          => __( 'Все инструкции', 'wescle' ),
			'add_new_item'       => __( 'Добавить новую инструкцию', 'wescle' ),
			'add_new'            => __( 'Добавить инструкцию', 'wescle' ),
			'new_item'           => __( 'Новая инструкция', 'wescle' ),
			'edit_item'          => __( 'Редактировать инструкцию', 'wescle' ),
			'update_item'        => __( 'Обновить инструкцию', 'wescle' ),
			'view_item'          => __( 'Просмотреть инструкцию', 'wescle' ),
			'search_items'       => __( 'Найти инструкцию', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Инструкция', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'page-attributes' ),
			//'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-info',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );


		register_taxonomy(
			'faqcat_wescle',
			array( $this->post_type ),
			array(
				'hierarchical'      => true,
				'labels'            => array(
					'name'          => _x( 'Категории инструкций', 'taxonomy general name', 'wescle' ),
					'singular_name' => _x( 'Категория инструкции', 'taxonomy singular name', 'wescle' ),
					'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
					'new_item_name' => __( 'Новая категория инструкции', 'wescle' ),
				),
				'public'            => false,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'show_admin_column' => true,
			)
		);
	}
}