<?php

class Event {

	protected $post_type = 'event_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {
		$labels = array(
			'name'               => _x( 'Мероприятия', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Мероприятие', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Мероприятия', 'wescle' ),
			'name_admin_bar'     => __( 'Мероприятие', 'wescle' ),
			'all_items'          => __( 'Все мероприятия', 'wescle' ),
			'add_new_item'       => __( 'Добавить новое мероприятие', 'wescle' ),
			'add_new'            => __( 'Добавить мероприятие', 'wescle' ),
			'new_item'           => __( 'Новое мероприятие', 'wescle' ),
			'edit_item'          => __( 'Редактировать мероприятие', 'wescle' ),
			'update_item'        => __( 'Обновить мероприятие', 'wescle' ),
			'view_item'          => __( 'Просмотреть мероприятие', 'wescle' ),
			'search_items'       => __( 'Найти мероприятие', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'               => __( 'Мероприятие', 'wescle' ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments', 'page-attributes' ),
			'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'menu_position'       => 5,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'post',
			'rewrite'             => array( 'slug' => 'event' ),
			'menu_icon'           => 'dashicons-calendar-alt',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );
	}
}