<?php

class Course {

	protected $post_type = 'course_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'single_template', [ $this, 'course_template' ] );
		add_filter( 'taxonomy_template', [ $this, 'course_cat_template' ] );
		add_filter( 'theme_page_templates', [ $this, 'theme_page_templates' ] );
		add_filter( 'wescle_comment_form_args', [ $this, 'add_rating_comment_form' ] );
		add_action( 'comment_post', [ $this, 'save_rating_comment_form' ] );
		add_action( 'edit_comment', [ $this, 'edit_comment_rating' ] );
		add_action( 'deleted_comment', [ $this, 'deleted_comment_rating' ], 10, 2 );
	}

	public function register_post_type() {
		$labels = array(
			'name'               => _x( 'Курсы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Курс', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Курсы', 'wescle' ),
			'name_admin_bar'     => __( 'Курс', 'wescle' ),
			'all_items'          => __( 'Все курсы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый курс', 'wescle' ),
			'add_new'            => __( 'Добавить курс', 'wescle' ),
			'new_item'           => __( 'Новый курс', 'wescle' ),
			'edit_item'          => __( 'Редактировать курс', 'wescle' ),
			'update_item'        => __( 'Обновить курс', 'wescle' ),
			'view_item'          => __( 'Просмотреть курс', 'wescle' ),
			'search_items'       => __( 'Найти курс', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Курсы', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments' ),
			'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => true,
			'rewrite'           => array( 'slug' => 'course' ),
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args );

		register_post_type( $this->post_type, $args );

		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => _x( 'Категории курсов', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Категория курса', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
				'new_item_name' => __( 'Новая категория курса', 'wescle' ),
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'course-category' ),
			'show_admin_column' => true,
		);
		$args_tax = apply_filters( 'wescle_cpt_coursecat_wescle_args', $args_tax );

		register_taxonomy(
			'coursecat_wescle',
			array( $this->post_type ),
			$args_tax
		);

		$args_tax = array(
			'hierarchical'      => false,
			'labels'            => array(
				'name'          => _x( 'Навыки', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Навык', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новый навык', 'wescle' ),
				'new_item_name' => __( 'Новый навык', 'wescle' ),
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'course-skill' ),
			'show_admin_column' => true,
		);
		$args_tax = apply_filters( 'wescle_cpt_coursetag_wescle_args', $args_tax );

		register_taxonomy(
			'coursetag_wescle',
			array( $this->post_type ),
			$args_tax
		);

		$labels = array(
			'name'               => _x( 'Видео для курса', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Видео', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Видео', 'wescle' ),
			'name_admin_bar'     => __( 'Видео', 'wescle' ),
			'all_items'          => __( 'Видео для курсов', 'wescle' ),
			'add_new_item'       => __( 'Добавить новое видео курса', 'wescle' ),
			'add_new'            => __( 'Добавить видео', 'wescle' ),
			'new_item'           => __( 'Новое видео', 'wescle' ),
			'edit_item'          => __( 'Редактировать видео', 'wescle' ),
			'update_item'        => __( 'Обновить видео', 'wescle' ),
			'view_item'          => __( 'Просмотреть видео', 'wescle' ),
			'search_items'       => __( 'Найти видео', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'           => __( 'Видео', 'wescle' ),
			'labels'          => $labels,
			'supports'        => array( 'title', 'editor', 'thumbnail' ),
			'show_in_rest'    => false, // Add Gutenberg Support
			'hierarchical'    => false,
			'public'          => false,
			'show_ui'         => true,
			'show_in_menu'    => 'edit.php?post_type=' . $this->post_type,
			'capability_type' => 'post',
		);
		register_post_type( 'course_video', $args );
	}

	public function course_template( $template ) {
		if ( is_singular( $this->post_type ) ) {
			$new_template = locate_template( array( 'template-parts/singular/course.php' ) );
			if ( '' != $new_template ) {
				$template = $new_template;
			}
		}

		return $template;
	}

	public function course_cat_template( $template ) {
		if ( is_tax( [ 'coursecat_wescle', 'coursetag_wescle' ] ) ) {
			$new_template = locate_template( array( 'template-parts/taxonomy/coursecat_wescle.php' ) );
			if ( '' != $new_template ) {
				$template = $new_template;
			}
		}

		return $template;
	}

	public function theme_page_templates( $templates ) {
		if ( ! get_theme_mod( 'module_course_enabled' ) ) {
			foreach ( $templates as $key => $name ) {
				if ( strpos( $key, 'templates/template-courses.php' ) !== false ) {
					unset( $templates[ $key ] );
				}
			}
		}

		return $templates;
	}

	public function add_rating_comment_form( $args ) {
		if ( get_theme_mod( 'course_rating_enabled', true ) && is_singular( 'course_wescle' ) ) {
			$args['comment_field'] .= '<p class="comment-form-rating"><select name="rating" id="rating" required>
						<option value="">' . esc_html__( 'Ваша оценка', 'wescle' ) . '</option>
						<option value="5">' . esc_html__( 'Отлично', 'wescle' ) . '</option>
						<option value="4">' . esc_html__( 'Хорошо', 'wescle' ) . '</option>
						<option value="3">' . esc_html__( 'Средне', 'wescle' ) . '</option>
						<option value="2">' . esc_html__( 'Неплохо', 'wescle' ) . '</option>
						<option value="1">' . esc_html__( 'Очень плохо', 'wescle' ) . '</option>
					</select></p>';
		}

		return $args;
	}

	public function save_rating_comment_form( $comment_id ) {
		if ( get_theme_mod( 'course_rating_enabled', true ) && isset( $_POST['rating'] ) ) {
			$rating = intval( wp_unslash( $_POST['rating'] ) );
			if ( $rating ) {
				update_comment_meta( $comment_id, 'rating', $rating ); // WPCS: input var ok.

				$post           = get_post( get_comment( $comment_id )->comment_post_ID );
				$average_rating = Helper::course_get_average_ratings( $post->ID );
				if ( $average_rating ) {
					update_post_meta( $post->ID, 'rating', $average_rating['avg'] );
				}
				else {
					delete_post_meta( $post->ID, 'rating' );
				}
			}
		}
	}

	public function edit_comment_rating( $comment_id ) {
		if ( get_theme_mod( 'course_rating_enabled', true ) ) {
			$post = get_post( get_comment( $comment_id )->comment_post_ID );
			if ( 'course_wescle' === $post->post_type ) {
				$average_rating = Helper::course_get_average_ratings( $post->ID );
				if ( $average_rating ) {
					update_post_meta( $post->ID, 'rating', $average_rating['avg'] );
				}
				else {
					delete_post_meta( $post->ID, 'rating' );
				}
			}
		}
	}

	public function deleted_comment_rating( $comment_id, $comment ) {
		if ( get_theme_mod( 'course_rating_enabled', true ) ) {
			$post = get_post( $comment->comment_post_ID );
			if ( 'course_wescle' === $post->post_type ) {
				$average_rating = Helper::course_get_average_ratings( $post->ID );
				if ( $average_rating ) {
					update_post_meta( $post->ID, 'rating', $average_rating['avg'] );
				}
				else {
					delete_post_meta( $post->ID, 'rating' );
				}
			}
		}
	}
}