<?php

class Catalog {

	protected $post_type = 'catalog_item';
	protected static $post_type_public = false;
	protected static $load_map_script = false;

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'manage_' . $this->post_type . '_posts_columns', array( $this, 'stock_posts_columns' ) );
		add_action( 'manage_' . $this->post_type . '_posts_custom_column', array( $this, 'stock_column_data' ) );
		add_filter( 'admin_footer', array( $this, 'include_css' ) );

		add_filter( 'single_template', [ $this, 'catalog_single_template' ] );
		add_filter( 'taxonomy_template', [ $this, 'catalog_cat_template' ] );
		add_filter( 'search_template', [ $this, 'catalog_cat_template' ] );
		add_filter( 'theme_page_templates', [ $this, 'theme_page_templates' ] );
		add_filter( 'wescle_sidebar_name', [ $this, 'sidebar_catalog' ], 10, 2 );
		add_filter( 'posts_related_args', [ $this, 'posts_related_args' ] );

		add_shortcode( 'catalog_map', [ 'Catalog', 'shortcode_catalog_map' ] );
		add_filter( 'wp_footer', [ 'Catalog', 'enqueue_google_maps' ], 90 );
		add_filter( 'get_the_archive_description', [ $this, 'map_in_content' ] );

		add_action( 'template_redirect', [ 'Catalog', 'redirect_add_to_cart' ], 5 );
		add_action( 'template_redirect', [ 'Catalog', 'filter_catalog_cat' ], 5 );
		add_action( 'pre_get_posts', [ 'Catalog', 'pre_get_posts' ], 5 );

		add_action( 'save_post', [ $this, 'delete_transient_data' ], 99 );
		add_action( 'delete_post', [ $this, 'delete_transient_data' ], 99 );
		add_action( 'generate_rewrite_rules', [ $this, 'delete_transient_data' ], 99 );

		add_action( 'wp_ajax_decrement_catalog_count', array( $this, 'ajax_decrement_catalog_count' ) );
		add_action( 'wp_ajax_nopriv_decrement_catalog_count', array( $this, 'ajax_decrement_catalog_count' ) );
		add_action( 'woocommerce_update_order', array( $this, 'change_catalog_count_order' ), 10, 2 );
	}

	public function register_post_type() {
		$post_values = Helper::get_customizer_post_values();

		$cpt_name = get_theme_mod( 'module_catalog_post_name', Helper::get_default_theme_data( 'module_catalog_post_name' ) );
		if ( ! $cpt_name ) {
			$cpt_name = Helper::get_default_theme_data( 'module_catalog_post_name' );
		}
		$cpt_singular_name = get_theme_mod( 'module_catalog_singular_name', Helper::get_default_theme_data( 'module_catalog_singular_name' ) );
		if ( ! $cpt_singular_name ) {
			$cpt_singular_name = Helper::get_default_theme_data( 'module_catalog_singular_name' );
		}
		$tax_name = get_theme_mod( 'module_catalog_tax_name', Helper::get_default_theme_data( 'module_catalog_tax_name' ) );
		if ( ! $tax_name ) {
			$tax_name = Helper::get_default_theme_data( 'module_catalog_tax_name' );
		}
		$tax_singular_name = get_theme_mod( 'module_catalog_tax_singular_name', Helper::get_default_theme_data( 'module_catalog_tax_singular_name' ) );
		if ( ! $tax_singular_name ) {
			$tax_singular_name = Helper::get_default_theme_data( 'module_catalog_tax_singular_name' );
		}

		$labels    = array(
			'name'          => $cpt_name,
			'singular_name' => $cpt_singular_name,
		);
		$is_public = get_theme_mod( 'module_catalog_item_public', true );
		if ( isset( $post_values['module_catalog_item_public'] ) && ! $post_values['module_catalog_item_public'] ) {
			$is_public = false;
		}
		$args                   = array(
			'label'             => $cpt_singular_name,
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments' ),
			'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => $is_public,
			'rewrite'           => array( 'slug' => 'catalog-item' ),
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);
		$args                   = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );
		self::$post_type_public = $args['public'];
		register_post_type( $this->post_type, $args );


		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => $tax_name,
				'singular_name' => $tax_singular_name,
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'rewrite'           => array(
				'slug'         => 'catalog-category',
				'with_front'   => false,
				'hierarchical' => true,
			),
			'show_admin_column' => true,
		);
		$args_tax = apply_filters( 'wescle_cpt_catalogcat_wescle_args', $args_tax, 'catalogcat_wescle' );
		register_taxonomy(
			'catalogcat_wescle',
			array( $this->post_type ),
			$args_tax
		);


		$badge_post_type = 'badge_catalog';
		$labels          = array(
			'name'          => _x( 'Лейблы', 'Post Type General Name', 'wescle' ),
			'singular_name' => _x( 'Лейбл', 'Post Type Singular Name', 'wescle' ),
		);
		$args = array(
			'label'             => __( 'Лейбл', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => 'edit.php?post_type=' . $this->post_type,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);
		$args            = apply_filters( 'wescle_cpt_' . $badge_post_type . '_args', $args, $badge_post_type );
		register_post_type( $badge_post_type, $args );


		$info_post_type = 'info_catalog';
		$labels         = array(
			'name'          => _x( 'Инфо-блоки', 'Post Type General Name', 'wescle' ),
			'singular_name' => _x( 'Инфо-блок', 'Post Type Singular Name', 'wescle' ),
		);
		$args           = array(
			'label'             => __( 'Инфо-блоки', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => 'edit.php?post_type=' . $this->post_type,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => false,
			'capability_type'   => 'post',
		);
		$args           = apply_filters( 'wescle_cpt_' . $info_post_type . '_args', $args, $info_post_type );
		register_post_type( $info_post_type, $args );

		add_filter( 'manage_' . $info_post_type . '_posts_columns', array( $this, 'info_catalog_posts_columns' ) );
		add_action( 'manage_' . $info_post_type . '_posts_custom_column', array( $this, 'info_catalog_column_data' ) );
	}

	function info_catalog_posts_columns( $columns ) {
		$new_columns = [];

		foreach ( $columns as $key => $label ) {
			$new_columns[ $key ] = $label;

			if ( $key == 'title' ) {
				$new_columns['icon'] = __( 'Иконка', 'wescle' );
				$new_columns['text'] = __( 'Описание', 'wescle' );
			}
		}

		return $new_columns;
	}

	function info_catalog_column_data( $column ) {
		global $post;
		switch ( $column ) {
			case 'icon':
				echo '<div class="column-image">' . wp_get_attachment_image( get_post_meta( $post->ID, 'icon_id', 1 ), 'medium' ) . '</div>';
				break;
			case 'text':
				echo get_post_meta( $post->ID, 'text', 1 );
				break;
		}
	}

	public function delete_transient_data() {
		global $wescle_filters;

		delete_transient( 'wescle_badge_catalog_data' );
		delete_transient( 'wescle_catalog_locations' );

		if ( $wescle_filters && is_array( $wescle_filters ) ) {
			foreach ( $wescle_filters as $taxonomy => $item ) {
				delete_transient( 'wescle_filter_nav_counts_' . $taxonomy );
			}
		}
	}

	function stock_posts_columns( $columns ) {
		if ( ! get_theme_mod( 'module_catalog_stock_enabled', true ) ) {
			return $columns;
		}

		$new_columns = [];

		foreach ( $columns as $key => $label ) {
			$new_columns[ $key ] = $label;

			if ( $key == 'title' ) {
				$new_columns['stock'] = __( 'Запасы', 'wescle' );
			}
		}

		return $new_columns;
	}

	function stock_column_data( $column ) {
		global $post;
		switch ( $column ) {
			case 'stock':
				echo self::html_stock_status( $post );
				break;
		}
	}

	function include_css() {
		$screen = get_current_screen();
		if ( $screen && $screen->base == 'edit' && $screen->post_type == 'catalog_item' ) {
			echo '<link rel="stylesheet" href="' . get_template_directory_uri() . '/assets/css/includes/index/wescle-transport.min.css" media="all">';
		}
	}

	public function catalog_single_template( $template ) {
		if ( is_singular( $this->post_type ) ) {
			$new_template = locate_template( array( 'template-parts/singular/catalog_item.php' ) );
			if ( '' != $new_template ) {
				$template = $new_template;
			}
		}

		return $template;
	}

	public function catalog_cat_template( $template ) {
		if ( is_tax( Helper::get_catalog_taxs() ) || ( is_search() && $_REQUEST['post_type'] == 'catalog' ) ) {
			$new_template = locate_template( array( 'template-parts/taxonomy/catalogcat_wescle.php' ) );
			if ( Helper::is_catalog_cat_map() ) {
				$new_template = locate_template( array( 'template-parts/taxonomy/catalogcat_wescle-map.php' ) );
			}
			if ( '' != $new_template ) {
				$template = $new_template;
			}
		}

		return $template;
	}

	public function theme_page_templates( $templates ) {
		if ( ! get_theme_mod( 'module_catalog_enabled' ) ) {
			foreach ( $templates as $key => $name ) {
				if ( strpos( $key, 'templates/template-catalog_wescle.php' ) !== false ) {
					unset( $templates[ $key ] );
				}
			}
		}

		return $templates;
	}

	public function sidebar_catalog( $name, $post ) {
		if ( $post->post_type == $this->post_type ) {
			$name = 'catalog';
		}

		return $name;
	}

	public function posts_related_args( $args ) {
		global $post;

		$taxonomy = 'catalogcat_wescle';

		if ( $post->post_type == $this->post_type ) {
			$terms = get_the_terms( $post, $taxonomy );
			if ( $terms ) {
				$args['tax_query'] = [
					[
						'taxonomy' => $taxonomy,
						'terms'    => wp_list_pluck( $terms, 'term_id' )
					]
				];
			}
		}

		return $args;
	}

	public static function shortcode_catalog_map( $atts ) {
		$atts = shortcode_atts( array(
			'center_lat' => 0,
			'center_lng' => 0,
			'height'     => 400,
			'zoom'       => 7,
			'class'      => '',
		), $atts, 'catalog_map' );

		if ( is_admin() ) {
			return;
		}

		if ( ! get_theme_mod( 'google_map_api_key' ) ) {
			return;
		}

		$locations = self::catalog_locations_data();
		if ( ! $locations ) {
			return;
		}

		if ( is_tax() && ! is_tax( [ 'catalogcat_wescle' ] ) ) {
			return;
		}

		if ( is_tax( [ 'catalogcat_wescle' ] ) ) {
			$current_term = get_queried_object();
			$taxonomy_key = $current_term->taxonomy == 'catalogcat_wescle' ? 'catalog_cat' : 'catalog_loc';
			foreach ( $locations as $key => $location ) {
				if ( ! in_array( $current_term->term_id, $location[ $taxonomy_key ] ) ) {
					unset( $locations[ $key ] );
				}
			}
			if ( ! $locations ) {
				return;
			}
		}
		$locations = array_values( $locations );

		self::$load_map_script = true;

		$map_bounds = false;

		$center_lat = $atts['center_lat'];
		$center_lng = $atts['center_lng'];
		if ( ! $center_lat || ! $center_lng ) {
			if ( count( $locations ) > 1 ) {
				$map_bounds = true;
			}
			foreach ( $locations as $location ) {
				$center_lat = $location['lat'];
				$center_lng = $location['lng'];
				break;
			}
		}

		ob_start();
		$map_zoom = apply_filters( 'catalog_map_zoom', $atts['zoom'] );
		?>
        <div id="map" class="catalog-map <?php echo $atts['class']; ?>">
            <div id="catalog_map" style="height:<?php echo $atts['height']; ?>px;width:100%;"></div>
        </div>
        <script>
            const catalog_locations = <?php echo json_encode( $locations ); ?>;

            function initMapCatalogItem() {
                const map_center = {lat: <?php echo $center_lat; ?>, lng: <?php echo $center_lng; ?> };
                const map = new google.maps.Map(document.getElementById("catalog_map"), {
                    zoom: <?php echo $map_zoom; ?>,
                    center: map_center,
                });
                const infoWindow = new google.maps.InfoWindow({
                    content: "",
                    disableAutoPan: true,
                });
				<?php if ( $map_bounds ) { ?>
                const bounds = new google.maps.LatLngBounds();
				<?php } ?>

                // Create markers.
                for (let i = 0; i < catalog_locations.length; i++) {
                    const marker = new google.maps.Marker({
                        position: new google.maps.LatLng(catalog_locations[i].lat, catalog_locations[i].lng),
                        icon: catalog_locations[i].icon_url,
                        map: map
                    });
					<?php if ( $map_bounds ) { ?>
                    bounds.extend(marker.getPosition());
					<?php } else { ?>
                    if (catalog_locations[i].lat * 1 == map_center.lat && catalog_locations[i].lng * 1 == map_center.lng) {
                        marker.set("title", "active_marker");
                    }
					<?php } ?>

                    let target = catalog_locations[i].custom_url ? ' target="_blank" ' : '';
                    let image_html = catalog_locations[i].image_url ? '<div class="infoWindow-image"><a href="' + catalog_locations[i].post_url + '"' + target + '><img src="' + catalog_locations[i].image_url + '" alt=""></a></div>' : '';
                    let info_html = '<div class="infoWindow">' + image_html + '<div class="infoWindow-text">' + catalog_locations[i].title + '</div></div>';

                    marker.addListener("click", () => {
                        infoWindow.setContent(info_html);
                        infoWindow.open(map, marker);
                    });
                }
				<?php if ( $map_bounds ) { ?>
                map.fitBounds(bounds);
				<?php } else { ?>
                map.addListener('tilesloaded', function () {
                    var node = document.querySelector('[title="active_marker"]');
                    node.removeAttribute("title");
                });
				<?php } ?>
            }

            window.initMap = initMapCatalogItem;
        </script>
		<?php
		return ob_get_clean();
	}

	public static function enqueue_google_maps() {
		if ( self::$load_map_script ) {
			$api_key = get_theme_mod( 'google_map_api_key' );
			?>
            <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $api_key; ?>&callback=initMapCatalogItem&v=weekly"></script>
			<?php
		}
	}

	public function map_in_content( $text ) {
		if ( is_tax( 'catalogcat_wescle' ) && ! Helper::is_catalog_cat_map() ) {
			$show_map     = get_theme_mod( 'catalog_archive_show_map' );
			$top_show_map = get_theme_mod( 'catalog_archive_top_show_map' );
			if ( $show_map && $top_show_map ) {
				$text .= do_shortcode( '[catalog_map class="_small-map"]' );
			}
		}

		return $text;
	}

	public static function catalog_locations_data() {
		$locations = get_transient( 'wescle_catalog_locations' );

		$isset_filters = ( WsclAdminFilters::get_filter_nav_chosen() || isset( $_GET['orderby'] ) ) ? true : false;
		if ( $isset_filters ) {
			$locations = false;
		}

		if ( false === $locations ) {
			$locations = [];

			$posts = get_posts( [
				'post_type'      => 'catalog_item',
				'posts_per_page' => - 1,
			] );
			foreach ( $posts as $post ) {
				$lat = get_post_meta( $post->ID, 'lat', 1 );
				$lng = get_post_meta( $post->ID, 'lng', 1 );
				if ( ! $lat || ! $lng ) {
					continue;
				}

				$image_url = '';
				if ( $img_id = get_post_thumbnail_id( $post ) ) {
					$image_url = wp_get_attachment_image_url( $img_id, 'medium' );
				}

				$icon_url = '';
				if ( $img_id = get_post_meta( $post->ID, 'map_image', 1 ) ) {
					$icon_url = wp_get_attachment_image_url( $img_id );
				}

				$catalog_cat_ids = [];
				if ( $terms = get_the_terms( $post, 'catalogcat_wescle' ) ) {
					$catalog_cat = wp_list_pluck( $terms, 'term_id' );
					foreach ( $catalog_cat as $term_id ) {
						$catalog_cat_ids[] = $term_id;
						$parents_ids       = get_ancestors( $term_id, 'catalogcat_wescle', 'taxonomy' );
						$catalog_cat_ids   = array_merge( $catalog_cat_ids, $parents_ids );
					}
					$catalog_cat_ids = array_unique( $catalog_cat_ids );
				}

				$post_url = get_post_meta( $post->ID, 'custom_url', 1 );
				if ( ! $post_url ) {
					$post_url = get_permalink( $post );
				}

				$locations[] = [
					'lat'         => $lat,
					'lng'         => $lng,
					'title'       => $post->post_title,
					'image_url'   => $image_url,
					'icon_url'    => $icon_url,
					'catalog_cat' => $catalog_cat_ids,
					'post_url'    => $post_url,
					'custom_url'  => get_post_meta( $post->ID, 'custom_url', 1 ),
				];
			}

			if ( ! $isset_filters ) {
				set_transient( 'wescle_catalog_locations', $locations );
			}
		}

		return $locations;
	}

	public static function redirect_add_to_cart() {
		global $post;

		if ( isset( $_GET['add-to-cart'] ) && ! $_GET['add-to-cart'] && ( is_singular( 'catalog_item' ) || isset( $_GET['for-catalog'] ) ) ) {
			$post_id    = is_singular( 'catalog_item' ) ? $post->ID : $_GET['for-catalog'];
			$product_id = get_post_meta( $post_id, 'related_product', 1 );
			if ( $product_id ) {
				WC()->cart->empty_cart();
				$url          = self::$post_type_public ? get_permalink( $post ) : home_url();
				$redirect_url = add_query_arg( [ 'add-to-cart' => $product_id, 'for-catalog' => '' ], $url );
				wp_redirect( $redirect_url );
			}
		}

		if ( isset( $_GET['add-to-cart'] ) && $_GET['add-to-cart'] && isset( $_GET['for-catalog'] ) ) {
			wc_clear_notices();
			wp_redirect( wc_get_checkout_url() );
			exit;
		}
	}

	public static function filter_catalog_cat() {
		if ( isset( $_GET['catalog_cat'] ) && $_GET['catalog_cat'] ) {
			$redirect_url = get_term_link( intval( $_GET['catalog_cat'] ), 'catalogcat_wescle' );
			$redirect_url .= '?' . $_SERVER['QUERY_STRING'];
			$redirect_url = remove_query_arg( 'catalog_cat', $redirect_url );
			wp_redirect( $redirect_url );
			exit;
		}
	}

	public static function pre_get_posts( $query ) {
		if ( is_admin() ) {
			return;
		}

		if ( $query->is_main_query() && $query->is_tax( Helper::get_catalog_taxs() ) ) {
			$param_orderby = $_REQUEST['orderby'] ?? '';
			if ( $param_orderby ) {
				if ( 'price' == $param_orderby ) {
					$query->set( 'meta_key', 'price' );
					$query->set( 'orderby', 'meta_value_num' );
					$query->set( 'order', 'ASC' );
				}

				if ( 'top' == $param_orderby ) {
					$query->set( 'meta_key', 'is_top' );
					$query->set( 'orderby', 'meta_value_num' );
					$query->set( 'order', 'DESC' );
				}

				if ( 'popularity' == $param_orderby ) {
					$query->set( 'meta_key', 'count_order' );
					$query->set( 'orderby', 'meta_value_num' );
					$query->set( 'order', 'DESC' );
				}
			}
		}
	}

	public static function is_public() {
		return self::$post_type_public;
	}

	public static function get_statuses() {
		$data = [
			'instock'    => Helper::get_default_theme_data( 'module_catalog_label_instock' ),
			'outofstock' => Helper::get_default_theme_data( 'module_catalog_label_outofstock' ),
		];

		$data = apply_filters( 'wescle_catalog_statuses', $data );

		return $data;
	}

	public static function get_stock_status( $post_id = 0 ) {
		if ( ! get_theme_mod( 'module_catalog_stock_enabled', true ) ) {
			return;
		}

		$post = get_post( $post_id );
		if ( ! $post ) {
			return;
		}

		$status = '';

		$related_product_id = get_post_meta( $post->ID, 'related_product', 1 );
		if ( $related_product_id && Helper::is_woocommerce_active() ) {
			$product = wc_get_product( $related_product_id );
			if ( $product ) {
				$status = $product->get_stock_status();
				if ( 'onbackorder' === $status ) {
					$status = 'instock';
				}
				if ( $status == 'instock' && $product->get_manage_stock() ) {
					$count_stock = $product->get_stock_quantity();
					if ( $count_stock && $count_stock <= wc_get_low_stock_amount( $product ) ) {
						$status = 'minstock';
					}
				}
			}
		}
		else {
			$status_stock = get_post_meta( $post->ID, 'stock_status', 1 );
			$manage_stock = get_post_meta( $post->ID, 'manage_stock', 1 );
			$count_stock  = intval( get_post_meta( $post->ID, 'stock', 1 ) );

			if ( ! $manage_stock ) {
				$status = $status_stock;
			}
			else {
				$status = 'instock';

				if ( $count_stock <= 0 ) {
					$status = 'outofstock';
				}
				else {
					$min_stock = get_theme_mod( 'module_catalog_min_stock', 2 );
					if ( $count_stock <= $min_stock ) {
						$status = 'minstock';
					}
				}
			}
		}

		return $status;
	}

	public static function get_stock_count( $post_id = 0 ) {
		$post = get_post( $post_id );
		if ( ! $post ) {
			return;
		}

		$count_stock = false;

		$related_product_id = get_post_meta( $post->ID, 'related_product', 1 );
		if ( $related_product_id && Helper::is_woocommerce_active() ) {
			$product = wc_get_product( $related_product_id );
			if ( $product && $product->get_manage_stock() ) {
				$count_stock = $product->get_stock_quantity();
			}
		}
		else {
			$manage_stock = get_post_meta( $post->ID, 'manage_stock', 1 );
			if ( $manage_stock ) {
				$count_stock = intval( get_post_meta( $post->ID, 'stock', 1 ) );
			}
		}

		return $count_stock;
	}

	public static function html_stock_status( $post_id = 0 ) {
		if ( ! get_theme_mod( 'module_catalog_stock_enabled', true ) ) {
			return;
		}

		$post = get_post( $post_id );
		if ( ! $post ) {
			return;
		}

		$html   = '';
		$status = self::get_stock_status( $post );

		if ( $status == 'instock' ) {
			$label       = get_theme_mod( 'module_catalog_label_instock', Helper::get_default_theme_data( 'module_catalog_label_instock' ) );
			$count       = self::get_stock_count( $post->ID );
			$class_count = '';
			if ( $count ) {
				$count       .= ' ';
				$class_count = ' in-stock_count';
			}
			$html = '<div class="wescle-transport-item__available in-stock' . $class_count . '">' . $count . $label . '</div>';
		}
        elseif ( $status == 'outofstock' ) {
	        $label = get_theme_mod( 'module_catalog_label_outofstock', Helper::get_default_theme_data( 'module_catalog_label_outofstock' ) );
	        $html  = '<div class="wescle-transport-item__available out-of-stock">' . $label . '</div>';
        }
        elseif ( $status == 'minstock' ) {
			$label = get_theme_mod( 'module_catalog_label_minstock', Helper::get_default_theme_data( 'module_catalog_label_minstock' ) );
			$html  = '<div class="wescle-transport-item__available available-on-backorder">' . $label . '</div>';
		}

		return $html;
	}

	public function ajax_decrement_catalog_count() {
		global $wpdb;

		$post_type  = $this->post_type;
		$post_title = stripslashes_deep( $_POST['title'] );

		$sql_query = "SELECT ID FROM {$wpdb->prefix}posts
                         WHERE post_type = '{$post_type}' 
                         AND post_title='%s'";

		$post_id = $wpdb->get_var( $wpdb->prepare( $sql_query, $post_title ) );
		if ( $post_id ) {
			$post = get_post( $post_id );
			if ( $post ) {
				if ( get_post_meta( $post->ID, 'manage_stock', 1 ) ) {
					$count_stock = intval( get_post_meta( $post->ID, 'stock', 1 ) );
					if ( $count_stock > 0 ) {
						$count_stock --;
						update_post_meta( $post->ID, 'stock', $count_stock );
					}
				}

				$count_order = intval( get_post_meta( $post->ID, 'count_order', 1 ) );
				$count_order ++;
				update_post_meta( $post->ID, 'count_order', $count_order );
			}
		}

		exit;
	}

	public function change_catalog_count_order( $order_id, $order ) {
		$items = $order->get_items();
		foreach ( $items as $item ) {
			$product_id = $item->get_product_id();

			$catalog_posts = get_posts( [
				'post_type'      => 'catalog_item',
				'posts_per_page' => 1,
				'meta_key'       => 'related_product',
				'meta_value'     => $product_id,
			] );
			if ( $catalog_posts ) {
				$catalog_post = current( $catalog_posts );
				$count_order  = intval( get_post_meta( $product_id, 'total_sales', 1 ) );
				if ( $count_order ) {
					update_post_meta( $catalog_post->ID, 'count_order', $count_order );
				}
			}
		}
	}

}