<?php

class BadgeProduct {

	protected $post_type = 'badge_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_action( 'save_post', [ $this, 'delete_transient_data' ], 99 );
		add_action( 'delete_post', [ $this, 'delete_transient_data' ], 99 );
	}

	public function register_post_type() {
		$labels = array(
			'name'               => _x( 'Значки', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Значок', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Значки', 'wescle' ),
			'name_admin_bar'     => __( 'Значок', 'wescle' ),
			'all_items'          => __( 'Все значки', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый значок', 'wescle' ),
			'add_new'            => __( 'Добавить значок', 'wescle' ),
			'new_item'           => __( 'Новый значок', 'wescle' ),
			'edit_item'          => __( 'Редактировать значок', 'wescle' ),
			'update_item'        => __( 'Обновить значок', 'wescle' ),
			'view_item'          => __( 'Просмотреть значок', 'wescle' ),
			'search_items'       => __( 'Найти значок', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Значок', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'thumbnail' ),
			'show_in_rest'      => false, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => 'edit.php?post_type=product',
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args );

		register_post_type( $this->post_type, $args );
	}

	public function delete_transient_data() {
		delete_transient( 'wescle_badges_data' );
	}
}

new BadgeProduct();