jQuery(document).ready(function ($) {

    $('body').on('click', '.widget-content .repeater-fields .button-link-delete', function (e) {
        e.preventDefault();

        $(this).closest('.repeater-row').remove();
        $('.widget-contact_v2-input-hidden').trigger('change');
    });

    $('body').on('click', '.widget-content .repeater-add-item', function (e) {
        e.preventDefault();

        var block_fields = $(this).prev();
        block_fields.append(block_fields.find('.repeater-field-hidden').html());
    });

    $('body').on('change', '.color-picker', function () {
        $('.widget-contact_v2-input-hidden').trigger('change');
    })

    $('body').on('change', '.button_type-radio_fields input', function () {
        show_hide_button_setting_colors();
    })

    function show_hide_button_setting_colors() {
        $('.button_type-radio_fields').each(function () {
            var block_fields = $(this);
            var animation_fields = block_fields.next('.button-color-settings').find('.wrap-button_blick_color, .wrap-button_blick_color_hover, .wrap-button_blick_speed');
            var type = block_fields.find('input:checked').val();

            if ('default' == type) {
                block_fields.next('.button-color-settings').hide();
            } else {
                block_fields.next('.button-color-settings').show();
            }

            if ('animation' == type) {
                animation_fields.show();
            } else {
                animation_fields.hide();
            }
        });
    }

    show_hide_button_setting_colors();

    function initColorPicker() {
        $('#widgets-right .color-picker, .inactive-sidebar .color-picker').wpColorPicker({
            'change': function () {
                $('.widget-contact_v2-input-hidden').trigger('change');
            }
        });
    }

    initColorPicker();

    // Executes wpColorPicker function after AJAX is fired on saving the widget
    $(document).ajaxComplete(function () {
        initColorPicker();
        show_hide_button_setting_colors();
    });
});