jQuery(document).ready(function ($) {
    let custom_posts = [];
    let custom_taxs = [];

    $('#wescle_form_import').submit(function () {
        if (!$('#wescle_import').val()) return false;

        let spinner = $(this).find('.spinner');
        spinner.css('visibility', 'visible');

        let form = $(this);
        let formData = new FormData(form[0]);

        $.ajax({
            url: ajaxurl,
            data: formData,
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            type: 'POST',
            success: function (data) {
                if (data.success) {
                    console.log(data);

                    custom_posts = data.data.custom_posts;
                    custom_taxs = data.data.custom_taxs;

                    upload_images(data.data.images_url);
                } else {
                    spinner.css('visibility', 'hidden');
                    alert('Error: ' + data.data);
                }
            }
        }).fail(function (xhr, status, error) {
            alert(error);
            console.log(xhr.responseText);
        })

        return false;
    });

    function upload_images(images_url) {
        if (images_url.length < 1) {
            wescle_import_custom_taxs(custom_taxs);
            return;
        }

        $.post(
            ajaxurl,
            {
                action: 'wescle_import_upload_image',
                img_url: images_url.shift(),
            },
            function (data) {
                console.log(data);
                addToTextarea($('#log'), data);
                upload_images(images_url);
            }
        ).fail(function (xhr, status, error) {
            alert(error);
            console.log(xhr.responseText);
        });
    }

    function wescle_import_custom_taxs(custom_taxs) {
        if (!custom_taxs || custom_taxs.length < 1) {
            wescle_import_custom_posts(custom_posts);
            return;
        }

        $.post(
            ajaxurl,
            {
                action: 'wescle_import_custom_taxs',
                term_data: custom_taxs.shift(),
            },
            function (data) {
                console.log(data);
                addToTextarea($('#log'), data);
                wescle_import_custom_taxs(custom_taxs);
            }
        ).fail(function (xhr, status, error) {
            alert(error);
            console.log(xhr.responseText);
        });
    }

    function wescle_import_custom_posts(custom_posts) {
        if (!custom_posts || custom_posts.length < 1) {
            wescle_import_add_page();
            return;
        }

        $.post(
            ajaxurl,
            {
                action: 'wescle_import_custom_posts',
                post_data: custom_posts.shift(),
            },
            function (data) {
                console.log(data);
                addToTextarea($('#log'), data);
                wescle_import_custom_posts(custom_posts);
            }
        ).fail(function (xhr, status, error) {
            alert(error);
            console.log(xhr.responseText);
        });
    }

    function wescle_import_add_page() {
        $.post(
            ajaxurl,
            {
                action: 'wescle_import_add_page',
            },
            function (data) {
                console.log(data);
                addToTextarea($('#log'), data);

                $('#wescle_import').val('');
                $('#wescle_form_import').find('.spinner').css('visibility', 'hidden');
            }
        ).fail(function (xhr, status, error) {
            alert(error);
            console.log(xhr.responseText);
        });
    }

    function addToTextarea($ta, text) {
        let val = $ta.val();
        if (val) {
            $ta.val(val + '\n' + text);
        } else {
            $ta.val(text);
        }
        $ta.scrollTop($ta[0].scrollHeight);
    }
});