jQuery(function ($) {

    // on upload button click
    $('body').on('click', '.profile-image-upl', function (e) {

        e.preventDefault();

        var button = $(this),
            custom_uploader = wp.media({
                //title: 'Set Profile Image',
                library: {
                    // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                    type: 'image'
                },
                button: {
                    //text: 'Use this image' // button label text
                },
                multiple: false
            }).on('select', function () { // it also has "open" and "close" events
                var attachment = custom_uploader.state().get('selection').first().toJSON();
                var size = button.attr('data-size');

                var img_src = '';

                if (attachment.sizes === undefined) {
                    img_src = attachment.url;
                } else {
                    if (typeof (attachment.sizes[size]) == 'undefined') {
                        size = 'thumbnail';
                    }

                    if (typeof (attachment.sizes[size]) == 'undefined') {
                        img_src = attachment.url;
                    } else {
                        img_src = attachment.sizes[size]['url'];
                    }
                }

                button.html('<img src="' + img_src + '">').next().show();
                button.html('<img src="' + img_src + '">').next().next().val(attachment.id);
            }).open();
    });

    // on remove button click
    $('body').on('click', '.profile-image-remove', function (e) {
        e.preventDefault();

        var button = $(this);
        button.next().val(''); // emptying the hidden field
        button.hide();
        var td_block = button.closest('td').find('.profile-image-upl');
        td_block.html(button.attr('data-title_upload'));
    });

    var $description = $('#description');
    if ($description.length > 0) {
        $description.parents('tr').remove();
    }

});