window.addEventListener('DOMContentLoaded', () => {
  const throttle = (func, ms) => {
    let isThrottled = false;
    let savedArgs = null;
    let savedThis = null;

    function wrapper() {
      if (isThrottled) {
        savedArgs = arguments;
        savedThis = this;
        return;
      }

      func.apply(this, arguments);
      isThrottled = true;
      setTimeout(() => {
        isThrottled = false;
        if (savedArgs) {
          wrapper.apply(savedThis, savedArgs);
          savedArgs = savedThis = null;
        }
      }, ms);
    }

    return wrapper;
  };

  document.addEventListener('click', (e) => {
    const target = e.target;

    if (document.querySelector('._site-settings__categories')) {
      const categories = document.querySelector('._site-settings__categories');

      if (target.closest('._categories-toggle')) {
        categories.classList.toggle('_active');
      }

      if ((!target.closest('._categories-list') || target.closest('._categories-list'))
          && !target.closest('._categories-toggle')
          && categories.classList.contains('_active')) {
        categories.classList.remove('_active');
      }
    }
  });

  if (document.querySelector('._site-settings__categories')) {
    const categories = document.querySelector('._site-settings__categories');
    const blocks = document.querySelectorAll('._site-settings__section');
    const links = document.querySelectorAll('._categories-list a');

    window.addEventListener('scroll', throttle(() => {
          const curPos = window.scrollY;

          const removeActive = () => {
            blocks.forEach((block, i) => {
              block.classList.remove('_current');
              links[i].classList.remove('_active');
            });
          };

          const getCurrentIndex = (id) => {
            let index = 0;
            links.forEach((link, i) => {
              if (link.getAttribute('href').replace('#', '') === id) {
                index = i;
              }
            });
            return index;
          };

          blocks.forEach(block => {
            const top = block.getBoundingClientRect().top + window.pageYOffset - block.offsetHeight / 2;

            if (curPos >= top) {
              removeActive();
              block.classList.add('_current');
              const currentID = block.id;
              const curIndex = getCurrentIndex(currentID);
              links[curIndex].classList.add('_active');
            }
          });

        }, 400),
        {passive: true});

    document.addEventListener('click', (e) => {
      const target = e.target;

      if (target.closest('._categories-list a')) {
        links.forEach(el => el.classList.remove('_active'));
        target.closest('._categories-list a').classList.add('_active');
        categories.classList.remove('_active');
      }
    });
  }
});

jQuery(document).ready(function ($) {
  $('.customizer_sections_checkbox').change(function () {
    let parent_block = $(this).closest('._content-block');
    parent_block.find('._content-block__img').prepend('<span class="spinner"></span>');
    $.post(
        ajaxurl,
        $(this).closest('form').serialize() + '&action=save_customizer_sections',
        function (data) {
          parent_block.find('.spinner').remove();
        }
    )
  });
});