(function ($) {
    wp.customize.bind('ready', function () {
        var customize = this;

        $(document.body).on('click', '.customizer-edit', function () {
            var data_control = $(this).data('control');
            if (data_control) {
                customize.control(data_control.name).focus();
            }

            var data_section = $(this).data('section');
            if (data_section) {
                customize.section(data_section.name).focus();
            }
        });

        $(document.body).on('click', '#customize-control-phone_others .repeater-row-header', function (e) {
            show_hide_phone_operator($(this));
            show_hide_phone_username($(this));
        });

        $(document.body).on('change', 'select[data-field="phone_type"]', function (e) {
            show_hide_phone_operator($(this));
            show_hide_phone_username($(this));
        });

        $(document.body).on('click', '#customize-control-phone_others .repeater-add', function (e) {
            setTimeout(function () {
                show_hide_phone_username($('#customize-control-phone_others').find('.repeater-row:last').find('.repeater-row-header'));
            }, 100);
        });

        function show_hide_phone_operator(obj) {
            var parent_block = obj.closest('li');

            var phone_operator_block = parent_block.find('.repeater-field-phone_operator');
            phone_operator_block.hide();

            if (parent_block.find('select[data-field="phone_type"]').val() == 'tel') {
                phone_operator_block.show();
            }
        }

        function show_hide_phone_username(obj) {
            var parent_block = obj.closest('li');

            var phone_username_block = parent_block.find('.repeater-field-phone_username');
            phone_username_block.hide();

            var phone_type = parent_block.find('select[data-field="phone_type"]').val();

            if (phone_type == 'telegram' || phone_type == 'skype' || phone_type == 'wechat') {
                phone_username_block.show();
            }
        }

        $(document.body).on('click', '#customize-control-woo_blocks_items .repeater-row-header', function (e) {
            show_hide_store_block_inner($(this));
        });

        $(document.body).on('change', '.repeater-field-woo_block_type input, .repeater-field-woo_block_product_type input, .repeater-field-woo_block_slider_enabled input', function (e) {
            show_hide_store_block_inner($(this));
        });

        $(document.body).on('click', '#sub-accordion-section-woo_blocks .repeater-add', function (e) {
            setTimeout(function () {
                show_hide_store_block_inner($('#sub-accordion-section-woo_blocks').find('.repeater-row:last').find('.repeater-row-header'));
            }, 100);
        });

        function show_hide_store_block_inner(obj) {
            var parent_block = obj.closest('li');

            var blocks_type_cat = parent_block.find('.repeater-field-woo_block_category_limit, .repeater-field-woo_block_category_select, .repeater-field-woo_block_category_shadow, .repeater-field-woo_block_category_show_count, .repeater-field-woo_block_category_count_at_img');
            var blocks_type_product = parent_block.find('.repeater-field-woo_block_category, .repeater-field-woo_block_limit, .repeater-field-woo_block_product_type, .repeater-field-woo_block_products, .repeater-field-woo_block_product_stock_enabled, .repeater-field-woo_block_product_rating_enabled');

            var block_type = parent_block.find('.repeater-field-woo_block_type input:checked').val();

            if (block_type == 'category') {
                blocks_type_cat.show();
                blocks_type_product.hide();
            } else if (block_type == 'product') {
                blocks_type_product.show();
                blocks_type_cat.hide();
            } else {
                blocks_type_cat.hide();
                blocks_type_product.hide();
            }

            var product_type = parent_block.find('.repeater-field-woo_block_product_type input:checked').val();
            var blocks_by_product = parent_block.find('.repeater-field-woo_block_category, .repeater-field-woo_block_products');
            if (block_type == 'product' && product_type == 'custom') {
                blocks_by_product.show();
            } else {
                blocks_by_product.hide();
            }

            var slider_enabled = parent_block.find('.repeater-field-woo_block_slider_enabled input').prop('checked');
            var blocks_by_slider = parent_block.find('.repeater-field-woo_block_count_slides, .repeater-field-woo_block_slider_arrow, .repeater-field-woo_block_slider_arrow_mobile, .repeater-field-woo_block_slider_dots, .repeater-field-woo_block_slider_speed');
            var block_grid_count = parent_block.find('.repeater-field-woo_block_category_grid_count');
            if (!slider_enabled) {
                blocks_by_slider.hide();
                block_grid_count.show();
            } else {
                blocks_by_slider.show();
                block_grid_count.hide();
            }
        }

        $(document.body).on('click', '#customize-control-product_tabs_items .repeater-row-header', function (e) {
            show_hide_tab_block_inner($(this));
        });

        $(document.body).on('change', '.repeater-field-tab_block_type input, .repeater-field-tab_block_product_type input, .repeater-field-tab_block_slider_enabled input', function (e) {
            show_hide_tab_block_inner($(this));
        });

        $(document.body).on('click', '#sub-accordion-section-woo_blocks .repeater-add', function (e) {
            setTimeout(function () {
                show_hide_tab_block_inner($('#sub-accordion-section-woo_blocks').find('.repeater-row:last').find('.repeater-row-header'));
            }, 100);
        });

        function show_hide_tab_block_inner(obj) {
            var parent_block = obj.closest('li');
            var blocks_by_product = parent_block.find('.repeater-field-tab_block_category, .repeater-field-tab_block_products');
            var product_type = parent_block.find('.repeater-field-tab_block_product_type input:checked').val();

            if (product_type == 'custom') {
                blocks_by_product.show();
            } else {
                blocks_by_product.hide();
            }
        }

        $(document.body).on('click', '#sub-accordion-section-home_blocks .repeater-row-header', function (e) {
            parent_block = $(this).closest('li');

            var current_text = parent_block.find('.repeater-field-block_post_card_type .select2-selection__rendered').text();
            var current_value = '';
            parent_block.find('select[data-field="block_post_card_type"] option').each(function () {
                if ($(this).text() == current_text) {
                    current_value = $(this).attr('value');
                }
            });

            show_hide_post_card_opacity($(this), current_value);
        });

        $(document.body).on('change', '.repeater-field-block_post_card_type select', function (e) {
            show_hide_post_card_opacity($(this));
        });

        $(document.body).on('click', '#sub-accordion-section-home_blocks .repeater-add', function (e) {
            setTimeout(function () {
                show_hide_post_card_opacity($('#sub-accordion-section-home_blocks').find('.repeater-row:last').find('.repeater-row-header'), 'default');
            }, 100);
        });

        function show_hide_post_card_opacity(obj, current_value) {
            var parent_block = obj.closest('li');

            var blocks_opacity = parent_block.find('.repeater-field-block_post_card_opacity');
            var blocks_excerpt = parent_block.find('.repeater-field-visibility_excerpt');
            var block_type = parent_block.find('.repeater-field-block_post_card_type select').val();

            if (block_type == 'vertical' || current_value == 'vertical') {
                blocks_opacity.show();
                blocks_excerpt.hide();
            } else {
                blocks_opacity.hide();
                blocks_excerpt.show();
            }

            var blocks_columns = parent_block.find('.repeater-field-block_post_card_columns');
            if (block_type == 'default' || current_value == 'default') {
                blocks_columns.show();
            } else {
                blocks_columns.hide();
            }
        }

        $(document.body).on('click', '#customize-control-banner_shares_slides_logic .repeater-row-header', function (e) {
            show_hide_timer_type($(this));
        });

        $(document.body).on('change', '.repeater-field-type input', function (e) {
            show_hide_timer_type($(this));
        });

        $(document.body).on('click', '#customize-control-banner_shares_slides_logic .repeater-add', function (e) {
            setTimeout(function () {
                show_hide_timer_type($('#customize-control-banner_shares_slides_logic').find('.repeater-row:last').find('.repeater-row-header'));
            }, 100);
        });

        function show_hide_timer_type(obj) {
            var parent_block = obj.closest('li');

            var block_date = parent_block.find('.repeater-field-date');
            var block_timer = parent_block.find('.repeater-field-hours');
            var timer_type = parent_block.find('.repeater-field-type input:checked').val();

            if (timer_type == 'date') {
                block_date.show();
                block_timer.hide();
            } else {
                block_date.hide();
                block_timer.show();
            }
        }

        $(document.body).on('click', '#customize-control-home_map_items .repeater-row-header', function (e) {
            show_hide_map_contact($(this));
        });

        $(document.body).on('change', '.repeater-field-map_contact input', function (e) {
            show_hide_map_contact($(this));
        });

        $(document.body).on('click', '#customize-control-home_map_items .repeater-add', function (e) {
            setTimeout(function () {
                show_hide_map_contact($('#customize-control-home_map_items').find('.repeater-row:last').find('.repeater-row-header'));
            }, 100);
        });

        function show_hide_map_contact(obj) {
            var parent_block = obj.closest('li');

            var contact_enabled = parent_block.find('.repeater-field-map_contact input').prop('checked');
            var blocks = parent_block.find('.repeater-field-map_contact_title,.repeater-field-map_contact_text,.repeater-field-map_contact_phone,.repeater-field-map_contact_email,.repeater-field-map_contact_button1_text,.repeater-field-map_contact_button2_text,.repeater-field-map_contact_button1_url,.repeater-field-map_contact_button2_url');

            if (contact_enabled) {
                blocks.show();
            } else {
                blocks.hide();
            }
        }

        /* IMPORT demo content */
        $(document.body).on('click', '.button_import_demo', function (e) {
            var parent_block = $(this).closest('.wrap-democontent');
            var demo_block = parent_block.attr('data-block_key');
            var demo_block_alt = parent_block.attr('data-block_key_alt');
            var demo_value = parent_block.find('input:checked').val();

            if (!demo_value) {
                return;
            }

            if (!window.confirm(server_data.labels['import_demo'])) {
                return;
            }

            parent_block.addClass('loading');
            $.post(
                ajaxurl,
                {
                    action: 'import_demo_block',
                    block_key: demo_block,
                    block_key_alt: demo_block_alt,
                    data_type: demo_value,
                },
                function (data) {
                    if (data.status == 'ok') {
                        // console.log('kirki');
                        // console.log(kirki);
                        console.log(data);
                        is_reload = false;
                        $.each(data.updated_data, function (key, value_data) {
                            if (key.indexOf('_items') !== -1) {
                                is_reload = true;
                            }
                        });

                        $.each(data.updated_data, function (key, value_data) {
                            var value_type = value_data[0];
                            var value = value_data[1];

                            if (key.indexOf('_items') === -1) {
                                $('input[data-id="' + key + '"], select[data-id="' + key + '"], input[data-customize-setting-link="' + key + '"], textarea#kirki-editor-' + key).val(value);
                                console.log(value_type + ' = ' + key + ' = ' + value);

                                if (value_type == 'select') {
                                    $('select[data-id="' + key + '"]').trigger('change');
                                }
                                if (value_type == 'color') {
                                    $('input[data-id="' + key + '"]').trigger('change');
                                }
                                if (value_type == 'editor') {
                                    var textarea_id = 'kirki-editor-' + key;
                                    var text = $('#' + textarea_id).val();

                                    tinyMCE.get(textarea_id).setContent(text);
                                }
                                if (value_type == 'image') {
                                    var block = $('#customize-control-' + key);
                                    if (block.length) {
                                        block.find('.placeholder').remove();
                                        block.find('.thumbnail').remove();
                                        block.find('.image-upload-remove-button').show();
                                        block.find('.image-wrapper').prepend('<div class="thumbnail thumbnail-image"><img src="' + value + '" alt=""></div>')
                                    }
                                }
                            }
                        });

                        if (is_reload) {
                            location.reload();
                        } else {
                            wp.customize.previewer.refresh();
                            /*if ( data.scroll_to ) {
                                wp.customize.previewer.send('scroll', $(data.scroll_to).offset().top+170 );
                            }*/
                            parent_block.find('input:checked').prop('checked', false);
                            setTimeout(function () {
                                parent_block.removeClass('loading');
                            }, 2000);

                            // alert($('input[data-id="home_about_color_bg"]').val());
                            // alert($('select[data-id="home_about_link_id"]').val());
                        }
                    } else {
                        alert('Not found data!');
                    }
                }
            );
        });

        $('body').on('click', '#reset_theme_options', function (e) {
            e.preventDefault();
            if (confirm(server_data.labels.reset_options)) {
                location.href = $(this).attr('data-href');
            }
        });

        // Show/Hide block sortable
        $('body').on('change', "input[id$='_enabled']", function (e) {
            let key_block_sortable = $(this).attr('data-customize-setting-link');

            key_block_sortable = key_block_sortable.replace('home_blocks', 'block_posts');
            key_block_sortable = key_block_sortable.replace('home_licensewescle', 'licenses');
            key_block_sortable = key_block_sortable.replace('home_why_site', 'why');
            key_block_sortable = key_block_sortable.replace('home_videos_max', 'videos_max');
            key_block_sortable = key_block_sortable.replace('home_videos2', 'videos2');
            key_block_sortable = key_block_sortable.replace('home_videos', 'videos_carousel');

            key_block_sortable = key_block_sortable.replace('home_', '');
            key_block_sortable = key_block_sortable.replace('_enabled', '');
            let li_block = $('#customize-control-home_block_sortable li[data-value="' + key_block_sortable + '"]');
            if ($(this).prop('checked') === true) {
                li_block.show();
            } else {
                li_block.hide();
            }
        });
    });

    //var customize = wp.customize;

    /*
    customize.previewer.bind( 'preview-edit', function( data ) {
        var data = JSON.parse( data );
        console.log( '2data' );
        console.log( data );
        /*var control = customize.control( data.name );

        control.focus();
    } );
*/

})(jQuery);