jQuery(document).ready(function ($) {
    $('.annotation-comment-form__bottom .btn[type="reset"]').click(function () {
        $('#annotation-post_id').val('');
    });

    // Change annotation item
    $('body').on('click', '.annotation-item__buttons button', function () {
        let button_type = $(this).attr('data-type');
        let post_id = $(this).attr('data-post_id');

        if (button_type == 'change') {
            let username = $('#annotation-item__hidden-text-' + post_id).attr('data-username');
            $('.annotation-comment-form__for .annotation-comment-form__name').text(username);

            let text = $('#annotation-item__hidden-text-' + post_id).html();
            text = text.replaceAll("<br>", "\n");

            $('#annotation-input').val(text).focus();
            $('#input_pin_id').val(post_id);
            $('#annotation_form_action').val('create_new_pin');
            $('#annotation-main-form button[type="reset"]').removeClass('_hide');
        } else {
            $.post(
                server_data.url,
                {
                    'action': 'change_pin',
                    'button_action': button_type,
                    'post_id': post_id,
                },
                function (data) {
                    //console.log(data);
                }
            )

            if (button_type == 'delete' || button_type == 'success') {
                $(this).closest('.annotation-item').remove();
                $('.annotation-id[data-pin-id="' + post_id + '"]').remove();

                if ($('.annotation-item-post').length == 0) {
                    $('.annotation-desc').closest('.annotation').addClass('without-comments');
                }
            }
        }
    })

    // Change comment annotation
    $('body').on('click', '.annotation-comment__buttons button', function () {
        let parent_block = $(this).closest('.annotation-item-post');
        let button_type = $(this).attr('data-type');
        let comment_id = $(this).attr('data-id');

        if (button_type == 'change') {
            let username = $('#annotation-comment__hidden-text-' + comment_id).attr('data-username');
            $('.annotation-comment-form__for .annotation-comment-form__name').text(username);

            let text = $('#annotation-comment__hidden-text-' + comment_id).html();
            text = text.replaceAll("<br>", "\n");

            $('.btn-mention').addClass('hide');

            let form = $('#annotation-main-form');
            form.find('textarea').val(text).focus();
            $('#input_comment_id').val(comment_id);
            $('#annotation_form_action').val('add_comment_pin');
            $('#annotation-main-form button[type="reset"]').removeClass('_hide');
        } else if (button_type == 'delete') {
            $.post(
                server_data.url,
                {
                    'action': 'delete_comment_pin',
                    'comment_id': comment_id,
                    'post_id': parent_block.attr('data-pin-id')
                },
                function (data) {
                    data = JSON.parse(data);
                    parent_block.find('.annotation-answers-count span').html(data.count_answers);
                }
            )

            $(this).closest('.annotation-item').remove();
        }
    });

    $('body').on('input propertychange', '#annotation-input', function () {
        $('#annotation-main-form button[type="reset"]').removeClass('_hide');
    })

    $('body').on('click', '.btn-answer', function () {
        $('.btn-mention').addClass('hide');
    })

    $('body').on('click', '.btn-answer-pin', function () {
        $('#annotation_form_action').val('add_comment_pin');
        $('#input_comment_post_ID').val($(this).attr('data-pin_id'));
        $('#input_comment_parent').val(0);
    })

    $('body').on('click', '.btn-answer-comment', function () {
        $('#annotation_form_action').val('add_comment_pin');
        $('#input_comment_post_ID').val($(this).attr('data-pin_id'));
        $('#input_comment_parent').val($(this).attr('data-comment_ID'));
    })

    $('body').on('click', '.annotation-comment-form__users-list a', function () {
        let rel_users = $(this).attr('data-id');
        $('#input_rel_users').val(rel_users);
    })

    // RESET button
    $('#annotation-main-form button[type="reset"]').click(function () {
        $('.btn-mention').removeClass('hide');
        $('#annotation-input').val('');
        $('#input_rel_users').val('');
        $('#input_pin_id').val('');
        $('#input_comment_id').val('');
        $('#input_comment_post_ID').val('');
        $('#input_comment_parent').val('');
        $('#annotation_form_action').val('create_new_pin');
    })

    $('#annotation-button-submit').click(function () {
        let text = $('#annotation-input').val();
        if (!text) {
            return;
        }

        $('#annotation-main-form').addClass('loading');
        $.post(
            server_data.url,
            $('#annotation-main-form').serialize(),
            function (data) {
                $('#annotation-main-form').removeClass('loading');
                if (data) {
                    data = JSON.parse(data);
                    //console.log(data);

                    // NEW Pin
                    if ($('#annotation_form_action').val() == 'create_new_pin') {
                        if (data.update) {
                            $('#annotation-item__text-' + data.post_id).html(data.html);
                            $('#annotation-item__hidden-text-' + data.post_id).html(data.html_text);
                            $('#annotation-item__hidden-text-' + data.post_id).attr('data-username', data.username);
                        } else {
                            $('#annotation-list').prepend(data.html);
                            window.setNumbers();
                        }
                        if ($('.annotation-item-post').length > 0) {
                            $('.annotation-desc').closest('.annotation').removeClass('without-comments');
                            $('.annotation-filters').removeClass('hide');
                        }
                    }
                    // NEW comment
                    else if ($('#annotation_form_action').val() == 'add_comment_pin') {
                        if (data.update) {
                            $('#annotation-comment__text-' + data.comment_id).html(data.html);
                            $('#annotation-comment__hidden-text-' + data.comment_id).html(data.html_text);
                        } else {
                            $('#annotation-item-' + $('#input_comment_post_ID').val() + ' .annotation-answers-count span').html(data.count_answers);

                            if ($('#input_comment_parent').val() * 1 > 0) {
                                $('#annotation-comment-' + $('#input_comment_parent').val()).after(data.html);
                            } else {
                                let body_answers = $('#annotation-item-' + $('#input_comment_post_ID').val()).find('.annotation-answers__body');
                                body_answers.append(data.html);
                                body_answers.removeAttr('hidden');
                                $('#annotation-item-' + $('#input_comment_post_ID').val()).find('.annotation-answers').removeAttr('hidden');
                                $('#annotation-item-' + $('#input_comment_post_ID').val()).find('.annotation-answers-count').addClass('_active js-active');
                            }
                        }
                    }

                    $('#annotation-main-form button[type="reset"]').click();
                }
            }
        )
    });

    $('body').on('movePin', function (e) {
        if (e.detail.pinID) {
            e.detail.action = 'save_position_pin';
            $.post(
                server_data.url,
                e.detail,
                function (data) {
                    //console.log(data)
                }
            )
        }
    });

    $('body').on('click', '.btn-pin', function (e) {
        let pin_id = $(this).closest('.annotation-item-post').attr('data-pin-id');
        $.post(
            server_data.url,
            {
                action: 'save_position_pin',
                pinID: pin_id,
                left: 0,
                right: 0,
            },
            function (data) {
                //console.log(data)
            }
        )
    });

    // Filter click
    $('.annotation-filters__dropdown-list a').click(function () {
        let button_text = $(this).text();
        if (button_text == $('.annotation-filters__btn span').text()) {
            return;
        }

        $('#annotation-list').addClass('loading');
        $.post(
            server_data.url,
            {
                action: 'get_pins_filter',
                filter: $(this).attr('data-type'),
                object_type: $('#input_object_type').val(),
                object_id: $('#input_object_id').val(),
            },
            function (data) {
                $('#annotation-list').html($(data).find('#annotation-list').html());
                $('#annotation-list').removeClass('loading');
                if ($('.annotation-item-post').length > 0) {
                    $('.annotation').removeClass('without-comments');
                } else {
                    $('.annotation').addClass('without-comments');
                }
            }
        )

    });

});