jQuery(document).ready(function ($) {
    $('body').on('click', '#PartnerLinkButton', function () {
        let copyText = document.getElementById("PartnerLinkInput");
        copyText.select();
        copyText.setSelectionRange(0, 99999)
        document.execCommand('copy');
        alert("Вы скопировали ссылку:\r\n " + copyText.value);
    })

    $('body').on('click', '.upload_thumbnail_archive', function (e) {
        e.preventDefault();

        let button = $(this),
            aw_uploader = wp.media({
                library: {
                    type: 'image'
                },
                multiple: false
            }).on('select', function () {
                let attachment = aw_uploader.state().get('selection').first().toJSON();

                formfield = button.closest('td').find('input');
                img_block = button.closest('td').find('.upload_thumbnail_archive_img');
                formfield.val(attachment.id);
                let url = attachment.sizes['full']['url'];
                if (typeof attachment.sizes.medium !== 'undefined') {
                    url = attachment.sizes['full']['url'];
                }
                img_block.html('<img src="' + url + '">');
            }).open();
    });

    $('body').on('click', '.remove_thumbnail_archive', function (e) {
        e.preventDefault();

        let block = $(this).closest('td');
        block.find('input').val('');
        block.find('.upload_thumbnail_archive_img').html('');
    });

    if ($('.input-datepicker').length) {
        $(".input-datepicker").each(function () {
            let inp_obj = $(this);
            inp_obj.datepicker({
                onSelect: function () {
                    let dateText = $.datepicker.formatDate("yymmdd", $(this).datepicker("getDate"));
                    $('#' + inp_obj.attr('data-id')).val(dateText);
                }
            });

            inp_obj.change(function () {
                $('#' + $(this).attr('data-id')).val($(this).val());
            })
        });
    }

    if ($('.input-color').length) {
        $('.input-color').wpColorPicker();
    }

    if ($('#modal_work').length) {
        show_hide_modal_timer();
        show_hide_modal_сf7();
        show_hide_modal_text_bottom();

        $('#modal_work').change(function () {
            show_hide_modal_timer();
        });

        $('input[name="type"]').change(function () {
            show_hide_modal_сf7();
            show_hide_modal_text_bottom();
        });

        $('#show_logic').select2();
    }

    if ($('#related_product').length) {
        $('#related_product').select2();
    }

    function show_hide_modal_timer() {
        let modal_work = $('#modal_work').val();
        if (modal_work == 'auto') {
            $('.field-auto_timer').show();
        } else {
            $('.field-auto_timer').hide();
        }
    }

    function show_hide_modal_сf7() {
        let modal_type = $('input[name="type"]:checked').val();
        if (modal_type == 4) {
            $('.field-cf7').hide();
        } else {
            $('.field-cf7').show();
        }
    }

    function show_hide_modal_text_bottom() {
        let modal_type = $('input[name="type"]:checked').val();
        if (modal_type == 5) {
            $('.field-text_bottom').show();
        } else {
            $('.field-text_bottom').hide();
        }
    }

    if ($('#post_blocks_show_enabled').length > 0) {
        show_hide_post_blocks_show();
        show_hide_post_blocks_about_version();

        $('#post_blocks_show_enabled').change(function () {
            show_hide_post_blocks_show();
            show_hide_post_blocks_about_version();
            show_hide_post_blocks_box_width();
        });

        $('input[name="about_version"]').change(function () {
            show_hide_post_blocks_about_version();
        });
    }

    function show_hide_post_blocks_show() {
        let enabled = $('#post_blocks_show_enabled').prop('checked');
        $('#blocks_show_post_type_meta_box .form-table-custom tr').each(function () {
            if ($(this).hasClass('field-post_blocks_show_enabled')) {
                return true;
            }

            if ($(this).hasClass('field-content_box_width_val')) {
                return true;
            }

            if (enabled) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    }

    function show_hide_post_blocks_about_version() {
        let enabled = $('#post_blocks_show_enabled').prop('checked');
        let about_version = $('input[name="about_version"]:checked').val();

        if (enabled && about_version == 'v4') {
            $('.field-about_full_height').show();
        } else {
            $('.field-about_full_height').hide();
        }

        if (enabled && (about_version == 'v1' || about_version == 'v2')) {
            $('.field-about_version_image').show();
            $('.field-about_image_height_variable').show();
        } else {
            $('.field-about_version_image').hide();
            $('.field-about_image_height_variable').hide();
        }
    }

    if ($('#show_form_after_content').length) {
        show_hide_fields_form_after_content();

        $('#show_form_after_content').change(function () {
            show_hide_fields_form_after_content();
        });
    }

    function show_hide_fields_form_after_content() {
        let enabled = $('#show_form_after_content').prop('checked');

        if (enabled) {
            $('.field-title_form_after_content').show();
            $('.field-text_form_after_content').show();
        } else {
            $('.field-title_form_after_content').hide();
            $('.field-text_form_after_content').hide();
        }
    }

    if ($('#content_box_width_val').length > 0) {
        show_hide_post_blocks_box_width();

        $('#custom_content_box_width').change(function () {
            show_hide_post_blocks_box_width();
        });

        $('.field-content_box_width_val, .field-sidebar_box_width_val').each(function () {
            let block = $(this);

            let rangeInput = block.find('input[type="range"]');
            let textInput = block.find('input[type="text"]');
            let rangeReset = block.find('.slider-reset');

            rangeInput.on('change input', function () {
                textInput.val(rangeInput.val());
            });

            textInput.on('keyup', function () {
                rangeInput.val(textInput.val());
            });

            rangeReset.on('click', function () {
                rangeInput.val(rangeReset.attr('data-default')).trigger('change');
            });
        });
    }

    function show_hide_post_blocks_box_width() {
        let enabled = $('#post_blocks_show_enabled').prop('checked');
        let enabled_box_width = $('#custom_content_box_width').prop('checked');

        if (enabled && enabled_box_width) {
            $('.field-content_box_width_val').show();
        } else {
            $('.field-content_box_width_val').hide();
        }
    }

    $('body').on('click', '.wescle-metabox .repeater-add-item', function (e) {
        e.preventDefault();

        let check_add = true;

        let block_fields = $(this).prev();
        let limit = $(this).attr('data-limit') * 1;
        if (limit) {
            let count_rows = block_fields.find('.repeater-row').length;
            if (count_rows > limit) {
                check_add = false;
            }
        }

        if (check_add) {
            block_fields.append(block_fields.find('.repeater-field-hidden').html());
            if (block_fields.find('.air-datepicker').length) {
                init_air_datepicker();
            }

            if ($('.wescle-select2-init').length) {
                block_fields.find('.repeater-row').each(function () {
                    if ($(this).parent().hasClass('repeater-fields')) {
                        let select2_init = $(this).find('.wescle-select2-init');
                        if (select2_init.length) {
                            select2_init.removeClass('wescle-select2-init').select2();
                        }
                    }
                });
            }

            $('body').trigger('wescle_repeater-add-item', block_fields);
        }
    });

    $('body').on('click', '.wescle-metabox .repeater-fields .button-link-delete', function (e) {
        e.preventDefault();

        $(this).closest('.repeater-row').remove();

        $('body').trigger('wescle_repeater-remove-item');
    });

    if ($('.wescle-select2').length) {
        $('.wescle-select2').select2();
    }

    if ($('.wescle-metabox .repeater-fields').length) {
        $('.wescle-metabox .repeater-fields').sortable();
    }

    /*if ($('.wescle-metabox .repeater-fields').length) {
        $('.wescle-metabox .repeater-fields').sortable();
    }*/

    $('body').on('click', '.termeta_img_button', function (ev) {
        ev.preventDefault();

        let frame,
            $imgwrap = $(this).closest('.term__image__wrapper'),
            $imgid = $(this).closest('.term__image__wrapper').find('.term_imgid');

        let media_type = $imgid.attr('data-type');
        if (!media_type) {
            media_type = 'image';
        }

        let frame_title = server_data.frame_media_title;
        let button_text = server_data.frame_media_button;
        if (media_type == 'video') {
            frame_title = server_data.frame_media_video_title;
            button_text = server_data.frame_media_video_button;
        }

        // задаем media frame
        frame = wp.media.frames.questImgAdd = wp.media({
            states: [
                new wp.media.controller.Library({
                    title: frame_title,
                    library: wp.media.query({type: media_type}),
                    multiple: false,
                })
            ],
            button: {
                text: button_text, // Set the text of the button.
            }
        });

        // выбор
        frame.on('select', function () {
            let selected = frame.state().get('selection').first().toJSON();
            if (selected) {
                $imgid.val(selected.id);
                if (selected.type == 'image') {
                    $imgwrap.find('img').attr('src', selected.url);
                } else if (selected.type == 'video') {
                    //console.log(selected);
                    $imgwrap.find('img').attr('src', selected.thumb.src);
                    $imgwrap.find('.filename div').html(selected.filename);
                }
            }
        });

        // открываем
        frame.on('open', function () {
            if ($imgid.val()) frame.state().get('selection').add(wp.media.attachment($imgid.val()));
        });

        frame.open();
    });

    // удаление
    $('body').on('click', '.termeta_img_remove', function (ev) {
        ev.preventDefault();

        let $imgid = $(this).closest('.term__image__wrapper').find('.term_imgid');
        let media_type = $imgid.attr('data-type');

        $imgid.val('');
        if (!media_type || media_type == 'image') {
            $(this).closest('.term__image__wrapper').find('img').attr('src', '');
        } else if (media_type == 'video') {
            $(this).closest('.term__image__wrapper').find('img').attr('src', '');
            $(this).closest('.term__image__wrapper').find('.filename div').html('');
        }
    });

    if ($('table.form-table-metabox-page').length && $('.field-taxonomy_brand').length) {
        function show_hide_template_brands_settings(template) {
            let blocks = $('.field-taxonomy_brand, .field-count_popular, .field-title_popular, .field-column_width, .field-custom');
            if ('templates/template-brands.php' == template) {
                blocks.show();
            } else {
                blocks.hide();
            }
        }

        show_hide_template_brands_settings(server_data.template);

        $('body').on('change', '.interface-interface-skeleton__sidebar select', function () {
            let select_val = $(this).val();
            show_hide_template_brands_settings(select_val);
        })
    }

    if ($('.wescle-widget-logic-tabs').length) {
        function wescle_widget_logic_tabs() {
            $('.wescle-widget-logic-tabs').each(function () {
                let selected_tabs = $(this).find('.wescle-widget-logic-selected_tab').val();

                $(this).tabs({'active': selected_tabs});
            });
        }

        wescle_widget_logic_tabs();

        $('body').on('click', '.wescle-nav-tab', function (event, ui) {
            let div_tabs = $(this).closest('.wescle-widget-logic-tabs');
            div_tabs.find('.wescle-widget-logic-selected_tab').val(div_tabs.tabs('option', 'active'));
        });

        $(document).on('widget-added', function (event, widget) {
            wescle_widget_logic_tabs();
        });

        //fires when widget updated
        $(document).on('widget-updated', function (event, widget) {
            wescle_widget_logic_tabs();
        });
    }
});

