/*jslint browser: true*/
/*jslint white: true */
/*global $,jQuery,ozy_headerType,headerMenuFixed,alert,$OZY_WP_AJAX_URL,$OZY_WP_IS_HOME,$OZY_WP_HOME_URL,addthis*/

/* Wedding Planner WordPress Theme Main JS File */

/**
* Call Close Fancybox
*/
function close_fancybox(){
	"use strict";
	jQuery.fancybox.close();
}

/**
* Read cookie
*
* @key - Cookie key
*/
function getCookieValue(key) {
	"use strict";
    var currentcookie = document.cookie, firstidx, lastidx;
    if (currentcookie.length > 0)
    {
        firstidx = currentcookie.indexOf(key + "=");
        if (firstidx !== -1)
        {
            firstidx = firstidx + key.length + 1;
            lastidx = currentcookie.indexOf(";", firstidx);
            if (lastidx === -1)
            {
                lastidx = currentcookie.length;
            }
            return decodeURIComponent(currentcookie.substring(firstidx, lastidx));
        }
    }
    return "";
}

/**
* Cookie checker for like system
*
* @post_id - WordPress post ID
*/
function check_favorite_like_cookie(post_id) {
	"use strict";
	var str = getCookieValue( "post_id" );
	if(str.indexOf("[" + post_id + "]") > -1) {
		return true;
	}

	return false;
}

/**
* Cokie writer for like system
*
* @post_id - WordPress post ID
*/
function write_favorite_like_cookie(post_id) {
	"use strict";
	var now = new Date();
	now.setMonth( now.getYear() + 1 );
	post_id = "[" + post_id + "]," + getCookieValue("post_id");
	document.cookie="post_id=" + post_id + "; expires=" + now.toGMTString() + "; path=/; ";
}

/**
* Cookie Notice Banner
*/
function ozy_cookie_notice_banner() {
	"use strict";
	if(getCookieValue( "wedding_planner_cookie_banner" ) != '1') {
		jQuery('#ozy-cookie_notice_banner').addClass('show');

		jQuery('#ozy-cookie_notice_banner a.generic-button').on("click", function(e){
			e.preventDefault();

			var now = new Date();
			now.setMonth( now.getYear() + 1 );
			document.cookie="wedding_planner_cookie_banner=" + "1; expires=" + now.toGMTString() + "; path=/; ";
			jQuery('#ozy-cookie_notice_banner').removeClass('show');

			return false;
		});
	}
}

/**
* Like buttons handler
*
* @post_id - WordPress post ID
* @p_post_type
* @p_vote_type
* @$obj
*/
function ajax_favorite_like(post_id, p_post_type, p_vote_type, $obj) {
	"use strict";
	if( !check_favorite_like_cookie( post_id ) ) { //check, if there is no id in cookie
		jQuery.ajax({
			url: ozy_headerType.$OZY_WP_AJAX_URL,
			data: { action: 'wedding_planner_ajax_like', vote_post_id: post_id, vote_post_type: p_post_type, vote_type: p_vote_type },
			cache: false,
			success: function(data) {
				//not integer returned, so error message
				if( parseInt(data,0) > 0 ){
					write_favorite_like_cookie(post_id);
					jQuery('span', $obj).text(data);
				} else {
					alert(data);
				}
			},
			error: function(MLHttpRequest, textStatus, errorThrown){
				alert("MLHttpRequest: " + MLHttpRequest + "\ntextStatus: " + textStatus + "\nerrorThrown: " + errorThrown);
			}
		});
	}
}

/**
* Load more button handler
*
* @order
* @orderby
* @item_count
* @category_name
* @offset
* @found
* @e
* @layout_type
*/
function ozy_ajax_load_more_blog(order, orderby, item_count, category_name, offset, found, e, layout_type, fitRows) {

	jQuery.ajax({
		url: ozy_headerType.$OZY_WP_AJAX_URL,
		data: { action: 'wedding_planner_ajax_load_more', p_order : order, p_orderby : orderby, p_item_count : item_count, p_category_name : category_name, p_offset : offset, p_layout_type : layout_type},
		cache: false,
		success: function(data) {

			jQuery('.wpb_wrapper.isotope').append(data);

			if(layout_type === 'portfolio') {
				ozy_page_template_page_portfolio_init();
			}else{
				ozy_page_template_page_isotope_blog_init(fitRows);
			}

			jQuery(e).find('a.button').html( jQuery(e).data('loadmorecaption') + '<span></span><span></span>');

			if((item_count + offset) >= found) {
				jQuery(e).hide();
			}

			var load_more_button_top_pos = e.position();
			jQuery('html, body').animate({scrollTop: load_more_button_top_pos.top }, 'slow');

		},
		error: function(MLHttpRequest, textStatus, errorThrown){
			alert(errorThrown);
		}
	});

}

function ozy_ajax_load_more_blog_action() {
	jQuery(".load_more_blog").click(function(e) {

		e.preventDefault();

		jQuery(this).find('a.button').html( jQuery(this).data('loadingcaption') + '<span></span><span></span>');

		var order 			= jQuery(this).data("order");
		var orderby 		= jQuery(this).data("orderby");
		var item_count 		= jQuery(this).data("item_count");
		var excerpt_length 	= jQuery(this).data("excerpt_length");
		var category_name 	= jQuery(this).data("category_name");
		var offset 			= jQuery(this).data("offset");
		var found 			= jQuery(this).data("found");
		var layout_type 	= jQuery(this).data("layout_type");
		var	fitRows		 	= jQuery(this).data("fitrows");

		offset = offset + item_count;
		ozy_ajax_load_more_blog(order, orderby, item_count, category_name, offset, found, jQuery(this), layout_type, fitRows);
		jQuery(this).data("offset", offset);

		return false;

	});
}

function ozy_page_template_page_portfolio_init() {
	var $container_portfolio, visible_item_count = 8;
	jQuery('.isotope').each(function() {
		var $that = jQuery(this);
		$that.imagesLoaded( function() {
			var conf_arr = {
				filter:  '',
				itemSelector: '.ozy_portfolio',
				layoutMode: 'masonry',
				masonry: {}
			};
			if($that.hasClass('custom-gutter')) {
				visible_item_count = parseInt($that.data('visible_item_count')) + 2;
				conf_arr['masonry'] = {
					columnWidth: '.grid-sizer',
					gutter: '.gutter-sizer'
				};
			}else{
				visible_item_count = $that.data('visible_item_count');
				conf_arr['masonry'] = {
					gutter:0
				};
			}
			conf_arr['filter'] = jQuery('.ozy-portfolio-listing').length>0 ? ':nth-child(-n+'+ visible_item_count +')' : '';
			jQuery('.isotope.loaded-already').isotope('destroy');
			$container_portfolio = $that.addClass('loaded-already').isotope(conf_arr);

			jQuery('.load_more_blog').animate({opacity:1}, 300, 'easeInOutExpo');

			if(jQuery('.ozy-portfolio-listing').length<=0) {
				jQuery('#portfolio-filter a').each(function() {
					if(!jQuery('.isotope>div' + jQuery(this).data('filter')).length) {
						jQuery(this).addClass('disabled').parent('li').animate({opacity:'.3'}, 300, 'easeInOutExpo');
					}else{
						jQuery(this).removeClass('disabled').parent('li').animate({opacity:'1'}, 300, 'easeInOutExpo');
					}
				});
			}

			// Deep linking, just finds the filtering links and calling click of it
			if (location.hash.indexOf('#') > -1) {
				let $deep_link_filter = '.category-' + location.hash.substring(('#').length);
				jQuery('#portfolio-filter a[data-filter="'+ $deep_link_filter +'"]').click(); //$container_portfolio.isotope({ filter: $deep_link_filter });
			}			
		});
	});

	// bind filter button click
	jQuery('#portfolio-filter a').on( 'click', function(e) {
		e.preventDefault();
		if(jQuery(this).hasClass('disabled')) {return false;}
		var filterValue = jQuery(this ).attr('data-filter');
		$container_portfolio.isotope({ filter: filterValue });
		jQuery(this).parents('ul').find('li').removeClass('active');jQuery(this).parent('li').addClass('active');
		return false;
	});
}

/**
* Popup window launcher
*
* @url - Url address for the popup window
* @title - Popup window title
* @w - Width of the window
* @h - Height of the window
*/
function ozyPopupWindow(url, title, w, h) {
	"use strict";
	var left = (screen.width/2)-(w/2), top = (screen.height/2)-(h/2);
	return window.open(url, title, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width='+w+', height='+h+', top='+top+', left='+left);
}

/**
* To check iOS devices and versions
*/
function ozyCheckIsMobile() {
	"use strict";
	return (/Mobi/.test(navigator.userAgent));
}

function ozyCheckIs768el() {
	"use strict";
	return jQuery(window).width()<=768 ? true : false;
}

function ozyCheckIs1440el() {
	"use strict";
	return jQuery(window).width()<=1440 ? true : false;
}

function ozyCheckMac(){
	"use strict";
	var isMac = /(mac)/.exec( window.navigator.userAgent.toLowerCase() );
	return ( isMac != null && isMac.length );
}

function ozyCheckFirefox() {
	if(navigator.userAgent.toLowerCase().indexOf('firefox') > -1){
		 return true;
	}
	return false;
}

function ozyCheckChrome() {
	"use strict";
	var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
	var isSafari = /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
	return isChrome || isSafari;
}

/**
* ozy_full_row_fix
*
* Set sections to document height which matches with selector
*/
function ozy_full_row_fix() {
	"use strict";
	/* Countdown Page */
	if(jQuery('body.page-template-page-countdown').length || jQuery('body.page-template-page-revo-full').length) {
		jQuery('#content').height(jQuery(window).height() - 80); //-80 for top bottom padding
	}
}

function ozy_share_button() {
	"use strict";
	jQuery(document).on('click', 'a.footer-share-buttons, body.single .post-submeta>a:not(.blog-like-link)', function(e) {
		e.preventDefault();
		ozyPopupWindow(jQuery(this).attr('href'), 'Share', 640, 440);
	});
}

/**
* ozy_hash_scroll_fix
*
* Check if there is a hash and scrolls to there, onload
*/
function ozy_hash_scroll_fix() {
	"use strict";
	setTimeout(function(){
	if(window.location.hash) {
		var hash = window.location.hash;
		if(jQuery(hash).length) {
			jQuery('html,body').animate({scrollTop: jQuery(hash).offset().top}, 1600, 'easeInOutExpo');
		}
	}}, 200);
}

function ozy_custom_map_mobile_full_height_fix() {
	/* Google Map */
	if ('undefined' !== typeof jQuery.fn.prettyMaps) {
		if( jQuery(window).width() <= 479)  {
			jQuery('.ozy-google-map:not(.init-later)').each(function(index, element) {
				if(jQuery(this).data('height').toString().indexOf('%') !== -1) {
					jQuery(this).height('400px');
				}
			});
		} else {
			jQuery('.ozy-google-map:not(.init-later)').each(function(index, element) {
				if(jQuery(this).data('height').toString().indexOf('%') !== -1) {
					jQuery(this).height(jQuery(this).data('height'));
				}
			});
		}
	}
}

var ozy_ticker_containerheight = 0, ozy_ticker_numbercount = 0, ozy_ticker_liheight, ozy_ticker_index = 1, ozy_ticker_timer;
function ozy_callticker() {
	"use strict";
	jQuery(".ozy-ticker ul").stop().animate({
		"margin-top": (-1) * (ozy_ticker_liheight * ozy_ticker_index)
	}, 1500);
	jQuery('#ozy-tickerwrapper .pagination>a').removeClass('active');jQuery('#ozy-tickerwrapper .pagination>a[data-slide="'+ (ozy_ticker_index) +'"]').addClass('active');//bullet active
	if (ozy_ticker_index != ozy_ticker_numbercount - 1) {
		ozy_ticker_index = ozy_ticker_index + 1;
	}else{
		ozy_ticker_index = 0;
	}
	ozy_ticker_timer = setTimeout("ozy_callticker()", 3600);
}

/* Resets windows scroll position if there is a hash to make it work smooth scroll*/
var windowScrollTop = jQuery(window).scrollTop();
window.scrollTo(0, 0);
setTimeout(function() {
	"use strict";
	window.scrollTo(0, windowScrollTop);
}, 1);

jQuery(window).resize(function() {
	"use strict";
	ozy_full_row_fix();
	ozy_custom_map_mobile_full_height_fix();
});

jQuery(window).on('load', function(){
	if (jQuery().masonry) {
		/* Search page */
		if(jQuery('body.search-results').length) {
			jQuery('body.search-results .post-content>div').imagesLoaded( function(){
				jQuery('body.search-results .post-content>div').masonry({
					itemSelector : 'article.result',
					gutter : 20
				});
			});
		}
	}

	/* Row Kenburns Slider */
	jQuery('.smoothslides').each(function() {
		jQuery(jQuery(this)).smoothSlides({
			effectModifier: (ozyCheckFirefox() ? 1 : 1.3),
			effectDuration:5000,
			navigation:false,
			pagination:false,
			matchImageSize:false
		});
    });

	/* Testimonial Slider Bullet Fix */
	jQuery('div.flickity-carousel').find('.testimonial').each(function(index, element) {
		jQuery(this).parents('div.flickity-carousel').find('ol.flickity-page-dots').css('bottom', '25px');
		return;
	});

	/*Music Player*/
	if(jQuery('#wedding_planner_mp3_player').length && jQuery(window).width() >= 768) {
		function ss_soundbits(sound){
			var audio_element = document.getElementById("wedding_planner_mp3_player");
			audio_element.playclip=function(){
				audio_element.pause();
				audio_element.currentTime=0;
				audio_element.play();
			};
			return audio_element;
		}

		function ss_sounbit_cookie_check(post_id) {
			"use strict";
			var str = getCookieValue( "post_id_audio"+ post_id );
			if(str == 'true')
				return true;
			return false;
		}

		function ss_sounbit_cookie_write(post_id, val) {
			"use strict";
			var now = new Date();
			now.setMonth( now.getYear() + 1 );
			document.cookie="post_id_audio"+ post_id +"=" + val + "; expires=" + now.toGMTString() + "; path=/; ";
		}

		var audio = ss_soundbits(ozy_headerType.mp3_file)

		var stopped = false;
		//check if music previously stopped
		if(!ss_sounbit_cookie_check(ozy_headerType.post_id)) {
			audio.playclip();
		} else {
			stopped = true;
		}

		audio.addEventListener('ended', function() {
			if(!stopped){
				this.currentTime = 0;
				this.play();
			}
		}, false);

		jQuery('#music-play').click(function(e) {
			e.preventDefault();
			if(stopped) {
				stopped = false;
				audio.play();
			}else{
				stopped = true;
				audio.pause();
			}
			jQuery(this).attr('data-stopped', stopped);
			ss_sounbit_cookie_write(ozy_headerType.post_id, stopped);
		}).attr('data-stopped', stopped);
	}
	
	/* WooCommerce Category & Product Pages */	
	wedding_planner_shop_page_masonry();
});

function wedding_planner_shop_page_masonry() {
	if (jQuery().isotope) {
		if(jQuery('.woocommerce ul.products').length) {
			jQuery('.woocommerce ul.products').imagesLoaded( function(){
				try {
					jQuery('.woocommerce ul.products').isotope('reloadItems');	
				} catch (error) {
					// nothing, just ignore.
				}
				jQuery('.woocommerce ul.products').isotope({
					layoutMode: 'fitRows',
					itemSelector: 'li.product',
					isAnimated: true,
					fitRows: {
						gutter: '.woo-gutter-spacer'
					}
				});
			});
		}
	}	
}

/* Sticky Menu, only works on desktop devices */
function wedding_planner_ozy_menu_bg_color_fixer() {
	"use strict";
	var do_time = 0;
	var headerMenuFixed = false;
	jQuery.doTimeout('scroll', do_time, function(){
		if(!jQuery('body').hasClass('force-transparent-menu') && !jQuery('body').hasClass('ozy-menu-script')) {
			if(jQuery(window).scrollTop() >= 50) {
				if(!headerMenuFixed) {
					jQuery('body').addClass('ozy-alternate-menu');
				}
			} else {
				jQuery('body').removeClass('ozy-alternate-menu');
				headerMenuFixed = false;
			}
		}

		/* Cookie Notice Banner Visibility */
		if(jQuery('#ozy-cookie_notice_banner').length) {
			if(jQuery(window).scrollTop() >= 150) {
				jQuery('#ozy-cookie_notice_banner').addClass('in-viewport');
			}else{
				jQuery('#ozy-cookie_notice_banner').removeClass('in-viewport');
			}
		}
	});
}

jQuery(window).scroll(function() {
	"use strict";
	wedding_planner_ozy_menu_bg_color_fixer();
});

jQuery(document).ajaxComplete(function() {
	/*re init lighgallery for newly loaded items*/
	if(jQuery('.wpb_wrapper.isotope').length) {
		var $target_gallery = jQuery('.wpb_wrapper.isotope');
		if($target_gallery.data('lightGallery')) {
			$target_gallery.data('lightGallery').destroy(true);
		}
		$target_gallery.lightGallery({
			selector: '.lightgallery',
			thumbnail:true
		});

		jQuery(".ozy_portfolio:not(.zs-wrapper)").zoomScroller({
			onZoom: function(el, zoomType) {
				if (zoomType == "in") {
					el.find(".caption").fadeIn("slow");
				} else {
					el.find(".caption").fadeOut("slow");
				}
			}
		});
	}

	/* re init woocommerce shop page on ajax event complete */
	if(jQuery('body').hasClass('woocommerce-shop')) {
		wedding_planner_shop_page_masonry();
	}	
});

jQuery(document).ready(function($) {
	"use strict";

	jQuery(window).scroll(); //init logo switch for first time

	ozy_share_button();

	ozy_full_row_fix();

	ozy_ajax_load_more_blog_action();

	ozy_hash_scroll_fix();

	ozy_cookie_notice_banner();

	/* Animsition */
	if(ozy_Animsition.is_active) {
		$(".animsition").animsition({
			inClass: 'fade-in',
			outClass: 'fade-out',
			inDuration: 1500,
			outDuration: 800,
			linkElement: 'nav.navbar.bootsnav ul.nav li>a:not([target="_blank"]):not([href^="#"])', // e.g. linkElement: 'a:not([target="_blank"]):not([href^=#])'
			loading: true,
			loadingParentElement: 'body', //animsition wrapper element
			loadingClass: 'square-loader',//'uil-ring-css',//'animsition-loading',
			loadingInner: '<div><div><svg class="loader_1" xmlns="http://www.w3.org/2000/svg" width="70" height="70" viewBox="-50 -50 244 265"><title></title><desc></desc><g><path class="line_1" stroke-width="2" stroke="#000" fill="#000" opacity=".9"d="M72.7 0.6L72.7 0.6C74.8 0.6 76.4 2.4 76.4 4.6L76.4 36.6C76.4 38.8 74.8 40.6 72.7 40.6 70.7 40.6 69.1 38.8 69.1 36.6L69.1 4.6C69.1 2.4 70.7 0.6 72.7 0.6"/><path class="line_2" stroke-width="2" stroke="#000" opacity="0.8" fill="#000" d="M137.8 40.6C137.1 40.6 136.4 40.8 135.7 41.2L107.5 58.2C105.6 59.4 104.9 62 106 64 106.8 65.3 108.1 66.1 109.6 66.1 110.2 66.1 110.9 65.9 111.6 65.5L139.8 48.5C141.8 47.4 142.4 44.8 141.3 42.7 140.6 41.4 139.2 40.6 137.8 40.6"/><path class="line_3" stroke-width: "2" stroke="#000" opacity="0.6" fill="#000" d="M109.6 102.5C108.1 102.5 106.8 103.3 106 104.6 104.9 106.7 105.6 109.3 107.5 110.5L135.7 127.4C136.4 127.8 137.1 128 137.8 128 139.2 128 140.6 127.3 141.3 125.9 142.4 123.9 141.8 121.3 139.8 120.1L111.6 103.1C110.9 102.7 110.2 102.5 109.6 102.5"/><path class="line_4" stroke-width="2" stroke="#000" opacity="0.6" fill="#000" d="M72.7 124.4C70.7 124.4 69.1 126.2 69.1 128.4L69.1 160.4C69.1 162.6 70.7 164.4 72.7 164.4 74.8 164.4 76.4 162.6 76.4 160.4L76.4 128.4C76.4 126.2 74.8 124.4 72.7 124.4"/><path class="line_5" stroke-width="2" stroke="#000" opacity="0.4" fill="#000" d="M32.3 102.5C31.6 102.5 30.9 102.7 30.3 103.1L2 120.1C0.1 121.3-0.6 123.9 0.5 125.9 1.3 127.3 2.7 128 4.1 128 4.8 128 5.5 127.8 6.1 127.4L34.3 110.5C36.3 109.3 37 106.7 35.8 104.6 35.1 103.3 33.7 102.5 32.3 102.5"/><path class="line_6" stroke-width="2" stroke="#000" opacity="0.2" fill="#000" d="M4.1 40.6C2.7 40.6 1.3 41.4 0.5 42.7 -0.6 44.8 0.1 47.4 2 48.5L30.3 65.5C30.9 65.9 31.6 66.1 32.3 66.1 33.7 66.1 35.1 65.3 35.8 64 37 62 36.3 59.4 34.3 58.2L6.1 41.2C5.5 40.8 4.8 40.6 4.1 40.6"/></g></svg></div></div>', // e.g '<img src="loading.svg" />'
			timeout: true,
			timeoutCountdown: 3000,
			onLoadEvent: true,
			browser: [ 'animation-duration', '-webkit-animation-duration'],
			overlay : false,
			overlayClass : 'animsition-overlay-slide',
			overlayParentElement : 'body',
			transition: function(url){ window.location.href = url; }
		});
	}

	/* Menu Link */
	$('nav.navbar.bootsnav ul.nav>li>a[href*="#"]:not([href="#"]),#content a[href^="#"]:not([data-filter]),#content a.vc_btn3[href*="#"],.widget ul.menu>li>a[href*="#"]').click(function(e) {
		var pattern = /^((http|https|ftp):\/\/)/;
		if(pattern.test(this.href)) {
			e.preventDefault();
			if(ozy_click_hash_check(this)) {
				if(ozy_Animsition.is_active) {
					$('.animsition').animsition('out', $(e.target), ozy_headerType.$OZY_WP_HOME_URL + this.hash);
				}else{
					window.location = ozy_headerType.$OZY_WP_HOME_URL + this.hash;
				}
			}
		}else if (/#/.test(this.href)) {
			e.preventDefault();
			if(ozy_click_hash_check(this)) {
				if(ozy_Animsition.is_active) {
					$('.animsition').animsition('out', $(e.target), ozy_headerType.$OZY_WP_HOME_URL + $(this).attr('href'));
				}else{
					window.location = ozy_headerType.$OZY_WP_HOME_URL + $(this).attr('href');
				}
			}
		}else{
			if(ozy_Animsition.is_active) {
				e.preventDefault();
				$('.animsition').animsition('out', $(e.target), $(this).attr('href'));
			}
		}
	});

	/* Search Button & Stuff */
	$(document).on('touchstart, click', '#close-search-overlay,.attr-nav>ul>li.search>a', function(e) {
		e.preventDefault();
		$('body').toggleClass('search-overlay-open');$('#search-overlay #search').focus();
	});
	$(document).keyup(function(e) {
		if (e.which == 27) {
			$('body').removeClass('search-overlay-open');
		}
		e.preventDefault();
    });

	/* Floating Share Bar */
	$('#floating-share>span:first-child, #close-floating-share-bar').click(function(e) {
		$('body').toggleClass('floatin-share-bar-open');
        e.preventDefault();
    });

	/* Language Switcher */
	$('.lang-switcher').click(function(e) {
		$('.lang-switcher-dropdown,.top-info-bar>div>span.lang-switcher').toggleClass('open');
        e.preventDefault();
    });
	
	/* Product page Qantity Form */
	$('body.single form.cart').find('.button').each(function(){
		$(this).height($(this).find('input.qty').outerHeight() ? $(this).find('input.qty').outerHeight() : '50px');
	});

	function customQtyButtons(){
		//$('.qty-plus, .qty-minus').unbind('click');
		$('.quantity').off('click', '.qty-plus').on('click', '.qty-plus', function() {
			var _field = $(this).parents('.quantity').find('input.qty');
			var _new_val = parseFloat(_field.val()) + 1; var _max = parseFloat(_field.attr('max'));
			_field.val( _new_val <= _max ?  _new_val : parseFloat(_field.val()) ).change();
		});

		$('.quantity').off('click', '.qty-minus').on('click', '.qty-minus', function() {
			var _field = $(this).parents('.quantity').find('input.qty');
			var _new_val = parseFloat(_field.val()) - 1;  var _min = parseFloat(_field.attr('min'));
			_field.val( _new_val >= _min ? _new_val : parseFloat(_field.val()) ).change();
		});
	}

	jQuery(document).ajaxComplete(function() {
		customQtyButtons();
	});

	customQtyButtons();

	$('body.single-product .comment-form .comment-form-comment label').each(function(){
		$(this).insertAfter( $(this).next('input') );
		$(this).insertAfter( $(this).next('textarea') );
	});

	/* WooCommerce Basket */
	function woocommerce_mini_cart() {
		if($('a.cart-contents').length && $('#woocommerce-cart-wrapper').length) {
			$('a.cart-contents,#woocommerce-cart-wrapper>h3>.fa.fa-chevron-circle-right').unbind('click').on('click', function(e){
				e.preventDefault();
				$('body').toggleClass('cart-open');
				return false;
			});
			jQuery(document).on("click", function(e) {
				var basket_div = jQuery('body.cart-open #woocommerce-cart-wrapper');
				if (!basket_div.is(e.target) && !basket_div.has(e.target).length && basket_div.is(':visible') && !jQuery(e.target).hasClass('ajax-basket')) {
					$('body').toggleClass('cart-open');
				}
			});
		}
	}
	if(ozy_headerType.woocommerce_active) {
		var woo_cart_init_count = 0;

		$('.cart_list.product_list_widget').niceScroll({scrollbarid:"mini-cart-scrollbar", autohidemode:"false", cursorwidth: "6px", cursorcolor: "rgba(33,30,31,.5)", cursorborder: "none"});

		jQuery(window).on('load', function(){
			woocommerce_mini_cart();
		});

		jQuery(document).ajaxComplete(function() {
			woocommerce_mini_cart();
			if(woo_cart_init_count>1) { $('#mini-cart-scrollbar, #mini-cart-scrollbar-hr').remove(); }
			$('.cart_list.product_list_widget').niceScroll({scrollbarid:"mini-cart-scrollbar", autohidemode:"false", cursorwidth: "6px", cursorcolor: "rgba(33,30,31,.5)", cursorborder: "none"});
			woo_cart_init_count++;
		});

		// WooCommerce Ajax delete product in the cart
		$(document).on('click', '.mini_cart_item a.remove', function (e) {
			e.preventDefault();

			var product_id = $(this).attr("data-product_id"),
				cart_item_key = $(this).attr("data-cart_item_key"),
				product_container = $(this).parents('.mini_cart_item');

			// Add loader
			product_container.block({
				message: null,
				overlayCSS: {
					cursor: 'none'
				}
			});

			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: wc_add_to_cart_params.ajax_url,
				data: {
					action: "product_remove",
					product_id: product_id,
					cart_item_key: cart_item_key
				},
				success: function(response) {
					if ( ! response || response.error ) {
						return;
					}

					var fragments = response.fragments;

					// Replace fragments
					if ( fragments ) {
						$.each( fragments, function( key, value ) {
							$( key ).replaceWith( value );
						});
					}
				}
			});
		});
	}
	

	function ozy_visual_stuff() {
		/* Blog Share Button*/
		$(document).on('click', '.post-submeta>a.post-share, .big-blog-post-submeta>a.post-share', function(e) {
			if($(this).data('open') !== '1') {
				$(this).data('open', '1').next('div').stop().animate({'margin-left': '0', opacity: 'show'}, 300, 'easeInOutExpo');
			}else{
				$(this).data('open', '0').next('div').stop().animate({'margin-left': '30px', opacity: 'hide'}, 300, 'easeInOutExpo');
			}
			e.preventDefault();
		});
		$(document).on("click", function(e) {
			var post_share_button = $(".post-submeta>a.post-share, .big-blog-post-submeta>a.post-share");
			if (!post_share_button.is(e.target) && !post_share_button.has(e.target).length) {
				post_share_button.data('open', '0').next('div').stop().animate({'margin-left': '30px', opacity: 'hide'}, 300, 'easeInOutExpo');
			}
		});

		/* Tooltip plugin init */
		$(function(){
			$('.tooltip-top').tooltipsy({className:'tooltipsy white', offset: [0, 20]});
			$('.tooltip').tooltipsy();
		});

		/* YouTube Embed */
		$('.oytb-videoWrapper').each(function(index, element) {
			var $poster = $(this);
			var $wrapper = $poster.closest(this);

			$(this).click(function(ev){
				ev.preventDefault();
				videoPlay($wrapper);
			});

			function videoPlay($wrapper) {
				var $iframe = $wrapper.find('.oytb-js-videoIframe');
				var src = $iframe.data('src');
				$wrapper.addClass('oytb-videoWrapperActive');
				$poster.parent('div').find('.oytb-video-StopButton').show(100, 'easeInOutExpo');
				$iframe.attr('src',src);
			}

			$('.oytb-video-StopButton').click(function(){
				videoStop($wrapper);
			});

			function videoStop($wrapper) {
				if (!$wrapper) {
					var $wrapper = $('.oytb-js-videoWrapper');
					var $iframe = $('.oytb-js-videoIframe');
				} else {
					var $iframe = $wrapper.find('.oytb-js-videoIframe');
				}
				$wrapper.removeClass('oytb-videoWrapperActive');
				$poster.parent('div').find('.oytb-video-StopButton').hide(100, 'easeInOutExpo');
				$iframe.attr('src','');
			}
        });

		/* Flickity See All switch button */
		$('.flickity-carousel-wrapper>.flickity-carousel.carousel').each(function(index, element) {
			var $carousel = $(this);
			var isFlickity = true;
			// toggle Flickity on/off
			$('.flickity-see-all').on( 'click', function() {
				//switch button label
				var button_label = $(this).toggleClass('grid-open').data('label');$(this).data('label', $(this).html());$(this).html(button_label);

				if ( isFlickity ) {
					//setup isotope
					var conf_arr = {
						layoutMode: 'packery',
						itemSelector: '.carousel-cell'
					};
					$carousel.toggleClass('flickity-carousel-grid').flickity('destroy').isotope(conf_arr);

					//isotope animation
					var anim_timing = 0.25;
					$carousel.find('.carousel-cell').each(function(index, element) {
						$(this).css({'-webkit-transform' : 'translateX(200%)', 'transform' : 'translateX(200%)', '-webkit-animation' : 'comeFromRight '+anim_timing+'s ease-in-out forwards', 'animation' : 'comeFromRight '+anim_timing+'s ease-in-out forwards'});
						anim_timing = anim_timing + 0.10;
                    });

				} else {
					//init new Flickity
					var data_flickity_str = $carousel.attr('data-flickity');
					$carousel.isotope('destroy').toggleClass('flickity-carousel-grid').flickity(JSON.parse(data_flickity_str));
				}
				isFlickity = !isFlickity;
				return false;
			});
		});

		/* Custom Buttons */
		$('.ozy-custom_button.ocbtn-6')
		.on('mouseenter', function(e) {
				var parentOffset = $(this).offset(),
				relX = e.pageX - parentOffset.left,
				relY = e.pageY - parentOffset.top;
				$(this).find('span').css({top:relY, left:relX})
		})
		.on('mouseout', function(e) {
				var parentOffset = $(this).offset(),
				relX = e.pageX - parentOffset.left,
				relY = e.pageY - parentOffset.top;
			$(this).find('span').css({top:relY, left:relX})
		});
	}

	ozy_visual_stuff();

	function ozy_vc_components() {
		/* Google Map */
		if ('undefined' !== typeof jQuery.fn.prettyMaps) {
			$('.ozy-google-map:not(.init-later)').each(function(index, element) {
				if($(this).data('height').toString().indexOf('%') !== -1) {
					$(this).parent('div.wpb_wrapper').css('height', '100%');
				}
				$(this).parent().append(
					$('<div class="gmaps-cover"></div>').click(function(){ $(this).remove(); })
				);
				$(this).prettyMaps({
					address: $(this).data('address'),
					zoom: $(this).data('zoom'),
					panControl: true,
					zoomControl: true,
					mapTypeControl: true,
					scaleControl: true,
					streetViewControl: true,
					overviewMapControl: true,
					scrollwheel: true,
					image: $(this).data('icon'),
					hue: $(this).data('hue'),
					saturation: $(this).data('saturation'),
					lightness: $(this).data('lightness')
				});
			});
			ozy_custom_map_mobile_full_height_fix();
		}

		/* Counter */
		if ('undefined' !== typeof jQuery.fn.waypoint) {
			jQuery('.ozy-counter>.timer').waypoint(function() {
				if(!$(this.element).hasClass('ran')) {
					$(this.element).addClass('ran').countTo({
						from: $(this.element).data('from'),
						to: $(this.element).data('to'),
						speed: 5000,
						refreshInterval: 25,
						sign: $(this.element).data('sign'),
						signpos: $(this.element).data('signpos')
					});
				}
			},{
				offset: '85%'
			});
		}

		/* Sticky Footer Info Bar */
		if(!ozyCheckIsMobile()) {
			jQuery('#footer-widget-bar').waypoint(function(direction) {
				jQuery('#footer-widget-bar-sticky').removeClass('inherit fixed').addClass((direction !== 'down' ? 'fixed' : 'inherit'));
			},{
				offset: '95%'
			});
		}
		$('#footer-widget-bar-sticky #close-footer-info-bar').click(function(e) {
			e.preventDefault();
			$('#footer-widget-bar-sticky').animate({height:0, opacity:0}, 200, 'easeInOutExpo');
		});

		/* Hearts Background */
		function heartsBackground() {
			$(".vc_row.has-heart-bg").each(function(index, element) {
				var love = setInterval(function(){
					var r_num = Math.floor(Math.random() * 40) + 1;
					var r_size = Math.floor(Math.random() * 35) + 10;
					var r_left = Math.floor(Math.random() * 100) + 1;
					var r_bg = Math.floor(Math.random() * 25) + 100;
					var r_time = Math.floor(Math.random() * 5) + 5;

					$(element).append("<div class='heart' style='width:"+r_size+"px;height:"+r_size+"px;left:"+r_left+"%;background:rgba(255,"+(r_bg-25)+","+r_bg+",1);-webkit-animation:love "+r_time+"s ease;-moz-animation:love "+r_time+"s ease;-ms-animation:love "+r_time+"s ease;animation:love "+r_time+"s ease'></div>");

					$(element).append("<div class='heart' style='width:"+(r_size-10)+"px;height:"+(r_size-10)+"px;left:"+(r_left+r_num)+"%;background:rgba(255,"+(r_bg-25)+","+(r_bg+25)+",1);-webkit-animation:love "+(r_time+5)+"s ease;-moz-animation:love "+(r_time+5)+"s ease;-ms-animation:love "+(r_time+5)+"s ease;animation:love "+(r_time+5)+"s ease'></div>");

					$('.heart', element).each(function(){
						var top = $(this).css("top").replace(/[^-\d\.]/g, '');
						var width = $(this).css("width").replace(/[^-\d\.]/g, '');
						if(top <= -100 || width >= 150){
							$(this).detach();
						}
					});
				},500);
			});
		}
		heartsBackground();

		/* Typewriter */
		$(".typing-box").each(function() {
			var options = {
				typeSpeed : $(this).data('typespeed'),
				startDelay : $(this).data('startdelay'),
				backSpeed : $(this).data('backspeed'),
				backDelay : $(this).data('backdelay'),
				loop : $(this).data('loop'),
				strings : $.parseJSON(ozyTypeWriterData[$(this).data('path')])
			};
			$(this).typed(options);
        });		

		/* Instagram Feed */
		$('.ozy-instagram-gallery:not(.new)').each(function(index, element) {
			var accesstoken = $(this).data('accesstoken'),
				num_photos = $(this).data('numitems');
			$.ajax({
				url: 'https://api.instagram.com/v1/users/self/media/recent/?access_token='+accesstoken+'&count='+num_photos+'&callback=?',
				dataType: 'jsonp',
				type: 'GET',
				data: {count: num_photos, access_token: accesstoken},
				success: function(data2){
					if ('undefined' !== typeof data2.data) {
						for(var i = 0; i < data2.data.length; i++) {
							$(element).append('<li><a href="'+ data2.data[i].link +'" target="_blank"><img src="'+data2.data[i].images.thumbnail.url+'"></a></li>');
						}
					}
				},
				error: function(data2){
					$(element).append('<li>'+ data2 +'</li>');
				}
			});
		});

		/* New Instagram Feed */
		$('.ozy-instagram-gallery.new').each(function(index, element) {
			var accesstoken = $(this).data('accesstoken'),
				userid = $(this).data('userid'),
				num_photos = $(this).data('numitems');
			if(accesstoken && userid && num_photos) {
				jQuery.ajax({
					url: ozy_headerType.$OZY_WP_AJAX_URL,
					data: { action: 'wedding_planner_ajax_instagram', request_user_id : userid, request_access_token : accesstoken, request_num_photos : num_photos},
					cache: false,
					success: function(data) {
						$(element).replaceWith(data);
					},
					error: function(MLHttpRequest, textStatus, errorThrown){
						alert(errorThrown);
					}
				});
			}
		});

		/* Team Member Extended Content (Lightbox) */
		if($('.ozy-team_member.has-extended-content').length) {
			$('.ozy-team_member.has-extended-content a').click(function(e) {
				e.preventDefault();
				var $this = $(this).parents('div.ozy-team_member');
				$this.find('figure>a').click(function(e){ e.preventDefault(); });
				var $source = $this.find('.extended-content'),
				$target = $('#side-extended-content');
				$.fancybox({
					maxWidth:940,
					maxHeight:640,
					padding:0,
					scrolling:'no',
					'content' : $source.html()
				});
			});
		}

		/* Fancy Blog List */
		$('.ozy-fancyaccordion-feed tr.title').click(function(e){
			e.preventDefault();
			if($(this).hasClass('open')) {
				$(this).next('tr.excerpt').find('td>div').hide(200, function() {
					$(this).parent().slideUp(100);
				});
			}else{
				$(this).next('tr.excerpt').find('td').show(200, function() {
					$(this).find('div').slideDown(100);
				});
			}
			$(this).toggleClass('open');
		});
	}

	ozy_vc_components();

	function ozy_click_hash_check($this) {
		if (location.pathname.replace(/^\//,'') == $this.pathname.replace(/^\//,'')
			|| location.hostname == $this.hostname) {

			var target = $($this.hash);
			target = target.length ? target : $('[name=' + $this.hash.slice(1) +']');
		   	if (target.length) {
				$('html,body').animate({
					 scrollTop: target.offset().top
				}, 1600, 'easeInOutExpo');
				return false;
			}
		}
		return true;
	}

	/* Waypoint animations */
	if ('undefined' !== typeof jQuery.fn.waypoint) {
	    jQuery('.ozy-waypoint-animate').waypoint(function() {
			jQuery(this.element).addClass('ozy-start-animation');
		},{
			offset: '85%'
		});
	}

	/* Blog post like function */
	$(document).on('click', '.blog-like-link', function(e) {
		ajax_favorite_like($(this).data('post_id'), 'like', 'blog', this);
		e.preventDefault();
    });

	/* FancyBox initialization */
	$(".wp-caption>p").click(  function(){ jQuery(this).prev('a').attr('title', jQuery(this).text()).click(); } ); //WordPress captioned image fix
	$(".fancybox, .wp-caption>a, .single-image-fancybox a").fancybox({
		beforeLoad: function() {
		},
		padding : 0,
		helpers		: {
			title	: { type : 'inside' },
			buttons	: {}
		}
	});
	$('.fancybox-media').fancybox({openEffect  : 'none',closeEffect : 'none',helpers : {title	: { type : 'inside' }, media : {}}});
    $('.fancybox-iframe-link').fancybox({ type: 'iframe' });

	/* Back to top button */
	var pxScrolled = 200;
	var duration = 500;

	$(window).scroll(function() {
		if ($(this).scrollTop() > pxScrolled) {
			$('.wedding-planner-btt-container').css({'bottom': '65px', 'transition': '.3s'});
		} else {
			$('.wedding-planner-btt-container').css({'bottom': '-100px'});
		}
	});

	$('.top').click(function() {
		$('body,html').animate({scrollTop: 0}, duration);
	})
});

/* page-portfolio.php*/
document.addEventListener("DOMContentLoaded", function() {
	imagesLoaded('body', function() {	
		if(jQuery('body.page-template-page-portfolio-php').length>0) {
			jQuery('.wpb_wrapper.isotope').lightGallery({
				selector: '.lightgallery',
				thumbnail:true
			});
			ozy_page_template_page_portfolio_init();
		}
	});
});