jQuery('section.strips').each(function () {

  var tile = jQuery('.strips__strip', this);
  var tileLink = jQuery('.strips__strip > .strip__content', this);
  var tileText = tileLink.find('.strip__inner-text');
  var tileSubTitle = tileText.find('h2');
  var stripClose = jQuery('.strip__close', this);

  var expanded = false;

  var $that = jQuery(this);

  var open = function () {

    var tile = jQuery(this).parent();
    
    stripClose.css('color', tileSubTitle.data('color'));

    if (!expanded) {
    
      var to_scroll_position = jQuery($that).offset().top - (jQuery('nav.navbar').height() + 40);
      jQuery('html, body').animate({ scrollTop: to_scroll_position }, 'slow');

      jQuery(this).addClass('fade-logo-menu-to-top');
      tile.addClass('strips__strip--expanded');
      setTimeout(function () { tileText.animate({ 'opacity': 1 }, 200); }, 600);
      stripClose.addClass('strip__close--show');
      stripClose.css('transition', 'all .6s 1s cubic-bezier(0.23, 1, 0.32, 1)');
      expanded = true;

    }

  };

  var close = function () {

    if (expanded) {

      jQuery(this).removeClass('fade-logo-menu-to-top');
      tileText.animate({ 'opacity': 0 }, 200, function () {
        tile.removeClass('strips__strip--expanded');
        stripClose.removeClass('strip__close--show');
        stripClose.css('transition', 'all 0.2s 0s cubic-bezier(0.23, 1, 0.32, 1)')
        expanded = false;
      });

    }

  }

  tileLink.on('click', open);
  stripClose.on('click', close);
});