<?php
/*
Template Name: Portfolio Listing
*/
get_header();

wedding_planner_portfolio_meta_params();

/* Widgetized LEFT sidebar */
if(is_active_sidebar(wedding_planner_gd('_page_sidebar_name')) && function_exists( 'dynamic_sidebar' ) && $ozyWeddingPlannerHelper->hasIt(wedding_planner_gd('_page_content_css_name'),'left-sidebar') && wedding_planner_gd('_page_sidebar_name')) {
?>
	<div id="sidebar" class="<?php echo esc_attr(wedding_planner_gd('_page_content_css_name')); ?>">
		<ul>
        	<?php dynamic_sidebar( wedding_planner_gd('_page_sidebar_name') ); ?>
		</ul>
	</div>
	<!--sidebar-->
<?php
}
?>
<div id="content" class="<?php echo esc_attr(wedding_planner_gd('_page_content_css_name')); ?> template-clean-page">
    <?php if ( have_posts() && wedding_planner_gd('_page_hide_page_content') != '1') while ( have_posts() ) : the_post(); ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class('page'); ?>>
            <article>
                
                <div class="post-content page-content">
                    <?php the_content(); ?>
					
                    <!--filter-->
                    <ul id="portfolio-filter">
                        <li class="active"><a href="#all" data-filter=".category-all"><?php esc_attr_e('ALL', 'wedding-planner') ?></a></li>
                        <?php
                        echo wedding_planner_print_portfolio_filter(
							wedding_planner_gd('_portfolio_portfolio_categories_tree'), 
							wedding_planner_gd('_portfolio_category_filter_parent'), 
							0, 
							wedding_planner_gd('_portfolio_category_search_type'), 
							''
						);
                        ?>
                    </ul>
                    
                    <!--grid-->
                    <div class="wpb_wrapper isotope column-<?php echo esc_attr(wedding_planner_gd('_portfolio_column_count'))?>">
					<?php
						$args = array(
							'post_type' 			=> 'ozy_portfolio',
							'posts_per_page'		=> wedding_planner_gd('_portfolio_post_per_load'),
							'orderby' 				=> wedding_planner_gd('_portfolio_orderby'),
							'order' 				=> wedding_planner_gd('_portfolio_order'),
							'ignore_sticky_posts' 	=> 1,
							'meta_key' 				=> '_thumbnail_id',
							'tax_query' => array(
								array(
									'taxonomy' 	=> 'portfolio_category',
									'field' 	=> 'id',
									'terms' 	=> wedding_planner_gd('_portfolio_include_categories'),
									'operator' 	=> 'IN'
								),
							),											
						);

						$the_query = new WP_Query( $args );

						while ( $the_query->have_posts() ) {
							$the_query->the_post();
														
							$tax_terms = get_the_terms($post->ID, 'portfolio_category');						
							$tax_terms_slug = wp_list_pluck($tax_terms, 'slug');
							$tax_terms_name = wp_list_pluck($tax_terms, 'name');
						?>
						<div <?php post_class('category-all category-' . implode(' category-', $tax_terms_slug) . ' post-single'); ?>>
						<?php
							$thumbnail_image_src = $post_image_src = array();
							if ( has_post_thumbnail() ) { 
								$thumbnail_image_src 	= wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'blog' , false );
								$post_image_src 		= wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' , false );						
	
								if ( isset($thumbnail_image_src[0]) && isset($post_image_src[0])) { 
									echo '<img src="'. esc_url($thumbnail_image_src[0]) .'" alt="'. esc_attr(get_the_title()) .'" data-skip-lazy/>';
									echo '<div class="featured-thumbnail" data-skip-lazy>';
										echo '<div class="caption">';
											echo '<p class="tag">' . implode(', ', $tax_terms_name) . '</p>';
											echo '<h2 class="heading">';
											echo '<a href="'. esc_attr(get_permalink()) .'" title="'. esc_attr(get_the_title()) .'" rel="bookmark">' . 
											( get_the_title() ? get_the_title() : get_the_time(WEDDING_PLANNER_DATE_FORMAT) ) 
											. '</a>';
											echo '</h2>';
											echo '<span class="view-more heading-font">'. wedding_planner_gd('_portfolio_hover_caption') .'</span>';
										echo '</div>'; 
									the_post_thumbnail('blog');
									echo '</div>'; 
								}
							}
							?>
                        </div><!--.post-single-->                           
                        <?php													
						}
					?>
                    </div>
                    <!--grid-->
					
                    <?php if($the_query->found_posts > wedding_planner_gd('_portfolio_post_per_load')) { ?>
                    <div class="button-container load_more_blog" data-layout_type="portfolio" data-item_count="<?php echo esc_attr(wedding_planner_gd('_portfolio_post_per_load')) ?>" data-offset="0" data-found="<?php echo esc_attr($the_query->found_posts) ?>" data-order_by="<?php echo esc_attr(wedding_planner_gd('_portfolio_orderby')) ?>" data-order="<?php echo esc_attr(wedding_planner_gd('_portfolio_order')) ?>" data-category_name="<?php  echo esc_attr((is_array(wedding_planner_gd('_portfolio_include_categories')) ? join(',', wedding_planner_gd('_portfolio_include_categories')) : '')) ?>" data-loadingcaption="<?php echo esc_attr__('LOADING...', 'wedding-planner') ?>" data-loadmorecaption="<?php echo esc_attr__('LOAD MORE', 'wedding-planner') ?>">
                        <a href="#" class="button" onclick="javascript:void(0);"><?php echo esc_attr__('LOAD MORE', 'wedding-planner') ?><span></span><span></span></a>
                    </div>
					<!--.load more portfolio-->
                    <?php } ?>
                </div><!--.post-content .page-content -->
            </article>
			
        </div><!--#post-# .post-->

    <?php endwhile; ?>
</div><!--#content-->
<?php
/* Widgetized RIGHT sidebar */
if(is_active_sidebar(wedding_planner_gd('_page_sidebar_name')) && function_exists( 'dynamic_sidebar' ) && $ozyWeddingPlannerHelper->hasIt(wedding_planner_gd('_page_content_css_name'),'right-sidebar') && wedding_planner_gd('_page_sidebar_name')) {
?>
	<div id="sidebar" class="<?php echo esc_attr(wedding_planner_gd('_page_content_css_name')); ?>">
		<ul>
        	<?php dynamic_sidebar( wedding_planner_gd('_page_sidebar_name') ); ?>
		</ul>
	</div>
	<!--sidebar-->
<?php
}
get_footer();
?>
