<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <!--[if IE]><meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1'><![endif]-->
	<meta charset="<?php esc_attr(bloginfo( 'charset' )); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1"/>
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php echo esc_url(get_bloginfo('pingback_url')); ?>" />
	<?php wp_head(); /* this is used by many Wordpress features and for plugins to work proporly */ ?>
</head>

<body <?php body_class(); ?>>
	<?php
	wedding_planner_body_frame();
	
	if(wedding_planner_gd('is_animsition_active')) echo '<div class="animsition">';
    
	if(wedding_planner_gd('hide_everything_but_content') != 999) {
		include_once(WEDDING_PLANNER_BASE_DIR . 'include/primary-menu.php');        
	    include_once(WEDDING_PLANNER_BASE_DIR . 'include/google-maps_bg.php'); /* google maps background */ 
	}
    ?>        
    <div class="none-visible">
        <p><a href="#content"><?php esc_attr_e('Skip to Content', 'wedding-planner'); ?></a></p><?php /* used for accessibility, particularly for screen reader applications */ ?>
    </div><!--.none-->
    <?php
		if(wedding_planner_gd('hide_everything_but_content') <= 0): 
	?> 
    
    <div id="main" class="<?php echo esc_attr(wedding_planner_gd('header_slider_class')); echo esc_attr(wedding_planner_gd('footer_slider_class')); ?>">
        <?php
		wedding_planner_ozy_custom_header();
        ?>
        <div class="container <?php echo esc_attr(wedding_planner_gd('_page_content_css_name')); ?>">
	<?php endif; ?>