<?php
// Remove CSS and/or JS for Select2 used by WooCommerce, see https://gist.github.com/Willem-Siebe/c6d798ccba249d5bf080.
 
add_action( 'wp_enqueue_scripts', 'wedding_planner_dequeue_stylesandscripts_select2', 100 );
 
function wedding_planner_dequeue_stylesandscripts_select2() {
    if ( class_exists( 'woocommerce' ) ) {
        wp_dequeue_style( 'selectWoo' );
        wp_deregister_style( 'selectWoo' );
 
        wp_dequeue_script( 'selectWoo');
        wp_deregister_script('selectWoo');
    } 
} 

// Remove the product rating display on product loops
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10 );

// Remove the product rating display on product page
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );

add_action('after_setup_theme', 'wedding_planner_woocommerce_theme_setup');	
function wedding_planner_woocommerce_theme_setup() {
	update_option('woocommerce_enable_review_rating', 'no');
}

//* Remove add to cart button
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

//* Add add to cart button before price tag
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 99 );

// Remove display notice - Showing all x results
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

// Remove default sorting drop-down from WooCommerce
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

// Remove title from product page
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );

// To alter CSS class of item title
remove_action( 'woocommerce_shop_loop_item_title','woocommerce_template_loop_product_title', 10 );
add_action('woocommerce_shop_loop_item_title', 'wedding_planner_woo_change_products_title', 10 );
function wedding_planner_woo_change_products_title() {	
	echo '<h2 class="woocommerce-loop-product__title"><a href="'. esc_url(get_permalink()) .'">' . get_the_title() . '</a></h2>';
}

// Shop/archives: wrap the product image/thumbnail in a div.
add_action( 'woocommerce_before_shop_loop_item_title', function(){
	echo '<div class="imagewrapper">';	
}, 8 );

add_action( 'woocommerce_before_shop_loop_item_title', function(){
    echo '</div>';
}, 11 );

// Shop/archives: wrap the title and price with a div
add_action( 'woocommerce_shop_loop_item_title', function(){
	echo '<div class="detailswrapper">';	
}, 5 );

add_action( 'woocommerce_after_shop_loop_item_title', function(){
    echo '</div>';
}, 10 );

// Show attributes after summary section
add_action ( 'woocommerce_product_meta_end', 'wedding_planner_woo_show_attributes', 25 );
function wedding_planner_woo_show_attributes() {
	global $product;
	wc_display_product_attributes( $product );
}

// Move description into summary section
add_action( 'woocommerce_product_meta_end', 'wedding_planner_woo_template_product_description', 26 );
function wedding_planner_woo_template_product_description() {
	wc_get_template( 'single-product/tabs/description.php' );
}

// Remove product data tabs
add_filter( 'woocommerce_product_tabs', 'wedding_planner_woo_remove_product_tabs', 98 );
function wedding_planner_woo_remove_product_tabs( $tabs ) {
    unset( $tabs['description'] );      		// Remove the description tab
    //unset( $tabs['reviews'] ); 				// Remove the reviews tab
    unset( $tabs['additional_information'] );  	// Remove the additional information tab
    return $tabs;
}

// Remove the product description Title
add_filter( 'woocommerce_product_description_heading', 'wedding_planner_woo_remove_product_description_heading' );
function wedding_planner_woo_remove_product_description_heading() {
	return '';
}

// Remove price from product page
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price' );

// Add price to product page to change order of price
add_filter( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 22 );

// Add category before price
add_filter( 'woocommerce_single_product_summary', 'wedding_planner_woo_add_category_before_price', 21 );
function wedding_planner_woo_add_category_before_price() {
	global $product;
	echo '<div class="product_meta category">' . wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'wedding-planner' ) . ' ', '</span>' ) . '</div>';
}

// Set Image ratio to uncroppped on theme activation
if ( is_admin() && isset($_GET['activated'] ) && $pagenow == 'themes.php' ) {
    add_action('admin_footer','wedding_planner_woo_set_image_crop');
}

function wedding_planner_woo_set_image_crop(){
	if(get_option('wedding_planner_woo_crop_set') != '1') {//check if this theme activated once
		update_option( 'woocommerce_thumbnail_cropping', 'uncropped' );
		update_option( 'wedding_planner_woo_crop_set', 1 );
	}
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'wedding_planner_woo_loop_columns');
if (!function_exists('wedding_planner_woo_loop_columns')) {
	function wedding_planner_woo_loop_columns() {
		return 3; // 3 products per row
	}
}

// Change number of related products output
add_filter( 'woocommerce_output_related_products_args', 'wedding_planner_woo_related_products_limit' );
function wedding_planner_woo_related_products_limit( $args ) {
	$args['posts_per_page'] = 3; // 3 related products
	$args['columns'] = 3; // arranged in 3 columns
	return $args;
}

/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter( 'loop_shop_per_page', 'wedding_planner_woo_loop_shop_per_page', 20 );

function wedding_planner_woo_loop_shop_per_page( $cols ) {
	// $cols contains the current number of products per page based on the value stored on Options -> Reading
	// Return the number of products you wanna show per page.
	$cols = 6;
	return $cols;
}

/**
* Remove page title from shop page
*/
add_filter( 'woocommerce_show_page_title', 'wedding_planner_woo_a_shop_page' );
function wedding_planner_woo_a_shop_page() {
    return boolval(!is_shop());
}

/**
* Ensure cart contents update when products are added to the cart via AJAX
*/
add_filter( 'woocommerce_add_to_cart_fragments', 'wedding_planner_woo_header_add_to_cart_fragment' );
function wedding_planner_woo_header_add_to_cart_fragment( $fragments ) {
	ob_start();
	?>
	<a class="cart-contents content-font" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'wedding_planner' ); ?>"><i class="ajax-basket"></i><span class="basket-count"><?php echo esc_html(WC()->cart->get_cart_contents_count()) ?></span><?php echo WC()->cart->get_cart_total(); ?></a>
	<?php

	$fragments['a.cart-contents'] = ob_get_clean();

	return $fragments;
}

/**
 * Exclude products from a particular category on the shop page
 */
function wedding_planner_woo_pre_get_posts_query( $q ) {
	$excluded_categories = wedding_planner_get_option('page_section_woo_exclude_categories');
	
	if(is_array($excluded_categories) && count($excluded_categories)>0) {
		$tax_query = (array) $q->get( 'tax_query' );

		$tax_query[] = array(
			   'taxonomy' => 'product_cat',
			   'field' => 'slug',
			   'terms' => $excluded_categories, // Don't display products in the clothing category on the shop page.
			   'operator' => 'NOT IN'
		);

		$q->set( 'tax_query', $tax_query );
	}

}
add_action( 'woocommerce_product_query', 'wedding_planner_woo_pre_get_posts_query' ); 
?>