<?php

require_once(WEDDING_PLANNER_BASE_DIR . 'functions/classes/tgm-plugin-activation.php');

/**
* TGM Plugin activator
*/
function wedding_planner_register_required_plugins() {
	$ext_plugin_path = wedding_planner_settings(); if($ext_plugin_path == false) return;
	$plugins = array(
		array(
			'name'     	=> 'Wedding Planner Essentials',
			'slug'     	=> 'ozy-wedding-planner-essentials',
			'source'   	=> $ext_plugin_path . 'ozy-wedding-planner-essentials.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '2.5'
		),array(
			'name'     	=> 'Classic Editor',
			'slug'     	=> 'classic-editor',
			'required' 	=> true,
			'force_deactivation' => false,
			//'version'	=> '1.6.3'
		),array(
			'name'     	=> 'Revolution Slider',
			'slug'     	=> 'revslider',
			'source'   	=> $ext_plugin_path . 'revslider.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '6.7.36'
		),array(
			'name'     	=> 'WPBakery Page Builder',
			'slug'     	=> 'js_composer',
			'source'   	=> $ext_plugin_path . 'js_composer.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '8.6.1'
		),array(
			'name'     	=> 'MailChimp Widget',
			'slug'     	=> 'mailchimp-widget',
			'source'   	=> $ext_plugin_path . 'mailchimp-widget.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '2.0.9'
		),array(
			'name'     	=> 'Envato Market',
			'slug'     	=> 'envato-market',
			//'source'   	=> $ext_plugin_path . 'envato-market.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			//'version'	=> '2.0.10'
		),array(
			'name'     	=> 'Contact Form 7',
			'slug'     	=> 'contact-form-7',
			'required' 	=> true,
			'force_deactivation' => true,
			//'version'	=> '5.8.3'
		)
	);

	$config = array(
		'id'           => 'wedding-planner',  		// Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      	// Default absolute path to bundled plugins.
		'menu'         => 'install-required-plugins', // Menu slug.
		'has_notices'  => true,                    	// Show admin notices or not.
		'dismissable'  => true,                    	// If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      	// If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   	// Automatically activate plugins after installation or not.
		'message'      => '',                      	// Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );

}

add_action('tgmpa_register', 'wedding_planner_register_required_plugins');

?>
