<?php
// Output option-based style
if( !function_exists( 'wedding_planner_wedding_planner_style') ) :
	function wedding_planner_wedding_planner_style() {
		ob_start();
		global $ozyWeddingPlannerHelper, $post;

		// is page based styling enabled?
		$body_style = $content_background_color = $transparent_content_background = '';
		$page_id = is_search() ? 0 : get_the_ID();

		if(vp_metabox('ozy_wedding_planner_meta_page.ozy_wedding_planner_meta_page_use_custom_style', null, $page_id) == '1') {
			$_var = 'ozy_wedding_planner_meta_page.ozy_wedding_planner_meta_page_layout_group.0.ozy_wedding_planner_meta_page_layout_';
			$content_background_color 		= vp_metabox($_var . 'ascend_background', null, $page_id);
			$transparent_content_background = vp_metabox($_var . 'transparent_background', null, $page_id);
		}else{
			$content_background_color 		= wedding_planner_get_option('content_background_color', null, $page_id);
		}

		if(vp_metabox('ozy_wedding_planner_meta_page.ozy_wedding_planner_meta_page_use_custom_background', null, $page_id) == '1' && !is_search()) {
			$_var = 'background_group.0.ozy_wedding_planner_meta_page_background_';
			$body_style = $ozyWeddingPlannerHelper->background_style_render(
				wedding_planner_get_metabox($_var . 'color', null, $page_id),
				wedding_planner_get_metabox($_var . 'image', null, $page_id),
				wedding_planner_get_metabox($_var . 'image_size', null, $page_id),
				wedding_planner_get_metabox($_var . 'image_repeat', null, $page_id),
				wedding_planner_get_metabox($_var . 'image_attachment', null, $page_id),
				false,
				wedding_planner_get_metabox($_var . 'image_pos_x', null, $page_id),
				wedding_planner_get_metabox($_var . 'image_pos_y', null, $page_id)
			);
		}else{
			if(is_singular('ozy_portfolio') || is_page_template('page-portfolio.php')) {
				// Custom background for portfolio post
				$body_style = $ozyWeddingPlannerHelper->background_style_render(wedding_planner_get_option('portfolio_body_background_color', null, $page_id), '', '', '', '');
			}else{
				$_var = 'body_background_';
				$body_style = $ozyWeddingPlannerHelper->background_style_render(
					wedding_planner_get_option($_var . 'color', null, $page_id),
					wedding_planner_get_option($_var . 'image', null, $page_id),
					wedding_planner_get_option($_var . 'image_size', null, $page_id),
					wedding_planner_get_option($_var . 'image_repeat', null, $page_id),
					wedding_planner_get_option($_var . 'image_attachment', null, $page_id)
				);
			}
		}

	?>
			@media only screen and (min-width: 1212px) {
				.container{padding:0;width:<?php echo wedding_planner_gd('container_width'); ?>px;}
				#content{width:<?php echo wedding_planner_gd('content_width'); ?>px;}
				#sidebar{width:<?php echo wedding_planner_gd('sidebar_width'); ?>px;}
			}

			/* Body Background Styling */
			body{
				<?php wedding_planner_o_css($body_style); ?>
				border-color:<?php echo wedding_planner_get_option('body_frame_color', '#fff'); ?>;
			}
			.top-info-bar,
			#floating-share,
			body>.frame-bottom,body>.frame-left,body>.frame-right{background-color:<?php echo wedding_planner_get_option('body_frame_color', '#fff'); ?>;}

			/* Layout and Layout Styling */
			#main.header-slider-active>.container,
			#main.footer-slider-active>.container{padding-top:0px;}
			#footer-widget-bar,#footer-widget-bar-sticky,.wedding-planner-btt {
				font-family:<?php echo wedding_planner_get_option('footer_typography_font_face', 'Cormorant Garamond')?>;
				background-color:<?php echo wedding_planner_get_option('footer_color_1', 'rgba(0,0,0,1)');?>;
			}
			#footer {
				background-color:<?php echo wedding_planner_get_option('footer_color_2', 'rgba(0,0,0,1)');?>;
			}
			#footer-widget-bar h1,#footer-widget-bar h2,#footer-widget-bar h3,#footer-widget-bar h4,#footer-widget-bar h5,#footer-widget-bar h6,#back-to-top-wrapper a,#back-to-top-wrapper a span,.ozy-twitter-widget-icon>span {color:<?php echo wedding_planner_get_option('footer_color_5', '#ffffff');?> !important;}
			#footer-widget-bar-sticky * {color:<?php echo wedding_planner_get_option('footer_color_3', '#ffffff');?> !important;}

			#footer-widget-bar *,#footer-widget-bar-sticky #close-footer-info-bar {color:<?php echo wedding_planner_get_option('footer_color_2', '#ffffff');?>;}

			#footer .container, #footer a {
				font-family:<?php echo wedding_planner_get_option('footer_typography_font_face', 'Cormorant Garamond')?>;
				color:<?php echo wedding_planner_get_option('footer_color_3', '#ffffff');?>;
			}

			#footer-widget-bar a,
			.ozy-twitter-widget div>span {color:<?php echo wedding_planner_get_option('footer_color_2', '#04c1ff');?> !important;}

			#footer-widget-bar #social-icons>a {
				background-color:<?php echo wedding_planner_get_option('footer_color_2', '#000000');?> !important;
			}
			/*.wedding-planner-btt svg>path{fill:<?php echo wedding_planner_get_option('footer_color_2', '#000000');?> !important;}*/
			#footer-widget-bar #social-icons>a>span {
				color:<?php echo wedding_planner_get_option('footer_color_3', '#ffffff');?> !important;
			}
			#footer-widget-bar{border-top-color:<?php echo wedding_planner_get_option('footer_color_4', 'rgba(255,255,255,.10)');?> !important;}
			#footer-widget-bar-sticky>.container.info-bar,
			#footer-widget-bar-sticky #close-footer-info-bar {background-color:<?php echo wedding_planner_get_option('footer_info_bg', 'rgba(29,27,27,1)');?>;}
			#footer-widget-bar form input:not(.button):not([type=checkbox]):not([type=radio]):not([type=submit]),
			form.ns_widget_mailchimp_form input:not(.button):not([type=checkbox]):not([type=radio]):not([type=submit]) {
				background-color:<?php echo wedding_planner_get_option('footer_color_3', '#000000');?> !important;
				color:<?php echo wedding_planner_get_option('footer_color_2', '#ffffff');?> !important;
				border-color:<?php echo wedding_planner_get_option('footer_color_2', '#ffffff');?> !important;
			}
			#footer-widget-bar form input.button, #footer-widget-bar form input[type=submit],
			form.ns_widget_mailchimp_form input.button, #footer-widget-bar form input[type=submit]{
				background-color:<?php echo wedding_planner_get_option('footer_color_2', '#000000');?> !important;
				color:<?php echo wedding_planner_get_option('footer_color_3', '#ffffff');?> !important;
			}
		<?php
			$menu_logo_height = wedding_planner_get_option('primary_menu_height', '130') . 'px';
			$menu_logo_height_alternate = wedding_planner_get_option('primary_menu_height_alternate', '60') . 'px';

			wedding_planner_o_css($transparent_content_background == '1' ? '	#main{background-color:transparent !important;}' . PHP_EOL : '');

			$footer_background_image = wedding_planner_get_option('footer_background_image');
			if($footer_background_image) { echo '#footer{background:url('. $footer_background_image .') repeat center center;}'; }

			?>
			/* Header Over Primary Menu Styling */
			.logo h1>a{color:<?php echo wedding_planner_get_option('primary_menu_font_color_hover'); ?>;}

			nav.navbar.bootsnav ul.nav > li > a {
				<?php
				wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render(
					wedding_planner_get_option('primary_menu_typography_font_face'),
					wedding_planner_get_option('primary_menu_typography_font_weight'),
					wedding_planner_get_option('primary_menu_typography_font_style'),
					wedding_planner_get_option('primary_menu_typography_font_size') . 'px',
					wedding_planner_get_option('primary_menu_typography_line_height') . 'em',
					wedding_planner_get_option('primary_menu_font_color')
				));
				?>
			}

			div.navbar-collapse .dropdown a,
			div.navbar-collapse .dropdown h4,
			nav.navbar.bootsnav .dropdown-menu a,
			nav.navbar.bootsnav .dropdown-submenu h4,
			nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li a {
				<?php
				wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render(
					wedding_planner_get_option('primary_menu_typography_font_face'),
					wedding_planner_get_option('primary_menu_typography_font_weight'),
					wedding_planner_get_option('primary_menu_typography_font_style'),
					wedding_planner_get_option('primary_menu_typography_font_size') . 'px',
					wedding_planner_get_option('primary_menu_typography_line_height') . 'em',
					wedding_planner_get_option('primary_menu_dropdown_font_color')
				));
				?>
			}
			div.navbar-collapse .dropdown a:hover,
			nav.navbar.bootsnav .dropdown-menu a:hover,
			nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li a:hover,
			div.navbar-collapse .dropdown li.active a,
			nav.navbar.bootsnav .dropdown-menu li.active a,
			nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li.active a,
			nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li.current-menu-item a {
				color:<?php echo wedding_planner_get_option('primary_menu_dropdown_font_color_hover') ?>;
			}
			@media (min-width: 1025px) {
				nav.navbar.bootsnav li.dropdown.on>a>span,
				nav.navbar.bootsnav li.dropdown ul.dropdown-menu,
				ul.navbar-nav>li.dropdown:hover>a>span {
					background-color:<?php echo wedding_planner_get_option('primary_menu_dropdown_background_color') ?>;;
					color:<?php echo wedding_planner_get_option('primary_menu_font_color_hover') ?>;
				}

				nav.navbar .navbar-brand img.logo,
				nav.navbar .navbar-brand,
				nav.bootsnav .container {height:<?php echo esc_attr($menu_logo_height)?>;}
				.attr-nav {line-height:<?php echo esc_attr($menu_logo_height)?>;}
				body.ozy-alternate-menu nav.navbar .navbar-brand img.logo,
				body.ozy-alternate-menu nav.navbar .navbar-brand,
				body.ozy-alternate-menu nav.bootsnav .container {height:<?php echo esc_attr($menu_logo_height_alternate); ?>;}
				body.ozy-alternate-menu .attr-nav {line-height:<?php echo (int)esc_attr($menu_logo_height_alternate)-8; ?>px;}
				nav.navbar {min-height:<?php echo esc_attr($menu_logo_height_alternate); ?>;}
				body.ozy-alternate-menu nav.navbar.bootsnav ul.nav > li > a	{line-height:<?php echo esc_attr($menu_logo_height_alternate); ?>;}
				body.ozy-alternate-menu nav.navbar .navbar-brand img.logo {margin-top: -<?php echo esc_attr($menu_logo_height_alternate); ?>;}
				/* Dropdown & Mega Menu border fix */
				nav.bootsnav.brand-center ul.nav > li.dropdown > ul.dropdown-menu{top:<?php echo esc_attr((int)$menu_logo_height_alternate-3) ?>px}
				body.ozy-alternate-menu nav.bootsnav.brand-center ul.nav > li.dropdown > ul.dropdown-menu{top:<?php echo esc_attr((int)$menu_logo_height_alternate+1) ?>px;}
			}
			@media (min-width: 1025px) and (max-width: 1440px) {
				nav.bootsnav.brand-center ul.nav > li.dropdown > ul.dropdown-menu{top:<?php echo esc_attr((int)$menu_logo_height_alternate-18) ?>px}
				body.ozy-alternate-menu nav.bootsnav.brand-center ul.nav > li.dropdown > ul.dropdown-menu{top:<?php echo esc_attr((int)$menu_logo_height_alternate-17) ?>px;}
			}
			@media (max-width: 1025px) {
				nav.navbar {
					background-color:<?php echo wedding_planner_get_option('mobile_menu_background_color') ?> !important;
					color:<?php echo wedding_planner_get_option('mobile_menu_font_color') ?> !important;
					/*min-height:<?php echo esc_attr($menu_logo_height_alternate); ?>;*/
					min-height: auto;					
				}
				.attr-nav > ul > li.search > a {
					color:<?php echo wedding_planner_get_option('mobile_menu_font_color') ?> !important;
				}
				nav.navbar.bootsnav ul.nav li a,
				nav.navbar.bootsnav .dropdown .megamenu-content .col-menu .title {
					color:<?php echo wedding_planner_get_option('mobile_menu_dropdown_font_color') ?> !important;
				}
				div.navbar-collapse .dropdown a:hover, nav.navbar.bootsnav .dropdown-menu a:hover, nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li a:hover, div.navbar-collapse .dropdown li.active a, nav.navbar.bootsnav .dropdown-menu li.active a, nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li.active a, nav.navbar.bootsnav ul.dropdown-menu.megamenu-content .content ul.menu-col li.current-menu-item a {
					color:<?php echo wedding_planner_get_option('mobile_menu_dropdown_font_color_hover') ?> !important;
				}
				body.ozy-alternate-menu ul.navbar-nav>li.dropdown:hover>a>span {
					background-color: transparent !important;
					color:<?php echo wedding_planner_get_option('mobile_menu_dropdown_font_color_hover') ?> !important;
				}
				nav.navbar.bootsnav .navbar-collapse {
					background-color:<?php echo wedding_planner_get_option('mobile_menu_dropdown_background_color') ?> !important;
				}

				nav.navbar.bootsnav .navbar-nav > li > a,
				nav.navbar.bootsnav .dropdown .megamenu-content .col-menu ul > li > a,
				nav.navbar.bootsnav .dropdown .megamenu-content .col-menu .title {
					border-color: <?php echo wedding_planner_get_option('mobile_menu_separator_color') ?> !important;
				}
			}
			
			body.ozy-alternate-menu nav.navbar {
				background-color:<?php echo wedding_planner_get_option('primary_menu_background_color_alternate') ?>;
			}

			.attr-nav > ul > li.search > a {
				color:<?php echo wedding_planner_get_option('primary_menu_font_color') ?>;
			}
			body.ozy-alternate-menu nav.navbar.bootsnav ul.nav > li > a,
			body.ozy-alternate-menu .attr-nav > ul > li.search > a {
				color:<?php echo wedding_planner_get_option('primary_menu_font_color_alternate') ?>;
			}
			body.ozy-alternate-menu ul.navbar-nav>li.dropdown:hover>a>span {
				background-color:<?php echo wedding_planner_get_option('primary_menu_dropdown_background_color_alternate') ?>;
				color:<?php echo wedding_planner_get_option('primary_menu_font_color_hover_alternate') ?>;
			}
			ul.navbar-nav>li.on>a>span,
			ul.navbar-nav>li>a:hover>span,
			nav.bootsnav.brand-center ul.nav > li.dropdown  ul.dropdown-menu,
			nav.navbar.bootsnav li.dropdown ul.dropdown-menu > li > a {
				border-color:<?php echo wedding_planner_get_option('primary_menu_separator_color_alternate') ?>;
			}
			ul.navbar-nav>li>a>span>span {
				border-color:<?php echo wedding_planner_get_option('primary_menu_font_color') ?>;
			}
			body.ozy-alternate-menu ul.navbar-nav>li>a>span>span {
				border-color:<?php echo wedding_planner_get_option('primary_menu_font_color_alternate') ?>;
			}

			/* Widgets */
			.widget li>a{color:<?php echo wedding_planner_get_option('content_color'); ?> !important;}
			.widget li>a:hover{color:<?php echo wedding_planner_get_option('content_color_alternate'); ?> !important;}
			.ozy-latest-posts>a>span,.lSSlideOuter .lSPager.lSpg>li.active a, .lSSlideOuter .lSPager.lSpg>li:hover a{
				background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?>;
				color:<?php echo wedding_planner_get_option('content_color') ?>;
			}

			/* Page Styling and Typography */
			.content-color-alternate, .content-color-alternate a, .content-color-alternate p{color:<?php echo wedding_planner_get_option('content_color_alternate'); ?> !important;}
			.content-color-alternate2, .content-color-alternate2 a, .content-color-alternate2 p{color:<?php echo wedding_planner_get_option('content_color_alternate2'); ?> !important;}
			.content-color-alternate3, .content-color-alternate3 a, .content-color-alternate3 p{color:<?php echo wedding_planner_get_option('content_color_alternate3'); ?> !important;}
			.content-color-alternate4,.nav-box>h4,.nav-box>a>span,h4.ozy-related-posts-title {color:<?php echo wedding_planner_get_option('content_color_alternate4'); ?> !important;}
			.heading-color, .heading-color a,h1.content-color>a,h2.content-color>a,h3.content-color>a,
			h4.content-color>a,h5.content-color>a,h6.content-color>a,blockquote,.a-page-title {color:<?php echo wedding_planner_get_option('heading_color'); ?> !important;}
			.ozy-footer-slider,.content-font,.ozy-header-slider,#content, #sidebar,#footer,.tooltipsy{
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render(wedding_planner_get_option('typography_font_face'),
				wedding_planner_get_option('typography_font_weight'),
				wedding_planner_get_option('typography_font_style'),
				wedding_planner_get_option('typography_font_size') . 'px',
				wedding_planner_get_option('typography_font_line_height') . 'em',
				wedding_planner_get_option('content_color')));?>
			}
			.content-font-family{font-family:<?php echo wedding_planner_get_option('typography_font_face'); ?>}
			.lg-sub-html{font-family:<?php echo wedding_planner_get_option('typography_font_face') ?>}/*light gallery caption*/
			#content a:not(.ms-btn):not(.vc_btn3),#sidebar a,.alternate-text-color,#footer-widget-bar>.container>.widget-area a:hover,.fancybox-inner a,.item__details ul li:first-child {			color:<?php echo wedding_planner_get_option('content_color_alternate');?>;}
			#ozy-share-div>a>span,.page-pagination a {
				background-color:<?php echo wedding_planner_get_option('content_background_color_alternate');?> !important;
				color:<?php echo wedding_planner_get_option('content_color');?> !important;
			}
			.page-pagination a.current{
				background-color:<?php echo wedding_planner_get_option('content_color_alternate');?> !important;
				color:<?php echo wedding_planner_get_option('content_color_alternate2');?> !important;
			}
			.fancybox-inner{color:<?php echo wedding_planner_get_option('content_color');?> !important;}
			.header-line{background-color:<?php echo wedding_planner_get_option('separator_color') ?>;}
			.a-page-title:hover{border-color:<?php echo wedding_planner_get_option('heading_color');?> !important;}
			.nav-box a, .ozy-related-posts a,#page-title-wrapper h1,#page-title-wrapper h4,
			#side-nav-bar a,#side-nav-bar h3,#content h1,
			#sidebar .widget h1,#content h2,#sidebar .widget h2,
			#content h3,#sidebar .widget h3,#content h4,
			#sidebar .widget h4,#content h5,#sidebar .widget h5,
			#content h6,#sidebar .widget h6,.heading-font,
			#logo,#tagline,.fancybox-inner{<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render(wedding_planner_get_option('typography_heading_font_face'), '', '', '', '', wedding_planner_get_option('heading_color')));?>}
			#page-title-wrapper h1,#content h1,#footer-widget-bar h1,
			#sidebar h1,#footer h1,#sidr h1{
					<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h1'),
				wedding_planner_get_option('typography_heading_h1_font_style'),
				wedding_planner_get_option('typography_heading_h1_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h1', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h1')));?>
			}
			#footer-widget-bar .widget-area h4,
			#sidebar .widget>h4,
			h4.heading-h4 {
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h4'),
				wedding_planner_get_option('typography_heading_h4_font_style'),
				wedding_planner_get_option('typography_heading_h4_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h4', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h4')));?>
			}
			#content h2,#footer-widget-bar h2,#sidebar h2,
			#footer h2,#sidr h2{
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h2'),
				wedding_planner_get_option('typography_heading_h2_font_style'),
				wedding_planner_get_option('typography_heading_h2_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h2', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h2')));?>;
			}
			#content h3,#footer-widget-bar h3,#sidebar h3,#footer h3,#sidr h3{
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h3'),
				wedding_planner_get_option('typography_heading_h3_font_style'),
				wedding_planner_get_option('typography_heading_h3_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h3', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h3')));?>;
			}
			#content h4,#page-title-wrapper h4,#footer-widget-bar h4,
			#sidebar h4,#footer h4,#sidr h4{
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h4'),
				wedding_planner_get_option('typography_heading_h4_font_style'),
				wedding_planner_get_option('typography_heading_h4_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h4', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h4')));?>;
			}
			#content h5,#footer-widget-bar h5,#sidebar h5,#footer h5,#sidr h5 {
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h5'),
				wedding_planner_get_option('typography_heading_h5_font_style'),
				wedding_planner_get_option('typography_heading_h5_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h5', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h5')));?>;
			}
			#content h6,#footer-widget-bar h6,#sidebar h6,#footer h6,#sidr h6{
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h6'),
				wedding_planner_get_option('typography_heading_h6_font_style'),
				wedding_planner_get_option('typography_heading_h6_font_size') . 'px',
				wedding_planner_get_option('typography_heading_line_height_h6', '1.5') . 'em', '', '',
				wedding_planner_get_option('typography_heading_font_ls_h6')));?>;
			}
			body.single h2.post-title,.post-single h2.post-title {
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render('',
				wedding_planner_get_option('typography_heading_font_weight_h1'),
				wedding_planner_get_option('typography_heading_h1_font_style'),
				wedding_planner_get_option('typography_heading_h1_font_size') . 'px',
				'1.1em', '', '!important',
				wedding_planner_get_option('typography_heading_font_ls_h1')));?>
			}
			.h1-size{
				font-size:<?php echo wedding_planner_get_option('typography_heading_h1_font_size') . 'px';?>;
				line-height:<?php echo wedding_planner_get_option('typography_heading_line_height_h1', '1.5') . 'em'; ?>
			}
			.h2-size{
				font-size:<?php echo wedding_planner_get_option('typography_heading_h2_font_size') . 'px';?>;
				line-height:<?php echo wedding_planner_get_option('typography_heading_line_height_h2', '1.5') . 'em'; ?>
			}
			.h3-size{
				font-size:<?php echo wedding_planner_get_option('typography_heading_h3_font_size') . 'px';?>;
				line-height:<?php echo wedding_planner_get_option('typography_heading_line_height_h3', '1.5') . 'em'; ?>
			}
			.h4-size{
				font-size:<?php echo wedding_planner_get_option('typography_heading_h4_font_size') . 'px';?>;
				line-height:<?php echo wedding_planner_get_option('typography_heading_line_height_h4', '1.5') . 'em'; ?>
			}
			.h5-size{
				font-size:<?php echo wedding_planner_get_option('typography_heading_h5_font_size') . 'px';?>;
				line-height:<?php echo wedding_planner_get_option('typography_heading_line_height_h5', '1.5') . 'em'; ?>
			}
			.h6-size{
				font-size:<?php echo wedding_planner_get_option('typography_heading_h6_font_size') . 'px';?>;
				line-height:<?php echo wedding_planner_get_option('typography_heading_line_height_h6', '1.5') . 'em'; ?>
			}

			#footer-widget-bar .widget a:hover,
			#sidebar .widget a:hover{color:<?php echo wedding_planner_get_option('content_color')?>;}
			span.plus-icon>span{background-color:<?php echo wedding_planner_get_option('content_color')?>;}
			.content-color,#single-blog-tags>a{color:<?php echo wedding_planner_get_option('content_color'); ?> !important;}

			/* Forms */
			input,select,textarea{
				<?php wedding_planner_o_css($ozyWeddingPlannerHelper->font_style_render(wedding_planner_get_option('typography_font_face'),
				wedding_planner_get_option('typography_font_weight'),
				wedding_planner_get_option('typography_font_style'),
				wedding_planner_get_option('typography_font_size') . 'px',
				wedding_planner_get_option('typography_font_line_height') . 'em',
				wedding_planner_get_option('form_font_color')));?>
			}
			.lightbox-book-me-now {
				color:<?php echo wedding_planner_get_option('form_button_font_color_hover')?> !important;
			}
			.wp-search-form i.oic-zoom{color:<?php echo wedding_planner_get_option('form_font_color') ?>;}
			.woocommerce #respond input#submit, input:not([type=reset]):not([type=button]):not([type=submit]):not([type=password]):not([type=radio]):not([type=checkbox]):not([type=file]),select,textarea{
				background-color:<?php echo wedding_planner_get_option('form_background_color')?>;
				border-color:<?php echo wedding_planner_get_option('form_background_color')?> !important;
			}
			#content input:not([type=submit]):not([type=radio]):not([type=checkbox]):not([type=file]):hover,#content textarea:hover,
			#content input:not([type=submit]):not([type=radio]):not([type=checkbox]):not([type=file]):focus,#content textarea:focus{border-color:<?php echo wedding_planner_get_option('content_color_alternate')?> !important;}
			.woocommerce #respond input#submit, .generic-button,input[type=button],input[type=submit],button[type=submit],.tagcloud>a {
				color:<?php wedding_planner_o_css($ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('form_button_font_color')))?> !important;
				background-color:<?php echo wedding_planner_get_option('form_button_background_color')?>;
				border:1px solid <?php echo wedding_planner_get_option('form_button_background_color')?>;
			}
			.generic-button-opacity {
				background-color:<?php wedding_planner_o_css($ozyWeddingPlannerHelper->change_opacity(wedding_planner_get_option('form_button_background_color'),'.8'))?>!important;
			}
			.woocommerce #respond input#submit, input[type=button]:hover,input[type=submit]:hover,button[type=submit]:hover,.tagcloud>a:hover{
				background-color:<?php wedding_planner_o_css($ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('form_button_background_color_hover')))?>;
				color:<?php wedding_planner_o_css($ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('form_button_font_color_hover')))?> !important;
				border:1px solid <?php echo wedding_planner_get_option('form_button_background_color_hover')?>;
			}

			/* Blog Comments & Blog Stuff */
			.post.regular-blog{background-color:<?php echo wedding_planner_get_option('content_background_color_alternate') ?> !important;}
			#comments>h3>span{background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?>;}
			.comment-body>.comment-meta.commentmetadata>a,.comment-body .reply>a,#commentform .form-submit .submit{color:<?php echo wedding_planner_get_option('content_color') ?> !important}
			#commentform .form-submit .submit{border-color:<?php echo wedding_planner_get_option('content_color') ?> !important;}
			#commentform .form-submit .submit:hover{border-color:<?php echo wedding_planner_get_option('content_color_alternate') ?> !important;}
			.post-meta p.g{color:<?php echo wedding_planner_get_option('content_color_alternate2')?>;}
			.ozy-related-posts .caption,
			.ozy-related-posts .caption>h4>a{
				color:<?php echo wedding_planner_get_option('content_background_color') ?> !important;
				background-color:<?php echo wedding_planner_get_option('content_color') ?>;
			}
			.super-header-share-buttons>a{
				background-color:<?php echo wedding_planner_get_option('content_color_alternate3') ?>;
				color:<?php echo wedding_planner_get_option('content_color_alternate2') ?>;
			}
			.super-header-share-buttons>a:hover,
			.super-header-share-buttons>a:active{
				background-color:<?php echo wedding_planner_get_option('content_color_alternate2') ?>;
				color:<?php echo wedding_planner_get_option('content_color_alternate3') ?>;
			}
			/*post formats*/
			.simple-post-format>div>span,.simple-post-format>div>h2,.simple-post-format>div>p,
			.simple-post-format>div>p>a,.simple-post-format>div>blockquote,.post-excerpt-audio>div>div{color:<?php wedding_planner_o_css($ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('content_background_color')))?> !important;}
			div.sticky.post-single {
				background-color:<?php echo wedding_planner_get_option('separator_color') ?>;
				border-color:<?php echo wedding_planner_get_option('content_color_alternate') ?>;
			}
			#content .post .post-meta {
				position:absolute;left:20px;top:20px;width:65px;padding:8px 0 0 0;
				background-color: <?php echo wedding_planner_get_option('content_color_alternate')?>;
				text-align:center;
				z-index:1;
			}
			#content .post .post-meta span {display:block;font-weight:400;padding-bottom:4px !important;}
			#content .post .post-meta span.d,
			#content .post .post-meta span.c>span.n {font-size:24px !important;line-height:24px !important;font-weight:700;}
			#content .post .post-meta span.c>span.t {font-size:8px !important;line-height:10px !important;}
			#content .post .post-meta span.m,
			#content .post .post-meta span.y,
			#content .post .share-box>span {
				font-size:10px !important;line-height:12px !important;
				color: <?php echo wedding_planner_get_option('content_color_alternate4')?> !important;
				text-transform:uppercase;
			}
			#content .post .post-meta span.d{font-weight:700 !important;color: <?php echo wedding_planner_get_option('content_color_alternate4')?> !important;}
			#content .post .post-meta span.c {
				padding-top:8px;background-color: <?php echo wedding_planner_get_option('content_color_alternate4')?>;
				color: <?php echo wedding_planner_get_option('content_color_alternate3')?>;
			}

			/* Shortcodes */
			.flickity-page-dots .dot{background-color:<?php echo wedding_planner_get_option('content_color') ?>;}
			.flickity-page-dots .dot.is-selected{background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?>;}

			.ozy-button.auto,.wpb_button.wpb_ozy_auto{
				background-color:<?php echo wedding_planner_get_option('form_button_background_color') ?>;
				color:<?php echo wedding_planner_get_option('form_button_font_color')?>;
			}
			.ozy-button.auto:hover,
			.wpb_button.wpb_ozy_auto:hover{
				border-color:<?php echo wedding_planner_get_option('form_button_background_color_hover') ?>;
				color:<?php echo wedding_planner_get_option('form_button_font_color_hover') ?> !important;
				background-color:<?php echo wedding_planner_get_option('form_button_background_color_hover')?>;
			}
			.ozy-call-to-action-box>div.overlay-wrapper>a:hover{
				background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?> !important;
				border-color:<?php echo wedding_planner_get_option('content_color_alternate') ?> !important;
			}
			.ozy-call-to-action-box>div.overlay-wrapper>a {border-color:<?php echo wedding_planner_get_option('content_color_alternate3') ?> !important;}
			.ozy-call-to-action-box>div.overlay-wrapper>a,
			.ozy-call-to-action-box>div.overlay-wrapper>h2{color:<?php echo wedding_planner_get_option('content_color_alternate3') ?> !important;}
			.ozy-canvas-slider-wrapper nav.btns button:hover{
				background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?> !important;
				color:<?php echo wedding_planner_get_option('content_color_alternate3') ?> !important;
			}

			/* Fancy Post Accordion */
			.ozy-fancyaccordion-feed tr.title td:last-child h3,
			.ozy-fancyaccordion-feed tr.excerpt td:last-child p>a {
				color:<?php echo wedding_planner_get_option('content_color') ?> !important;
			}
			.ozy-fancyaccordion-feed tr.excerpt td:last-child p>a {
				border-color:<?php echo wedding_planner_get_option('content_color') ?> !important;
			}
			.ozy-fancyaccordion-feed tr.title:hover td:last-child h3,
			.ozy-fancyaccordion-feed tr.title.open td:last-child h3 {
				color:<?php echo wedding_planner_get_option('content_color_alternate') ?> !important;
			}
			.ozy-fancyaccordion-feed tr.title td:first-child span {
				background-color:<?php echo wedding_planner_get_option('content_color') ?> !important;
				color:<?php echo wedding_planner_get_option('content_color_alternate3') ?> !important;
			}
			.ozy-fancyaccordion-feed tr.title:hover td:first-child span,
			.ozy-fancyaccordion-feed tr.title.open td:first-child span {
				background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?> !important;
				color:<?php echo wedding_planner_get_option('content_color_alternate3') ?> !important;
			}

			#ozy-cookie_notice_banner {
				color:<?php echo wedding_planner_get_option('form_button_font_color') ?>;
				background-color:<?php wedding_planner_o_css($ozyWeddingPlannerHelper->change_opacity(wedding_planner_get_option('form_button_background_color'), '1')); ?>;
			}

			/* Shared Border Color */
			.ozy-fancyaccordion-feed td, .post .pagination>a,.ozy-border-color,#ozy-share-div.ozy-share-div-blog,.page-content table td,#content table tr,.post-content table td,.ozy-toggle .ozy-toggle-title, .ozy-toggle-inner,.ozy-tabs .ozy-nav li a,.ozy-accordion>h6.ui-accordion-header,.ozy-accordion>div.ui-accordion-content,.chat-row .chat-text,#sidebar .widget>h4,
			#sidebar .widget li,.ozy-content-divider,#post-author,.single-post .post-submeta>.blog-like-link,.widget ul ul,blockquote,.page-pagination>a,.page-pagination>span,#content select,body.search article.result,div.rssSummary,#content table tr td,#content table tr th,.widget .testimonial-box,
			.facts-bar,.facts-bar>.heading,.ozy-tabs-menu li,.ozy-tab,#ozy-tickerwrapper,#ozy-tickerwrapper>strong,#single-blog-tags>a,.comment-body,#comments-form h3#reply-title,.ozy-news-box-ticker-wrapper .news-item, .shared-border-color {border-color:<?php echo wedding_planner_get_option('separator_color') ?>!important;}
			#content table tr.featured {border:2px solid <?php echo wedding_planner_get_option('content_color_alternate') ?> !important;}
			#ozy-tickerwrapper div.pagination>a.active>span,
			.header-line>span{background-color:<?php echo wedding_planner_get_option('content_color_alternate') ?>;}

			/* Specific heading styling */
		<?php
			$use_no_page_title_margin = $custom_header = false;
			if(!is_search() && !is_404() && isset($post->ID)) {
				/*to get custom post*/
				//$post_id = $post->ID;
				$post_id = wedding_planner_get_woocommerce_page_id() ? wc_get_page_id('shop') : $post->ID;
				if (is_single() && isset($post->post_type) && $post->post_type === 'post' && (int)wedding_planner_get_option('page_blog_page_id')>0) { $post_id = wedding_planner_get_option('page_blog_page_id'); }

				if(wedding_planner_get_metabox('use_custom_title', 0, $post_id) == '1') {
					$_var = 'use_custom_title_group.0.ozy_wedding_planner_meta_page_custom_title_';
					$h_height 	= wedding_planner_get_metabox($_var . 'height', '90', $post_id);
					$h_bgcolor 	= wedding_planner_get_metabox($_var . 'bgcolor', '', $post_id);
					$h_bgimage 	= wedding_planner_get_metabox($_var . 'bg', '', $post_id);
					$h_bg_xpos	= wedding_planner_get_metabox($_var . 'bg_x_position', '', $post_id);
					$h_bg_ypos	= wedding_planner_get_metabox($_var . 'bg_y_position', '', $post_id);
					$h_bg_repeat= wedding_planner_get_metabox($_var . 'bg_repeat', '', $post_id);
					$h_bg_size	= wedding_planner_get_metabox($_var . 'bg_size', '', $post_id);

					$h_css = (int)$h_height > 0 ? 'height:'. $h_height .'px;' : '';
					$h_css.= (int)$h_height > 0 ? $ozyWeddingPlannerHelper->background_style_render($h_bgcolor, $h_bgimage, $h_bg_size, $h_bg_repeat, 'inherit', true, $h_bg_xpos, $h_bg_ypos) : '';
					echo '#page-title-wrapper{'. $h_css .'}';
					$h_title_color = wedding_planner_get_metabox($_var . 'color', 0, $post_id);
					if($h_title_color) {
						echo '#page-title-wrapper>div>h1{
							color:'. $h_title_color .';
						}';
					}
					$h_sub_title_color = wedding_planner_get_metabox('use_custom_title_group.0.ozy_wedding_planner_meta_page_custom_sub_title_color', 0, $post_id);
					if($h_sub_title_color) {
						echo '#page-title-wrapper>div>h4{
							color:'. $h_sub_title_color .';
							font-weight:300;
						}';
					}

					$h_title_position = wedding_planner_get_metabox($_var . 'position', 0, $post_id);
					if($h_title_position) {
						echo '#page-title-wrapper>div>h1,
						#page-title-wrapper>div>h4{
							text-align:'. $h_title_position .';
							font-weight:300;
						}';
					}
					$custom_header = true;
				}else{
					echo '#page-title-wrapper{
						height:140px;
						text-align:center;
					}';
				}
			}else{
				echo '#page-title-wrapper{
					height:140px;
					text-align:center;
				}';
			}
			$use_no_menu_space = $page_id > 0 ? vp_metabox('ozy_wedding_planner_meta_page.ozy_wedding_planner_meta_page_no_menu_space', 0, $page_id) : 0;
			if($use_no_menu_space === '1') {
				echo '#main{padding-top:0!important}';
				echo '@media only screen and (max-width: 1024px) { #main {padding-top: '. $menu_logo_height_alternate .'!important;} }';
				echo '@media only screen and (max-width: 667px) { #main {padding-top: 100px!important;} body.no-top-info-bar #main {padding-top: 60px!important;} }';
			}else{
				echo '@media only screen and (min-width: 479px) { body:not(.full-page-template):not(.single) #main{padding-top:'. $menu_logo_height .';} }';
				echo '@media only screen and (max-width: 479px) { body:not(.full-page-template):not(.single) #main,body.single-ozy_portfolio #main{padding-top:'. ((int)$menu_logo_height/2) .'px;} }';
				echo '@media only screen and (min-width: 479px) { body:not(.full-page-template).woocommerce-page #main{padding-top:'. ((int)$menu_logo_height + 93) .'px;} }';
			}
			if(wedding_planner_get_metabox('use_no_content_padding') === '1') {
				echo '#main>.container{
					padding-top:0!important;
				}';
			}
			//echo 'body.full-page-template{#main{padding-top:0!important}}';
		?>

			/* Conditional Page Template Styles */
			<?php
			if(is_home() || is_category() || is_archive() || is_tag() || is_author()) {
				echo '#main{background-color:'. wedding_planner_get_option('content_background_color_alternate') .' !important}';
			}
			if(is_page_template('page-big-blog.php')) {
				echo '.big-blog-post-submeta>a.button{color:'. wedding_planner_get_option('content_color') .' !important}';
				echo '.big-blog-post-submeta>a.button>i,.big-blog-category{color:'. wedding_planner_get_option('heading_color') .'}';
				echo 'body.page-template-page-big-blog .big-blog-date-category-seperator{background-color:'. wedding_planner_get_option('heading_color') .'}';
				echo 'body.page-template-page-big-blog .post.regular-blog{border-color:'. wedding_planner_get_option('heading_color') .'}';
			}
			if(is_page_template('page-full-blog.php')) {
				echo '.page-template-page-full-blog-php .share-buttons a:hover{background-color:'. wedding_planner_get_option('content_color_alternate') .';}';
			}
			if (is_single() && isset($post->post_type) && $post->post_type === 'ozy_portfolio') {
				echo '.portfolio-single-title{color:'. wedding_planner_get_option('heading_color', '#000') .';}';
			}
			if(is_page_template('page-portfolio.php')) {
			?>
			.button-container .button {
				color:<?php echo wedding_planner_get_option('content_color', '#fff') ?>!important;
			}
			.button-container .button:hover {
				color:<?php echo wedding_planner_get_option('content_color_alternate', '#30303c') ?>!important;
			}
			#portfolio-filter>li>a {
				color:<?php echo wedding_planner_get_option('content_color', '#fff') ?>!important;
			}
			#portfolio-filter>li.active>a {
				color:<?php echo wedding_planner_get_option('content_color_alternate', '#fff') ?>!important;
			}
			#portfolio-filter>li.active {
				border-color:currentColor;
			}
			body.page-template-page-portfolio .lightgallery.plus-icon {
				color:<?php echo wedding_planner_get_option('content_color', '#fff') ?>!important;
				background-color:<?php echo wedding_planner_get_option('content_color_alternate3', '#30303c') ?>!important;
			}
			.wpb_wrapper.isotope>.ozy_portfolio>.featured-thumbnail>.caption>.heading>a,
			.wpb_wrapper.isotope>.ozy_portfolio>.featured-thumbnail>.caption>.view-more{color:<?php echo wedding_planner_get_option('content_color_alternate3', '#30303c') ?>!important;}
			<?php
			}

			if(is_page_template('page-big-blog.php')) {
				echo '.big-blog-post-submeta>a.button{color:'. wedding_planner_get_option('content_color') .' !important}';
				echo '.big-blog-post-submeta>a.button>i,.big-blog-category{color:'. wedding_planner_get_option('heading_color') .'}';
				echo 'body.page-template-page-big-blog .big-blog-date-category-seperator{background-color:'. wedding_planner_get_option('heading_color') .'}';
				echo 'body.page-template-page-big-blog .post.regular-blog{border-color:'. wedding_planner_get_option('heading_color') .'}';
			}
			$ozyWeddingPlannerHelper->render_custom_fonts();
			?>
			.nav-box-wrapper>div,
			.ozy-related-posts-wrapper>div,
			#content.no-vc,
			body.single-post #content,
			.ozy-page-model-full #page-title-wrapper>div,
			.featured-thumbnail-header>div>div>div,
			.ozy-page-model-boxed #main {max-width:<?php echo wedding_planner_gd('container_width'); ?>px !important;} /*1212*/

			body:not(.single):not(.single-ozy_portfolio) #content.no-sidebar {width:<?php echo (int)wedding_planner_gd('container_width')-72; ?>px;} /*1140*/

			body.page-template-page-full:not(.single):not(.single-ozy_portfolio) #content.no-sidebar {width:100%;} /*1140*/
			#footer-widget-bar-sticky>.container.info-bar>section {max-width:<?php echo (int)wedding_planner_gd('container_width')-32; ?>px;} /*1180*/

			#footer-widget-bar .container,
			#footer .container{width:100%;max-width:1600px;}

			body.page-template-page-regular-blog .ozy-header-slider,
			body.single #content.no-vc {max-width:<?php echo (int)wedding_planner_gd('container_width')-72; ?>px;} /*1140*/
			@media only screen and (max-width: 1024px) {
				.nav-box-wrapper>div,
				.ozy-related-posts-wrapper>div,
				#content.no-vc,
				body.single-post #content,
				.ozy-page-model-full #page-title-wrapper>div,
				.ozy-page-model-boxed #main {width:<?php echo wedding_planner_gd('container_width'); ?>px !important;width:100% !important;}
			}
			<?php	
			if(wedding_planner_is_woocommerce_activated()) { ?>
			/* WooCommerce */
			.woocommerce .onsale,
			.woocommerce .woocommerce-product-details__short-description,
			body.single-product.woocommerce .summary .price,
			.woocommerce ul.products li.product .price {
				font-family:<?php echo wedding_planner_get_option('typography_heading_font_face') ?>;
			}

			.woocommerce div.product p.price, 
			.woocommerce div.product span.price,
			.woocommerce ul.products li.product .price {
				color:<?php echo wedding_planner_get_option('content_color_alternate'); ?>;
			}
			
			.woocommerce li.product a.added_to_cart.wc-forward,
			.woocommerce li.product a.button.add_to_cart_button,
			.woocommerce li.product a.button.product_type_grouped,
			.woocommerce ul.products li.product .woocommerce-loop-category__title,
			.woocommerce ul.products li.product .woocommerce-loop-product__title,
			.woocommerce ul.products li.product h3,
			.woocommerce div.product .product_title,
			.woocommerce .wc-tab h2, 
			.woocommerce .upsells h2, 
			.woocommerce .related.products h2,
			.tabs.wc-tabs>li>a {
				color:<?php echo wedding_planner_get_option('content_color'); ?>!important;
			}

			.woocommerce li.product a.added_to_cart.wc-forward:hover,
			.woocommerce li.product a.button.add_to_cart_button:hover,
			.woocommerce li.product a.button.product_type_grouped:hover {
				color:<?php echo wedding_planner_get_option('content_color_alternate3'); ?>!important;
				background-color:<?php echo wedding_planner_get_option('content_color_alternate'); ?>!important;
			}

			.woocommerce li.product a.added_to_cart.wc-forward,
			.woocommerce li.product a.button.add_to_cart_button,
			.woocommerce li.product a.button.product_type_grouped {
				color:<?php echo wedding_planner_get_option('content_color_alternate3'); ?>!important;
				background-color:<?php echo wedding_planner_get_option('content_color_alternate4'); ?>!important;
			}

			.woocommerce ul.products li.product .woocommerce-loop-category__title a,
			.woocommerce ul.products li.product .woocommerce-loop-product__title a {
				color:<?php echo wedding_planner_get_option('content_color_alternate'); ?>!important;
			}
			.woocommerce div.product form.cart .button:not(.like-text-field),
			.woocommerce #review_form #respond .form-submit input,
			.woocommerce .button:not(.like-text-field),
			a.cart-contents {
				color:<?php echo $ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('form_button_font_color'))?> !important;
				background-color:<?php echo wedding_planner_get_option('form_button_background_color')?> !important;
				border: none;
			}
			.woocommerce div.product form.cart .button:not(.like-text-field):hover,
			.woocommerce #review_form #respond .form-submit input:hover,
			.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover,
			.woocommerce .button:not(.like-text-field):hover,
			a.cart-contents:hover {
				background-color:<?php echo $ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('form_button_background_color_hover'))?> !important;
				color:<?php echo $ozyWeddingPlannerHelper->rgba2rgb(wedding_planner_get_option('form_button_font_color_hover'))?> !important;
				transition: all .3s;
			}

			#content .woocommerce table.shop_attributes th,
			#content table.shop_attributes th {
				color:<?php echo wedding_planner_get_option('content_color')?> !important;
			}
			<?php
				echo '.woocommerce ul.product_list_widget li a{color:' . wedding_planner_get_option('content_color') . ';}';
			}

		return $ozyWeddingPlannerHelper->wedding_planner_trim_all(ob_get_clean());
	}
endif;
?>
