<?php
/**
 * Menu item custom fields example
 *
 * Copy this file into your wp-content/mu-plugins directory.
 *
 * @package Menu_Item_Custom_Fields
 * @version 0.1.0
 * @author Dzikri Aziz <kvcrvt@gmail.com>
 *
 *
 * Plugin name: Menu Item Custom Fields Example
 * Plugin URI: https://github.com/kucrut/wp-menu-item-custom-fields
 * Description: Example usage of Menu Item Custom Fields in plugins/themes
 * Version: 0.1.0
 * Author: Dzikri Aziz
 * Author URI: http://kucrut.org/
 * License: GPL v2
 * Text Domain: my-plugin
 */
class Menu_Item_Custom_Fields_Mega_Menu_Title {

	/**
	 * Initialize plugin
	 */
	public static function init() {
		add_action( 'menu_item_custom_fields', array( __CLASS__, '_fields' ), 10, 3 );
		add_action( 'wp_update_nav_menu_item', array( __CLASS__, '_save' ), 10, 3 );
		add_filter( 'manage_nav-menus_columns', array( __CLASS__, '_columns' ), 99 );
	}

	/**
	 * Save custom field value
	 *
	 * @wp_hook action wp_update_nav_menu_item
	 *
	 * @param int   $menu_id         Nav menu ID
	 * @param int   $menu_item_db_id Menu item ID
	 * @param array $menu_item_args  Menu item data
	 */
	public static function _save( $menu_id, $menu_item_db_id, $menu_item_args ) {
		//check_admin_referer( 'update-nav_menu', 'update-nav-menu-nonce' );

		// Sanitize
		if ( ! empty( $_POST['menu-item-istitle'][ $menu_item_db_id ] ) ) {
			// Do some checks here...
			$value = $_POST['menu-item-istitle'][ $menu_item_db_id ];
		}
		else {
			$value = '';
		}

		// Update
		if ( ! empty( $value ) ) {
			update_post_meta( $menu_item_db_id, 'menu-item-istitle', $value );
		}
		else {
			delete_post_meta( $menu_item_db_id, 'menu-item-istitle' );
		}
	}


	/**
	 * Print field
	 *
	 * @param object $item  Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args  Menu item args.
	 * @param int    $id    Nav menu ID.
	 *
	 * @return string Form fields
	 */
	public static function _fields( $item, $depth, $args = array(), $id = 0 ) {
		?>
			<p class="field-custom description description-wide">
				<label for="edit-menu-item-istitle-<?php echo esc_attr( $item->ID ) ?>">
					<?php printf(
						'<input type="checkbox" value="1" '. (esc_attr( get_post_meta( $item->ID, 'menu-item-istitle', true )) ? 'checked':'') .' name="menu-item-istitle[%2$d]" class="widefat code menu-item-istitle" id="edit-menu-item-istitle-%2$d">'. esc_attr__( 'Mega Menu?', 'wedding-planner' ) .'<br/>
						<i>Check this option to display sub menu items as mega menu.</i>',
						esc_attr( get_post_meta( $item->ID, 'menu-item-istitle', true ) ),
						$item->ID
					) ?>
				</label>
			</p>            
		<?php
	}


	/**
	 * Add our field to the screen options toggle
	 *
	 * To make this work, the field wrapper must have the class 'field-custom'
	 *
	 * @param array $columns Menu item columns
	 * @return array
	 */
	public static function _columns( $columns ) {
		$columns['custom_mega_menu_title'] = esc_attr__( 'Mega Menu?', 'wedding-planner' );

		return $columns;
	}
}
Menu_Item_Custom_Fields_Mega_Menu_Title::init();

class Menu_Item_Custom_Fields_Mega_Menu_Column_Count {

	/**
	 * Initialize plugin
	 */
	public static function init() {
		add_action( 'menu_item_custom_fields', array( __CLASS__, '_fields' ), 10, 3 );
		add_action( 'wp_update_nav_menu_item', array( __CLASS__, '_save' ), 10, 3 );
		add_filter( 'manage_nav-menus_columns', array( __CLASS__, '_columns' ), 99 );
	}

	/**
	 * Save custom field value
	 *
	 * @wp_hook action wp_update_nav_menu_item
	 *
	 * @param int   $menu_id         Nav menu ID
	 * @param int   $menu_item_db_id Menu item ID
	 * @param array $menu_item_args  Menu item data
	 */
	public static function _save( $menu_id, $menu_item_db_id, $menu_item_args ) {
		//check_admin_referer( 'update-nav_menu', 'update-nav-menu-nonce' );

		// Sanitize
		if ( ! empty( $_POST['menu-column-count'][ $menu_item_db_id ] ) ) {
			// Do some checks here...
			$value = $_POST['menu-column-count'][ $menu_item_db_id ];
		}
		else {
			$value = '';
		}

		// Update
		if ( ! empty( $value ) ) {
			update_post_meta( $menu_item_db_id, 'menu-column-count', $value );
		}
		else {
			delete_post_meta( $menu_item_db_id, 'menu-column-count' );
		}
	}


	/**
	 * Print field
	 *
	 * @param object $item  Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args  Menu item args.
	 * @param int    $id    Nav menu ID.
	 *
	 * @return string Form fields
	 */
	public static function _fields( $item, $depth, $args = array(), $id = 0 ) {
		?>
			<p class="field-custom description description-wide">
				<label for="edit-menu-column-count-<?php echo esc_attr( $item->ID ) ?>">
					<?php printf(
						esc_attr__( 'Column Count', 'wedding-planner' ) .'<br/><input type="number" min="1" max="12" step="1" value="'. (esc_attr( get_post_meta( $item->ID, 'menu-column-count', true )) ? esc_attr( get_post_meta( $item->ID, 'menu-column-count', true )):'3') .'" name="menu-column-count[%2$d]" class="widefat code menu-column-count" id="edit-menu-column-count-%2$d">
						<i>Set column count for mega menu dropdown.</i>',
						esc_attr( get_post_meta( $item->ID, 'menu-column-count', true ) ),
						$item->ID
					) ?>
				</label>
			</p>            
		<?php
	}


	/**
	 * Add our field to the screen options toggle
	 *
	 * To make this work, the field wrapper must have the class 'field-custom'
	 *
	 * @param array $columns Menu item columns
	 * @return array
	 */
	public static function _columns( $columns ) {
		$columns['custom_mega_menu_column_count'] = esc_attr__( 'Column Count', 'wedding-planner' );

		return $columns;
	}
}
Menu_Item_Custom_Fields_Mega_Menu_Column_Count::init();

class Menu_Item_Custom_Fields_Mega_Menu_Media_Element {

	/**
	 * Initialize plugin
	 */
	public static function init() {
		add_action( 'menu_item_custom_fields', array( __CLASS__, '_fields' ), 10, 3 );
		add_action( 'wp_update_nav_menu_item', array( __CLASS__, '_save' ), 10, 3 );
		add_filter( 'manage_nav-menus_columns', array( __CLASS__, '_columns' ), 99 );
	}

	/**
	 * Save custom field value
	 *
	 * @wp_hook action wp_update_nav_menu_item
	 *
	 * @param int   $menu_id         Nav menu ID
	 * @param int   $menu_item_db_id Menu item ID
	 * @param array $menu_item_args  Menu item data
	 */
	public static function _save( $menu_id, $menu_item_db_id, $menu_item_args ) {
		//check_admin_referer( 'update-nav_menu', 'update-nav-menu-nonce' );

		// Sanitize
		if ( ! empty( $_POST['menu-media-element'][ $menu_item_db_id ] ) ) {
			// Do some checks here...
			$value = $_POST['menu-media-element'][ $menu_item_db_id ];
		}
		else {
			$value = '';
		}

		// Update
		if ( ! empty( $value ) ) {
			update_post_meta( $menu_item_db_id, 'menu-media-element', $value );
		}
		else {
			delete_post_meta( $menu_item_db_id, 'menu-media-element' );
		}
	}


	/**
	 * Print field
	 *
	 * @param object $item  Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args  Menu item args.
	 * @param int    $id    Nav menu ID.
	 *
	 * @return string Form fields
	 */
	public static function _fields( $item, $depth, $args = array(), $id = 0 ) {
		$img_id = (esc_attr( get_post_meta( $item->ID, 'menu-media-element', true )) ? wp_get_attachment_image_src(get_post_meta( $item->ID, 'menu-media-element', true ), 'thumbnail') : 0);
		if(is_array($img_id) && isset($img_id[0])) {
			$img_url = $img_id[0];
		}else{
			$img_url = WEDDING_PLANNER_BASE_URL . '/images/blank.gif';
		}
		?>
			<p class="field-custom description description-wide">
				<label for="edit-menu-media-element-<?php echo esc_attr( $item->ID ) ?>">
					<?php printf(
						esc_attr__( 'Image', 'wedding-planner' ) .'<br/><input type="text" style="display:none" value="'. (esc_attr( get_post_meta( $item->ID, 'menu-media-element', true )) ? esc_attr( get_post_meta( $item->ID, 'menu-media-element', true )):'') .'" name="menu-media-element[%2$d]" class="widefat code menu-media-element" id="edit-menu-media-element-%2$d">
						<img src="'. esc_url($img_url) .'" style="max-width:80px"><br/><button class="upload-image-button button">'. esc_attr__('Set Image', 'wedding-planner') .'</button>&nbsp;<button class="remove-image-button button deletion">'. esc_attr__('Remove Image', 'wedding-planner') .'</button>
						<i>Select a media element for your menu.</i>',
						esc_attr( get_post_meta( $item->ID, 'menu-media-element', true ) ),
						$item->ID
					) ?>
				</label>
			</p>            
		<?php
	}


	/**
	 * Add our field to the screen options toggle
	 *
	 * To make this work, the field wrapper must have the class 'field-custom'
	 *
	 * @param array $columns Menu item columns
	 * @return array
	 */
	public static function _columns( $columns ) {
		$columns['custom_mega_menu_media_element'] = esc_attr__( 'Media Element', 'wedding-planner' );

		return $columns;
	}
}
Menu_Item_Custom_Fields_Mega_Menu_Media_Element::init();