<?php

class FreeVisionDashboardNotifications {

    private $json_url                   = 'https://ozythemes.s3.amazonaws.com/freevision-notifications.json?tag=%1$s';	
    private $interval                   = 12 * HOUR_IN_SECONDS;
    private $TAG                        = 'wedding-planner';
    private $transient_key              = 'fv_notifier_data';

    private $db_cache_field             = 'fv-notifier-cache';
    private $db_cache_field_stored_ids  = 'fv-notifier-stored-ids';
    private $json_data                  = '';

    public function __construct() {       
        add_action('init', array($this, 'get_latest_theme_version'));

        add_action('wp_ajax_fv_dismiss_notifier_message', function(){
            if ( current_user_can('manage_options') ) {
                $id = absint( $_GET['id'] );

                if( $id > 0 ) {
                    $stored_notification_ids   = unserialize(get_option($this->db_cache_field_stored_ids, serialize(array())));
                    $stored_notification_ids[] = $id;
                    $stored_notification_ids   = array_unique( $stored_notification_ids );
                    update_option($this->db_cache_field_stored_ids, serialize($stored_notification_ids));
                }
            }

            exit();
        });

        add_action('admin_footer', function() {
            ?>
            <script>
                jQuery(document).ready(function($) {
                    $(document).on("click", ".fv-notifier-message .notice-dismiss", function(e) {
                        e.preventDefault();
                        $.ajax({
                            url: ajaxurl,
                            data: {
                                action: "fv_dismiss_notifier_message",
                                id: $(this).parents('.fv-notifier-message').attr("data-id")
                            }
                        });
                    });
                });
            </script>
            <?php
        });        
    }

    public function init() {
        $json_data = $this->get_cached_data();

        if ( !is_array($json_data) ) {
            return;
        }

        foreach( $json_data as $j ) {
            if( isset($j->TAG) && isset($j->exclude) && isset($j->ID) && isset($j->title) && isset($j->content) && isset($j->link) && isset($j->link_caption) && isset($j->start_date) && isset($j->end_date) 
                && !empty($j->TAG) && !empty($j->ID) && !empty($j->title) && !empty($j->content) && !empty($j->link) && !empty($j->link_caption) && !empty($j->start_date) && !empty($j->end_date) ) {
                
                $exclude = explode(',', $j->exclude);
                $exclude = is_array($exclude) ? $exclude : [];

                if( ! in_array($this->TAG, $exclude) && $this->is_notification_new($j->ID) && ('generic' == $j->TAG || $this->TAG == $j->TAG) ) {
                    $this->display_message($j);                    
                }
            }
        }
    }

    private function display_message($j) {
        // Display the disposable message on the dashboard
        $id           = $j->ID;
        $title        = $j->title;
        $content      = $j->content;
        $link         = $j->link;
        $link_caption = $j->link_caption;

        $allowed_tags = array(
            'a' => array(
                'href'   => true,
                'title'  => true,
                'target' => true
            ),
            'ul'     => array(),
            'li'     => array(),
            'strong' => array(),
            'p'      => array(),
            'br'     => array(),
            'img'    => array(),
        );		

        // Output HTML or use WordPress functions to display the message
        echo "<div class='notice notice-info is-dismissible fv-notifier-message' data-id='". esc_attr($id). "'>
                <p><strong>". wp_kses($title, $allowed_tags) ."</strong></p>
                <p>". wp_kses($content, $allowed_tags) ."</p>
                <p><a href='". esc_url($link) ."' target='_blank' class='button button-primary notice-dismiss-link'>". wp_kses($link_caption, $allowed_tags) ."</a></p>
            </div>";
    }	

    public function get_latest_theme_version() {
        $json_data = $this->get_cached_data();

        $this->json_data = $json_data;

        add_action('admin_notices', array($this, 'init'));
    }   

    private function get_cached_data() {
        $cached_data = get_transient($this->transient_key);

        if (false === $cached_data) {
            $response = wp_remote_get(sprintf($this->json_url, $this->TAG), array('timeout' => 20));

            if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                $remote_data = wp_remote_retrieve_body($response);
                $cached_data = json_decode($remote_data);

                set_transient($this->transient_key, $cached_data, $this->interval);
            } else {
                $cached_data = json_decode('{"TAG": "generic", "ID": 0, "title": "", "content": "", "link": "", "link_caption": "", "start_date": "", "end_date": "" }');
            }
        }

        return $cached_data;
    }

    private function is_notification_new($id) {
        $stored_notification_ids = unserialize(get_option($this->db_cache_field_stored_ids, serialize(array())));

        return !in_array($id, $stored_notification_ids);
    }

}

new FreeVisionDashboardNotifications();
