<?php
/**
* Constants
*/
update_option( 'wedding_planner_purchase_code' , 'babiato');

define( 'WEDDING_PLANNER_BASE_DIR', get_template_directory() . '/' );
define( 'WEDDING_PLANNER_BASE_URL', get_template_directory_uri() . '/' );
define( 'WEDDING_PLANNER_CSS_DIRECTORY_URL', get_stylesheet_directory_uri() . '/');
define( 'WEDDING_PLANNER_THEME_VERSION', '6.9' );
define( 'WEDDING_PLANNER_THEMENAME', 'WEDDING_PLANNER' ); //used in TGM Plugin Activation
define( 'WEDDING_PLANNER_DATE_FORMAT', get_option('date_format'));

define( 'WEDDING_PLANNER_FONT_UPLOAD_DIR', trailingslashit( wedding_planner_wp_upload_dir('basedir') ) . 'wedding-planner-google-fonts/' );
define( 'WEDDING_PLANNER_FONT_UPLOAD_URL', trailingslashit( wedding_planner_wp_upload_dir('baseurl') ) . 'wedding-planner-google-fonts/' );

/**
* Globals
*/
include_once(WEDDING_PLANNER_BASE_DIR . 'functions/classes/helper.php');

/**
* WPML Plugin Check
*/
if(class_exists('SitePress') && function_exists("icl_get_languages") && 
	defined("ICL_LANGUAGE_CODE") && defined('ICL_LANGUAGE_NAME') && 
	function_exists('icl_object_id')) 
{
	global $sitepress;
	define( 'OZY_WPLANG', $sitepress->get_default_language());
	define( 'WEDDING_PLANNER_HOME_URL', esc_url(apply_filters( 'wpml_home_url', get_option( 'home' ) ) . '/') );
}else if(function_exists('pll_default_language') && function_exists('pll_home_url')){
	define( 'OZY_WPLANG', pll_default_language());
	define( 'WEDDING_PLANNER_HOME_URL', esc_url( pll_home_url() . '/' ) );
}else{
	define( 'OZY_WPLANG', substr(get_locale(), 0, 2));
	define( 'WEDDING_PLANNER_HOME_URL', esc_url(home_url('/') . '/') );
}

wedding_planner_sd('wpml_current_language_', '');

if(defined("ICL_LANGUAGE_CODE") && ICL_LANGUAGE_CODE != OZY_WPLANG) {
	wedding_planner_sd('wpml_current_language_', '_' . ICL_LANGUAGE_CODE);
}

/**
* Sets up theme defaults and registers support for various WordPress features.
*/
add_action('after_setup_theme', 'wedding_planner_theme_setup');
function wedding_planner_theme_setup() {
	// Load Languages
	load_theme_textdomain('wedding-planner', get_template_directory() . '/lang/');

	// Declare Automatic Feed Links support
	add_theme_support( 'automatic-feed-links' );

	// Post thumbnail support
	add_theme_support( 'post-thumbnails' );

	// Custom menu support
	if ( function_exists( 'register_nav_menus' ) ) {
		register_nav_menus(
			array(
			  'header-menu' => esc_attr__('Primary Menu', 'wedding-planner'),
			  'logged-in-menu' => esc_attr__('Logged In Primary Menu', 'wedding-planner'),
			  'header-mobile-menu' => esc_attr__('Mobile Menu', 'wedding-planner'),
			  'logged-in-mobile-menu' => esc_attr__('Logged In Mobile Menu', 'wedding-planner')			  
			)
		);
	}

	// Add custom thumbnail sizes
	if ( function_exists( 'add_image_size' ) ) {
		add_image_size( 'wedding_planner_sixteennine', 560, 380, true );
		add_image_size( 'wedding_planner_showbiz', 720, 720, true );
		add_image_size( 'wedding_planner_blog', 1144, 9999, false );
	}

	// WordPress 4.1+ title tag support
	add_theme_support("title-tag");
	
	// Declare WooCommerce support
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );	
	
	// Opting out of the block-based widgets editor WP 5.8+
	remove_theme_support( 'widgets-block-editor' );	
}

/**
 * Sets the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function wedding_planner_content_width() {
	$GLOBALS['content_width'] = apply_filters('wedding_planner_content_width', 1212); //1600
}
add_action('after_setup_theme', 'wedding_planner_content_width', 0);

/**
* TGM & Plugins
*/
require_once WEDDING_PLANNER_BASE_DIR . 'functions/extender.php';

/**
* Include Vafpress Framework
*/
require_once WEDDING_PLANNER_BASE_DIR . 'framework/bootstrap.php';

/**
* Include Custom Data Sources
*/
require_once WEDDING_PLANNER_BASE_DIR . 'admin/data_sources.php';

/**
* Theme options initializing here
*/
$ozy_tmpl_opt = WEDDING_PLANNER_BASE_DIR . 'admin/option/option.php';

/*
* Chat Formatter
*/
include_once(WEDDING_PLANNER_BASE_DIR . 'functions/chat.formatter.php');

/**
* Main functions / actions / hooks
*/
include_once(WEDDING_PLANNER_BASE_DIR . 'functions/functions.php');

/**
* Include Dynamic Sidebars
*/
require_once WEDDING_PLANNER_BASE_DIR . 'functions/sidebars.php';

/**
* Include Inline Resource file that contain SVG and etc.
*/
include_once(WEDDING_PLANNER_BASE_DIR . 'include/inline-resource.php');

/**
* Dashboard motification class
*/
include_once(WEDDING_PLANNER_BASE_DIR . 'functions/classes/class-freevision-dashboard-notifications.php');

/**
* Custom Menu Items
*/
if(defined('OZY_WEDDING_PLANNER_ESSENTIALS_ACTIVATED')) {
	require_once WEDDING_PLANNER_BASE_DIR . 'functions/menu-item-custom-fields/menu-item-custom-fields.php';
	require_once WEDDING_PLANNER_BASE_DIR . 'functions/menu-item-custom-fields/menu-item-custom-fields-megamenu.php';
}

/**
* Create instance of Theme Options
*/
$theme_options = new VP_Option(array(
	'is_dev_mode' 			=> false, // dev mode, default to false
	'option_key' 			=> 'vpt_ozy_wedding_planner_option', // options key in db, required
	'page_slug' 			=> 'vpt_option', // options page slug, required
	'template' 				=> $ozy_tmpl_opt, // template file path or array, required
	'menu_page' 			=> admin_url('themes.php'), // parent menu slug or supply `array` (can contains 'icon_url' & 'position') for top level menu
	'use_auto_group_naming' => true, // default to true
	'use_exim_menu' 		=> true, // default to true, shows export import menu
	'minimum_role' 			=> 'edit_theme_options', // default to 'edit_theme_options'
	'layout' 				=> 'fixed', // fluid or fixed, default to fixed
	'page_title' 			=> esc_attr__( 'Theme Options', 'wedding-planner' ), // page title
	'menu_label' 			=> esc_attr__( 'Theme Options', 'wedding-planner' ), // menu label
));

/**
* Load option based css
*/
include_once(WEDDING_PLANNER_BASE_DIR . 'functions/option-based-css.php');

/**
* Visual Composer Add-On visual shortcodes
*/
wedding_planner_sd('vc_active', false);

function wedding_planner_init_vc_shortcodes() {
	if(function_exists('vc_map') &&
		function_exists('vc_set_as_theme')) {

		/* Make visual composer part of the theme */
		vc_set_as_theme();

		wedding_planner_sd('vc_active', true);

		include_once(WEDDING_PLANNER_BASE_DIR . 'functions/vc_extend.php');
	}
}
add_action( 'init', 'wedding_planner_init_vc_shortcodes', 99 );

/**
* wedding_planner_o
*
* @$input - String
* @type - String - Default: attr
*
*/
function wedding_planner_o($input, $type = 'attr') {
	switch ($type) {
		case 'attr';
			echo esc_attr($input);
			break;
		case 'url';
			echo esc_url($input);
			break;
		case 'css';
			echo strip_tags($input);
			break;
		case 'post';
			echo html_entity_decode($input);
			break;
		case 'html';
			return $input;
			break;
		default:
			echo esc_attr($input);
			break;
	}
}
function wedding_planner_o_html($input) {
	echo wedding_planner_o($input, 'html');
}
function wedding_planner_o_css($input) {
	wedding_planner_o($input, 'css');
}
/**
* Customize Tag Cloud widget
*/
function wedding_planner_tag_cloud_fix($tag_string){
   return preg_replace("/style='font-size:.+pt;'/", '', $tag_string);
}
add_filter('wp_generate_tag_cloud', 'wedding_planner_tag_cloud_fix',10,3);

/**
* Check if WPML plugin is activated
*/
function wedding_planner_is_wpml_active() {
	if(function_exists("icl_get_languages") && defined("ICL_LANGUAGE_CODE") && defined("ICL_LANGUAGE_NAME")) {
		return true;
	}
	return false;
}

/**
* This function called to set global variable $more
*/
function wedding_planner_blog_more($v = 0) {
	global $more; $more = $v;
}

/**
* Output and checks for wp_head
*/
function wedding_planner_wp_head() {
	// Compatiblity check for old style favicon
	if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
		echo '<link rel="icon" href="'. esc_url(wedding_planner_get_option('favicon')) . '" type="image/x-icon" />
		<link rel="apple-touch-icon" href="' . esc_url(wedding_planner_get_option('favicon_apple_small')) . '">
		<link rel="apple-touch-icon" sizes="76x76" href="' . esc_url(wedding_planner_get_option('favicon_apple_medium')) . '">
		<link rel="apple-touch-icon" sizes="120x120" href="' . esc_url(wedding_planner_get_option('favicon_apple_large')) . '">
		<link rel="apple-touch-icon" sizes="152x152" href="' . esc_url(wedding_planner_get_option('favicon_apple_xlarge')) . '">';
	}

	// Header / Footer slider check
	wedding_planner_sd('header_slider', wedding_planner_check_header_slider());
	wedding_planner_sd('footer_slider', wedding_planner_check_footer_slider());
	$temp_header_slider = wedding_planner_gd('header_slider'); $temp_footer_slider = wedding_planner_gd('footer_slider');
	wedding_planner_sd('header_slider_class', (is_array($temp_header_slider) && $temp_header_slider[0] != '') ? 'header-slider-active':'');
	wedding_planner_sd('footer_slider_class', (is_array($temp_footer_slider) && $temp_footer_slider[0] != '') ? 'footer-slider-active':'');
}
add_action('wp_head','wedding_planner_wp_head');

add_filter( 'wp_lazy_loading_enabled',  '__return_false', 10, 3 );

function wedding_planner_wp_upload_dir( $key ) {
	$upload_dir = wp_upload_dir();
	if ( isset( $upload_dir[ $key ] ) ) {
		return $upload_dir[ $key ];
	}
	return null;
}
