<?php

return array(

	////////////////////////////////////////
	// Localized JS Message Configuration //
	////////////////////////////////////////

	/**
	 * Validation Messages
	 */
	'validation' => array(
		'alphabet'     => esc_attr__('Value needs to be Alphabet', 'wedding-planner'),
		'alphanumeric' => esc_attr__('Value needs to be Alphanumeric', 'wedding-planner'),
		'numeric'      => esc_attr__('Value needs to be Numeric', 'wedding-planner'),
		'email'        => esc_attr__('Value needs to be Valid Email', 'wedding-planner'),
		'url'          => esc_attr__('Value needs to be Valid URL', 'wedding-planner'),
		'maxlength'    => esc_attr__('Length needs to be less than {0} characters', 'wedding-planner'),
		'minlength'    => esc_attr__('Length needs to be more than {0} characters', 'wedding-planner'),
		'maxselected'  => esc_attr__('Select no more than {0} items', 'wedding-planner'),
		'minselected'  => esc_attr__('Select at least {0} items', 'wedding-planner'),
		'required'     => esc_attr__('This is required', 'wedding-planner'),
	),

	/**
	 * Import / Export Messages
	 */
	'util' => array(
		'import_success'    => esc_attr__('Import succeed, option page will be refreshed..', 'wedding-planner'),
		'import_failed'     => esc_attr__('Import failed', 'wedding-planner'),
		'export_success'    => esc_attr__('Export succeed, copy the JSON formatted options', 'wedding-planner'),
		'export_failed'     => esc_attr__('Export failed', 'wedding-planner'),
		'restore_success'   => esc_attr__('Restoration succeed, option page will be refreshed..', 'wedding-planner'),
		'restore_nochanges' => esc_attr__('Options identical to default', 'wedding-planner'),
		'restore_failed'    => esc_attr__('Restoration failed', 'wedding-planner'),
	),

	/**
	 * Control Fields String
	 */
	'control' => array(
		// select2 select box
		'select2_placeholder' => esc_attr__('Select option(s)', 'wedding-planner'),
		// fontawesome chooser
		'fac_placeholder'     => esc_attr__('Select an Icon', 'wedding-planner'),
	),

);

/**
 * EOF
 */