<?php
$footer_copyright_array =		array(
									array(
										'type' => 'toggle',
										'name' => 'ozy_wedding_planner_section_footer_copyright_bar',
										'label' => esc_attr__('Footer Info / Social Bar', 'wedding-planner'),
										'description' => esc_attr('Show / Hide footer Info / Social bar.', 'wedding-planner'),
										'default' => '0',
									),

									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_section_footer_copyright_text',
										'label' => esc_attr__('Footer Info / Social Bar Caption', 'wedding-planner'),
										'default' => esc_attr__("Let's talk about your wedding", 'wedding-planner')
									),

									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_section_footer_booking_button_label',
										'label' => esc_attr__('Booking Button Label', 'wedding-planner'),
										'description' => esc_attr__('Enter a label for Book Wedding Planner button.', 'wedding-planner'),
										'default' => esc_attr('Book Wedding Planner', 'wedding-planner')
									),

									array(
										'type' => 'select',
										'name' => 'ozy_wedding_planner_section_footer_booking_page',
										'label' => esc_attr__('Booking Button Page', 'wedding-planner'),
										'description' => esc_attr__('Select an available page to use as target page on Book Wedding Planner button.', 'wedding-planner'),
										'default' => '{{first}}',
										'items' => array(
											'data' => array(
												array(
													'source' => 'function',
													'value' => 'vp_bind_ozy_wedding_planner_pages',
												),
											),
										),
									),

									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_section_footer_tweet_button_label',
										'label' => esc_attr__('Tweet Button Label', 'wedding-planner'),
										'description' => esc_attr__('Enter a label for Tweet button.', 'wedding-planner'),
										'default' => esc_attr('Tweet', 'wedding-planner')
									),

									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_section_footer_fb_button_label',
										'label' => esc_attr__('Facebook Button Label', 'wedding-planner'),
										'description' => esc_attr__('Enter a label for Share Via FB button.', 'wedding-planner'),
										'default' => esc_attr('Share Via FB', 'wedding-planner')
									),

									array(
										'type' => 'toggle',
										'name' => 'ozy_wedding_planner_section_footer_info_bar',
										'label' => esc_attr__('Show Sticky Info Bar', 'wedding-planner'),
										'description' => wp_kses(__('This option also could be managed individually for each page on Page Options panel. To fill the bar, visit <a href="widgets.php">Appearance > Widgets</a>', 'wedding-planner'), array('a' => array('href' => array()))),
										'default' => '0',
									),
								);

$primary_menu_address_array =	array(
									array(
										'type'    => 'slider',
										'name'    => 'ozy_wedding_planner_primary_menu_height',
										'label'   => esc_attr__('Menu Height', 'wedding-planner'),
										'description'   => esc_attr__('Set this value to fit at least same as your logo height for better results.', 'wedding-planner'),
										'min'     => '40',
										'max'     => '700',
										'default' => '130',
									),
									array(
										'type'    => 'slider',
										'name'    => 'ozy_wedding_planner_primary_menu_height_alternate',
										'label'   => esc_attr__('Alternate Menu Height', 'wedding-planner'),
										'description'   => esc_attr__('Set this value to fit at least same as your alternate logo height for better results.', 'wedding-planner'),
										'min'     => '40',
										'max'     => '700',
										'default' => '60',
									),array(
										'type' => 'toggle',
										'name' => 'ozy_wedding_planner_primary_top_info_bar',
										'label' => esc_attr__('Hide Top Info Bar?', 'wedding-planner'),
										'description' => esc_attr__('Show or hide top information bar above primary menu.', 'wedding-planner'),
										'default' => '0',
									),
									array(
										'type' => 'toggle',
										'name' => 'ozy_wedding_planner_primary_menu_search',
										'label' => esc_attr__('Hide Search Button?', 'wedding-planner'),
										'description' => esc_attr__('Show or hide search button on primary menu.', 'wedding-planner'),
										'default' => '0',
									),
									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_top_info_address_text',
										'label' => esc_attr__('Address', 'wedding-planner'),
										'default' => esc_html__('Unit D2/D3, Wira Office Park LS16 6EB', 'wedding-planner')
									),
									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_top_info_phone_text',
										'label' => esc_attr__('Phone', 'wedding-planner'),
										'default' => esc_html__('+80 664 578 78 64', 'wedding-planner')
									)
								);

$custom_logo_array =	[
							'type' => 'section',
							'title' => esc_attr__('Logo', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_section_image_logo',
							'fields' => array(
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_use_custom_logo',
									'label' => esc_attr__('Use Custom Logo', 'wedding-planner'),
									'default' => 1,
									'description' => esc_attr__('Use custom logo or text logo', 'wedding-planner'),
								),
								array(
									'type' => 'upload',
									'name' => 'ozy_wedding_planner_custom_logo',
									'label' => esc_attr__('Custom Logo', 'wedding-planner'),
									'default' => WEDDING_PLANNER_BASE_URL . 'images/logo.png',
									'dependency' => array(
										'field' => 'ozy_wedding_planner_use_custom_logo',
										'function' => 'vp_dep_boolean',
									),
									'description' => esc_attr__('Upload or choose custom logo', 'wedding-planner'),
								),
								array(
									'type' => 'upload',
									'name' => 'ozy_wedding_planner_custom_logo_alternate',
									'label' => esc_attr__('Custom Logo Alternate', 'wedding-planner'),
									'default' => WEDDING_PLANNER_BASE_URL . 'images/logo_alternate.png',
									'dependency' => array(
										'field' => 'ozy_wedding_planner_use_custom_logo',
										'function' => 'vp_dep_boolean',
									),
									'description' => esc_attr__('Upload or choose custom alternate logo', 'wedding-planner'),
								)
							),
						];

$cookie_notice_array =	array(
							array(
								'type' => 'toggle',
								'name' => 'ozy_wedding_planner_cookie_banner',
								'label' => esc_attr__('Enable Cookie Notice Banner?', 'wedding-planner'),
								'description' => esc_attr__('Enable / Disable cookie notice banner site wide.', 'wedding-planner'),
								'default' => '0'
							),
							array(
								'type' => 'codeeditor',
								'name' => 'ozy_wedding_planner_cookie_notice',
								'label' => esc_attr__('Notice Text', 'wedding-planner'),
								'theme' => 'mono_industrial',
								'mode' => 'html',
								'default' => wp_kses(__('We use cookies in accordance with our Cookie Notice. Please refer to our <a href="#">Cookie Notice</a> here for more information on how we use cookies and how to adjust your browser settings to block cookies. If you consent to the use of cookies, please click Accept. We will not ask for consent for strictly necessary cookies, but if you choose to block strictly necessary cookies this may affect your website experience.', 'wedding-planner'),array('a' => array('href' => array(), 'target' => array())))
							),
							array(
								'type' => 'textbox',
								'name' => 'ozy_wedding_planner_cookie_button',
								'label' => esc_attr__('Button Caption', 'wedding-planner'),
								'default' => esc_attr__('ACCEPT', 'wedding-planner')
							)
						);

if(wedding_planner_is_wpml_active()){
	$languages = icl_get_languages('skip_missing=0&orderby=code');
	if(!empty($languages)){
		foreach($languages as $l){
			if(OZY_WPLANG != $l['language_code']) {				
				array_push($footer_copyright_array,	array(
														'type' => 'toggle',
														'name' => 'ozy_wedding_planner_section_footer_copyright_bar' . $l['language_code'],
														'label' => esc_attr__('Footer Info / Social Bar', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'description' => '',
														'default' => '0',
													),

													array(
														'type' => 'textbox',
														'name' => 'ozy_wedding_planner_section_footer_copyright_text' . $l['language_code'],
														'label' => esc_attr__('Footer Info / Social Bar Caption', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'default' => esc_attr__("Let's talk about your wedding", 'wedding-planner')
													),

													array(
														'type' => 'textbox',
														'name' => 'ozy_wedding_planner_section_footer_booking_button_label' . $l['language_code'],
														'label' => esc_attr__('Booking Button Label', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'description' => esc_attr__('Enter a label for Book Wedding Planner button.', 'wedding-planner'),
														'default' => esc_attr('Book Wedding Planner', 'wedding-planner')
													),

													array(
														'type' => 'select',
														'name' => 'ozy_wedding_planner_section_footer_booking_page' . $l['language_code'],
														'label' => esc_attr__('Booking Button Page', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'description' => esc_attr__('Select an available page to use as target page on Book Wedding Planner button.', 'wedding-planner'),
														'default' => '{{first}}',
														'items' => array(
															'data' => array(
																array(
																	'source' => 'function',
																	'value' => 'vp_bind_ozy_wedding_planner_pages',
																),
															),
														),
													),

													array(
														'type' => 'textbox',
														'name' => 'ozy_wedding_planner_section_footer_tweet_button_label' . $l['language_code'],
														'label' => esc_attr__('Tweet Button Label', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'description' => esc_attr__('Enter a label for Tweet button.', 'wedding-planner'),
														'default' => esc_attr('Tweet', 'wedding-planner')
													),

													array(
														'type' => 'textbox',
														'name' => 'ozy_wedding_planner_section_footer_fb_button_label' . $l['language_code'],
														'label' => esc_attr__('Facebook Button Label', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'description' => esc_attr__('Enter a label for Share Via FB button.', 'wedding-planner'),
														'default' => esc_attr('Share Via FB', 'wedding-planner')
													),
													array(
														'type' => 'toggle',
														'name' => 'ozy_wedding_planner_section_footer_info_bar' . $l['language_code'],
														'label' => esc_attr__('Show Sticky Info Bar', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
														'description' => wp_kses(__('This option also could be managed individually for each page on Page Options panel. To fill the bar, visit <a href="widgets.php">Appearance > Widgets</a>', 'wedding-planner'), array('a' => array('href' => array()))),
														'default' => '0',
													)
												);
				array_push($primary_menu_address_array,
									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_top_info_address_text' . $l['language_code'],
										'label' => esc_attr__('Address', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
										'default' => esc_html__('Unit D2/D3, Wira Office Park LS16 6EB', 'wedding-planner')
									),
									array(
										'type' => 'textbox',
										'name' => 'ozy_wedding_planner_top_info_phone_text' . $l['language_code'],
										'label' => esc_attr__('Phone', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
										'default' => esc_html__('+80 664 578 78 64', 'wedding-planner')
									)
								);
				
				array_push($custom_logo_array['fields'],
							array(
								'type' => 'upload',
								'name' => 'ozy_wedding_planner_custom_logo' . $l['language_code'],
								'label' => esc_attr__('Custom Logo', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
								'default' => WEDDING_PLANNER_BASE_URL . 'images/logo.png',
								'dependency' => array(
									'field' => 'ozy_wedding_planner_use_custom_logo',
									'function' => 'vp_dep_boolean',
								),
								'description' => esc_attr__('Upload or choose custom logo', 'wedding-planner'),
							),
							array(
								'type' => 'upload',
								'name' => 'ozy_wedding_planner_custom_logo_alternate' . $l['language_code'],
								'label' => esc_attr__('Custom Logo Alternate', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
								'default' => WEDDING_PLANNER_BASE_URL . 'images/logo_alternate.png',
								'dependency' => array(
									'field' => 'ozy_wedding_planner_use_custom_logo',
									'function' => 'vp_dep_boolean',
								),
								'description' => esc_attr__('Upload or choose custom alternate logo', 'wedding-planner'),
							)
					);
				

				array_push($cookie_notice_array,
					array(
						'type' => 'codeeditor',
						'name' => 'ozy_wedding_planner_cookie_notice' . $l['language_code'],
						'label' => esc_attr__('Notice Text', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
						'theme' => 'mono_industrial',
						'mode' => 'html',
					),array(
						'type' => 'textbox',
						'name' => 'ozy_wedding_planner_cookie_button' . $l['language_code'],
						'label' => esc_attr__('Button Caption', 'wedding-planner') . '(' . strtoupper($l['native_name']) .')',
						'default' => esc_attr__('ACCEPT', 'wedding-planner')
					)
				);
			}
		}
	}
}

//return
$ozy_wedding_planner_option_arr = array(
	'title' => esc_attr__('WEDDING_PLANNER Option Panel', 'wedding-planner'),
	'logo' => WEDDING_PLANNER_BASE_URL . 'admin/images/logo.png',
	'menus' => array(
		array(
			'title' => esc_attr__('General Options', 'wedding-planner'),
			'name' => 'ozy_wedding_planner_general_options',
			'icon' => 'font-awesome:fa-gear',
			'controls' => array(
				array(
					'type' => 'section',
					'title' => esc_attr__('Cookie Notice Banner', 'wedding-planner'),
					'fields' => $cookie_notice_array
				),

				array(
					'type' => 'section',
					'title' => esc_attr__('General', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'toggle',
							'name' => 'ozy_wedding_planner_back_to_top_button',
							'label' => esc_attr__('Back To Top Button', 'wedding-planner'),
							'description' => esc_attr__('Enable / Disable Back To Top Button globally.', 'wedding-planner'),
							'default' => '1',
						),
						/*array(
							'type' => 'toggle',
							'name' => 'ozy_wedding_planner_smooth_scroll',
							'label' => esc_attr__('Smooth Scrolling', 'wedding-planner'),
							'description' => esc_attr__('When enabled page will scrool smoothly when mousewheel used, on supported browsers.', 'wedding-planner'),
							'default' => '0',
						),*/
						array(
							'type' => 'toggle',
							'name' => 'ozy_wedding_planner_disable_animsition',
							'label' => esc_attr__('Disable Loading Screen', 'wedding-planner'),
							'description' => esc_attr__('Loading screen and page transition on this page will be disable.', 'wedding-planner'),
							'default' => '0',
						),
						array(
							'type' => 'toggle',
							'name' => 'ozy_wedding_planner_social_icons',
							'label' => esc_attr__('Show Social Icons', 'wedding-planner'),
							'description' => esc_attr__('To manage social icon accounts visit Social tab.', 'wedding-planner'),
							'default' => '1',
						),
						array(
							'type' => 'codeeditor',
							'name' => 'ozy_wedding_planner_custom_script',
							'label' => esc_attr__('Custom JS', 'wedding-planner'),
							'description' => esc_attr__('Write your custom js here. Please do not add script tags into this box. Please do not add "script" tags.', 'wedding-planner'),
							'theme' => 'mono_industrial',
							'mode' => 'javascript',
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('Fallback Favicons', 'wedding-planner'),
					'description' => esc_attr__('Please use Appearance > Customize to choose a favicon. This panel being used just for fallback.', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'notebox',
							'name' => 'ozy_wedding_planner_favicon_info',
							'label' => esc_attr__('About Favicons', 'wedding-planner'),
							'description' => esc_attr__('Please use Appearance > Customize to choose a favicon. This panel being used just for fallback.', 'wedding-planner'),
							'status' => 'normal',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_favicon',
							'label' => esc_attr__('Favicon', 'wedding-planner'),
							'description' => esc_attr__('Upload a 16px x 16px .png or .gif image, will be set as your favicon.', 'wedding-planner'),
							'default' => WEDDING_PLANNER_CSS_DIRECTORY_URL . '/favico.gif',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_favicon_apple_small',
							'label' => esc_attr__('Apple Touch Icon (small)', 'wedding-planner'),
							'description' => esc_attr__('Upload a 57px x 57px image, will be set as your small Apple Touch Icon.', 'wedding-planner'),
							'default' => WEDDING_PLANNER_CSS_DIRECTORY_URL . '/images/favico_57.gif',
						),array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_favicon_apple_medium',
							'label' => esc_attr__('Apple Touch Icon (medium)', 'wedding-planner'),
							'description' => esc_attr__('Upload a 76px x 76px image, will be set as your large Apple Touch Icon (iPad).', 'wedding-planner'),
							'default' => WEDDING_PLANNER_CSS_DIRECTORY_URL . '/images/favico_76.gif',
						),array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_favicon_apple_large',
							'label' => esc_attr__('Apple Touch Icon (large)', 'wedding-planner'),
							'description' => esc_attr__('Upload a 120px x 120px image, will be set as your large Apple Touch Icon (iPhone Retina).', 'wedding-planner'),
							'default' => WEDDING_PLANNER_CSS_DIRECTORY_URL . '/images/favico_120.gif',
						),array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_favicon_apple_xlarge',
							'label' => esc_attr__('Apple Touch Icon (large)', 'wedding-planner'),
							'description' => esc_attr__('Upload a 152px x 152px image, will be set as your large Apple Touch Icon (iPad Retina).', 'wedding-planner'),
							'default' => WEDDING_PLANNER_CSS_DIRECTORY_URL . '/images/favico_152.gif',
						),
					),
				),
			),
		),


		array(
			'title' => esc_attr__('Typography', 'wedding-planner'),
			'name' => 'ozy_wedding_planner_typography',
			'icon' => 'font-awesome:fa-pencil',
			'controls' => array(
				array(
					'type' => 'section',
					'title' => esc_attr__('Extended Parameters', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'textbox',
							'name' => 'ozy_wedding_planner_typography_google_param',
							'description' => esc_html('Add extra parameters here. By this option, you can load non-latin charset or more types byt available parameters. Use like ":ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900".', 'wedding-planner'),
							'default' => ':ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900'
							//'default' => ':100,200,300,400,500,600,700,800,900'
						),
						array(
							'type' => 'toggle',
							'name' => 'ozy_wedding_planner_host_google_fonts_locally',
							'description' => esc_html__( 'Disable this option if you are having difficulties with locally hosted Google Fonts.', 'wedding-planner' ),
							'label' => esc_attr__('Host Google Fonts Locally', 'wedding-planner'),
							'default' => '0'
						),
						array(
							'type' => 'html',
							'name' => 'ozy_wedding_planner_host_google_fonts_locally_cache',
							'binding' => array(
								'field'    => 'ozy_wedding_planner_host_google_fonts_locally',
								'function' => 'ozy_google_fonts_cache',
							),
							'dependency' => array(
								'field' => 'ozy_wedding_planner_host_google_fonts_locally',
								'function' => 'vp_dep_boolean',
							),							
						),						
					)
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('Content Typography', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'html',
							'name' => 'ozy_wedding_planner_typography_font_preview',
							'binding' => array(
								'field'    => 'ozy_wedding_planner_typography_font_face,ozy_wedding_planner_typography_font_style,ozy_wedding_planner_typography_font_weight,ozy_wedding_planner_typography_font_size, ozy_wedding_planner_typography_font_line_height',
								'function' => 'vp_font_preview',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_font_face',
							'label' => esc_attr__('Font Face', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Poppins'
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_font_style',
							'label' => esc_attr__('Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_font_weight',
							'label' => esc_attr__('Font Weight', 'wedding-planner'),
							'default' => '300',
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_font_face',
										'value' => 'vp_get_gwf_weight',
									),
								),
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_font_size',
							'label'   => esc_attr__('Font Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '86',
							'default' => '14',
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_font_line_height',
							'label'   => esc_attr__('Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('Heading Typography', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'html',
							'name' => 'ozy_wedding_planner_typography_heading_font_preview',
							'binding' => array(
								'field'    => 'ozy_wedding_planner_typography_heading_font_face,ozy_wedding_planner_typography_heading_font_style,ozy_wedding_planner_typography_heading_font_weight,ozy_wedding_planner_typography_heading_h1_font_size',
								'function' => 'vp_font_preview_simple',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_face',
							'label' => esc_attr__('Font Face', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Cormorant Garamond'
						)
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('H1 Options', 'wedding-planner'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_h1_font_size',
							'label'   => esc_attr__('H1 Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '46',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_heading_h1_font_style',
							'label' => esc_attr__('H1 Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_weight_h1',
							'label' => esc_attr__('H1 Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_line_height_h1',
							'label'   => esc_attr__('H1 Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.3',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_ls_h1',
							'label' => esc_attr__('H1 Letter Spacing', 'wedding-planner'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('H2 Options', 'wedding-planner'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_h2_font_size',
							'label'   => esc_attr__('H2 Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '36',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_heading_h2_font_style',
							'label' => esc_attr__('H2 Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_weight_h2',
							'label' => esc_attr__('H2 Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_line_height_h2',
							'label'   => esc_attr__('H2 Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.3',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_ls_h2',
							'label' => esc_attr__('H2 Letter Spacing', 'wedding-planner'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('H3 Options', 'wedding-planner'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_h3_font_size',
							'label'   => esc_attr__('H3 Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '30',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_heading_h3_font_style',
							'label' => esc_attr__('H3 Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_weight_h3',
							'label' => esc_attr__('H3 Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_line_height_h3',
							'label'   => esc_attr__('H3 Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.3',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_ls_h3',
							'label' => esc_attr__('H3 Letter Spacing', 'wedding-planner'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('H4 Options', 'wedding-planner'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_h4_font_size',
							'label'   => esc_attr__('H4 Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '24',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_heading_h4_font_style',
							'label' => esc_attr__('H4 Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_weight_h4',
							'label' => esc_attr__('H4 Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_line_height_h4',
							'label'   => esc_attr__('H4 Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_ls_h4',
							'label' => esc_attr__('H4 Letter Spacing', 'wedding-planner'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('H5 Options', 'wedding-planner'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_h5_font_size',
							'label'   => esc_attr__('H5 Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '20',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_heading_h5_font_style',
							'label' => esc_attr__('H5 Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_weight_h5',
							'label' => esc_attr__('H5 Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_line_height_h5',
							'label'   => esc_attr__('H5 Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_ls_h5',
							'label' => esc_attr__('H5 Letter Spacing', 'wedding-planner'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('H6 Options', 'wedding-planner'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_h6_font_size',
							'label'   => esc_attr__('H6 Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '16',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_typography_heading_h6_font_style',
							'label' => esc_attr__('H6 Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_weight_h6',
							'label' => esc_attr__('H6 Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_typography_heading_line_height_h6',
							'label'   => esc_attr__('H6 Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_typography_heading_font_ls_h6',
							'label' => esc_attr__('H6 Letter Spacing', 'wedding-planner'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),


				array(
					'type' => 'section',
					'title' => esc_attr__('Primary Menu Typography', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_primary_menu_section_typography',
					'fields' => array(
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_primary_menu_typography_font_face',
							'label' => esc_attr__('Font Face', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Cormorant Garamond'
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_primary_menu_typography_font_style',
							'label' => esc_attr__('Font Style', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_primary_menu_typography_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_primary_menu_typography_font_weight',
							'label' => esc_attr__('Font Weight', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_wedding_planner_primary_menu_typography_font_face',
										'value' => 'vp_get_gwf_weight',
									),
								),
							),
							'default' => array(
								'600',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_primary_menu_typography_font_size',
							'label'   => esc_attr__('Font Size (px)', 'wedding-planner'),
							'min'     => '5',
							'max'     => '128',
							'default' => '18',
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_wedding_planner_primary_menu_typography_line_height',
							'label'   => esc_attr__('Line Height (em)', 'wedding-planner'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.3',

							'step'    => '0.1',
						),
					),
				),

				array(
					'type' => 'section',
					'title' => esc_attr__('Footer Typography', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_footer_section_typography',
					'fields' => array(
						array(
							'type' => 'select',
							'name' => 'ozy_wedding_planner_footer_typography_font_face',
							'label' => esc_attr__('Font Face', 'wedding-planner'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Cormorant Garamond'
						)
					),
				),

			),
		),


		array(
			'title' => esc_attr__('Layout', 'wedding-planner'),
			'name' => 'ozy_wedding_planner_layout',
			'icon' => 'font-awesome:fa-magic',
			'menus' => array(
				array(
					'title' => esc_attr__('Primary Menu / Logo', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_primary_menu',
					'icon' => 'font-awesome:fa-cogs',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('Primary Menu', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_section_header_layout',
							'fields' => $primary_menu_address_array
						),

						$custom_logo_array
					),
				),


				array(
					'title' => esc_attr__('Footer', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_footer',
					'icon' => 'font-awesome:fa-cog',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('Footer Layout', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_section_footer_copyright',
							'fields' => $footer_copyright_array
						)
					),
				),


				array(
					'title' => esc_attr__('Content / Page / Post', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_page',
					'icon' => 'font-awesome:fa-pencil',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('General Layout', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_page_section_general_layout',
							'fields' => array(
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_wedding_planner_page_layout_width',
									'label' => esc_attr__('Layout Width', 'wedding-planner'),
									'items' => array(
										array(
											'value' => '1212',
											'label' => esc_attr__('Normal (1212px)', 'wedding-planner'),
										),
										array(
											'value' => '1672',
											'label' => esc_attr__('Wider (1600px)', 'wedding-planner'),
										)
									),
									'default' => array(
										'1212',
									),
								)
							),
						),
						array(
							'type' => 'section',
							'title' => esc_attr__('Custom Page Pointers', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_page_section_custom_page_pointers',
							'description' => esc_attr__('Select a page to use as your custom pages for some available places.', 'wedding-planner'),
							'fields' => array(
								array(
									'type' => 'select',
									'name' => 'ozy_wedding_planner_page_404_page_id',
									'label' => esc_attr__('404 Page', 'wedding-planner'),
									'description' => esc_attr__('Select a page to use as custom 404 page.', 'wedding-planner'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_wedding_planner_pages',
											),
										),
									),
								),
								array(
									'type' => 'select',
									'name' => 'ozy_wedding_planner_page_blog_page_id',
									'label' => esc_attr__('Blog Page', 'wedding-planner'),
									'description' => esc_attr__('Select a page to use as custom Blog page.', 'wedding-planner'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_wedding_planner_pages',
											),
										),
									),
								)
							),
						),
						array(
							'type' => 'section',
							'title' => esc_attr__('Page', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_page_section_page_sidebar_position',
							'description' => esc_attr__('Select position for your page sidebar', 'wedding-planner'),
							'fields' => array(
								array(
									'type' => 'notebox',
									'name' => 'ozy_wedding_planner_page_page_sidebar_info',
									'label' => esc_attr__('About Sidebars', 'wedding-planner'),
									'description' => wp_kses(__('To create a dynamic sidebar, first make sure "Wedding Planner Theme Essentials" plugins installed and activated, then please open <a href="edit.php?post_type=ozy_sidebars">Sidebars</a> section.', 'wedding-planner'),array('a' => array('href' => array()))),
									'status' => 'normal',
								),
								array(
									'type' => 'radioimage',
									'name' => 'ozy_wedding_planner_page_page_sidebar_position',
									'label' => esc_attr__('Default Sidebar Position', 'wedding-planner'),
									'description' => esc_attr__('Select one of available header type.', 'wedding-planner'),
									'item_max_width' => '86',
									'items' => array(
										array(
											'value' => 'full',
											'label' => esc_attr__('No Sidebar', 'wedding-planner'),
											'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/full-width.png',
										),
										array(
											'value' => 'left',
											'label' => esc_attr__('Left Sidebar', 'wedding-planner'),
											'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/left-sidebar.png',
										),
										array(
											'value' => 'right',
											'label' => esc_attr__('Right Sidebar', 'wedding-planner'),
											'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/right-sidebar.png',
										)
									),
									'default' => array(
										'{{first}}',
									),
								),
								array(
									'type' => 'select',
									'name' => 'ozy_wedding_planner_page_page_sidebar_id',
									'label' => esc_attr__('Default Sidebar', 'wedding-planner'),
									'description' => esc_attr__('This option could be overriden individually.', 'wedding-planner'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_wedding_planner_sidebars',
											),
										),
									),
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_page_comment',
									'label' => esc_attr__('Comments Section', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable comment section on the pages', 'wedding-planner'),
									'default' => '0',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_page_author',
									'label' => esc_attr__('Author Section', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable author section on the pages', 'wedding-planner'),
									'default' => '0',
								),
							),
						),
						array(
							'type' => 'section',
							'title' => esc_attr__('Blog', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_page_section_blog_sidebar_position',
							'description' => esc_attr__('Select position for your blog page sidebar', 'wedding-planner'),
							'fields' => array(
								array(
									'type' => 'notebox',
									'name' => 'ozy_wedding_planner_page_blog_sidebar_info',
									'label' => esc_attr__('About Sidebars', 'wedding-planner'),
									'description' => wp_kses(__('To create a dynamic sidebar, first make sure "Wedding Planner Theme Essentials" plugins installed and activated, then please open <a href="edit.php?post_type=ozy_sidebars">Sidebars</a> section.', 'wedding-planner'),array('a' => array('href' => array()))),
									'status' => 'normal',
								),
								array(
									'type' => 'radioimage',
									'name' => 'ozy_wedding_planner_page_blog_sidebar_position',
									'label' => esc_attr__('Defaul Sidebar Position', 'wedding-planner'),
									'description' => esc_attr__('Select one of available header type.', 'wedding-planner'),
									'item_max_width' => '86',
									'items' => array(
										array(
											'value' => 'full',
											'label' => esc_attr__('No Sidebar', 'wedding-planner'),
											'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/full-width.png',
										),
										array(
											'value' => 'left',
											'label' => esc_attr__('Left Sidebar', 'wedding-planner'),
											'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/left-sidebar.png',
										),
										array(
											'value' => 'right',
											'label' => esc_attr__('Right Sidebar', 'wedding-planner'),
											'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/right-sidebar.png',
										)
									),
									'default' => array(
										'{{first}}',
									),
								),
								array(
									'type' => 'select',
									'name' => 'ozy_wedding_planner_page_blog_sidebar_id',
									'label' => esc_attr__('Default Sidebar', 'wedding-planner'),
									'description' => esc_attr__('This option could be overriden individually.', 'wedding-planner'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_wedding_planner_sidebars',
											),
										),
									),
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_blog_comment',
									'label' => esc_attr__('Comments Section', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable comment section on the blog posts', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_blog_author',
									'label' => esc_attr__('Author Section', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable author section on the blog posts', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_blog_share',
									'label' => esc_attr__('Share Buttons', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable share buttons for posts.', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_blog_related_posts',
									'label' => esc_attr__('Related Posts', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable related posts.', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_page_blog_next_previous',
									'label' => esc_attr__('Next / Previous Post Navigation', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable navigation for posts.', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'select',
									'name' => 'ozy_wedding_planner_page_blog_list_page_id',
									'label' => esc_attr__('Default Listing Page', 'wedding-planner'),
									'description' => esc_attr__('Select a page to use as "Return to Blog" link.', 'wedding-planner'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_wedding_planner_pages',
											),
										),
									),
								)
							),
						),
					),
				),


				array(
					'title' => esc_attr__('Miscellaneous', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_misc',
					'icon' => 'font-awesome:fa-puzzle-piece',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('Generic', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_section_generic_layout',
							'fields' => array(								
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_generic_frame_border',
									'label' => esc_attr__('Frame Border', 'wedding-planner'),
									'description' => esc_attr__('Adds 40 piksels wide frame around all the pages.', 'wedding-planner'),
									'default' => '1',
								),
							),
						),						
						array(
							'type' => 'section',
							'title' => esc_attr__('Fancy Box (Lightbox)', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_section_fancybox_layout',
							'fields' => array(								
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_fancbox_media',
									'label' => esc_attr__('Video Support', 'wedding-planner'),
									'description' => esc_attr__('By enabling this option Fancybox will start to support popular media links.', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_fancbox_thumbnail',
									'label' => esc_attr__('Thumbnail', 'wedding-planner'),
									'description' => esc_attr__('Enable this option to show thumnails under your Fancybox window.', 'wedding-planner'),
									'default' => '0',
								),
							),
						),
					),
				),
				array(
					'title' => esc_attr__('Countdown Page', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_countdown',
					'icon' => 'font-awesome:fa-clock-o',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('Countdown Page Options', 'wedding-planner'),
							'name' => 'ozy_wedding_planner_section_countdown',
							'fields' => array(
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_countdown_year',
									'label' => esc_attr__('End Year', 'wedding-planner'),
									'description' => esc_attr__('Enter the Year of the date counter will count to.', 'wedding-planner'),
									'default' => date('Y', time())
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_countdown_month',
									'label' => esc_attr__('End Month', 'wedding-planner'),
									'description' => esc_attr__('Enter the Month of the date counter will count to.', 'wedding-planner'),
									'default' => date('m', time())
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_countdown_day',
									'label' => esc_attr__('End Day', 'wedding-planner'),
									'description' => esc_attr__('Enter the Day of the date counter will count to.', 'wedding-planner'),
									'default' => '15'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_countdown_hour',
									'label' => esc_attr__('End Hour', 'wedding-planner'),
									'description' => esc_attr__('Enter the Hour of the date counter will count to. Use 24 hour format', 'wedding-planner'),
									'default' => '12'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_countdown_minute',
									'label' => esc_attr__('End Minute', 'wedding-planner'),
									'description' => esc_attr__('Enter the Minute of the date counter will count to.', 'wedding-planner'),
									'default' => '12'
								)
							),
						),

					),
				),
			),
		),
		array(
			'name' => 'ozy_wedding_planner_color_options',
			'title' => esc_attr__('Color Options', 'wedding-planner'),
			'icon' => 'font-awesome:fa-eye',
			'controls' => array(

				array(
					'type' => 'section',
					'title' => esc_attr__('GENERIC', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_background_color',
							'label' => esc_attr__('Content Background', 'wedding-planner'),
							'format' => 'rgba',
							'default' => 'rgba(255,255,255,1)'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_heading_color',
							'label' => esc_attr__('Heading Color', 'wedding-planner'),
							'description' => esc_attr__('Default color for H1-H6 elements', 'wedding-planner'),
							'format' => 'hex',
							'default' => '#000000'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_color',
							'label' => esc_attr__('Content Color', 'wedding-planner'),
							'description' => esc_attr__('Font color of the content', 'wedding-planner'),
							'format' => 'hex',
							'default' => '#210c20'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_color_alternate',
							'label' => esc_attr__('Alternate Color #1', 'wedding-planner'),
							'description' => esc_attr__('Like link color, hover color and input elements active border', 'wedding-planner'),
							'format' => 'hex',
							'default' => '#c09e6f'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_color_alternate2',
							'label' => esc_attr__('Alternate Color #2', 'wedding-planner'),
							'description' => esc_attr__('Like footer, footer sidebar title color, text color and seperator color', 'wedding-planner'),
							'format' => 'hex',
							'default' => '#585558'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_color_alternate3',
							'label' => esc_attr__('Alternate Color #3', 'wedding-planner'),
							'description' => esc_attr__('Like footer sidebar link color', 'wedding-planner'),
							'format' => 'hex',
							'default' => '#ffffff'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_color_alternate4',
							'label' => esc_attr__('Alternate Color #4', 'wedding-planner'),
							'description' => esc_attr__('Like Blog meta info bar text', 'wedding-planner'),
							'format' => 'hex',
							'default' => '#000000'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_content_background_color_alternate',
							'label' => esc_attr__('Alternate Background Color', 'wedding-planner'),
							'description' => esc_attr__('Like comments background color', 'wedding-planner'),
							'format' => 'rgba',
							'default' => 'rgba(255,255,255,1)'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_separator_color',
							'label' => esc_attr__('Separator / Border Color', 'wedding-planner'),
							'description' => esc_attr__('Used for, in page Seperators and Comments bottom border', 'wedding-planner'),
							'default' => 'rgba(233,225,225,1)',
							'format' => 'rgba'
						),
					),
				),

				array(
					'type' => 'section',
					'title' => esc_attr__('Primary Menu', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_primary_menu_section_colors',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_font_color',
							'label' => esc_attr__('Font Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_font_color_hover',
							'label' => esc_attr__('Font Color : Hover / Active', 'wedding-planner'),
							'default' => 'rgba(152,119,58,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_dropdown_background_color',
							'label' => esc_attr__('Dropdown Background Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_dropdown_font_color',
							'label' => esc_attr__('Dropdown Font Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_dropdown_font_color_hover',
							'label' => esc_attr__('Dropdown Font Color : Hover / Active', 'wedding-planner'),
							'default' => 'rgba(152,119,58,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_background_color',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_separator_color',
							'label' => esc_attr__('Separator Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
					),
				),

				array(
					'type' => 'section',
					'title' => esc_attr__('Primary Menu (Alternate)', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_primary_menu_section_colors_alternate',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_font_color_alternate',
							'label' => esc_attr__('Font Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_font_color_hover_alternate',
							'label' => esc_attr__('Font Color : Hover / Active', 'wedding-planner'),
							'default' => 'rgba(152,119,58,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_dropdown_background_color_alternate',
							'label' => esc_attr__('Dropdown Background Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_background_color_alternate',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_primary_menu_separator_color_alternate',
							'label' => esc_attr__('Separator Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
					),
				),

				array(
					'type' => 'section',
					'title' => esc_attr__('Mobile Menu', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_mobile_menu_section_colors',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_background_color',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),						
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_font_color',
							'label' => esc_attr__('Font Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						/*array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_font_color_hover',
							'label' => esc_attr__('Font Color : Hover / Active', 'wedding-planner'),
							'default' => 'rgba(152,119,58,1)',
							'format' => 'rgba',
						),*/
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_dropdown_background_color',
							'label' => esc_attr__('Dropdown Background Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_dropdown_font_color',
							'label' => esc_attr__('Dropdown Font Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_dropdown_font_color_hover',
							'label' => esc_attr__('Dropdown Font Color : Hover / Active', 'wedding-planner'),
							'default' => 'rgba(152,119,58,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_mobile_menu_separator_color',
							'label' => esc_attr__('Separator Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
					),
				),				

				array(
					'type' => 'section',
					'title' => esc_attr__('Footer', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_footer_section_colors',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_footer_color_1',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'default' => 'rgba(249,249,249,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_footer_info_bg',
							'label' => esc_attr__('Info Bar Background Color', 'wedding-planner'),
							'default' => 'rgba(29,27,27,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_footer_color_5',
							'label' => esc_attr__('Title Foreground Color', 'wedding-planner'),
							'default' => '#000000',
							'format' => 'hex',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_footer_color_2',
							'label' => esc_attr__('Foreground Color', 'wedding-planner'),
							'default' => '#000000',
							'format' => 'hex',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_footer_color_3',
							'label' => esc_attr__('Alternate Color', 'wedding-planner'),
							'default' => '#ffffff',
							'format' => 'hex',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_footer_color_4',
							'label' => esc_attr__('Separator Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,0.10)',
							'format' => 'rgba',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_footer_background_image',
							'label' => esc_attr__('Background Image', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose custom page background image.', 'wedding-planner')
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('Form', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_form_section_coloring',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_form_font_color',
							'label' => esc_attr__('Font Color', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_form_background_color',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_form_button_font_color',
							'label' => esc_attr__('Font Color (Button)', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_form_button_font_color_hover',
							'label' => esc_attr__('Font Color : Hover / Active (Button)', 'wedding-planner'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_form_button_background_color',
							'label' => esc_attr__('Background Color (Button)', 'wedding-planner'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_form_button_background_color_hover',
							'label' => esc_attr__('Background Color : Hover / Active (Button)', 'wedding-planner'),
							'default' => 'rgba(221,181,127,1)',
							'format' => 'rgba',
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('Background Styling', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_body_background_color',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'description' => esc_attr__('This option will affect only page background.', 'wedding-planner'),
							'default' => '#f7f3f3',
							'format' => 'hex',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_body_frame_color',
							'label' => esc_attr__('Frame Color', 'wedding-planner'),
							'description' => esc_attr__('Frame color around the page.', 'wedding-planner'),
							'default' => '#ffffff',
							'format' => 'hex',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_body_background_image',
							'label' => esc_attr__('Custom Background Image', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose custom page background image.', 'wedding-planner'),
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_body_background_image_size',
							'label' => esc_attr__('Background Image Size', 'wedding-planner'),
							'description' => esc_attr__('Only available on browsers which supports CSS3.', 'wedding-planner'),
							'items' => array(
								array(
									'value' => '',
									'label' => esc_attr__('-not set-', 'wedding-planner'),
								),
								array(
									'value' => 'cover',
									'label' => esc_attr__('cover', 'wedding-planner'),
								),
								array(
									'value' => 'contain',
									'label' => esc_attr__('contain', 'wedding-planner'),
								)
							),
							'default' => '{{first}}',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_body_background_image_repeat',
							'label' => esc_attr__('Background Image Repeat', 'wedding-planner'),
							'items' => array(
								array(
									'value' => 'inherit',
									'label' => esc_attr__('inherit', 'wedding-planner'),
								),
								array(
									'value' => 'no-repeat',
									'label' => esc_attr__('no-repeat', 'wedding-planner'),
								),
								array(
									'value' => 'repeat',
									'label' => esc_attr__('repeat', 'wedding-planner'),
								),
								array(
									'value' => 'repeat-x',
									'label' => esc_attr__('repeat-x', 'wedding-planner'),
								),
								array(
									'value' => 'repeat-y',
									'label' => esc_attr__('repeat-y', 'wedding-planner'),
								)
							),
							'default' => '{{first}}',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_wedding_planner_body_background_image_attachment',
							'label' => esc_attr__('Background Image Attachment', 'wedding-planner'),
							'items' => array(
								array(
									'value' => '',
									'label' => esc_attr__('-not set-', 'wedding-planner'),
								),
								array(
									'value' => 'fixed',
									'label' => esc_attr__('fixed', 'wedding-planner'),
								),
								array(
									'value' => 'scroll',
									'label' => esc_attr__('scroll', 'wedding-planner'),
								),
								array(
									'value' => 'local',
									'label' => esc_attr__('local', 'wedding-planner')
								)
							),
							'default' => '{{first}}',
						),
					),
				),
				array(
					'type' => 'section',
					'title' => esc_attr__('Portfolio Post Background Styling', 'wedding-planner'),
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_wedding_planner_portfolio_body_background_color',
							'label' => esc_attr__('Background Color', 'wedding-planner'),
							'description' => esc_attr__('This option will affect only portfolio post background.', 'wedding-planner'),
							'default' => '#f7f3f3',
							'format' => 'hex',
						),
					),
				),

			),
		),

		array(
			'title' => esc_attr__('Social', 'wedding-planner'),
			'name' => 'ozy_wedding_planner_typography',
			'icon' => 'font-awesome:fa-group',
			'menus' => array(
				array(
					'title' => esc_attr__('Accounts', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_social_accounts',
					'icon' => 'font-awesome:fa-heart-o',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('Social Accounts', 'wedding-planner'),
							'description' => esc_attr__('Enter social account names/IDs box below', 'wedding-planner'),
							'fields' => array(
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_fivehundredpx',
									'label' => esc_attr__('500px', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_behance',
									'label' => esc_attr__('Behance', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_blogger',
									'label' => esc_attr__('Blogger', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_delicious',
									'label' => esc_attr__('Delicious', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_deviantart',
									'label' => esc_attr__('DeviantArt', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_digg',
									'label' => esc_attr__('Digg', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_dribble',
									'label' => esc_attr__('Dribble', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_email',
									'label' => esc_attr__('Email', 'wedding-planner'),
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_facebook',
									'label' => esc_attr__('Facebook', 'wedding-planner'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_flickr',
									'label' => esc_attr__('Flickr', 'wedding-planner'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_forrst',
									'label' => esc_attr__('Forrst', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_foursquare',
									'label' => esc_attr__('Foursquare', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_github',
									'label' => esc_attr__('Github', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_instagram',
									'label' => esc_attr__('Instagram', 'wedding-planner'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_lastfm',
									'label' => esc_attr__('Last.FM', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_linkedin',
									'label' => esc_attr__('LinkedIn', 'wedding-planner'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_myspace',
									'label' => esc_attr__('MySpace', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_pinterest',
									'label' => esc_attr__('Pinterest', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_rss',
									'label' => esc_attr__('RSS', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_soundcloud',
									'label' => esc_attr__('SoundCloud', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_stumbleupon',
									'label' => esc_attr__('StumbleUpon', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_tumblr',
									'label' => esc_attr__('Tumblr', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_twitter',
									'label' => esc_attr__('Twitter', 'wedding-planner'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_vimeo',
									'label' => esc_attr__('Vimeo', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_vk',
									'label' => __('VK', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_wordpress',
									'label' => esc_attr__('WordPress', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_yahoo',
									'label' => esc_attr__('Yahoo!', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_yelp',
									'label' => __('Yelp (Please use full URL)', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_youtube',
									'label' => esc_attr__('Youtube', 'wedding-planner')
								),																																																		array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_whatsapp',
									'label' => esc_attr__('Whatsapp', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_wechat',
									'label' => esc_attr__('Wechat', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_weibo',
									'label' => esc_attr__('Weibo', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_redbook',
									'label' => esc_attr__('Redbook', 'wedding-planner')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_wedding_planner_social_accounts_tiktok',
									'label' => esc_attr__('TikTok', 'wedding-planner')
								),								
							),
						),
					),
				),
				array(
					'title' => esc_attr__('General', 'wedding-planner'),
					'name' => 'ozy_wedding_planner_social_general',
					'icon' => 'font-awesome:fa-group',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => esc_attr__('Social Icons', 'wedding-planner'),
							'fields' => array(
								array(
									'type' => 'toggle',
									'name' => 'ozy_wedding_planner_social_use',
									'label' => esc_attr__('Social Share Buttons', 'wedding-planner'),
									'description' => esc_attr__('Enable / Disable social share buttons.', 'wedding-planner'),
									'default' => '1',
								),
								array(
									'type' => 'sorter',
									'name' => 'ozy_wedding_planner_social_icon_order',
									'max_selection' => 20,
									'label' => esc_attr__('Icon List / Order', 'wedding-planner'),
									'description' => esc_attr__('Select visible icons and sort.', 'wedding-planner'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_get_social_medias',
											),
										),
									),
									'default' => array('facebook', 'twitter', 'instagram', 'linkedin', 'flickr')
								),
								array(
									'type' => 'select',
									'name' => 'ozy_wedding_planner_social_icon_target',
									'label' => esc_attr__('Target Window', 'wedding-planner'),
									'description' => esc_attr__('Where links will be opened?', 'wedding-planner'),
									'items' => array(
										array(
											'value' => '_blank',
											'label' => esc_attr__('Blank Window / New Tab', 'wedding-planner'),
										),
										array(
											'value' => '_self',
											'label' => esc_attr__('Self Window', 'wedding-planner'),
										),
									),
									'default' => array(
										'_blank',
									),
								),
							),
						),
					),
				),
			),
		),
	)
);

return $ozy_wedding_planner_option_arr;

/**
 *EOF
 */
