<?php

return array(
	'id'          => 'ozy_wedding_planner_meta_page_portfolio',
	'types'       => array('page'),
	'title'       => esc_attr__('Portfolio Options', 'wedding-planner'),
	'priority'    => 'high',
	'template'    => array(
		array(
			'type' => 'notebox',
			'name' => 'ozy_wedding_planner_meta_page_portfolio_infobox',
			'label' => esc_attr__('Portfolio Options', 'wedding-planner'),
			'description' => esc_attr__('Below this point all the options are only works with portfolio template types.', 'wedding-planner'),
			'status' => 'info',
		),
		array(
			'type' => 'sorter',
			'name' => 'ozy_wedding_planner_meta_page_portfolio_category_sort',
			'label' => esc_attr__('Category Select / Order', 'wedding-planner'),
			'description' => esc_attr__('If you leave this field blank, all available categories will be listed. By this option, you can create multiple portfolio/gallery pages with different items.', 'wedding-planner'),			
			'default' => '{{all}}',
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_wedding_planner_portfolio_categories_simple',
					),
				),
			),
		),	
		array(
			'type' => 'radiobutton',
			'name' => 'ozy_wedding_planner_meta_page_portfolio_order',
			'label' => esc_attr__('Item Order', 'wedding-planner'),
			'description' => esc_attr__('By selecting "Custom Order ..." you will have to set the order field of each of the items.', 'wedding-planner'),			
			'items' => array(
				array(
					'value' => 'date-desc',
					'label' => 'Date DESC',
				),
				array(
					'value' => 'date-asc',
					'label' => 'Date ASC',
				),
				array(
					'value' => 'menu_order-desc',
					'label' => 'Custom DESC',
				),
				array(
					'value' => 'menu_order-asc',
					'label' => 'Custom ASC',
				),
			),
			'default' => '{{first}}'
		),
		array(
			'type' => 'radiobutton',
			'name' => 'ozy_wedding_planner_meta_page_portfolio_column_count',
			'label' => esc_attr__('Column Count', 'wedding-planner'),
			'items' => array(
				array(
					'value' => '2',
					'label' => '2 Column',
				),array(
					'value' => '3',
					'label' => '3 Column',
				),
				array(
					'value' => '4',
					'label' => '4 Column',
				)
			),
			'default' => '2'
		),
		array(
			'type' => 'textbox',
			'name' => 'ozy_wedding_planner_meta_page_portfolio_hover_caption',
			'label' => esc_attr__('Hover Caption', 'wedding-planner'),
			'default' => esc_attr__('View their perfect day', 'wedding-planner'),
		),				
		array(
			'type' => 'textbox',
			'name' => 'ozy_wedding_planner_meta_page_portfolio_count',
			'label' => esc_attr__('Item Count Per Load', 'wedding-planner'),
			'description' => esc_attr__('How many portfolio item will be loaded for each load.', 'wedding-planner'),
			'default' => '32',
			'validation' => 'numeric',
		),			
	),	
);

/**
 * EOF
 */