<?php

return array(
	'id'          => 'ozy_wedding_planner_meta_page',
	'types'       => array('page'),
	'title'       => esc_attr__('Page Options', 'wedding-planner'),
	'priority'    => 'high',
	'template'    => array(
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_transparent_menu',
			'label' => esc_attr__('Transparent Menu', 'wedding-planner'),
			'description' => esc_attr__('Check this option to use transparent menu layout even on scroll event.', 'wedding-planner'),
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_footer_info_bar',
			'label' => esc_attr__('Show Footer Sticky Info Bar', 'wedding-planner'),
			'description' => wp_kses(__('Turn this option to hide footer sticky info bar for this page. Please visit <a href="themes.php?page=vpt_option#_ozy_wedding_planner_footer">Theme Options > Layout > Footer</a> section to manage it globally. To fill the bar, visit <a href="widgets.php">Appearance > Widgets</a>', 'wedding-planner'), array('a' => array('href' => array()))),
			'default' => 0
		),			
		array(
			'type' => 'select',
			'name' => 'ozy_wedding_planner_meta_page_custom_menu',
			'label' => esc_attr__('Custom Menu', 'wedding-planner'),
			'description' => esc_attr__('You can select a custom menu for this page.', 'wedding-planner'),
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_wedding_planner_list_wp_menus',
					),
				),
			),
			'default' => '-1',
		),
		array(
			'type' => 'select',
			'name' => 'ozy_wedding_planner_meta_page_revolution_slider',
			'label' => esc_attr__('Revolution Header Slider', 'wedding-planner'),
			'description' => esc_attr__('You can select a header slider if you have installed and activated Revolution Slider which comes bundled with your theme.', 'wedding-planner'),
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_wedding_planner_revolution_slider',
					),
				),
			),
			'default' => '{{first}}',
		),
		array(
			'type' => 'select',
			'name' => 'ozy_wedding_planner_meta_page_master_slider',
			'label' => esc_attr__('Master Header Slider', 'wedding-planner'),
			'description' => esc_attr__('You can select a header slider if you have installed and activated Master Slider which comes bundled with your theme.', 'wedding-planner'),
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_wedding_planner_master_slider',
					),
				),
			),
			'default' => '{{first}}',
		),		


		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_footer_slider',
			'label' => esc_attr__('Use Footer Slider', 'wedding-planner'),
			'description' => esc_attr__('You can use footer slider with header slider too.', 'wedding-planner'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_wedding_planner_meta_page_use_footer_slider_group',
			'title'     => esc_attr__('Footer Slider', 'wedding-planner'),
			'dependency' => array(
				'field'    => 'ozy_wedding_planner_meta_page_use_footer_slider',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(
				array(
					'type' => 'select',
					'name' => 'ozy_wedding_planner_meta_page_revolution_footer_slider',
					'label' => esc_attr__('Revolution Footer Slider', 'wedding-planner'),
					'description' => esc_attr__('You can select a footer slider if you have installed and activated Revolution Slider which comes bundled with your theme.', 'wedding-planner'),
					'items' => array(
						'data' => array(
							array(
								'source' => 'function',
								'value' => 'vp_bind_ozy_wedding_planner_revolution_slider',
							),
						),
					),
					'default' => '{{first}}',
				),
				array(
					'type' => 'select',
					'name' => 'ozy_wedding_planner_meta_page_master_footer_slider',
					'label' => esc_attr__('Master Footer Slider', 'wedding-planner'),
					'description' => esc_attr__('You can select a footer slider if you have installed and activated Master Slider which comes bundled with your theme.', 'wedding-planner'),
					'items' => array(
						'data' => array(
							array(
								'source' => 'function',
								'value' => 'vp_bind_ozy_wedding_planner_master_slider',
							),
						),
					),
					'default' => '{{first}}',
				),				
			),
		),

		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_no_menu_space',
			'label' => esc_attr__('No Menu Space', 'wedding-planner'),
			'description' => esc_attr__('Min to check this option whenever you want to use Custom Header/Title Option. Page content top will set to "0", not the bottom point of primary menu.', 'wedding-planner'),
		),

		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_disable_loader',
			'label' => esc_attr__('Disable Loading Screen', 'wedding-planner'),
			'description' => esc_attr__('Loading screen and page transition on this page will be disable.', 'wedding-planner'),
		),
		array(
			'type' => 'radiobutton',
			'name' => 'ozy_wedding_planner_meta_page_hide_footer_widget_bar',
			'label' => esc_attr__('Footer Bars Visiblity', 'wedding-planner'),
			'description' => esc_attr__('By this option you can hide footer bars as you wish.', 'wedding-planner'),
			'items' => array(
				array(
					'value' => '-1',
					'label' => esc_attr__('All Visible', 'wedding-planner'),
				),
				array(
					'value' => '1',
					'label' => esc_attr__('Hide Widget Bar', 'wedding-planner'),
				),
				array(
					'value' => '2',
					'label' => esc_attr__('Hide Widget Bar and Footer', 'wedding-planner'),
				),
			),
			'default' => array(
				'-1',
			),
		),
		


		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_hide_title',
			'label' => esc_attr__('Hide Page Title', 'wedding-planner'),
			'description' => esc_attr__('Page title will not be shown on the page.', 'wedding-planner'),
		),
		
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_no_content_padding',
			'label' => esc_attr__('No content top padding', 'wedding-planner'),
			'description' => esc_attr__('Check this option to disable the padding top of your content (after page title).', 'wedding-planner'),
		),		
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_custom_title',
			'label' => esc_attr__('Custom Header/Title', 'wedding-planner'),
			'description' => esc_attr__('There are several options to help you customize your page header.', 'wedding-planner'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_wedding_planner_meta_page_use_custom_title_group',
			'title'     => esc_attr__('Custom Header/Title Options', 'wedding-planner'),
			'dependency' => array(
				'field'    => 'ozy_wedding_planner_meta_page_use_custom_title',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(	
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_custom_title_position',
					'label' => esc_attr__('Title Position', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => esc_attr__('Left', 'wedding-planner'),
						),
						array(
							'value' => 'right',
							'label' => esc_attr__('Right', 'wedding-planner'),
						),
						array(
							'value' => 'center',
							'label' => esc_attr__('Center', 'wedding-planner'),
						),
					),
					'default' => array(
						'center',
					),
				),			
				array(
					'type'      => 'textbox',
					'name'      => 'ozy_wedding_planner_meta_page_custom_title',
					'label'     => esc_attr__('Page Title', 'wedding-planner'),
				),
				array(
					'type'      => 'color',
					'name'      => 'ozy_wedding_planner_meta_page_custom_title_color',
					'label'     => esc_attr__('Title Color', 'wedding-planner'),
					'default' => '',
					'format' => 'rgba'
				),				
				array(
					'type'      => 'textbox',
					'name'      => 'ozy_wedding_planner_meta_page_custom_sub_title',
					'label'     => esc_attr__('Sub Title', 'wedding-planner'),
				),
				array(
					'type'      => 'color',
					'name'      => 'ozy_wedding_planner_meta_page_custom_sub_title_color',
					'label'     => esc_attr__('Sub Title Color', 'wedding-planner'),
					'default' => '',
					'format' => 'rgba'
				),				
				array(
					'type'      => 'color',
					'name'      => 'ozy_wedding_planner_meta_page_custom_title_bgcolor',
					'label'     => esc_attr__('Header Background Color', 'wedding-planner'),
					'default' => '',
					'format' => 'rgba'
				),				
				array(
					'type'      => 'upload',
					'name'      => 'ozy_wedding_planner_meta_page_custom_title_bg',
					'label'     => esc_attr__('Header Image', 'wedding-planner'),
					'description'=> esc_attr__('Please use images like 1600px, 2000px wide and have a minimum height like 475px for good results.', 'wedding-planner'),
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_custom_title_bg_repeat',
					'label' => esc_attr__('Background Repeat', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'no-repeat',
							'label' => esc_attr__('No Repeat', 'wedding-planner'),
						),			
						array(
							'value' => 'repeat',
							'label' => esc_attr__('Repeat', 'wedding-planner'),
						),
						array(
							'value' => 'repeat-x',
							'label' => esc_attr__('Repeat-X', 'wedding-planner'),
						),
						array(
							'value' => 'repeat-y',
							'label' => esc_attr__('Repeat-Y', 'wedding-planner'),
						)						
					),
					'default' => 'no-repeat',
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_custom_title_bg_size',
					'label' => esc_attr__('Background Image Size', 'wedding-planner'),
					'description' => esc_attr__('Only available on browsers which supports CSS3.', 'wedding-planner'),
					'items' => array(
						array(
							'value' => '',
							'label' => esc_attr__('-not set-', 'wedding-planner'),
						),			
						array(
							'value' => 'cover',
							'label' => esc_attr__('cover', 'wedding-planner'),
						),
						array(
							'value' => 'contain',
							'label' => esc_attr__('contain', 'wedding-planner'),
						)
					),
					'default' => 'cover',
				),						
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_custom_title_bg_x_position',
					'label' => esc_attr__('Background X-Position', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => esc_attr__('Left', 'wedding-planner'),
						),
						array(
							'value' => 'right',
							'label' => esc_attr__('Right', 'wedding-planner'),
						),
						array(
							'value' => 'center',
							'label' => esc_attr__('Center', 'wedding-planner'),
						),
						array(
							'value' => 'top',
							'label' => esc_attr__('Top', 'wedding-planner'),
						),
						array(
							'value' => 'bottom',
							'label' => esc_attr__('Bottom', 'wedding-planner'),
						),
					),
					'default' => array(
						'left',
					),
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_custom_title_bg_y_position',
					'label' => esc_attr__('Background Y-Position', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => esc_attr__('Left', 'wedding-planner'),
						),
						array(
							'value' => 'right',
							'label' => esc_attr__('Right', 'wedding-planner'),
						),
						array(
							'value' => 'center',
							'label' => esc_attr__('Center', 'wedding-planner'),
						),
						array(
							'value' => 'top',
							'label' => esc_attr__('Top', 'wedding-planner'),
						),
						array(
							'value' => 'bottom',
							'label' => esc_attr__('Bottom', 'wedding-planner'),
						),
					),
					'default' => array(
						'top',
					),
				),				
				array(
					'type'      => 'textbox',
					'name'      => 'ozy_wedding_planner_meta_page_custom_title_height',
					'label'     => esc_attr__('Header Height', 'wedding-planner'),
					'description'=> esc_attr__('Height of your header in pixels? Not need to add "px". e.g. 400', 'wedding-planner'),
					'default'	=> 300,
					'validation' => 'numeric'
				),				
			),
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_hide_content',
			'label' => esc_attr__('Hide Page Content', 'wedding-planner'),
			'description' => esc_attr__('Page content will not be shown. Supposed to use with Video backgrounds or Fullscreen sliders.', 'wedding-planner'),
		),		
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_sidebar',
			'label' => esc_attr__('Use Custom Sidebar', 'wedding-planner'),
			'description' => esc_attr__('You can use custom sidebar individually.', 'wedding-planner'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_wedding_planner_meta_page_sidebar_group',
			'title'     => esc_attr__('Custom Sidebar', 'wedding-planner'),
			'dependency' => array(
				'field'    => 'ozy_wedding_planner_meta_page_use_sidebar',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(
				array(
					'type' => 'radioimage',
					'name' => 'ozy_wedding_planner_meta_page_sidebar_position',
					'label' => esc_attr__('Sidebar Position', 'wedding-planner'),
					'description' => esc_attr__('Select one of available header type.', 'wedding-planner'),
					'item_max_width' => '86',
					'items' => array(
						array(
							'value' => 'full',
							'label' => esc_attr__('No Sidebar', 'wedding-planner'),
							'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/full-width.png',
						),
						array(
							'value' => 'left',
							'label' => esc_attr__('Left Sidebar', 'wedding-planner'),
							'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/left-sidebar.png',
						),
						array(
							'value' => 'right',
							'label' => esc_attr__('Right Sidebar', 'wedding-planner'),
							'img' => WEDDING_PLANNER_BASE_URL . 'admin/images/right-sidebar.png',
						)
					),
					'default' => '{{first}}',
				),			
				array(
					'type' => 'select',
					'name' => 'ozy_wedding_planner_meta_page_sidebar',
					'label' => esc_attr__('Sidebar', 'wedding-planner'),
					'items' => array(
						'data' => array(
							array(
								'source' => 'function',
								'value' => 'vp_bind_ozy_wedding_planner_sidebars',
							),
						),
					),
				),											
			),
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_custom_style',
			'label' => esc_attr__('Use Custom Style', 'wedding-planner'),
			'description' => esc_attr__('Options to customize your page individually.', 'wedding-planner'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_wedding_planner_meta_page_layout_group',
			'title'     => esc_attr__('Layout Styling', 'wedding-planner'),
			'dependency' => array(
				'field'    => 'ozy_wedding_planner_meta_page_use_custom_style',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(					
				array(
					'type' => 'color',
					'name' => 'ozy_wedding_planner_meta_page_layout_ascend_background',
					'label' => esc_attr__('Background Color', 'wedding-planner'),
					'description' => esc_attr__('This option will affect, main wrapper\'s background color.', 'wedding-planner'),
					'default' => 'rgba(255,255,255,1)',
					'format' => 'rgba',
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_wedding_planner_meta_page_layout_transparent_background',
					'label' => esc_attr__('Transparent Content Background', 'wedding-planner'),
					'description' => esc_attr__('If you want, you can use transparent background for your content.', 'wedding-planner'),
					'default' => '0',
				)														
			),
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_wedding_planner_meta_page_use_custom_background',
			'label' => esc_attr__('Use Custom Background', 'wedding-planner'),
			'description' => esc_attr__('Lots of options to customize your page background individually.', 'wedding-planner'),
		),		
		array(
			'type'      => 'group',
			'repeating' => false,
			'name'      => 'ozy_wedding_planner_meta_page_background_group',
			'title'     => esc_attr__('Background Styling', 'wedding-planner'),
			'dependency' => array(
				'field'    => 'ozy_wedding_planner_meta_page_use_custom_background',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(					
				array(
					'type' => 'upload',
					'name' => 'ozy_wedding_planner_meta_page_background_image',
					'label' => esc_attr__('Custom Background Image', 'wedding-planner'),
					'description' => esc_attr__('Upload or choose custom page background image.', 'wedding-planner'),
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_background_image_size',
					'label' => esc_attr__('Background Image Size', 'wedding-planner'),
					'description' => esc_attr__('Only available on browsers which supports CSS3.', 'wedding-planner'),
					'items' => array(
						array(
							'value' => '',
							'label' => esc_attr__('-not set-', 'wedding-planner'),
						),			
						array(
							'value' => 'cover',
							'label' => esc_attr__('cover', 'wedding-planner'),
						),
						array(
							'value' => 'contain',
							'label' => esc_attr__('contain', 'wedding-planner'),
						)
					),
					'default' => '{{first}}',
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_background_image_pos_x',
					'label' => esc_attr__('Background Position X', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => esc_attr__('left', 'wedding-planner'),
						),			
						array(
							'value' => 'center',
							'label' => esc_attr__('center', 'wedding-planner'),
						),
						array(
							'value' => 'right',
							'label' => esc_attr__('right', 'wedding-planner'),
						)
					),
					'default' => 'left',
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_background_image_pos_y',
					'label' => esc_attr__('Background Position Y', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'top',
							'label' => esc_attr__('top', 'wedding-planner'),
						),			
						array(
							'value' => 'center',
							'label' => esc_attr__('center', 'wedding-planner'),
						),
						array(
							'value' => 'bottom',
							'label' => esc_attr__('bottom', 'wedding-planner'),
						)
					),
					'default' => 'top',
				),				
				
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_background_image_repeat',
					'label' => esc_attr__('Background Image Repeat', 'wedding-planner'),
					'items' => array(
						array(
							'value' => 'inherit',
							'label' => esc_attr__('inherit', 'wedding-planner'),
						),			
						array(
							'value' => 'no-repeat',
							'label' => esc_attr__('no-repeat', 'wedding-planner'),
						),
						array(
							'value' => 'repeat',
							'label' => esc_attr__('repeat', 'wedding-planner'),
						),
						array(
							'value' => 'repeat-x',
							'label' => esc_attr__('repeat-x', 'wedding-planner'),
						),
						array(
							'value' => 'repeat-y',
							'label' => esc_attr__('repeat-y', 'wedding-planner'),
						)
					),
					'default' => '{{first}}',
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_wedding_planner_meta_page_background_image_attachment',
					'label' => esc_attr__('Background Image Attachment', 'wedding-planner'),
					'items' => array(
						array(
							'value' => '',
							'label' => esc_attr__('-not set-', 'wedding-planner'),
						),			
						array(
							'value' => 'fixed',
							'label' => esc_attr__('fixed', 'wedding-planner'),
						),
						array(
							'value' => 'scroll',
							'label' => esc_attr__('scroll', 'wedding-planner'),
						),
						array(
							'value' => 'local',
							'label' => esc_attr__('local', 'wedding-planner')
						)
					),
					'default' => '{{first}}',
				),										
				array(
					'type' => 'color',
					'name' => 'ozy_wedding_planner_meta_page_background_color',
					'label' => esc_attr__('Background Color', 'wedding-planner'),
					'description' => esc_attr__('This option will affect only page background.', 'wedding-planner'),
					'default' => '#ffffff',
					'format' => 'hex',
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_wedding_planner_meta_page_background_use_gmap',
					'label' => esc_attr__('Use Google Map', 'wedding-planner'),
					'description' => esc_attr__('Instead of using a static background, you can use a Google Map as background.', 'wedding-planner'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'name'      => 'ozy_wedding_planner_meta_page_background_gmap_group',
					'title'     => esc_attr__('Google Map', 'wedding-planner'),
					'dependency' => array(
						'field'    => 'ozy_wedding_planner_meta_page_background_use_gmap',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'textbox',
							'name' => 'ozy_wedding_planner_meta_page_background_gmap_address',
							'label' => esc_attr__('iFrame Src', 'wedding-planner'),
							'description' => esc_attr__('Enter src attribute of your Google Map iFrame.', 'wedding-planner'),
						)												
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_wedding_planner_meta_page_background_use_slider',
					'label' => esc_attr__('Use Background Slider', 'wedding-planner'),
					'description' => esc_attr__('Instead of using a static background, you can use background image slider.', 'wedding-planner'),
				),					
				array(
					'type'      => 'group',
					'repeating' => true,
					'sortable' => true,
					'name'      => 'ozy_wedding_planner_meta_page_background_slider_group',
					'title'     => esc_attr__('Slider Image', 'wedding-planner'),
					'dependency' => array(
						'field'    => 'ozy_wedding_planner_meta_page_background_use_slider',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_slider_image',
							'label' => esc_attr__('Slider Image', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose custom background image.', 'wedding-planner'),
						)												
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_wedding_planner_meta_page_background_use_video_self',
					'label' => esc_attr__('Use Self Hosted Video', 'wedding-planner'),
					'description' => esc_attr__('Instead of using a static background, you can use self hosted video.', 'wedding-planner'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'sortable' => false,
					'name'      => 'ozy_wedding_planner_meta_page_background_video_self_group',
					'title'     => esc_attr__('Self Hosted Video', 'wedding-planner'),
					'dependency' => array(
						'field'    => 'ozy_wedding_planner_meta_page_background_use_video_self',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_video_self_image',
							'label' => esc_attr__('Poster Image', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose a poster image.', 'wedding-planner'),
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_video_self_mp4',
							'label' => esc_attr__('MP4 File', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose a MP4 file.', 'wedding-planner'),
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_video_self_webm',
							'label' => esc_attr__('WEBM File', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose a WEBM file.', 'wedding-planner'),
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_video_self_ogv',
							'label' => esc_attr__('OGV File', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose an OGV file.', 'wedding-planner'),
						)
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_wedding_planner_meta_page_background_use_video_youtube',
					'label' => esc_attr__('Use YouTube Video', 'wedding-planner'),
					'description' => esc_attr__('Instead of using a static background, you can use YouTube video.', 'wedding-planner'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'sortable' => false,
					'name'      => 'ozy_wedding_planner_meta_page_background_video_youtube_group',
					'title'     => esc_attr__('YouTube Video', 'wedding-planner'),
					'dependency' => array(
						'field'    => 'ozy_wedding_planner_meta_page_background_use_video_youtube',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_video_youtube_image',
							'label' => esc_attr__('Poster Image', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose a poster image.', 'wedding-planner'),
						),
						array(
							'type' => 'textbox',
							'name' => 'ozy_wedding_planner_meta_page_background_video_youtube_id',
							'label' => esc_attr__('YouTube Video ID', 'wedding-planner'),
							'description' => esc_attr__('Enter YouTube video ID. http://www.youtube.com/watch?v=<span style="color:red;">mYKA-VokOtA</span> text marked with red is the ID you have to be looking for.', 'wedding-planner'),
						)
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_wedding_planner_meta_page_background_use_video_vimeo',
					'label' => esc_attr__('Use Vimeo Video', 'wedding-planner'),
					'description' => esc_attr__('Instead of using a static background, you can use Vimeo video.', 'wedding-planner'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'sortable' => false,
					'name'      => 'ozy_wedding_planner_meta_page_background_video_vimeo_group',
					'title'     => esc_attr__('Vimeo Video', 'wedding-planner'),
					'dependency' => array(
						'field'    => 'ozy_wedding_planner_meta_page_background_use_video_vimeo',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_wedding_planner_meta_page_background_video_vimeo_image',
							'label' => esc_attr__('Poster Image', 'wedding-planner'),
							'description' => esc_attr__('Upload or choose a poster image.', 'wedding-planner'),
						),
						array(
							'type' => 'textbox',
							'name' => 'ozy_wedding_planner_meta_page_background_video_vimeo_id',
							'label' => esc_attr__('Vimeo Video ID', 'wedding-planner'),
							'description' => esc_attr__('Enter Vimeo video ID. http://vimeo.com/<span style="color:red;">71964690</span> text marked with red is the ID you have to be looking for.', 'wedding-planner'),
						)
					),
				)
			),
		),
		array(
			'type'      	=> 'textbox',
			'name'      	=> 'ozy_wedding_planner_meta_page_music_file',
			'label'     	=> esc_attr__('MP3 Path', 'wedding-planner'),
			'description'   => esc_attr__('Please enter full path of your MP3 file.', 'wedding-planner')
		),		
		array(
			'type' => 'radiobutton',
			'name' => 'ozy_wedding_planner_meta_page_layout_width',
			'label' => esc_attr__('Layout Width', 'wedding-planner'),
			'items' => array(
				array(
					'value' => 'global',
					'label' => esc_attr__('Use Global Options', 'wedding-planner'),
				),			
				array(
					'value' => '1212',
					'label' => esc_attr__('Normal (1212px)', 'wedding-planner'),
				),
				array(
					'value' => '1672',
					'label' => esc_attr__('Wider (1600px)', 'wedding-planner'),
				)
			),
			'default' => array(
				'global',
			),
		)				
	),	
);

/**
 * EOF
 */