<?php
/**
 * Plugin Name: Wedding Planner Theme Essentials
 * Plugin URI: http://themeforest.net/user/freevision/portfolio
 * Description: This plugin will enable Custom Post types like few other features for your WEDDING PLANNER theme.
 * Version: 2.0
 * Author: freevision
 */

define( 'OZY_WEDDING_PLANNER_ESSENTIALS_ACTIVATED', 1 );

/**
 * Custom post types for portfolio and video gallery
 */
function ozy_plugin_create_post_types() {
	
	load_plugin_textdomain('ozy-wedding-planner-essentials', false, basename( dirname( __FILE__ ) ) . '/translate');
	
	$essentials_options = get_option('ozy_wedding_planner_essentials');
	if(is_array($essentials_options) && isset($essentials_options['image_gallery_slug'])) {
		$image_gallery_slug = $essentials_options['image_gallery_slug'];
	} else {
		$image_gallery_slug = 'gallery';
	}	
	
	if(is_array($essentials_options) && isset($essentials_options['portfolio_slug'])) {
		$portfolio_slug = $essentials_options['portfolio_slug'];
	} else {
		$portfolio_slug = 'portfolio';
	}	
	
	//User managaged sidebars
	register_post_type( 'ozy_sidebars',
		array(
			'labels' => array(
				'name' => esc_attr__( 'Sidebars', 'ozy-wedding-planner-essentials'),
				'singular_name' => esc_attr__( 'Sidebars', 'ozy-wedding-planner-essentials'),
				'add_new' => 'Add Sidebar',
				'add_new_item' => 'Add Sidebar',
				'edit_item' => 'Edit Sidebar',
				'new_item' => 'New Sidebar',
				'view_item' => 'View Sidebars',
				'search_items' => 'Search Sidebar',
				'not_found' => 'No Sidebar found',
				'not_found_in_trash' => 'No Sidebar found in Trash'				
			),
			'can_export' => true,
			'public' => true,
			'exclude_from_search' => true,
			'publicly_queryable' => false,
			'show_in_nav_menus' => false,
			'show_in_admin_bar' => false,
			'menu_position' => 60,
			'has_archive' => false,
			'hierarchical' => false,
			'show_in_rest' => false,
			'rewrite' => false,
			'supports' => array('title'),
			'taxonomies' => array(''),
			'menu_icon' => 'dashicons-align-left'
		)
	);
	
	//Portfolio
	register_post_type( 'ozy_portfolio',
		array(
			'labels' => array(
				'name' => esc_attr__( 'Portfolio', 'ozy-wedding-planner-essentials'),
				'singular_name' => esc_attr__( 'Portfolio', 'ozy-wedding-planner-essentials'),
				'add_new' => esc_attr__( 'Add Portfolio Item', 'ozy-wedding-planner-essentials'),
				'edit_item' => esc_attr__( 'Edit Portfolio Item', 'ozy-wedding-planner-essentials'),
				'new_item' => esc_attr__( 'New Portfolio Item', 'ozy-wedding-planner-essentials'),
				'view_item' => esc_attr__( 'View Portfolio Item', 'ozy-wedding-planner-essentials'),
				'search_items' => esc_attr__( 'Search Portfolio Items', 'ozy-wedding-planner-essentials'),
				'not_found' => esc_attr__( 'No Portfolio Items found', 'ozy-wedding-planner-essentials'),
				'not_found_in_trash' => esc_attr__( 'No Portfolio Items found in Trash', 'ozy-wedding-planner-essentials')				
			),
			'can_export' => true,
			'public' => true,
			'sort' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => $portfolio_slug, 'with_front' => true),
			'supports' => array('title','editor','thumbnail','excerpt','page-attributes'),
			'menu_icon' => 'dashicons-portfolio'
		)
	);	

}
add_action( 'init', 'ozy_plugin_create_post_types' );

/**
 * Custom taxonomy registration
 */
function ozy_plugin_create_custom_taxonomies() {

	//Portfolio Categories
	$labels = array(
		'name' => esc_attr__( 'Portfolio Categories', 'ozy-wedding-planner-essentials' ),
		'singular_name' => esc_attr__( 'Portfolio Category', 'ozy-wedding-planner-essentials' ),
		'search_items' =>  esc_attr__( 'Search Portfolio Categories', 'ozy-wedding-planner-essentials' ),
		'popular_items' => esc_attr__( 'Popular Portfolio Categories', 'ozy-wedding-planner-essentials' ),
		'all_items' => esc_attr__( 'All Portfolio Categories', 'ozy-wedding-planner-essentials' ),
		'parent_item' => esc_attr__( 'Parent Portfolio Categories', 'ozy-wedding-planner-essentials' ),
		'parent_item_colon' => esc_attr__( 'Parent Portfolio Category:', 'ozy-wedding-planner-essentials' ),
		'edit_item' => esc_attr__( 'Edit Portfolio Category', 'ozy-wedding-planner-essentials' ),
		'update_item' => esc_attr__( 'Update Portfolio Category', 'ozy-wedding-planner-essentials' ),
		'add_new_item' => esc_attr__( 'Add New Portfolio Category', 'ozy-wedding-planner-essentials' ),
		'new_item_name' => esc_attr__( 'New Portfolio Category', 'ozy-wedding-planner-essentials' ),
	);
	
	register_taxonomy('portfolio_category', array('ozy_portfolio'), array(
		'hierarchical' => true,
		'labels' => $labels,
		'show_ui' => true,
		'query_var' => true,
		'sort' => true,
		'rewrite' => array( 'slug' => 'portfolio_category' ),
	));
}
add_action( 'init', 'ozy_plugin_create_custom_taxonomies', 0 );

/**
 * Options panel for this plugin
 */
class OzyEssentialsOptionsPage_Wedding_Planner
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'page_init' ) );
    }

    /**
     * Add options page
     */
    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_options_page(
            'Settings Admin', 
            'Wedding Planner Essentials', 
            'manage_options', 
            'ozy-wedding-planner-essentials-setting-admin', 
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page()
    {
        // Set class property
        $this->options = get_option( 'ozy_wedding_planner_essentials' );
        ?>
        <div class="wrap">
            <h2>ozy Essentials Options</h2>           
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'ozy_wedding_planner_essentials_option_group' );
                do_settings_sections( 'ozy-wedding-planner-essentials-setting-admin' );
				do_settings_sections( 'ozy-wedding-planner-essentials-setting-admin-twitter' );
			
                submit_button(); 
            ?>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function page_init()
    {        
        register_setting(
            'ozy_wedding_planner_essentials_option_group', // Option group
            'ozy_wedding_planner_essentials', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );

        add_settings_section(
            'ozy-wedding-planner-essentials-setting-admin', // ID
            'Options', // Title
            array( $this, 'print_section_info' ), // Callback
            'ozy-wedding-planner-essentials-setting-admin' // Page
        );
		
        add_settings_field(
            'portfolio_slug', 
            'Portfolio Slug Name', 
            array( $this, 'field_callback' ), 
            'ozy-wedding-planner-essentials-setting-admin', 
            'ozy-wedding-planner-essentials-setting-admin'
        );			
		
        add_settings_section(
            'ozy-wedding-planner-essentials-setting-admin-twitter', 
            'Twitter Parameters', 
            array( $this, 'print_twitter_section_info' ),
            'ozy-wedding-planner-essentials-setting-admin-twitter'
        );		
		
        add_settings_field(
            'twitter_consumer_key', 
            'Consumer Key', 
            array( $this, 'field_callback_twitter_consumer_key' ), 
            'ozy-wedding-planner-essentials-setting-admin-twitter', 
            'ozy-wedding-planner-essentials-setting-admin-twitter'
        );

		add_settings_field(
            'twitter_secret_key', 
            'Secret Key', 
            array( $this, 'field_callback_twitter_secret_key' ), 
            'ozy-wedding-planner-essentials-setting-admin-twitter', 
            'ozy-wedding-planner-essentials-setting-admin-twitter'
        );
		
		add_settings_field(
            'twitter_token_key', 
            'Access Token Key', 
            array( $this, 'field_callback_twitter_token_key' ), 
            'ozy-wedding-planner-essentials-setting-admin-twitter', 
            'ozy-wedding-planner-essentials-setting-admin-twitter'
        );
		
		add_settings_field(
            'twitter_token_secret_key', 
            'Access Token Secret Key', 
            array( $this, 'field_callback_twitter_token_secret_key' ), 
            'ozy-wedding-planner-essentials-setting-admin-twitter', 
            'ozy-wedding-planner-essentials-setting-admin-twitter'
        );		

    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function sanitize( $input )
    {
        if( !empty( $input['portfolio_slug'] ) )
            $input['portfolio_slug'] = sanitize_text_field( $input['portfolio_slug'] );

		if( !empty( $input['twitter_consumer_key'] ) )
            $input['twitter_consumer_key'] = sanitize_text_field( $input['twitter_consumer_key'] );

		if( !empty( $input['twitter_secret_key'] ) )
            $input['twitter_secret_key'] = sanitize_text_field( $input['twitter_secret_key'] );

        if( !empty( $input['twitter_token_key'] ) )
            $input['twitter_token_key'] = sanitize_text_field( $input['twitter_token_key'] );

        if( !empty( $input['twitter_token_secret_key'] ) )
            $input['twitter_token_secret_key'] = sanitize_text_field( $input['twitter_token_secret_key'] );
			
        if( !is_numeric( $input['ozy_shortcodes'] ) )
            $input['ozy_shortcodes'] = '1'; 			

        return $input;
    }

    /** 
     * Print the Section text
     */
    public function print_section_info()
    {
        print 'Set custom slug for Portfolio post types.
		<p><strong>You may have to refresh your permalinks after saving this!</strong></p>';
    }
	
    public function print_twitter_section_info()
    {
        print 'Enter required parameters of your Twitter Dev. account <a href="https://dev.twitter.com/apps" target="_blank">https://dev.twitter.com/apps</a>';
    }	

    /** 
     * Get the settings option array and print one of its values : Portfolio Slug
     */
    public function field_callback()
    {
        printf(
            '<input type="text" id="portfolio_slug" name="ozy_wedding_planner_essentials[portfolio_slug]" value="%s" />',
            (!isset($this->options['portfolio_slug']) ? 'portfolio' : esc_attr( $this->options['portfolio_slug']))
        );
    }	
	
    /** 
     * Get the settings option array and print one of its values : Twitter Consumer Key
     */	
    public function field_callback_twitter_consumer_key()
    {
        printf(
            '<input type="text" id="twitter_consumer_key" name="ozy_wedding_planner_essentials[twitter_consumer_key]" value="%s" />',
            (!isset($this->options['twitter_consumer_key']) ? '' : esc_attr( $this->options['twitter_consumer_key']))
        );
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Secret Key
     */	
    public function field_callback_twitter_secret_key()
    {
        printf(
            '<input type="text" id="twitter_secret_key" name="ozy_wedding_planner_essentials[twitter_secret_key]" value="%s" />',
            (!isset($this->options['twitter_secret_key']) ? '' : esc_attr( $this->options['twitter_secret_key']))
        );		
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Token Key
     */	
    public function field_callback_twitter_token_key()
    {
        printf(
            '<input type="text" id="twitter_token_key" name="ozy_wedding_planner_essentials[twitter_token_key]" value="%s" />',
            (!isset($this->options['twitter_token_key']) ? '' : esc_attr( $this->options['twitter_token_key']))
        );		
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Token Secret Key
     */
    public function field_callback_twitter_token_secret_key()
    {
        printf(
            '<input type="text" id="twitter_token_secret_key" name="ozy_wedding_planner_essentials[twitter_token_secret_key]" value="%s" />',
            (!isset($this->options['twitter_token_secret_key']) ? '' : esc_attr( $this->options['twitter_token_secret_key']))
        );		
    }

}

/** 
 * Register activation redirection
 */
register_activation_hook(__FILE__, 'ozy_essentials_plugin_activate');
add_action('admin_init', 'ozy_essentials_plugin_activate_redirect');

function ozy_essentials_plugin_activate() {
    add_option('ozy_essentials_plugin_activate_redirect', true);
}

function ozy_essentials_plugin_activate_redirect() {
    if (get_option('ozy_essentials_plugin_activate_redirect', false)) {
        delete_option('ozy_essentials_plugin_activate_redirect');
        wp_redirect('options-general.php?page=ozy-wedding-planner-essentials-setting-admin');
    }
}

/**
* Sets up theme defaults and registers support for various WordPress features.
*/
function wedding_planner_plugin_theme_setup() {
	// Adds Post Format support
	// learn more: http://codex.wordpress.org/Post_Formats
	add_theme_support( 'post-formats', array( 
		'aside', 
		'gallery',
		'link',
		'image',
		'quote',
		'status',
		'video',
		'audio',
		'chat' ) 
	);
	
	// Enable shortcodes in the widgets
	add_filter('widget_text', 'shortcode_unautop');
	add_filter('widget_text', 'do_shortcode');	
	
	// Removes detailed login error information for security	
	add_filter('login_errors',function($a) {return null;});
}
add_action('after_setup_theme', 'wedding_planner_plugin_theme_setup', 99);	

/**
 * We need this plugin to work only on admin side
 */

if( is_admin() ) {
    $ozy_essentials_options_page = new OzyEssentialsOptionsPage_Wedding_Planner();
}

/*
* Widgets
*/
require_once plugin_dir_path( __FILE__ ) . 'ozy-wedding-planner-essentials-widgets.php';

/**
 *	Samples Importer
 */
require_once plugin_dir_path( __FILE__ ) .'ozy-wedding-planner-essentials-importer-init.php';

/**
* Update Notifier
*/
require(plugin_dir_path( __FILE__ ) . 'updater/update-notifier.php');
define( 'WEDDING_PLANNER_NOTIFIER_THEME_NAME', 'WEDDING_PLANNER' );
define( 'WEDDING_PLANNER_NOTIFIER_THEME_FOLDER_NAME', 'wedding_planner' );
define( 'WEDDING_PLANNER_NOTIFIER_XML_FILE', 'http://s3-eu-west-1.amazonaws.com/themeversion/wedding_planner.xml' );
define( 'WEDDING_PLANNER_NOTIFIER_CACHE_INTERVAL', 43200);

/**
* ozy_add_extra_page
*
* We are adding and extra page to include documentation into to the admin.
*/
function wedding_planner_ozy_add_extra_page() {
	add_menu_page(
		esc_attr__('Documentation','ozy-wedding-planner-essentials'), 
		esc_attr__('Documentation','ozy-wedding-planner-essentials'), 
		'read',
		'wedding-planner-ozy-wedding_planner-documentation', 
		'wedding_planner_ozy_wedding_planner_documentation', 
		'dashicons-editor-help' 
	);
}
add_action('admin_menu', 'wedding_planner_ozy_add_extra_page');

function wedding_planner_ozy_wedding_planner_documentation() {
	echo '<iframe src="http://doc.freevision.me/wedding-planner" id="ozy-help-iframe" width="100%" height="800px" frameborder="0"></iframe>';
}

if(!function_exists('wedding_planner_timestampdiff')) {
	function wedding_planner_timestampdiff($qw, $saw) {
		$datetime1 = new DateTime("@"."$qw");
		$datetime2 = new DateTime("@"."$saw");
		$interval = $datetime1->diff($datetime2);
		
		return $interval->format('%I');
	}
}

/**
* wedding_planner_ajax_instagram
*
* Instagram JSON data, to make sure not loading from remote service for each call to avoid exceeding the limit of use
*/
function wedding_planner_ajax_instagram() {
	$date = new DateTime(); $api_key = '';

	$request_user_id 		= isset($_GET["request_user_id"]) ? sanitize_text_field($_GET["request_user_id"]) : '';
	$request_access_token 	= isset($_GET["request_access_token"]) ? sanitize_text_field($_GET["request_access_token"]) : '';
	$request_num_photos 	= isset($_GET["request_num_photos"]) ? sanitize_text_field($_GET["request_num_photos"]) : '';
	
	if(trim($request_user_id) != '' && trim($request_access_token) != '' && trim($request_num_photos) != '') {
		if(get_option('wedding_planner_freevision_instagram_cache_time') != '' && wedding_planner_timestampdiff($date->getTimestamp(), get_option('wedding_planner_freevision_instagram_cache_time')) < 30) { //check if weather data 30 minutes old 		
			echo get_option('wedding_planner_freevision_instagram_cache');
			exit();			
		}else{			
			$request = wp_remote_get('https://graph.instagram.com/'. $request_user_id .'/media?fields=id,username&access_token=' . $request_access_token);
			if( is_wp_error( $request ) ) {
				echo '{"error":"Instagram Service Error: '. $request->get_error_message() .'"}';
				exit();
			}
			$body = wp_remote_retrieve_body( $request );
			$data = json_decode( $body );
			if( ! empty( $data ) ) {			
				if(isset($data->data)) {					
					$output = ''; $max_num_photos_counter = 0;

					if(isset($data->data[0]->username)) $output .= '<span class="alternate-text-color" id="instagram-feed-user-name-label">@'. $data->data[0]->username .'</span>';

					$output .= '<ul class="ozy-instagram-gallery new">';
					foreach($data->data as $d) {
						if(isset($d->id) && isset($d->username)) {
							$media_request = wp_remote_get('https://graph.instagram.com/'. $d->id .'?fields=id,media_type,media_url,thumbnail_url,username,timestamp,permalink,caption&access_token=' . $request_access_token);
							if( is_wp_error( $media_request ) ) {
								echo '{"error":"Instagram Service Error: '. $media_request->get_error_message() .'"}';
								exit();
							}							
							$media_body = wp_remote_retrieve_body( $media_request );
							$media_data = json_decode( $media_body );
							if( ! empty( $media_data ) ) {
								if(isset($media_data->media_url) && isset($media_data->permalink) && isset($media_data->media_type)) {
									if($media_data->media_type == 'VIDEO') {
										$output .= '<li class="video-item"><a href="'. $media_data->permalink .'" target="_blank"><img src="'. $media_data->thumbnail_url .'"></a></li>';
									}else if($media_data->media_type == 'IMAGE'){
										$output .= '<li class="image-item"><a href="'. $media_data->permalink .'" target="_blank"><img src="'. $media_data->media_url .'"></a></li>';
									}									
									
									$max_num_photos_counter++;
									if($max_num_photos_counter > $request_num_photos) break;
								}							
							}else{
								echo '{"error":"No media found"}'; exit();
							}
						}
					}
					$output .= '</ul>';

					update_option('wedding_planner_freevision_instagram_cache', $output);
					update_option('wedding_planner_freevision_instagram_cache_time', $date->getTimestamp());					
					
					echo $output; exit();
				}else{
					echo '{"error":"Invalid Request #1"}'; exit();
				}
			}else{
				echo '{"error":"Invalid Request #2"}'; exit();
			}
		}
	}else{		
		echo '{"error":"Missing parameters #3"}'; exit();
	}	

	exit();

}
add_action( 'wp_ajax_nopriv_wedding_planner_ajax_instagram', 'wedding_planner_ajax_instagram' ); 
add_action( 'wp_ajax_wedding_planner_ajax_instagram', 'wedding_planner_ajax_instagram' ); 

/**
 * Shortcodes
 */

if ( ! function_exists( 'is_plugin_active' ) ) require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
if(is_plugin_active("js_composer/js_composer.php") && function_exists('vc_map') && function_exists('vc_set_as_theme')) {

	//Icon Selector Attribute Type
	function ozy_select_an_icon_settings_field($settings, $value) {
       return '<div class="select_an_icon">'
                 .'<input name="'.$settings['param_name']
                 .'" id="field_'.$settings['param_name']
                 .'_select" class="wpb_vc_param_value wpb-textinput '
                 .$settings['param_name'].' '.$settings['type'].'_field" type="text" value="'
                 .$value.'"/>'
             .'</div>';
	}

	vc_add_shortcode_param('select_an_icon', 'ozy_select_an_icon_settings_field', get_template_directory_uri() .'/scripts/admin/admin.js');

	$add_css_animation = 
	array(
		'type' => 'animation_style',
		'heading' => esc_attr( 'Initial loading animation', 'ozy-wedding-planner-essentials' ),
		'param_name' => 'css_animation',
		'value' => '',
		'settings' => array(
			'type' => array(
				'in',
				'other',
			),
		),
		'description' => esc_attr( 'Select initial loading animation for grid element.', 'ozy-wedding-planner-essentials' ),
	);

	/**
	* Countdown
	*/
	if (!function_exists('ozy_vc_countdown')) {
		function ozy_vc_countdown( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_countdown', $atts);
			extract(shortcode_atts(array(
				'box_style'		=> '',
				'end_year'		=> '',
				'end_month'		=> '',
				'end_day'		=> '',
				'end_hour'		=> '',
				'end_minute'	=> '',
				'css_animation' => '',
				'el_class'		=> ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	

			wp_enqueue_script('wedding-planner-countdown');
			
			$output	='<div class="ozy-countdown '. esc_attr($box_style) .' '. $css_animation . ' ' . esc_attr($el_class)  .'" data-year="'. esc_attr($end_year) .'" data-month="'. esc_attr($end_month) .'" data-day="'. esc_attr($end_day) .'" data-hour="'. esc_attr($end_hour) .'" data-minute="'. esc_attr($end_minute) .'">';
            $output.='<div class="timer">';
            $output.='  <div class="days">';
            $output.='    <div class="time"><span>'. esc_html__('DAYS', 'ozy-wedding-planner-essentials') .'</span><div class="heading-font">000</div></div>';
            $output.='  </div>';
            $output.='  <div class="hours">';
            $output.='    <div class="time"><span>'. esc_html__('HOURS', 'ozy-wedding-planner-essentials') .'</span><div class="heading-font">00</div></div>';
            $output.='  </div>';
            $output.='  <div class="minutes">';
            $output.='    <div class="time"><span>'. esc_html__('MINUTES', 'ozy-wedding-planner-essentials') .'</span><div class="heading-font">00</div></div>';
            $output.='  </div>';
            $output.='  <div class="seconds">';
            $output.='    <div class="time"><span>'. esc_html__('SECONDS', 'ozy-wedding-planner-essentials') .'</span><div class="heading-font">00</div></div>';
            $output.='  </div>';
			$output.='</div></div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_countdown', 'ozy_vc_countdown');
		
		vc_map( array(
			"name" => esc_attr__("Countdown", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_countdown",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Style", "ozy-wedding-planner-essentials"),
					"param_name" => "box_style",
					"value" => array(
						esc_attr__("Botanical Frame", "ozy-wedding-planner-essentials") => "style1",
						esc_attr__("Handdrawn Wreath", "ozy-wedding-planner-essentials") => "style2",
						esc_attr__("Watercolor Frame", "ozy-wedding-planner-essentials") => "style3",
						esc_attr__("Botanical Wreath", "ozy-wedding-planner-essentials") => "style4"						
					),
					"admin_label" => true,
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("End Year", "ozy-wedding-planner-essentials"),
					"param_name" => "end_year",
					"admin_label" => true,
					"value" => (date('Y') + 1)
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("End Month", "ozy-wedding-planner-essentials"),
					"param_name" => "end_month",
					"admin_label" => true,
					"value" => "12"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("End Day", "ozy-wedding-planner-essentials"),
					"param_name" => "end_day",
					"admin_label" => true,
					"value" => "15"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("End Hour", "ozy-wedding-planner-essentials"),
					"param_name" => "end_hour",
					"admin_label" => true,
					"value" => "12"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("End Minute", "ozy-wedding-planner-essentials"),
					"param_name" => "end_minute",
					"admin_label" => true,
					"value" => "12"
				),$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		) );	
	}	
	
	/**
	* Animated Image Gallery
	*/
	if (!function_exists('ozy_vc_animated_image_gallery')) {
		function ozy_vc_animated_image_gallery( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_animated_image_gallery', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'el_class'		=> '',
				'min_height'	=> '500px',
				'link'			=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}		

			$link = vc_build_link($link); $a_start = ''; $a_end = '';
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$a_start = '<a href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']).'"':'').'>';
				$a_end = '</a>';
			}

			$output='<div class="ozy-photos '. $css_animation . ' ' . esc_attr($el_class)  .'"><div style="min-height:'. esc_attr($min_height) .'">';
			$image = explode(',', $image);
			if(is_array($image)) {
				$output .= $a_start;
				foreach($image as $img) {
					$img_src = wp_get_attachment_image_src($img, 'full');
					if(isset($img_src[0])) {
						$output .= '<img src="'. esc_url($img_src[0]) .'" alt=""/>';
					}
				}
				$output .= $a_end;
			}
			$output.='</div></div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_animated_image_gallery', 'ozy_vc_animated_image_gallery');
		
		vc_map( array(
			"name" => esc_attr__("Animated Image Gallery", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_animated_image_gallery",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_images",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Add 5 images in same ratio (width and height) to get best result.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Minimum Height", "ozy-wedding-planner-essentials"),
					"param_name" => "min_height",
					"admin_label" => true,
					"value" => '500px'
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		) );	
	}
	
	/**
	* Fancy Button
	*/
	if (!function_exists('ozy_vc_custom_button')) {
		function ozy_vc_custom_button( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_custom_button', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'link' => '',
				'fg_color' => '',
				'fg_color_hover' => '',
				'bg_color' => '',
				'bg_color_active' => '',
				'css_animation' => '',
				'button_style'	=> 'btn-0',
				'button_align'	=> 'left'
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$rand_id = 'ofcb-' . rand(10, 100000);
			
			$output = '<span  id="w'. esc_attr($rand_id) .'" class="ozy-custom_button_w"><a id="'. esc_attr($rand_id) .'" class="ozy-custom_button oc'. esc_attr($button_style) .'" ';
			$link = vc_build_link($link);
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$output .= ' href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']).'"':'').' ';
			}
			$output .= '>';
			if($button_style == 'btn-3' || $button_style == 'btn-4' || $button_style == 'btn-7' || $button_style == 'btn-9' || $button_style == 'btn-10') $output .= '<span>';
			$output .= esc_html($title);
			if($button_style == 'btn-6') $output .= '<span></span>';
			if($button_style == 'btn-3' || $button_style == 'btn-4' || $button_style == 'btn-7' || $button_style == 'btn-9' || $button_style == 'btn-10') $output .= '</span>';
			$output .= '</a></span>';
						
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			//$rand_id = $rand_id . '.ozy-custom_button.oc' . $button_style;
			if($button_style == 'btn-0') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before {background:". esc_attr($bg_color) ."!important;}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) ."!important;}
");
			if($button_style == 'btn-1') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:after {border-color:". esc_attr($bg_color) ." transparent transparent transparent;}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-1-2') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before {border-color:transparent transparent transparent ". esc_attr($bg_color) .";}#$rand_id:after {border-color:transparent transparent ". esc_attr($bg_color) ." transparent;}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-2' || $button_style == 'btn-5') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before {border-color:transparent transparent transparent ". esc_attr($bg_color) .";}#$rand_id:after {border-color:transparent ". esc_attr($bg_color) ." transparent transparent;}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-33') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before {border-color:transparent transparent transparent ". esc_attr($bg_color) .";}#$rand_id:after {border-color:transparent ". esc_attr($bg_color) ." transparent transparent;}#$rand_id span:before {border-color:transparent transparent ". esc_attr($bg_color) ." transparent;}#$rand_id span:after {border-color:". esc_attr($bg_color) ." transparent transparent transparent;}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");

			if($button_style == 'btn-4') 
				$ozyWeddingPlannerHelper->set_footer_style(
			"#$rand_id {color:". esc_attr($fg_color) ."!important;}
			#$rand_id:before {border-color:transparent transparent transparent ". esc_attr($bg_color) .";}
			#$rand_id:after {border-color:transparent ". esc_attr($bg_color) ." transparent transparent;}
			#$rand_id:before,#$rand_id:after {border-color:". esc_attr($bg_color) .";}
			#$rand_id span:before {border-color:transparent transparent ". esc_attr($bg_color) ." transparent;}
			#$rand_id span:after {border-color:". esc_attr($bg_color) ." transparent transparent transparent;}
			#$rand_id span:before,#$rand_id span:after {border-color:". esc_attr($bg_color) .";}
			#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}
			#$rand_id:active{background: ". esc_attr($bg_color_active) .";}");
			
			if($button_style == 'btn-6') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id span {background:". esc_attr($bg_color) .";}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-7') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before,#$rand_id:after,#$rand_id span:before,#$rand_id span:after {background:". esc_attr($bg_color) .";}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-8') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before,#$rand_id:after{background:". esc_attr($bg_color) .";}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-9' || $button_style == 'btn-10') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before,#$rand_id:after,#$rand_id span:before,#$rand_id span:after {background:". esc_attr($ozyWeddingPlannerHelper->hex2rgba($bg_color, '.25')) .";}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}#$rand_id:active{background: ". esc_attr($bg_color_active) .";}
");
			if($button_style == 'btn-11') 
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($fg_color) ."!important;}#$rand_id:before,#$rand_id:after {background:". esc_attr($bg_color) .";}#$rand_id:hover{color:". esc_attr($fg_color_hover) ."!important;}
");
			if($button_align == 'center') {
				$ozyWeddingPlannerHelper->set_footer_style("#w$rand_id {text-align:". esc_attr($button_align) .";width:100%;display:inline-block;}");
			}
			if($button_align == 'right') {
				$ozyWeddingPlannerHelper->set_footer_style("#w$rand_id{float:right;}");
			}

			return $output;
		}

		add_shortcode( 'ozy_vc_custom_button', 'ozy_vc_custom_button' );
		
		vc_map( array(
			"name" => esc_attr__("Custom Button", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_custom_button",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => esc_attr__("Button Text", "ozy-wedding-planner-essentials"),
					"description" => esc_attr__("Title of your box.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Foregound Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color",
					"admin_label" => false,
					"value" => "#000000"
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Foregound Color (Hover)", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color_hover",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Background Color", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#000000"
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Background Color (Active)", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_color_active",
					"admin_label" => false,
					"value" => "#2d2d2d"
				),array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Button Style", "ozy-wedding-planner-essentials"),
					"param_name" => "button_style",
					"value" => array(
						esc_attr__("Swipe", "ozy-wedding-planner-essentials") => "btn-0",
						esc_attr__("Diagonal Swipe", "ozy-wedding-planner-essentials") => "btn-1",
						esc_attr__("Double Swipe", "ozy-wedding-planner-essentials") => "btn-1-2",
						esc_attr__("Diagonal Close", "ozy-wedding-planner-essentials") => "btn-2",
						esc_attr__("Zoning In", "ozy-wedding-planner-essentials") => "btn-33",
						esc_attr__("4 Corners", "ozy-wedding-planner-essentials") => "btn-4",
						esc_attr__("Slice", "ozy-wedding-planner-essentials") => "btn-5",
						esc_attr__("Position Aware", "ozy-wedding-planner-essentials") => "btn-6",
						esc_attr__("Alternate", "ozy-wedding-planner-essentials") => "btn-7",
						esc_attr__("Smoosh", "ozy-wedding-planner-essentials") => "btn-8",
						esc_attr__("Vertical Overlap", "ozy-wedding-planner-essentials") => "btn-9",
						esc_attr__("Horizontal Overlap", "ozy-wedding-planner-essentials") => "btn-10",
						esc_attr__("Collision", "ozy-wedding-planner-essentials") => "btn-11",
					),
					"admin_label" => true,
				),array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Align", "ozy-wedding-planner-essentials"),
					"param_name" => "button_align",
					"value" => array(
						esc_attr__("Left", "ozy-wedding-planner-essentials") => "left",
						esc_attr__("Center", "ozy-wedding-planner-essentials") => "center",
						esc_attr__("Right", "ozy-wedding-planner-essentials") => "right"
					),
					"admin_label" => true,
				),$add_css_animation
		   )
		) );		
	}
	
	/**
	* Custom List
	*/
	if (!function_exists('ozy_vc_custom_list')) {
		function ozy_vc_custom_list( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_custom_list', $atts);
			extract(shortcode_atts(array(
				'icon' => '',
				'fg_color' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$rand_id = 'ocl-' . rand(10, 100000);
			
			$output = PHP_EOL . '<div id="'. esc_attr($rand_id) .'" class="ozy-custom-list wpb_content_element '. $css_animation .'">' . PHP_EOL;
			$output_content = $content;
			$output.= str_replace('<li>', '<li><i class="'. esc_attr($icon) .'"></i>', $output_content);
			$output.= '</div>';
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id li>i{color:". esc_attr($fg_color) ."}");
			
			return $output;
		}

		add_shortcode( 'ozy_vc_custom_list', 'ozy_vc_custom_list' );
		
		vc_map( array(
			"name" => esc_attr__("Custom List", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_custom_list",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "select_an_icon",
					"heading" => esc_attr__("Icon", "ozy-wedding-planner-essentials"),
					"param_name" => "icon",
					"value" => '',
					"admin_label" => false,
					"description" => esc_attr__("Select an icon.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Icon Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color",
					"admin_label" => false,
					"value" => "#000000"
				),array(
					"type" => "textarea_html",
					"class" => "",
					"heading" => esc_attr__("Content", "ozy-wedding-planner-essentials"),
					"param_name" => "content",
					"admin_label" => true,
					"value" => "<ul><li>Item #1</li><li>Item #2</li><li>Item #3</li></ul>",
				),$add_css_animation
		   )
		) );	
	}	
	
	/**
	* Floral Divider
	*/
	if (!function_exists('ozy_vc_floral_divider')) {
		function ozy_vc_floral_divider( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_floral_divider', $atts);
			extract(shortcode_atts(array(
				'style' => 'style_1',
				'align' => 'center',
				'max_width' => '353px',
				'fg_color' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$rand_id = 'ofd-' . rand(10, 100000);
			
			$output = PHP_EOL . '<div id="'. esc_attr($rand_id) .'" class="ozy-floral-divider '. esc_attr($style) . ' align-' . esc_attr($align) .' '. $css_animation .'">' . PHP_EOL;
			switch($style) {
				case 'style_1':
					$output.= '<svg viewBox="0 0 360.62 37.92"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/floral_divider.svg', dirname(__FILE__) ) . '#floral_divider"></use></svg>';
					break;
				case 'style_2':
					$output.= '<svg viewBox="0 0 351.36 18.83"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/decorative_separator.svg', dirname(__FILE__) ) . '#decorative_separator"></use></svg>';
					break;
				case 'ornament_1':
					$output.= '<svg viewBox="0 0 198.43 23.35"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/ornament_divider1.svg', dirname(__FILE__) ) . '#ornament_divider1"></use></svg>';
					break;
				case 'ornament_2':
					$output.= '<svg viewBox="0 0 127.56 30.87"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/ornament_divider2.svg', dirname(__FILE__) ) . '#ornament_divider2"></use></svg>';
					break;
				case 'ornament_3':
					$output.= '<svg viewBox="0 0 204.09 24.53"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/ornament_divider3.svg', dirname(__FILE__) ) . '#ornament_divider3"></use></svg>';
					break;
				case 'ornament_4':
					$output.= '<svg viewBox="0 0 113.39 12.37"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/ornament_divider4.svg', dirname(__FILE__) ) . '#ornament_divider4"></use></svg>';
					break;
				case 'ornament_5':
					$output.= '<svg viewBox="0 0 255.12 23.4"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/ornament_divider5.svg', dirname(__FILE__) ) . '#ornament_divider5"></use></svg>';
					break;
				case 'ornament_6':
					$output.= '<svg viewBox="0 0 255.12 23.4"><use xlink:href="' . plugins_url( 'ozy-wedding-planner-essentials/images/ornament_divider6.svg', dirname(__FILE__) ) . '#ornament_divider6"></use></svg>';
					break;

			}
			$output.= '</div>';
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id{max-width:". esc_attr($max_width) ."}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id svg,#$rand_id svg path {stroke-width: 0px;fill:". esc_attr($fg_color) .";stroke:". esc_attr($fg_color) ."}");
			
			return $output;
		}

		add_shortcode( 'ozy_vc_floral_divider', 'ozy_vc_floral_divider' );
		
		vc_map( array(
			"name" => esc_attr__("Floral Divider", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_floral_divider",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Style", "ozy-wedding-planner-essentials"),
					"param_name" => "style",
					"admin_label" => true,
					"value" => array("style_1", "style_2", "ornament_1", "ornament_2", "ornament_3", "ornament_4", "ornament_5", "ornament_6")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Align", "ozy-wedding-planner-essentials"),
					"param_name" => "align",
					"admin_label" => true,
					"value" => array("center", "left", "right")
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Foregound Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Max Width", "ozy-wedding-planner-essentials"),
					"param_name" => "max_width",
					"admin_label" => true,
					"value" => "353px",					
				),$add_css_animation
		   )
		) );	
	}	

	/**
	* Service Box
	*/
	if (!function_exists('ozy_vc_service_box')) {
		function ozy_vc_service_box( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_service_box', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'excerpt' => '',
				'link' => '',
				'fg_color' => '',
				'bg_image' => '',
				'box_size' => 'regular',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$rand_id = 'osrvbx-' . rand(10, 100000); $style = '';
			
			$bg_image = wp_get_attachment_image_src($bg_image, 'full');
			if(isset($bg_image[0])) {
				$style = 'background-image:url('. esc_url($bg_image[0]) .');';
			}			
			$output = '<div id="'. esc_attr($rand_id) .'" class="ozy-service_box box-size-' . esc_attr($box_size) .' '. $css_animation .'">' . PHP_EOL;
			$output.= '<div style="'. $style .'"></div>';

			$link = vc_build_link($link); $href = '';
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$href = ' href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']).'"':'').' ';
			}
			//$output.= '<div class="overlay"></div>';
			$output.= '<div class="caption">';
			$output.= '<a '. $href .'>';
			$output.= '<h2>'. esc_html($title) .'</h2>';
			$output.= '<p>'. esc_html($excerpt) .'</p>';
			$output.= '</a>';
			if($href) $output.= '<a '. $href .'><img src="' . plugins_url( 'ozy-wedding-planner-essentials/images/arrow_icon.svg', dirname(__FILE__) ) . '" class="svg" alt="Arrow Icon"/></a>';		
			$output.= '</div>' . PHP_EOL;
			
			$output.= '</div>' . PHP_EOL;
						
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			/*$ozyWeddingPlannerHelper->set_footer_style("#$rand_id, #$rand_id>div.overlay {background-color:". esc_attr($bg_color) ."!important}");*/
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id h2, #$rand_id p {color:". esc_attr($fg_color) ."!important}");
				$ozyWeddingPlannerHelper->set_footer_style("#$rand_id:before{border-color:". esc_attr($fg_color) ."!important}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id svg g path {fill:". esc_attr($fg_color) ." !important;}");
			
			return $output;
		}

		add_shortcode( 'ozy_vc_service_box', 'ozy_vc_service_box' );
		
		vc_map( array(
			"name" => esc_attr__("Service Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_service_box",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Title of your box.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Excerpt", "ozy-wedding-planner-essentials"),
					"param_name" => "excerpt",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter a short text to display under your title.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Foregound Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Background Image", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select image for your team member.", "ozy-wedding-planner-essentials")					
				),array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Size", "ozy-wedding-planner-essentials"),
					"param_name" => "box_size",
					"value" => array("regular", "tall"),
					"admin_label" => true,
				),$add_css_animation
		   )
		) );		
	}	
	
	/**
	* Image / Video Box
	*/
	if (!function_exists('ozy_vc_image_video_box')) {
		function ozy_vc_image_video_box( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_image_video_box', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'excerpt' => '',
				'event_date' => '',
				'link' => '',
				'video_url' => '',
				'fg_color' => '',
				'bg_image' => '',
				'bg_color' => '',
				'use_hover' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	
			
			$rand_id = 'oivbx-' . rand(10, 100000); $style = '';
			
			$bg_image = wp_get_attachment_image_src($bg_image, 'full');
			if(isset($bg_image[0])) {
				$style = 'background-image:url('. esc_url($bg_image[0]) .');';
			}			
			$output = '<div id="'. esc_attr($rand_id) .'" class="ozy-image_video_box '. ($video_url ? 'video-box' : '') . ' ' . ($use_hover == 'no' ? 'no-hover' : '') .' '. $css_animation .'" style="'. $style .'">' . PHP_EOL;
			if(!$video_url) {
				$link = vc_build_link($link); $href = '';
				if(is_array($link) && isset($link['url']) && $link['url']) {
					$href = ' href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']).'"':'').' ';
				}
				$output.= '<div class="overlay"></div>';
				$output.= '<a '. $href .' class="caption">';
				$output.= '<h2>'. esc_html($title) .'</h2>';
				$output.= '<p>'. esc_html($excerpt) .'</p>';
				$output.= $event_date ? '<span>'. esc_html($event_date) .'</span>' : '';
				$output.= '</a>';
				if($href) $output.= '<a '. $href .'><img src="' . plugins_url( 'ozy-wedding-planner-essentials/images/arrow_icon.svg', dirname(__FILE__) ) . '" class="svg" alt="Arrow Icon"/></a>';
			}else{
				$output.= '<a href="'. esc_url($video_url) .'" class="fancybox-media"><img src="' . plugins_url( 'ozy-wedding-planner-essentials/images/play_icon.svg', dirname(__FILE__) ) . '" class="svg" alt="Play Icon"/></a>';
			}
			$output.= '</div>' . PHP_EOL;
						
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id, #$rand_id>div.overlay {background-color:". esc_attr($bg_color) ."!important}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id h2, #$rand_id p, #$rand_id span {color:". esc_attr($fg_color) ."!important}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id svg g path {fill:". esc_attr($fg_color) ." !important;}");
			
			return $output;
		}

		add_shortcode( 'ozy_vc_image_video_box', 'ozy_vc_image_video_box' );
		
		vc_map( array(
			"name" => esc_attr__("Image / Video Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_image_video_box",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Title of your box.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Excerpt", "ozy-wedding-planner-essentials"),
					"param_name" => "excerpt",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter a short text to display under your title.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Event Date", "ozy-wedding-planner-essentials"),
					"param_name" => "event_date",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Optional field, date entry will be shown on hover state only (bottom-left).", "ozy-wedding-planner-essentials")
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Video URL", "ozy-wedding-planner-essentials"),
					"param_name" => "video_url",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("When used, Link entry will be ignored.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Foregound Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Background Image", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select image for your team member.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Overlay Background Color", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "rgba(0,0,0,0.90)"
				),array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Use Hover?", "ozy-wedding-planner-essentials"),
					"param_name" => "use_hover",
					"value" => array("default", "no"),
					"admin_label" => true,
				),$add_css_animation
		   )
		) );		
	}
	
	/**
	* YouTube Embed
	*/
	if (!function_exists('ozy_vc_youtube_embed')) {
		function ozy_vc_youtube_embed( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_youtube_embed', $atts);
			extract(shortcode_atts(array(
				'video_size' => '169',
				'video_id' => '',
				'poster_image' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	
			
			$rand_id = 'oyoutubeembed-' . rand(10, 100000); $style = '';

			$poster_image = wp_get_attachment_image_src($poster_image, 'full');
			if(isset($poster_image[0])) {
				$style = 'background-image:url('. esc_url($poster_image[0]) .');';
			}			
			
			$output = '<div id="'. esc_attr($rand_id) .'"><div class="oytb-videoWrapper oytb-videoWrapper'. esc_attr($video_size) .' oytb-js-videoWrapper '. $css_animation .'">
    <iframe class="oytb-videoIframe oytb-js-videoIframe" src="" frameborder="0" allowTransparency="true" allowfullscreen data-src="https://www.youtube.com/embed/'. esc_attr($video_id) .'?autoplay=1& modestbranding=1&rel=0&hl=sv"></iframe>
    <button class="oytb-videoPoster oytb-js-videoPoster" style="'. $style .'"><img src="' . plugins_url( 'ozy-wedding-planner-essentials/images/play_button.svg', dirname(__FILE__) ) . '#play" class="svg" alt="Play Icon"/></button>
  </div><button class="oytb-video-StopButton generic-button" title="'. esc_attr('close video', 'ozy-wedding-planner-essentials') .'">X</button></div>';
  
			return $output;
		}

		add_shortcode( 'ozy_vc_youtube_embed', 'ozy_vc_youtube_embed' );
		
		vc_map( array(
			"name" => esc_attr__("YouTube Embed", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_youtube_embed",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Video Size", "ozy-wedding-planner-essentials"),
					"param_name" => "video_size",
					"value" => array(esc_attr__("16:9", "ozy-wedding-planner-essentials") => "169", esc_attr__("4:3", "ozy-wedding-planner-essentials") => "43"),
					"admin_label" => true,
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Embed Video ID", "ozy-wedding-planner-essentials"),
					"param_name" => "video_id",
					"admin_label" => true,
					"value" => "",
					"description" => wp_kses(__('YouTube Embed Video ID. eq. https://www.youtube.com/watch?v=<strong style="color:red">3sey-GFl1SQ</strong>, the bold - red part is your video ID.', 'ozy-wedding-planner-essentials'), array('strong' => array('style' => array()),))
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Poster Image", "ozy-wedding-planner-essentials"),
					"param_name" => "poster_image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Set a poster image for your video player.", "ozy-wedding-planner-essentials")
				),$add_css_animation
		   )
		) );		
	}
	
	/**
	* Border Box
	*/
	if (!function_exists('ozy_vc_border_block')) {
		function ozy_vc_border_block( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_border_block', $atts);
			extract(shortcode_atts(array(
				'caption' => '',
				'excerpt' => '',
				'link' => '',
				'fg_color' => '#ffffff',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$rand_id = 'obb-' . rand(10, 100000); $style = '';
			
			$output = 
			'<div id="'. esc_attr($rand_id) .'" class="ozy-border-box-wrapper '. esc_attr($css_animation) .'">
				<div class="ozy-border-box">
					<span class="border-sides"></span>
					<h2>'. str_replace(',', '<br/>', esc_html($excerpt)) .'</h2>
					<div class="text-center">';
			
			$output.= '<a';
			$link = vc_build_link($link);
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$output.= ' href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']) .'"' : '');
			}					
			$output .= ' class="generic-button generic-button-opacity">'. esc_attr($caption) .'</a>';
			$output .= '</div>
				</div>
			</div>';
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id,#$rand_id .border-sides:before,#$rand_id .border-sides:after,#$rand_id .ozy-border-box:after{border-color:". esc_attr($fg_color) .";}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id h2{color:". esc_attr($fg_color) .";}");
  
			return $output;
		}

		add_shortcode( 'ozy_vc_border_block', 'ozy_vc_border_block' );
		
		vc_map( array(
			"name" => esc_attr__("Border Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_border_block",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Button / Sub Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => "",
				),array(
					"type" => "exploded_textarea",
					"class" => "",
					"heading" => esc_attr__("Excerpt", "ozy-wedding-planner-essentials"),
					"param_name" => "excerpt",
					"admin_label" => true,
					"value" => "",
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fg_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),$add_css_animation
		   )
		) );		
	}		

	/**
	* Multiscroll Container
	*/
	if (!function_exists('ozy_vc_multiscroll_container')) {
		function ozy_vc_multiscroll_container( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_multiscroll_container', $atts);
			extract(shortcode_atts(array(
				'css_animation' => ''
			), $atts));
					
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$output = '<div id="multiscroll-container" class="'. esc_attr($css_animation) .'">';
			$output.= do_shortcode( $content );			
			$output.= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_multiscroll_container', 'ozy_vc_multiscroll_container');
		
		vc_map( array(
			"name" => esc_attr("Multi Scroll Container", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_multiscroll_container",
			"as_parent" => array('only' => 'ozy_vc_multiscroll_wrapper'),
			"content_element" => true,
			"show_settings_on_create" => true,
			"is_container" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(						
				$add_css_animation
		   )
		   ,"js_view" => 'VcColumnView'
		) );
		
		class WPBakeryShortCode_Ozy_Vc_Multiscroll_container extends WPBakeryShortCodesContainer{}		
	}	
	
	/**
	* Multiscroll Wrapper
	*/
	if (!function_exists('ozy_vc_multiscroll_wrapper')) {
		function ozy_vc_multiscroll_wrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_multiscroll_wrapper', $atts);
			extract(shortcode_atts(array(
				'align' => 'left',
				'css_animation' => ''
			), $atts));
					
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$GLOBALS['OZY_MULTISCROLL_PANEL_ID'] = 1;
			
			$output = '<div class="ms-'. esc_attr($align) .' '. esc_attr($css_animation) .'">';
			$output.= do_shortcode( $content );			
			$output.= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_multiscroll_wrapper', 'ozy_vc_multiscroll_wrapper');
		
		vc_map( array(
			"name" => esc_attr("Multi Scroll Wrapper", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_multiscroll_wrapper",
			"as_child" => array('only' => 'ozy_vc_multiscroll_container'),
			"as_parent" => array('only' => 'ozy_vc_multiscroll_panel'),
			"content_element" => true,
			"show_settings_on_create" => true,
			"is_container" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Panel Align", "ozy-wedding-planner-essentials"),
					"param_name" => "align",
					"value" => array("left", "right"),
					"admin_label" => true,
				),							
				$add_css_animation
		   )
		   ,"js_view" => 'VcColumnView'
		) );
		
		class WPBakeryShortCode_Ozy_Vc_Multiscroll_wrapper extends WPBakeryShortCodesContainer{}		
	}
	
	/**
	* Multiscroll Panel
	*/
	if (!function_exists('ozy_vc_multiscroll_panel')) {
		function ozy_vc_multiscroll_panel( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_multiscroll_panel', $atts);
			extract(shortcode_atts(array(
				'hide_on_mobile' => 'false',
				'caption' => '',
				'anchor_id' => '',
				'image' => '',
				'bg_color' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$bg_image = wp_get_attachment_image_src($image, 'full'); $style = '';
			if(isset($bg_image[0])) {
				$style.= 'background-image:url('. esc_url($bg_image[0]) .');';
			}
			if($bg_color) {
				$style.= 'background-color:'. esc_attr($bg_color) .';';
			}			
			$output = '<div data-id="'. esc_attr($GLOBALS['OZY_MULTISCROLL_PANEL_ID']) .'" class="ms-section hide-on-mobile-'. esc_attr($hide_on_mobile) .' '. $css_animation . '" style="'. $style .'" data-caption="'. esc_attr($caption) .'" '. ($anchor_id ? ' data-anchor="'. esc_attr($anchor_id) .'"' : '') .'><div class="content">' . PHP_EOL;
			$output.= do_shortcode($content);
			$output.= '</div></div>';
			
			$GLOBALS['OZY_MULTISCROLL_PANEL_ID'] = $GLOBALS['OZY_MULTISCROLL_PANEL_ID'] + 1;
			
			return $output;
		}

		add_shortcode( 'ozy_vc_multiscroll_panel', 'ozy_vc_multiscroll_panel' );
		
		vc_map( array(
			"name" => esc_attr__("Multi Scroll Panel", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_multiscroll_panel",
			"icon" => "icon-wpb-ozy-el",
			"as_child" => array('only' => 'ozy_vc_multiscroll_wrapper'),
			//"as_parent" => '',
			"class" => '',
			"controls" => "full",
			"category" => "by OZY",
			"content_element" => true,
			"is_container" => true,
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Hide On Mobile", "ozy-wedding-planner-essentials"),
					"param_name" => "hide_on_mobile",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => esc_attr("When selected, this panel will not be shown on if window width equal or less than 768px (tablet in portrait mode).", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"heading" => esc_attr("Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
				),array(
					"type" => "textfield",
					"heading" => esc_attr("Anchor ID", "ozy-wedding-planner-essentials"),
					"param_name" => "anchor_id",
					"admin_label" => true,
					"description" => esc_attr__("Fill this field if you like to use deep linking.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Background Color", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Background Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select a background image for your panel.", "ozy-wedding-planner-essentials")
				),$add_css_animation
		   )
		   ,"js_view" => 'VcColumnView'
		) );	
		
		class WPBakeryShortCode_Ozy_Vc_Multiscroll_panel extends WPBakeryShortCodesContainer{}	
	}
	
	/**
	* Multi Carousel
	*/
	if (!function_exists('ozy_vc_multi_carousel')) {
		function ozy_vc_multi_carousel( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_multi_carousel', $atts);
			extract(shortcode_atts(array(
				'autoplay'		=> 'true',
				'groupcells'	=> 'false',
				'navigation_dots'=> 'true',
				'navigation_arrows'=> 'false',
				'images_loaded' => 'true',
				'percent_position' => 'true',
				'show_see_all' => 'true',
				'contain'	=> 'true',
				'cell_align' => 'left',
				'item_count' => '4',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
					
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			wp_enqueue_script('wedding-planner-isotope');
			wp_enqueue_script('wedding-planner-isotope-packery');

			$GLOBALS['OZY_CAROUSEL_ITEM_TYPE'] = 'multi';
			
			$output = '<div class="flickity-carousel-wrapper wpb_content_element"><div class="carousel flickity-carousel item-count-'. esc_attr($item_count) .'" data-flickity=\'{ "imagesLoaded": '. esc_attr($images_loaded) .', "percentPosition": '. esc_attr($percent_position) .', "pageDots": '. esc_attr($navigation_dots) .', "prevNextButtons": '. esc_attr($navigation_arrows) .', "groupCells": '. esc_attr($groupcells) .', "contain" : '. esc_attr($contain) .', "cellAlign": "'. esc_attr($cell_align) .'", "adaptiveHeight": false, "setGallerySize": true, "autoPlay": '. esc_attr($autoplay) .' }\'>';
			$output.= do_shortcode( $content );			
			$output.= '</div>';
			if($show_see_all == 'true') $output.= '<a href="#see-all" class="flickity-see-all" data-label="'. esc_html('SLIDER', 'ozy-wedding-planner-essentials') .'">' . esc_html('SEE ALL', 'ozy-wedding-planner-essentials') . '</a>';
			$output.= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_multi_carousel', 'ozy_vc_multi_carousel');
		
		vc_map( array(
			"name" => esc_attr("Multi Carousel", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_multi_carousel",
			"as_parent" => array('only' => 'ozy_vc_carousel_item,ozy_vc_carousel_variable_item'),
			"content_element" => true,
			"show_settings_on_create" => true,
			"is_container" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(			
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Auto Play", "ozy-wedding-planner-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => esc_attr("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-wedding-planner-essentials")
				),		
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Cell Group", "ozy-wedding-planner-essentials"),
					"param_name" => "groupcells",
					"value" => array("false", "true", "2", "3", "4", "5", "6"),
					"admin_label" => true,
					"description" => esc_attr("This variable allows you to set the maximum amount of items displayed at a time with the widest browser width.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Images Loaded", "ozy-wedding-planner-essentials"),
					"param_name" => "imagesLoaded",
					"value" => array("true", "false"),
					"description" => esc_attr("Set it true if you want to use Variant Sized Item.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Percent Position", "ozy-wedding-planner-essentials"),
					"param_name" => "percent_position",
					"value" => array("true", "false"),
					"description" => esc_attr("Set it false if you want to use Variant Sized Item.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Contain", "ozy-wedding-planner-essentials"),
					"param_name" => "contain",
					"value" => array("true", "false"),
					"description" => esc_attr("Contains cells to carousel element to prevent excess scroll at beginning or end.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Cell Align", "ozy-wedding-planner-essentials"),
					"param_name" => "cell_align",
					"value" => array("left", "center", "right"),
					"description" => esc_attr("Align cells within the carousel element.", "ozy-wedding-planner-essentials")
				),				
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Show See All Button", "ozy-wedding-planner-essentials"),
					"param_name" => "show_see_all",
					"value" => array("true", "false")
				),				
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Visible Item Count", "ozy-wedding-planner-essentials"),
					"param_name" => "item_count",
					"value" => array("4", "2", "3"),
					"admin_label" => true,
					"description" => esc_attr("Choose how many items will be visible on the carousel at once.", "ozy-wedding-planner-essentials")
				),				
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Show Dots", "ozy-wedding-planner-essentials"),
					"param_name" => "navigation_dots",
					"value" => array("true", "false"),
					"description" => esc_attr("Show navigation dots on this carousel.", "ozy-wedding-planner-essentials")
				),				
				array(
					"type" => 'dropdown',
					"heading" => esc_attr("Show Arrows", "ozy-wedding-planner-essentials"),
					"param_name" => "navigation_arrows",
					"value" => array("false", "true"),
					"description" => esc_attr("Show navigation arrows on this carousel.", "ozy-wedding-planner-essentials")
				),
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		   ,"js_view" => 'VcColumnView'
		) );
		
		class WPBakeryShortCode_Ozy_Vc_Multi_Carousel extends WPBakeryShortCodesContainer{}		
	}	
	
	/**
	* Regular Carousel
	*/
	if (!function_exists('ozy_vc_regular_carousel')) {
		function ozy_vc_regular_carousel( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_regular_carousel', $atts);
			extract(shortcode_atts(array(
				'autoplay'		=> 'true',
				'groupcells'	=> 'false',
				'navigation_dots'=> 'true',
				'navigation_arrows'=> 'false',
				'item_count' => '1',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
					
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			wp_enqueue_script('wedding-planner-isotope');
			wp_enqueue_script('wedding-planner-isotope-packery');
			
			$GLOBALS['OZY_CAROUSEL_ITEM_TYPE'] = 'single';
			
			$output = '<div class="carousel single wpb_content_element flickity-carousel '. esc_attr($extra_css) .' item-count-'. esc_attr($item_count) .'" data-flickity=\'{ "pageDots": '. esc_attr($navigation_dots) .', "prevNextButtons": '. esc_attr($navigation_arrows) .', "groupCells": '. esc_attr($groupcells) .', "contain" : true, "cellAlign": "left", "adaptiveHeight": false, "imagesLoaded": true, "setGallerySize": true, "autoPlay": '. esc_attr($autoplay) .' }\'>';
			$output.= do_shortcode( $content );			
			$output.= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_regular_carousel', 'ozy_vc_regular_carousel');
		
		vc_map( array(
			"name" => esc_attr("Regular Carousel", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_regular_carousel",
			"as_parent" => array('only' => 'ozy_vc_carousel_item,ozy_vc_testimonial_carousel_item'),
			"content_element" => true,
			"show_settings_on_create" => true,
			"is_container" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(			
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Auto Play", "ozy-wedding-planner-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => esc_attr("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-wedding-planner-essentials")
				),		
				array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Show Dots", "ozy-wedding-planner-essentials"),
					"param_name" => "navigation_dots",
					"value" => array("true", "false"),
					"description" => esc_attr__("Show navigation dots on this carousel.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Show Arrows", "ozy-wedding-planner-essentials"),
					"param_name" => "navigation_arrows",
					"value" => array("false", "true"),
					"description" => esc_attr__("Show navigation arrows on this carousel.", "ozy-wedding-planner-essentials")
				),
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		   ,"js_view" => 'VcColumnView'
		) );
		
		class WPBakeryShortCode_Ozy_Vc_Regular_Carousel extends WPBakeryShortCodesContainer{}		
	}	
	
	/**
	* Carousel Item
	*/
	if (!function_exists('ozy_vc_carousel_item')) {
		function ozy_vc_carousel_item( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_carousel_item', $atts);
			extract(shortcode_atts(array(
				'image' => '',
				'title' => '',
				'link' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$member_image = wp_get_attachment_image_src($image, 'full'); $img_opacity = '' ;
			
			if(!isset($member_image[0])) return '';
			
			if($GLOBALS['OZY_CAROUSEL_ITEM_TYPE'] == 'single') {
				$output = PHP_EOL . '<div class="ozy-caroseul_item carousel-cell '. $css_animation . '" style="background:url('. esc_url($member_image[0]) .');">' . PHP_EOL;
			}else{
				$output = PHP_EOL . '<div class="ozy-caroseul_item carousel-cell '. $css_animation . '">' . PHP_EOL;
			}

			$output.= '<a';
			$link = vc_build_link($link);
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$output.= ' href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']) .'"' : '');
			}
			
			//if(isset($member_image[0])) {
				$output.= '><img src="'. $member_image[0] .'" alt="'. esc_attr($title) .'">';
			//}
			//if($GLOBALS['OZY_CAROUSEL_ITEM_TYPE'] != 'single') {				
				$output.= esc_attr($title) ? '<strong class="'. $GLOBALS['OZY_CAROUSEL_ITEM_TYPE'] .'">'. esc_attr($title) .'</strong>' : '';
			//}			
			$output.= '</a>';
			$output.= '</div>';
			
			return $output;
		}

		add_shortcode( 'ozy_vc_carousel_item', 'ozy_vc_carousel_item' );
		
		vc_map( array(
			"name" => esc_attr__("Carousel Item", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_carousel_item",
			"icon" => "icon-wpb-ozy-el",
			"as_child" => array('only' => 'ozy_vc_regular_carousel, ozy_vc_multi_carousel'),
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select an image for your item.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Title for your carousel item.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),$add_css_animation
		   )
		) );	
		
		class WPBakeryShortCode_Ozy_Vc_Carousel_Item extends WPBakeryShortCode{}	
	}
	
	/**
	* Variable Size Item
	*/
	if (!function_exists('ozy_vc_carousel_variable_item')) {
		function ozy_vc_carousel_variable_item( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_carousel_variable_item', $atts);
			extract(shortcode_atts(array(
				'image' => '',
				'title' => '',
				'link' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$member_image = wp_get_attachment_image_src($image, 'full'); $img_opacity = '' ;
			
			if(!isset($member_image[0])) return '';
			
			$output = PHP_EOL . '<div class="ozy-caroseul_item carousel-cell variable '. $css_animation . '">' . PHP_EOL;

			$output.= '<a';
			$link = vc_build_link($link);
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$output.= ' href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']) .'"' : '');
			}
			
			$output.= '><img src="'. $member_image[0] .'" alt="'. esc_attr($title) .'">';

			$output.= esc_attr($title) ? '<strong class="'. $GLOBALS['OZY_CAROUSEL_ITEM_TYPE'] .' single">'. esc_attr($title) .'</strong>' : '';

			$output.= '</a>';
			$output.= '</div>';
			
			return $output;
		}

		add_shortcode( 'ozy_vc_carousel_variable_item', 'ozy_vc_carousel_variable_item' );
		
		vc_map( array(
			"name" => esc_attr__("Variable Size Item", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_carousel_variable_item",
			"icon" => "icon-wpb-ozy-el",
			"as_child" => array('only' => 'ozy_vc_multi_carousel'),
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select an image for your item.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Title for your carousel item.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),$add_css_animation
		   )
		) );	
		
		class WPBakeryShortCode_Ozy_Vc_Carousel_Variable_Item extends WPBakeryShortCode{}	
	}	
	
	/**
	* Testimonial Carousel Item
	*/
	if (!function_exists('ozy_vc_testimonial_carousel_item')) {
		function ozy_vc_testimonial_carousel_item( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_testimonial_carousel_item', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'excerpt' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$output = PHP_EOL . '<div class="ozy-caroseul_item testimonial carousel-cell '. $css_animation . '">' . PHP_EOL;			
			$output .= '<div class="testimonial">' . PHP_EOL;
			$output .= '<p class="testimonial-quote heading-font">'. esc_attr($excerpt) .'</p>' . PHP_EOL;
			$output .= '<span class="testimonial-author content-color heading-font">'. esc_attr($title) .'</span>' . PHP_EOL;
			$output .= '</div>' . PHP_EOL;
			$output .= '</div>' . PHP_EOL;
			
			return $output;
		}

		add_shortcode( 'ozy_vc_testimonial_carousel_item', 'ozy_vc_testimonial_carousel_item' );
		
		vc_map( array(
			"name" => esc_attr__("Testimonial Carousel Item", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_testimonial_carousel_item",
			"icon" => "icon-wpb-ozy-el",
			"as_child" => array('only' => 'ozy_vc_regular_carousel, ozy_vc_multi_carousel'),
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				/*array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select an image for your item.", "ozy-wedding-planner-essentials")
				),*/array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Title for your carousel item.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => esc_attr__("Excerpt", "ozy-wedding-planner-essentials"),
					"param_name" => "excerpt",
					"admin_label" => true,
					"value" => ""
				),$add_css_animation
		   )
		) );	
		
		class WPBakeryShortCode_Ozy_Vc_Testimonial_Carousel_Item extends WPBakeryShortCode{}	
	}	
	
	/**
	* Expandable Call Box
	*/
	if (!function_exists('ozy_vc_callboxwrapper')) {
		function ozy_vc_callboxwrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_callboxwrapper', $atts);
			extract(shortcode_atts(array(
				'title' => ''
			), $atts));

			$GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER'] = 1;
			
			$output = '<section class="strips">'. do_shortcode($content) .'<i class="strip__close">X</i></section>';
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;

			if($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER'] >= 1){
				$box_count = $GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER'] - 1; $css_output = '';
				for($i = 2; $i <= $box_count; $i++) {
					//$css_output.= '.strips__strip:nth-child('. esc_attr($i) .') {left: '. ((100 / $box_count) * ($i-1)) .'vw;}';
					$css_output.= '.strips__strip:nth-child('. esc_attr($i) .') {left: '. ((100 / $box_count) * ($i-1)) .'%;}';
				}
				//$css_output.= '.strips__strip{width:calc('. (100 / $box_count) .'% + 6px);}';
				$css_output.= '.strips__strip{width:'. (100 / $box_count) .'%;}';
				$ozyWeddingPlannerHelper->set_footer_style('@media only screen and (min-width: 769px) {' . $css_output . '}');
			}
			
			unset($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']);
			
			return $output;
		}
		
		add_shortcode('ozy_vc_callboxwrapper', 'ozy_vc_callboxwrapper');
		
		vc_map( array(
			"name" => esc_attr__("Expandable Call Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_callboxwrapper",
			"as_parent" => array('only' => 'ozy_vc_expandablecallbox'),
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"value" => "Enter an identifier name for your wrapper.",
					"description" => esc_attr__("PLEASE NOTE: Maximum 5 elements will be used to show, after 5 entry rest will be ignored for each wrapper.", "ozy-wedding-planner-essentials"),
					"admin_label" => true
				)
		   ),
		   "js_view" => 'VcColumnView'
		) );
		
		class WPBakeryShortCode_Ozy_Vc_Callboxwrapper extends WPBakeryShortCodesContainer{}		
	}	

	if (!function_exists('ozy_vc_expandablecallbox')) {
		function ozy_vc_expandablecallbox( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_expandablecallbox', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'image_large' => '',
				'title_color' => '#fff',
				'fn_color' => '#fff',
				'bg_color' => '#000',
				'css_animation' => ''
			), $atts));
			
			if($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER'] > 5) return ''; //don't render more than 5 object
			
			wp_enqueue_script('wedding-planner-expandable-callbox');
			wp_enqueue_style('wedding-planner-expandable-callbox');
						
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$large_image = ''; $rand_elm_id = 'ozy-exp-box-' . rand(1, 10000);

			$image_large = wp_get_attachment_image_src($image_large, 'full');
			if(isset($image_large[0])) { $large_image = esc_url($image_large[0]); }		

			$output = 
			'<article class="strips__strip" id='. esc_attr($rand_elm_id) .'>
				<div class="strip__content">
				  <h2 class="strip__title" data-name="'. esc_html($title) .'">'. esc_html($title) .'</h2>
				  <div class="strip__inner-text">
					<h2 data-color="'. esc_attr($fn_color) .'">'. esc_html($title) .'</h2>
					<p>'. do_shortcode($content) .'</p>
				  </div>
				<div class="bg" style="background-image:url('. esc_url($large_image) .');"></div><div class="color-overlay"></div></div>
			  </article>';

			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_elm_id.strips__strip:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content{background-color:". esc_attr($bg_color) .";color:". esc_attr($fn_color) .";}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_elm_id.strips__strip.strips__strip--expanded:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h1,#$rand_elm_id.strips__strip.strips__strip--expanded:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h2,#$rand_elm_id.strips__strip.strips__strip--expanded:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h3,#$rand_elm_id.strips__strip.strips__strip--expanded:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h4,#$rand_elm_id.strips__strip.strips__strip--expanded:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h5,#$rand_elm_id.strips__strip.strips__strip--expanded:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h6{color:". esc_attr($fn_color) .";}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_elm_id.strips__strip:nth-child(". esc_attr($GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER']) .") .strip__content h2{color:". esc_attr($title_color) .";}");				
			
			$GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER'] = $GLOBALS['OZY_WEDDING_PLANNER_CALLBOXCOUNTER'] + 1;
			
			return $output;
		}
		
		add_shortcode( 'ozy_vc_expandablecallbox', 'ozy_vc_expandablecallbox' );
		
		vc_map( array(
			"name" => esc_attr__("Expandable Call Box Content", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_expandablecallbox",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_callboxwrapper'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Background Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image_large",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Title Color", "ozy-wedding-planner-essentials"),
					"param_name" => "title_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Foreground Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Background Color", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#000000"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textarea_html",
					"class" => "",
					"heading" => esc_attr__("Content", "ozy-wedding-planner-essentials"),
					"param_name" => "content",
					"admin_label" => false,
					"description" => esc_attr__("This field is not required. Fill only when you need multiple columns on your row", "ozy-wedding-planner-essentials"),
					"value" => ""
				),$add_css_animation
		   )
		) );	
	}

	class WPBakeryShortCode_Ozy_Vc_Expandablecallbox extends WPBakeryShortCode{}		
	
	/**
	* Price Table
	*/
	if (!function_exists('ozy_vc_price_table')) {
		function ozy_vc_price_table( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_price_table', $atts);
			extract(shortcode_atts(array(
				'title'			=> '',
				'price'			=> '',
				'extra_css'		=> '',
				'box_heading'	=> '',
				'font_size'		=> '',
				'text_align'	=> '',
				'price_font_size' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}		
			
			$inline_style = ''; $price_label_inline_style = '';
			if(trim($font_size) != '100%' && trim($font_size) != '') {
				$inline_style.= 'font-size:' . esc_attr($font_size);
			}
			if(trim($text_align) != 'center' && trim($text_align) != '') {
				$inline_style.= ';text-align:' . esc_attr($text_align) . ';padding-left:40px;padding-right:40px;';
			}
			if(trim($price_font_size) != '45px' && trim($price_font_size) != '') {
				$price_label_inline_style.= ';font-size:' . esc_attr($price_font_size) . ';line-height:'. esc_attr(((int)$price_font_size)+20) .'px;';
			}
			$output = '<div class="ozy-price-table ozy-border-color '. $css_animation .'">';
			$output .= '<'. esc_attr($box_heading) .' class="ozy-border-color">'. esc_attr($title) .'</'. esc_attr($box_heading) .'>';
			$output .= '<div '. ($inline_style ? 'style="'. $inline_style .'"' : '') .'>'. do_shortcode($content) .'</div>';
			$output .= '<span class="ozy-border-color heading-font" '. ($price_label_inline_style ? 'style="'. $price_label_inline_style .'"' : '') .'>'. esc_attr($price) .'</span>';
			$output .= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_price_table', 'ozy_vc_price_table');
		
		vc_map( array(
			"name" => esc_attr__("Price Table", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_price_table",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("TITLE GOES HERE", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true
				),
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_attr__("Content", "ozy-wedding-planner-essentials"),
					"param_name" => "content"
				),				
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Price", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("$ 100", "ozy-wedding-planner-essentials"),
					"param_name" => "price",
					"admin_label" => true
				),				
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => esc_attr__("Box Heading Size", "ozy-wedding-planner-essentials"),
					"param_name" => "box_heading",
					"value" => array("h3", "h1", "h2", "h4", "h5", "h6"),
					"admin_label" => false,
					"group" => esc_attr("Styling", "ozy-wedding-planner-essentials")
				),					
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Font Size", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("100%", "ozy-wedding-planner-essentials"),
					"param_name" => "font_size",
					"admin_label" => false,
					"group" => esc_attr("Styling", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => esc_attr__("Text Align", "ozy-wedding-planner-essentials"),
					"param_name" => "text_align",
					"value" => array("center", "left", "right"),
					"admin_label" => false,
					"group" => esc_attr("Styling", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Price Font Size", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("45px", "ozy-wedding-planner-essentials"),
					"param_name" => "price_font_size",
					"admin_label" => false,
					"description" => esc_attr__("Please only use px values.", "ozy-wedding-planner-essentials"),
					"group" => esc_attr("Styling", "ozy-wedding-planner-essentials")
				),				
		   )
		) );
	}	
	
	/**
	* Call To Action With Image
	*/
	if (!function_exists('ozy_vc_calltoactionwimage')) {
		function ozy_vc_calltoactionwimage( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_calltoactionwimage', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'title'			=> '',
				'subtitle' 		=> '',
				'text_align'	=> '',
				'fn_color'		=> '#ffffff',
				'fn_color_sub'	=> '#c09e6f',
				'hover_overlay'	=> 'yes',
				'link'			=> '',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	
			
			$rand_id = "callbox-with-image-" . rand(1,10000);

			$image = wp_get_attachment_image_src($image, 'full'); $style = '';
			if(isset($image[0])) {
				$style = ' style="background-image:url('. esc_url($image[0]) .')" alt="' . esc_attr($title) . '" ';
			}			
			$output ='<div id="'. esc_attr($rand_id) .'" class="callbox-with-image overlay-'. esc_attr($hover_overlay) .' '. $css_animation .'">';
			$output.= '<div class="background-image" '. $style .'></div><a ';
			$link = vc_build_link($link);			
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$output.= 'href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']) .'"' : '');
			}
			$output.='>';
			$output.='<div class="'. esc_attr($text_align) .'"><h2>'. esc_html($title) .'</h2><span class="title content-font">'. esc_html($subtitle) .'</span></div></a></div>';
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id h2, #$rand_id span.title{color:". esc_attr($fn_color) ."}");
			
			return $output;
		}
		
		add_shortcode('ozy_vc_calltoactionwimage', 'ozy_vc_calltoactionwimage');
		
		vc_map( array(
			"name" => esc_attr__("Call to Action With Image", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_calltoactionwimage",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("Title Goes Here", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Subtitle", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("Subtitle Goes Here", "ozy-wedding-planner-essentials"),
					"param_name" => "subtitle",
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => esc_attr__("Text Align", "ozy-wedding-planner-essentials"),
					"param_name" => "text_align",
					"value" => array("center", "left", "right"),
					"admin_label" => false
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Foreground Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "dropdown",
					"heading" => esc_attr__("Hover Overlay", "ozy-wedding-planner-essentials"),
					"param_name" => "hover_overlay",
					"value" => array("yes", "no"),
					"admin_label" => false
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		) );
	}	
	
	/**
	* Fancy Hover Image Box
	*/
	if (!function_exists('ozy_vc_fancyhoverimagebox')) {
		function ozy_vc_fancyhoverimagebox( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_fancyhoverimagebox', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'title'			=> '',
				'size'			=> 'h2',
				'subtitle' 		=> '',
				'fn_color'		=> '#ffffff',
				'fn_color_sub'	=> '#c09e6f',
				'link'			=> '',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	
			
			$rand_id = "fancy-hover-box-" . rand(1,10000);

			$output ='<div id="'. esc_attr($rand_id) .'" class="fancy-hover-box '. $css_animation .'"><a ';
			$link = vc_build_link($link);			
			if(is_array($link) && isset($link['url']) && $link['url']) {
				$output.= 'href="'. esc_url($link['url']) .'" '. (isset($link['target']) ? ' target="'. esc_attr($link['target']) .'"' : '');
			}
			$output.='>';
			$image = wp_get_attachment_image_src($image, 'full');
			if(isset($image[0])) {
				$output.= '<img src="'. esc_url($image[0]) .'" alt="' . esc_attr($title) . '"/>';
			}
			$output.='<span class="name heading-font '. esc_attr($size) .'-size">'. esc_html($title) .'<span class="title content-font">'. esc_html($subtitle) .'</span></span></a></div>';
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id span{color:". esc_attr($fn_color) ."}");
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id span.title{color:". esc_attr($fn_color_sub) ."}");
			
			return $output;
		}
		
		add_shortcode('ozy_vc_fancyhoverimagebox', 'ozy_vc_fancyhoverimagebox');
		
		vc_map( array(
			"name" => esc_attr__("Fancy Hover Image Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_fancyhoverimagebox",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("Title Goes Here", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => esc_attr__("Heading Style", "ozy-wedding-planner-essentials"),
					"param_name" => "size",
					"value" => array("h2", "h1", "h3", "h4", "h5", "h6"),
					"admin_label" => false,
					"description" => esc_attr__("Title heading style.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Subtitle", "ozy-wedding-planner-essentials"),
					"value" => esc_attr__("Subtitle Goes Here", "ozy-wedding-planner-essentials"),
					"param_name" => "subtitle",
					"admin_label" => true
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Foreground Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Subtitle Foreground Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fn_color_sub",
					"admin_label" => false,
					"value" => "#c09e6f"
				),array(
					"type" => "vc_link",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => ""
				),
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		) );
	}	
	
	/**
	* Title with Icon Content
	*/
	if(!function_exists('ozy_vc_title_with_icon')) {
		function ozy_vc_title_with_icon( $atts, $content=null ) {
            $atts = vc_map_get_attributes('ozy_vc_title_with_icon', $atts);
			extract( shortcode_atts( array(
				  'icon' => '',
				  'icon_size' => 'medium',
				  'icon_position' => 'left',
				  'size' => 'h1',
				  'title' => '',
				  'icon_type' => '',
				  'icon_color' => '',
				  'text_color' => '',
				  'icon_bg_color' => 'transparent',
				  'icon_shadow_color' => '',
				  'go_link' => '',
				  'go_target' => '_self',
				  'connected' => 'no',
				  'dot_bg_color' => 'transparent'
				), $atts ) 
			);
			
			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$element_id = 'tile-with-icon_icon' . rand(100,10000);
			$a_begin = $a_end = $add_style = "";
			if(trim($go_link) !== '') {
				$a_begin = '<a href="' . esc_attr($go_link) . '" '. ($go_target=='fancybox' || $go_target=='fancybox-media' ? 'class':'target') .'="' . esc_attr($go_target) . '" style="'. ($text_color ? 'color:' . esc_attr($text_color) : '') .'">';
				$a_end   = '</a>';
			}

			if($icon_type === 'circle') {
				$icon_bg_color = 'transparent';
				$add_style = 'border-color:'. esc_attr($icon_color) .';';
			}
			
			if($title == '' && $content != '') {
				$title = wpb_js_remove_wpautop(do_shortcode($content));
				$content = '';
				$size = 'span';
			}
			
			$o_icon = ($icon ? $a_begin . '<span ' . ($icon_color ? ' style="'. $add_style .'color:'. esc_attr($icon_color) .' !important;background-color:'. esc_attr($icon_bg_color) .' !important;"' : '') . ' class="' . esc_attr($icon) . ' ' . esc_attr($icon_type) . ' ' . esc_attr($icon_size) . ' ' . '" '. (esc_attr($icon_shadow_color) ? 'data-color="'. esc_attr($icon_shadow_color) .'"':'') .'></span>' . $a_end : '');
			
			return '<div id="'. $element_id .'" class="title-with-icon-wrapper '. esc_attr($icon_type) . ' ' . esc_attr($icon_size) .' '. (esc_attr($connected) === 'yes' ? 'connected' : '') .'" data-color="'. esc_attr($dot_bg_color) .'">
			<div class="wpb_content_element title-with-icon clearfix ' . (trim($content) !== '' ? 'margin-bottom-0 ' : '') . ($icon_position !== 'left' ? esc_attr($icon_position).'-style' : '') . '">' . ($icon_position !== 'right' ? $o_icon:'') . 
			'<' . $size . (!$text_color ? (!$icon ? ' class="no-icon content-color"' : ' class="content-color"'):'') . ' style="'. ($text_color ? 'color:' . esc_attr($text_color) : '') .'">' . $a_begin . $title . $a_end . '</' . $size . '>' . ($icon_position === 'right' ? $o_icon:'') .'
			</div>' . (trim($content) !== '' && trim($title) !== '' ? '<div class="wpb_content_element '. esc_attr($icon_position) .'-cs title-with-icon-content '. esc_attr($icon_size) .' clearfix" style="'. (esc_attr($text_color) ? 'color:' . esc_attr($text_color) : '') .'">' 
			. wpb_js_remove_wpautop(do_shortcode($content)) . '</div>' : '') . '</div>';
		}
		
		add_shortcode( 'ozy_vc_title_with_icon', 'ozy_vc_title_with_icon' );
		
		vc_map( array(
			"name" => esc_attr__("Title With Icon", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_title_with_icon",
			"class" => "",
			"controls" => "full",
			'category' => 'by OZY',
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
			  array(
				"type" => "select_an_icon",
				"heading" => esc_attr__("Icon", "ozy-wedding-planner-essentials"),
				"param_name" => "icon",
				"value" => '',
				"admin_label" => false,
				"description" => esc_attr__("Title heading style.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => esc_attr__("Icon Size", "ozy-wedding-planner-essentials"),
				"param_name" => "icon_size",
				"value" => array(esc_attr__("medium", "ozy-wedding-planner-essentials") => "medium", esc_attr__("large", "ozy-wedding-planner-essentials") => "large", esc_attr__("xlarge", "ozy-wedding-planner-essentials") => "xlarge", esc_attr__("xxlarge", "ozy-wedding-planner-essentials") => "xxlarge", esc_attr__("xxxlarge", "ozy-wedding-planner-essentials") => "xxxlarge"),
				"admin_label" => false,
				"description" => esc_attr__("Size of the Icon.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => esc_attr__("Icon Position", "ozy-wedding-planner-essentials"),
				"param_name" => "icon_position",
				"value" => array(esc_attr__("left", "ozy-wedding-planner-essentials") => "left", esc_attr__("right", "ozy-wedding-planner-essentials") => "right", esc_attr__("top", "ozy-wedding-planner-essentials") => "top"),
				"admin_label" => false,
				"description" => esc_attr__("Position of the Icon.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => esc_attr__("Icon Alternative Color", "ozy-wedding-planner-essentials"),
				"param_name" => "icon_color",
				"value" => "",
				"admin_label" => false,
				"description" => esc_attr__("This field is not required.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => esc_attr__("Icon Background Type", "ozy-wedding-planner-essentials"),
				"param_name" => "icon_type",
				"value" => array(esc_attr__("rectangle", "ozy-wedding-planner-essentials") => "rectangle", esc_attr__("rounded", "ozy-wedding-planner-essentials") => "rounded", esc_attr__("circle", "ozy-wedding-planner-essentials") => "circle", esc_attr__("clear", "ozy-wedding-planner-essentials") => "clear"),
				"admin_label" => false,
				"description" => esc_attr__("Position of the Icon.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => esc_attr__("Icon Background Color", "ozy-wedding-planner-essentials"),
				"param_name" => "icon_bg_color",
				"value" => "",
				"admin_label" => false,
				"description" => esc_attr__("Background color of Icon.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => esc_attr__("Icon Shadow Color", "ozy-wedding-planner-essentials"),
				"param_name" => "icon_shadow_color",
				"value" => "",
				"admin_label" => false,
				"description" => esc_attr__("Shadow color of Icon.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => esc_attr__("Heading Style", "ozy-wedding-planner-essentials"),
				"param_name" => "size",
				"value" => array("h1", "h2", "h3", "h4", "h5", "h6"),
				"admin_label" => false,
				"description" => esc_attr__("Title heading style.", "ozy-wedding-planner-essentials")
			  ),array(
				 "type" => "textfield",
				 "class" => "",
				 "heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
				 "param_name" => "go_link",
				 "admin_label" => true,
				 "value" => "",
				 "description" => esc_attr__("Enter full path.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => esc_attr__("Link Target", "ozy-wedding-planner-essentials"),
				"param_name" => "go_target",
				"value" => array("_self", "_blank", "_parent", "fancybox", "fancybox-media"),
				"admin_label" => false,
				"description" => esc_attr__("Select link target window. fancybox will launch an lightbox window for images, and fancybox-media will launch a lightbox window for frames/video.", "ozy-wedding-planner-essentials")
			  ),array(
				 "type" => "textfield",
				 "class" => "",
				 "heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
				 "param_name" => "title",
				 "admin_label" => true,
				 "value" => esc_attr__("Enter your title here", "ozy-wedding-planner-essentials"),
				 "description" => esc_attr__("Content of the title.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => esc_attr__("Font Color", "ozy-wedding-planner-essentials"),
				"param_name" => "text_color",
				"value" => "",
				"admin_label" => false,
				"description" => esc_attr__("This option will affect Title and Content color.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => esc_attr__("Connected", "ozy-wedding-planner-essentials"),
				"param_name" => "connected",
				"value" => array("no", "yes"),
				"admin_label" => false,
				"description" => esc_attr__("Select yes to connect elements to next one with a dashed border.", "ozy-wedding-planner-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => esc_attr__("Border Color", "ozy-wedding-planner-essentials"),
				"param_name" => "dot_bg_color",
				"value" => "",
				"admin_label" => false,
				"dependency" => Array('element' => "connected", 'value' => 'yes')
			  ),array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_attr__("Content", "ozy-wedding-planner-essentials"),
				"param_name" => "content",
				"value" => "",
				"description" => esc_attr__("Type your content here.", "ozy-wedding-planner-essentials")
			  )
		   )
		) );
	}

	/**
	* Vertical Divider
	*/
	if (!function_exists('ozy_vc_vertical_divider')) {
		function ozy_vc_vertical_divider( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_vertical_divider', $atts);
			extract(shortcode_atts(array(
				'caption_size' => 'h2',
				'border_height' => '80px',
				'caption' 		=> '',
				'caption_color' => '#000000',
				'border_size' => '1',
				'css_animation' => ''
				), $atts ) 
			);
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$rand_id = 'ovd-' . rand(10, 100000);
			
			$output = '<div id="'. esc_attr($rand_id) .'" class="ozy-vertical_divider wpb_content_element"><span class="'. esc_attr($caption_size) .'-size heading-font">'. esc_attr($caption) .'</span></div>';

			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {padding:". esc_attr($border_height) ." 0;color:". esc_attr($caption_color) ."}");			
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id>span:before,#$rand_id>span:after{height:". esc_attr($border_height) .";width:". esc_attr($border_size) ."px;}");
			
			return $output;
		}

		add_shortcode('ozy_vc_vertical_divider', 'ozy_vc_vertical_divider');

		vc_map( array(
		   "name" => esc_attr__("Vertical Divider", "ozy-wedding-planner-essentials"),
		   "base" => "ozy_vc_vertical_divider",
		   "class" => "",
		   "controls" => "full",
		   'category' => 'by OZY',
		   "icon" => "icon-wpb-ozy-el",
		   "params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Caption Size", "ozy-wedding-planner-essentials"),
					"param_name" => "caption_size",
					"admin_label" => true,
					"value" => array("h2","h1","h3","h4","h5","h6")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Border Height", "ozy-wedding-planner-essentials"),
					"param_name" => "border_height",
					"admin_label" => true,
					"value" => "80px",
					"description" => esc_attr__("Height of divider lines.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => esc_attr__("Enter your caption here", "ozy-wedding-planner-essentials"),
					"description" => esc_attr__("Caption of the divider.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Color", "ozy-wedding-planner-essentials"),
					"param_name" => "caption_color",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Border Size", "ozy-wedding-planner-essentials"),
					"param_name" => "border_size",
					"admin_label" => true,
					"value" => array("1","2","3","4","5","6","7","8","9","10")
				),$add_css_animation	
			)
		) );
	}	
	
	/**
	* Divider
	*/
	if (!function_exists('ozy_vc_divider')) {
		function ozy_vc_divider( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_divider', $atts);
			extract(shortcode_atts(array(
				'caption_size' => 'h3',
				'caption' 		=> '',
				'caption_color' => '',
				'caption_align'	=> 'center',
				'caption_position' => '',
				'border_style'	=> 'solid',
				'border_size' => '1',
				'border_color' => '',
				'css_animation' => '',
				'more_custom' => 'off',
				'width' => '',
				'align' => 'center'
				), $atts ) 
			);
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$output = $more_custom_html = '';
			if(esc_attr($more_custom) == 'on' && esc_attr($width) && esc_attr($align)) {
				$more_custom_html = ';width:'. esc_attr($width) .';max-width:'. esc_attr($width) .';';
				switch(esc_attr($align)) {
					case 'center':
						$more_custom_html .= 'margin:20px auto;';
						break;
					case 'left':
						$more_custom_html .= 'left:0;';
						break;
					case 'right':
						$more_custom_html .= 'right:0;';
						break;						
					default:
						$more_custom_html .= 'margin:0 auto;';
				}
			}
			if('top' === esc_attr($caption_position)){
				$output = ( trim( esc_attr( $caption ) ) ? '<'. esc_attr($caption_size) .' class="ozy-divider-cap-' . esc_attr($caption_align) . ' wpb_content_element '. $css_animation .'" '. ($caption_color ? ' style="color:'. esc_attr($caption_color) .'" ':'') .'>' . esc_attr( $caption ) . '</'. esc_attr($caption_size) .'>' : '' );
				$output.= '<div class="ozy-content-divider '. $css_animation .'" style="border-top-style:'. esc_attr($border_style) . ';border-top-width:' . ('double' == esc_attr($border_style)?'3':esc_attr($border_size)) .'px' . ('' != esc_attr($border_color)?';border-top-color:'. esc_attr($border_color) .'!important':'') . $more_custom_html .'"></div>';
			}else{
				$output = '<fieldset class="ozy-content-divider '. $css_animation .' wpb_content_element" style="border-top-style:'. esc_attr($border_style) . ';border-top-width:' . ('double' == esc_attr($border_style)?'3':esc_attr($border_size)) .'px' . ('' != esc_attr($border_color)?';border-top-color:'. esc_attr($border_color) .'!important':'') . $more_custom_html .'">' . ( trim( esc_attr( $caption ) ) ? '<legend class="d' . esc_attr($caption_align) . '" align="' . esc_attr($caption_align) . '" '. ($caption_color ? ' style="color:'. esc_attr($caption_color) .'" ':'') .'>' . esc_attr( $caption ) . '</legend>' : '' ) . '</fieldset>';
			}
			return $output;
		}

		add_shortcode('ozy_vc_divider', 'ozy_vc_divider');

		vc_map( array(
		   "name" => esc_attr__("Separator With Caption", "ozy-wedding-planner-essentials"),
		   "base" => "ozy_vc_divider",
		   "class" => "",
		   "controls" => "full",
		   'category' => 'by OZY',
		   "icon" => "icon-wpb-ozy-el",
		   "params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Caption Size", "ozy-wedding-planner-essentials"),
					"param_name" => "caption_size",
					"admin_label" => true,
					"value" => array("h3","h1","h2","h4","h5","h6")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => esc_attr__("Enter your caption here", "ozy-wedding-planner-essentials"),
					"description" => esc_attr__("Caption of the divider.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Caption Color", "ozy-wedding-planner-essentials"),
					"param_name" => "caption_color",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Border Style", "ozy-wedding-planner-essentials"),
					"param_name" => "border_style",
					"admin_label" => true,
					"value" => array("solid","dotted","dashed","double")
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Border Size", "ozy-wedding-planner-essentials"),
					"param_name" => "border_size",
					"admin_label" => true,
					"value" => array("1","2","3","4","5","6","7","8","9","10")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_attr__("Border Color", "ozy-wedding-planner-essentials"),
					"param_name" => "border_color",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Caption Align", "ozy-wedding-planner-essentials"),
					"param_name" => "caption_align",
					"admin_label" => true,
					"value" => array("center", "left", "right"),
					"description" => esc_attr__("Caption align.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Caption Position", "ozy-wedding-planner-essentials"),
					"param_name" => "caption_position",
					"admin_label" => true,
					"value" => array("overlay", "top"),
					"description" => esc_attr__("Caption position.", "ozy-wedding-planner-essentials")
				),array(
					"type" => 'dropdown',
					"heading" => esc_attr__("More Customization", "ozy-wedding-planner-essentials"),
					"param_name" => "more_custom",
					"value" => array("off", "on"),
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Width", "ozy-wedding-planner-essentials"),
					"param_name" => "width",
					"admin_label" => true,
					"value" => "400px",
					"dependency" => Array('element' => "more_custom", 'value' => 'on')
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Align", "ozy-wedding-planner-essentials"),
					"param_name" => "align",
					"admin_label" => true,
					"value" => array("center", "left", "right"),
					"dependency" => Array('element' => "more_custom", 'value' => 'on')
				),$add_css_animation	
			)
		) );
	}
	
	/**
	* Typewriter
	*/
	if (!function_exists('ozy_vc_typewriter')) {
		function ozy_vc_typewriter( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_typewriter', $atts);
			extract(shortcode_atts(array(
				'title'	=> '',
				'typespeed'			=> '100',
				'startdelay'		=> '0',
				'backspeed'			=> '0',
				'backdelay' 		=> '1500',
				'loop'				=> 'true',
				'font_color'		=> '#fff',
				'font_size'			=> '4.2vw',
				'font_weight'		=> '700'
			), $atts));
						
			$rand_id = 'type_writer_data_' . rand(1, 1000000);
			$GLOBALS['OZY_TYPE_WRITER'] = array();
			
			do_shortcode($content);
			
			wp_localize_script( 'wedding_planner', 'ozyTypeWriterData', array($rand_id =>  json_encode($GLOBALS['OZY_TYPE_WRITER'])) );
			
			unset($GLOBALS['OZY_TYPE_WRITER']);

			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;
			$ozyWeddingPlannerHelper->set_footer_style("#$rand_id {color:". esc_attr($font_color) ." !important;font-size:". esc_attr($font_size) .";line-height:110%;font-weight:". esc_attr($font_weight) .";}");
			
			return '<div id="'. $rand_id .'" class="ozy-typing-box-wrapper heading-font">' . $title . '<span class="typing-box" 
			data-path="'. esc_attr($rand_id) .'" 
			data-typespeed="'. esc_attr($typespeed) .'" 
			data-startdelay="'. esc_attr($startdelay) .'" 
			data-backspeed="'. esc_attr($backspeed) .'" 
			data-backdelay="'. esc_attr($backdelay) .'" 
			data-loop="'. esc_attr($loop) .'"></span></div>';
		}
		
		add_shortcode('ozy_vc_typewriter', 'ozy_vc_typewriter');
	
		vc_map( array(
			"name" => esc_attr__("Typewriter", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_typewriter",
			"as_parent" => array('only' => 'ozy_vc_typewriter_line'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Static Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => ""
				),
				array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Font Color", "ozy-wedding-planner-essentials"),
					"param_name" => "font_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Font Size", "ozy-wedding-planner-essentials"),
					"param_name" => "font_size",
					"admin_label" => true,					
					"value" => "4.2vw"
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Font Weight", "ozy-wedding-planner-essentials"),
					"param_name" => "font_weight",
					"admin_label" => true,
					"value" => array("100", "200", "300", "400", "500", "600", "700", "800", "900")
				),					
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Type Speed", "ozy-wedding-planner-essentials"),
					"param_name" => "typespeed",
					"admin_label" => true,
					"description" => esc_attr__("Typing Speed", "ozy-wedding-planner-essentials"),
					"value" => "100"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Start Delay", "ozy-wedding-planner-essentials"),
					"param_name" => "startdelay",
					"admin_label" => true,
					"description" => esc_attr__("Time before typing starts", "ozy-wedding-planner-essentials"),
					"value" => "0"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Back Speed", "ozy-wedding-planner-essentials"),
					"param_name" => "backspeed",
					"admin_label" => true,
					"description" => esc_attr__("Backspacing speed", "ozy-wedding-planner-essentials"),
					"value" => "0"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Back Delay", "ozy-wedding-planner-essentials"),
					"param_name" => "backdelay",
					"admin_label" => true,
					"description" => esc_attr__("Time before backspacing", "ozy-wedding-planner-essentials"),
					"value" => "1500"
				),				
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Loop", "ozy-wedding-planner-essentials"),
					"param_name" => "loop",
					"admin_label" => true,
					"description" => esc_attr__("The whole typing is loop or not", "ozy-wedding-planner-essentials"),
					"value" => array("true", "false")
				)
				
		   ),
		   "js_view" => 'VcColumnView'		   
		) );
	}
	
	if (!function_exists('ozy_vc_typewriter_line')) {
		function ozy_vc_typewriter_line( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_typewriter_line', $atts);
			extract(shortcode_atts(array(
				'caption'		=> ''
			), $atts));
			
			$GLOBALS['OZY_TYPE_WRITER'][] = esc_attr($caption);
			
			return null;
		}
		
		add_shortcode('ozy_vc_typewriter_line', 'ozy_vc_typewriter_line');

		vc_map( array(
			"name" => esc_attr__("Line", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_typewriter_line",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_typewriter'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Typewriter Line", "ozy-wedding-planner-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"description" => esc_attr__('Add ^1000 between the words if you like add 1000ms delay to before the next word. Example: First ^1000 sentence.', 'ozy-wedding-planner-essentials'),
					"value" => ""
				)		
		   )
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Typewriter extends WPBakeryShortCodesContainer{}
	class WPBakeryShortCode_Ozy_Vc_Typewriter_Line extends WPBakeryShortCode{}		
	
	/**
	* Pretty Map
	*/
	if (!function_exists('ozy_vc_prettymap')) {
		function ozy_vc_prettymap( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_prettymap', $atts);
			extract(shortcode_atts(array(
				'address_'		=> 'Melbourne, Australia',
				'zoom'			=> '13',
				'custom_icon'	=> '',
				'hue'			=> '',//#ff0000
				'saturation'	=> '',//-30
				'lightness' 	=> '0',
				'height'		=> '350px',
				'extra_class_name' => '',
				'api_key'		=> ''
			), $atts));
			
			$custom_icon = wp_get_attachment_image_src($custom_icon, 'full');
			if(isset($custom_icon[0])) {
				$custom_icon = $custom_icon[0];
			}
			
			wp_enqueue_script('wedding-planner-googlemaps', '//maps.google.com/maps/api/js?'. ($api_key?'key=' . $api_key .'&':'') .'sensor=false&language=en', array('jquery'), null, true );
			//wp_enqueue_script('wedding-planner-googlemaps_infobox', '//cdn.rawgit.com/googlemaps/v3-utility-library/master/infobox/src/infobox_packed.js', array('jquery'), null, true );
			wp_enqueue_script('wedding-planner-googlemaps_infobox', get_template_directory_uri() . '/scripts/vendor/infobox_packed.js', array('jquery'), null, true );
			
			return '<div class="ozy-google-map '. esc_attr($extra_class_name) .'" 
			data-address="'. esc_attr($address_) .'" 
			data-zoom="'. esc_attr($zoom) .'" 
			data-hue="'. esc_attr($hue) .'" 
			data-saturation="'. esc_attr($saturation) .'" 
			data-lightness="'. esc_attr($lightness) .'" 
			data-height="'. esc_attr($height) .'" 
			data-icon="'. esc_url($custom_icon) .'" style="height:'. esc_attr($height) .'"></div><div class="gmap-infobox-wrapper"><div id="gmap-infobox" class="content-font">'. $content .'</div></div>';
		}
		
		add_shortcode('ozy_vc_prettymap', 'ozy_vc_prettymap');
		
		vc_map( array(
			"name" => esc_attr__("Custom Google Map", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_prettymap",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr("Google Maps API Key", "ozy-wedding-planner-essentials"),
					"param_name" => "api_key",
					"admin_label" => false,
					"value" => "",
					'description' => wp_kses(__('<a href="http://freevision.me/google-maps-key/" target="_blank">Learn how to get an API Key.</a>', 'ozy-wedding-planner-essentials'),array('a' => array('href' => array(), 'target' => array()))),					
				),				
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Height", "ozy-wedding-planner-essentials"),
					"param_name" => "height",
					"admin_label" => true,
					"value" => "350px"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Address", "ozy-wedding-planner-essentials"),
					"param_name" => "address_",
					"admin_label" => true,
					"value" => esc_attr__("Melbourne, Australia", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textarea",
					"class" => "",
					"heading" => esc_attr__("Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "content",
					"admin_label" => true,
					"value" => esc_attr__("Caption", "ozy-wedding-planner-essentials")
				),				
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Zoom Level", "ozy-wedding-planner-essentials"),
					"param_name" => "zoom",
					"admin_label" => true,
					"value" => "13"
				),			
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Custom Icon", "ozy-wedding-planner-essentials"),
					"param_name" => "custom_icon",
					"description" => esc_attr__("You can select a custom icon for your pin on the map", "ozy-wedding-planner-essentials"),
					"admin_label" => false,
					"value" => ""
				),
				array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Hue Color", "ozy-wedding-planner-essentials"),
					"param_name" => "hue",
					"admin_label" => false,
					"value" => "#FF0000"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Saturation", "ozy-wedding-planner-essentials"),
					"param_name" => "saturation",
					"admin_label" => true,
					"value" => "-30"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Lightness", "ozy-wedding-planner-essentials"),
					"param_name" => "lightness",
					"admin_label" => true,
					"value" => "0"
				)		
		   )
		) );
	}		
	
	/**
	* Counter
	*/
	if (!function_exists('ozy_vc_count_to')) {
		function ozy_vc_count_to( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_count_to', $atts);
			extract(shortcode_atts(array(
				'color' 		=> '#000000',
				'from'			=> 0,
				'to'			=> 100,
				'subtitle' 		=> '',
				'sign'			=> '',
				'signpos'		=> 'right',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	
			
			return '<div class="ozy-counter '. $css_animation .'" style="color:'. esc_attr($color) .'"><div class="timer" data-sign="'. esc_attr($sign) .'" data-signpos="'. esc_attr($signpos) .'" data-from="'. esc_attr($from) .'" data-to="'. esc_attr($to) .'">'. esc_attr($from) .'</div><div class="hr" style="background-color:'. esc_attr($color) .'"></div>'. (esc_attr($subtitle) ? '<span>'. esc_attr($subtitle) .'</span>' : '') .'</div>';
		}
		
		add_shortcode('ozy_vc_count_to', 'ozy_vc_count_to');
		
		vc_map( array(
			"name" => esc_attr__("Count To", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_count_to",
			"icon" => "",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Sub Title", "ozy-wedding-planner-essentials"),
					"param_name" => "subtitle",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Counter title.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("From", "ozy-wedding-planner-essentials"),
					"param_name" => "from",
					"admin_label" => true,
					"value" => "0",
					"description" => esc_attr__("Counter start from", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("To", "ozy-wedding-planner-essentials"),
					"param_name" => "to",
					"admin_label" => true,
					"value" => "100",
					"description" => esc_attr__("Counter count to", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Sign", "ozy-wedding-planner-essentials"),
					"param_name" => "sign",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter a sign like % or whatever you like", "ozy-wedding-planner-essentials")
				),array(
					"type" => "dropdown",
					"heading" => esc_attr__("Sign Position", "ozy-wedding-planner-essentials"),
					"param_name" => "signpos",
					"value" => array('right', 'left'),
					"admin_label" => false,
					"description" => esc_attr__("Select position of your sign.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Forecolor", "ozy-wedding-planner-essentials"),
					"param_name" => "color",
					"value" => "#000000",
					"admin_label" => false
				),$add_css_animation
		   )
		) );	
	}
	
	/**
	* Team Member Extended
	*/
	if (!function_exists('ozy_vc_team_member_ext')) {
		function ozy_vc_team_member_ext( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_team_member_ext', $atts);
			extract(shortcode_atts(array(
				'image' => '',
				'title' => '',
				'sub_title' => '',
				'excerpt' => '',			
				'twitter' => '',
				'facebook' => '',
				'linkedin' => '',
				'pinterest' => '',
				'link' => '',
				'link_caption' => '',
				'use_extended_content' => 'off',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}
			
			$output = PHP_EOL . '<div class="ozy-team_member '. $css_animation . ($use_extended_content==='on' ? ' has-extended-content':'') .'">' . PHP_EOL; //wpb_content_element
			$output.= '<figure>';
			$member_image = wp_get_attachment_image_src($image, 'full');
			if(isset($member_image[0])) {
				$output.= $link? '<a href="'. esc_attr($link) .'">' : '<a>';
				$output.= '<img src="'. $member_image[0] .'" alt="'. esc_attr($title) .'">';
				$member_image = $member_image[0];
				//$output.= $link? '</a>' : '';
				$output.= '</a>';
				
			}else{
				$member_image = '';
			}
			$output.= '<figcaption>';
			$output.= esc_attr($title) ? '<h3>'. esc_attr($title) .'</h3>' : '';
			$output.= esc_attr($sub_title) ? '<h5 class="content-color-alternate">'. esc_attr($sub_title) .'</h5>' : '';
			$output.= '<p>'. esc_attr($excerpt) .'</p>';

			$output.= '<div>';
			$output.= esc_attr($twitter) ? '<a href="http://www.twitter.com/'. esc_attr($twitter) .'" target="_blank" class="symbol-twitter tooltip" title="twitter"><span class="symbol">twitter'.'</span></a>' : '';
			$output.= esc_attr($facebook) ? '<a href="http://www.facebook.com/'. esc_attr($facebook) .'" target="_blank" class="symbol-facebook tooltip" title="facebook"><span class="symbol">facebook'.'</span></a>' : '';
			$output.= esc_attr($linkedin) ? '<a href="http://www.linkedin.com/'. esc_attr($linkedin) .'" target="_blank" class="symbol-linkedin tooltip" title="linkedin"><span class="symbol">linkedin'.'</span></a>' : '';
			$output.= esc_attr($pinterest) ? '<a href="http://pinterest.com/'. esc_attr($pinterest) .'" target="_blank" class="symbol-pinterest tooltip" title="pinterest"><span class="symbol">pinterest'.'</span></a>' : '';
			$output.= '</div>';
			
			$output.= '</figcaption>';
			$output.= '</figure>';
			$output.= ($use_extended_content==='on' ? '<div class="extended-content" data-rand_id="'. rand(10,10000) .'"><table class="team-member-lightbox-table"><tr><td style="background-image:url('. $member_image .');">&nbsp;</td><td class="content-font"><h2 class="heading-font">'. $title . '</h2>'. do_shortcode($content) . ($link && $link_caption ? '<a href="'. esc_url($link) .'" class="lightbox-book-me-now clearfix">'. esc_attr($link_caption) .'</a>':'') .'</td></tr></table></div>' : '');
			$output.= PHP_EOL . '</div>' . PHP_EOL;		
			
			return $output;
		}

		add_shortcode( 'ozy_vc_team_member_ext', 'ozy_vc_team_member_ext' );
		
		vc_map( array(
			"name" => esc_attr__("Team Member - Extended", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_team_member_ext",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Member Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Select image for your team member.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Title for your Team Member, like a name.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Sub Title", "ozy-wedding-planner-essentials"),
					"param_name" => "sub_title",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Sub Title for your Team Member, like work title.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => esc_attr__("Excerpt", "ozy-wedding-planner-essentials"),
					"param_name" => "excerpt",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Twitter", "ozy-wedding-planner-essentials"),
					"param_name" => "twitter",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter your Twitter account name", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Facebook", "ozy-wedding-planner-essentials"),
					"param_name" => "facebook",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter your Facebook account name", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("LinkedIn", "ozy-wedding-planner-essentials"),
					"param_name" => "linkedin",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter your LinkedIn account name", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Pinterest", "ozy-wedding-planner-essentials"),
					"param_name" => "pinterest",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr__("Enter your Pinterest account name", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => "",
					"description" => esc_attr__("Define a path to details page", "ozy-wedding-planner-essentials")
				),array(
					"type" => 'dropdown',
					"heading" => esc_attr__("Use Extended Content", "ozy-wedding-planner-essentials"),
					"param_name" => "use_extended_content",
					"value" => array("off", "on"),
					"description" => esc_attr__("Link will be used in extended content when this option used.", "ozy-wedding-planner-essentials")
				),array(
					"type" => "textarea_html",
					"heading" => esc_attr__("Extended Content", "ozy-wedding-planner-essentials"),
					"param_name" => "content",
					"value" => "",
					"admin_label" => false,
					"dependency" => Array('element' => "use_extended_content", 'value' => 'on')
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Link Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "link_caption",
					"admin_label" => false,
					"value" => esc_attr__("BOOK ME NOW", "ozy-wedding-planner-essentials"),
					"dependency" => Array('element' => "use_extended_content", 'value' => 'on')					
				),$add_css_animation
		   )
		) );		
	}
	
	/**
	* Icon Wrapper
	*/
	if (!function_exists('ozy_vc_iconwrapper')) {
		function ozy_vc_iconwrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_iconwrapper', $atts);
			extract(shortcode_atts(array(
				'title' => ''
			), $atts));

			$output = '<div class="ozy-icon-wrapper wpb_content_element">';
			if($title) $output.= '<span>' . esc_attr($title, 'ozy-wedding-planner-essentials') . '</span>';
			$output.= do_shortcode($content); 
			$output.= '</div>';

			return $output;
		}
		
		add_shortcode('ozy_vc_iconwrapper', 'ozy_vc_iconwrapper');
		
		vc_map( array(
			"name" => esc_attr__("Icon Wrapper", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_iconwrapper",
			"as_parent" => array('only' => 'vc_icon'),
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"value" => "",
					"admin_label" => true
				)
		   ),
		   "js_view" => 'VcColumnView'
		) );
		
		class WPBakeryShortCode_Ozy_Vc_Iconwrapper extends WPBakeryShortCodesContainer{}			
	}
	
	/**
	* Compact Post / Portfolio
	*/
	if (!function_exists('ozy_vc_hoverbox_feed')) {
		function ozy_vc_hoverbox_feed( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_hoverbox_feed', $atts);
			extract(shortcode_atts(array(
				'data_source'		=> 'blog',
				'orderby'			=> 'date',
				'order'				=> 'DESC',
				'css_animation' 	=> '',
				'category_name'		=> ''
			), $atts));
			
			if(!function_exists('wedding_planner_blog_more')) return '';
			
			wp_enqueue_style('wedding-planner-hoverbox-blog');
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$args = array(
				'post_type' 			=> ($data_source == 'portfolio' ? 'ozy_portfolio' : 'post'),
				'post_status'			=> 'publish',
				'orderby' 				=> $orderby,
				'order' 				=> $order,
				'posts_per_page'		=> 6,
				'ignore_sticky_posts' 	=> 1,
				'meta_key' 				=> '_thumbnail_id',
				'tax_query' => array(
					array(
						'taxonomy' => 'post_format',
						'field'    => 'slug',
						'terms' => array('post-format-aside', 'post-format-link', 'post-format-quote', 'post-format-status', 'post-format-audio', 'post-format-chat'),
						'operator' => 'NOT IN'
					),
				),								
			);
			
			if($data_source !== 'portfolio' && $category_name) {
				$args['category_name'] = $category_name;
			}else if($data_source === 'portfolio' && $category_name) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'portfolio_category',
						'field'    => 'slug',
						'terms'    => $category_name
					));
			}
			
			query_posts( $args );
			
			$effect_array = array(
				'effect-slideleft one-half', 
				'effect-slidedown one-half', 
				'effect-slideleft double-height one-full', 
				'effect-slideup one-half double-height', 
				'effect-slideleft one-half', 
				'effect-slideright one-half');
			$post_counter = 0;

			$excerpt_function = function_exists('wedding_planner_excerpt_max_charlength') ? 'wedding_planner_excerpt_max_charlength' : 'get_the_excerpt';			
			
			$output = '<div class="hoverbox-blog-grid '. $css_animation .'">';
						
			while (have_posts()) {
				the_post();wedding_planner_blog_more();

				$post_image_src = '';
				if ( has_post_thumbnail() ) { 
					$post_image_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'wedding_planner_blog' , false );
					if (isset($post_image_src[0])) {
						$post_image_src = $post_image_src[0];
					}else{
						$post_image_src = '';
					}
				}
				
				$dynamic_css_class_name = 'hover-box-1' . get_the_ID();
				
				$output.= 
					'<figure class="'. esc_attr($effect_array[$post_counter]) . '" style="background-image:url('. esc_url($post_image_src) .')">
						<img src="'. esc_attr($post_image_src) .'" alt="'. esc_attr(get_the_title()) .'"/>
						<figcaption class="'.  $dynamic_css_class_name  .'">
							<div>
								<span class="cat">';

				if($data_source !== 'portfolio') {
					$categories = get_the_category();
				}else{
					$categories = get_the_terms( $post->ID , 'portfolio_category' );
				}
				$separator = ' ';
				if ( ! empty( $categories ) ) {
					foreach( $categories as $category ) {
						$output .= $separator . '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' . esc_attr( sprintf( esc_attr( 'View all posts in %s', 'ozy-wedding-planner-essentials' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a>';
						$separator = ', ';
					}
				}
				
				//$output.=		'</span><h2>'. esc_html(get_the_title()) .'</h2>
				$output.=		'</span><h2>'. get_the_title() .'</h2>
								<p>'. esc_html(call_user_func($excerpt_function, 100)) .'</p>
								<a href="'. esc_url(get_permalink()) .'" class="button">'. esc_html('VIEW NOW', 'ozy-wedding-planner-essentials') .'</a>
							</div>
						</figcaption>			
					</figure>';
				
				$post_counter++;
				
				if(function_exists('wedding_planner_page_hover_box_blog_css_builder')) {
					wedding_planner_page_hover_box_blog_css_builder(get_the_ID(), $dynamic_css_class_name);
				}
			}
			$output.= '</div>';	
			
			wp_reset_postdata();
			
			wp_reset_query();
			
			return $output;
		}
		
		add_shortcode('ozy_vc_hoverbox_feed', 'ozy_vc_hoverbox_feed');
		
		vc_map( array(
			"name" => esc_attr("Compact Post / Portfolio", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_hoverbox_feed",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Data Source", "ozy-wedding-planner-essentials"),
					"param_name" => "data_source",
					"value" => array("", "blog", "portfolio"),
					"admin_label" => true,
					"description" => esc_attr("Choose source of your feed.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textfield",
					"heading" => esc_attr("Categories", "ozy-wedding-planner-essentials"),
					"param_name" => "category_name",
					"description" => esc_attr("If you want to narrow output, enter category slug names here. Display posts that have this category (and any children of that category), use category slug (NOT name). Split names with ','. More information; <a href='http://codex.wordpress.org/Class_Reference/WP_Query#Category_Parameters' target='_blank'>http://codex.wordpress.org/Class_Reference/WP_Query#Category_Parameters</a>", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => esc_attr__("Order by", "ozy-wedding-planner-essentials"),
					"param_name" => "orderby",
					"value" => array(esc_attr__("Date", "ozy-wedding-planner-essentials") => "date", esc_attr__("ID", "ozy-wedding-planner-essentials") => "ID", esc_attr__("Author", "ozy-wedding-planner-essentials") => "author", esc_attr__("Title", "ozy-wedding-planner-essentials") => "title", esc_attr__("Modified", "ozy-wedding-planner-essentials") => "modified", esc_attr__("Random", "ozy-wedding-planner-essentials") => "rand", esc_attr__("Comment count", "ozy-wedding-planner-essentials") => "comment_count", esc_attr__("Menu order", "ozy-wedding-planner-essentials") => "menu_order" ),
					"description" => esc_attr__('Select how to sort retrieved posts.', 'ozy-wedding-planner-essentials')
				),
				array(
					"type" => "dropdown",
					"heading" => esc_attr__("Order way", "ozy-wedding-planner-essentials"),
					"param_name" => "order",
					"value" => array(esc_attr__("Descending", "ozy-wedding-planner-essentials") => "DESC", esc_attr__("Ascending", "ozy-wedding-planner-essentials") => "ASC" ),
					"description" => esc_attr__('Designates the ascending or descending order.', "ozy-wedding-planner-essentials")
				),
				$add_css_animation
		   )
		) );
	}	
	
	/**
	* Accordion Post List
	*/
	if (!function_exists('ozy_vc_fancypostaccordion_feed')) {
		function ozy_vc_fancypostaccordion_feed( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_fancypostaccordion_feed', $atts);
			extract(shortcode_atts(array(
				'data_source'		=> 'blog',
				'link_caption' 		=> 'FIND OUT MORE',
				'link_target'		=> '_self',
				'posts_per_page'	=> '6',
				'css_animation' 	=> '',
				'category_name'		=> ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$args = array(
				'post_type' 			=> ($data_source == 'portfolio' ? 'ozy_portfolio' : 'post'),
				'posts_per_page'		=> esc_attr($posts_per_page),
				'orderby' 				=> 'date',
				'order' 				=> 'DESC',
				'ignore_sticky_posts' 	=> 1,
			);

			if($data_source !== 'portfolio' && $category_name) {
				$args['category_name'] = $category_name;
			}else if($data_source === 'portfolio' && $category_name) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'portfolio_category',
						'field'    => 'slug',
						'terms'    => $category_name
					));
			}

			$the_query = new WP_Query( $args );
			
			$output = '<table class="ozy-fancyaccordion-feed wpb_content_element '. $css_animation .'">';
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$categories = get_the_terms(get_the_ID(), ($data_source === 'blog' ? 'category' : 'portfolio_category'));
				
				$output .= '<tr class="title">';
				$output .= '<td class="heading-font">';
				if(is_array($categories)) {
					$output .= '<span class="category generic-button content-font">';
					$comma = '';			
					foreach ($categories as $cat) {
						$output .= $comma . $cat->name;
						$comma = ', ';
					}
					$output .= '</span>';
				}
				$output .= get_the_date(get_option('date_format'));
				$output .= '</td>';
				$output .= '<td>';
				$output .= '<h3 class="t">'. get_the_title() .'</h3><span class="plus-icon"><span class="h"></span><span class="v"></span></span>';				
				$output .= '</td>';
				$output .= '</tr>';
				$output .= '<tr class="excerpt">';
				$output .= '<td><div>&nbsp;</div></td>';
				$output .= '<td><div>';
				if(function_exists('wedding_planner_excerpt_max_charlength')) {
					$output .= wedding_planner_excerpt_max_charlength(200, true, false);
				}else{
					$output .= '**not proper theme in use**';
				}
				$output .= '<p>';
				$output .= '<a href="'. esc_url(get_permalink()) .'">'. esc_html($link_caption) .'</a>';
				$output .= '</p>';				
				$output .= '</div></td>';
				$output .= '</tr>';			
			}
			wp_reset_postdata();
			
			$output.= '</table>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_fancypostaccordion_feed', 'ozy_vc_fancypostaccordion_feed');
		
		vc_map( array(
			"name" => esc_attr("Accordion Post List", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_fancypostaccordion_feed",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Data Source", "ozy-wedding-planner-essentials"),
					"param_name" => "data_source",
					"value" => array("", "blog", "portfolio"),
					"admin_label" => true,
					"description" => esc_attr("Choose source of your feed.", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textfield",
					"heading" => esc_attr("Categories", "ozy-wedding-planner-essentials"),
					"param_name" => "category_name",
					"description" => esc_attr("If you want to narrow output, enter category slug names here. Display posts that have this category (and any children of that category), use category slug (NOT name). Split names with ','. More information; <a href='http://codex.wordpress.org/Class_Reference/WP_Query#Category_Parameters' target='_blank'>http://codex.wordpress.org/Class_Reference/WP_Query#Category_Parameters</a>", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr("Link Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "link_caption",
					"admin_label" => true,
					"value" => esc_attr("FIND OUT MORE", "ozy-wedding-planner-essentials")
				),array(
					"type" => "dropdown",
					"heading" => esc_attr("Link Target", "ozy-wedding-planner-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => esc_attr("Select link target window.", "ozy-wedding-planner-essentials")
				),					
				array(
					"type" => "dropdown",
					"heading" => esc_attr("Item Count", "ozy-wedding-planner-essentials"),
					"param_name" => "posts_per_page",
					"value" => array("6", "1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"),
					"admin_label" => true,
					"description" => esc_attr("How many post will be shown on the list.", "ozy-wedding-planner-essentials")
				),
				$add_css_animation
		   )
		) );
	}
	
	/**
	* Instagram Feed (Deprecated)
	*/
	if (!function_exists('ozy_vc_instagram')) {
		function ozy_vc_instagram( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_instagram', $atts);
			extract(shortcode_atts(array(
				'username' => '',
				'num_items' => '10',
				'access_token' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			return '<div class="ozy-instagram-gallery-wrapper wpb_content_element '. $css_animation .'"><span class="alternate-text-color">@'. esc_html($username) .'</span><ul class="ozy-instagram-gallery" data-username="'. esc_attr($username) .'" data-numitems="'. esc_attr($num_items) .'" data-accesstoken="'. esc_attr($access_token) .'"></ul></div>';
		}

		add_shortcode('ozy_vc_instagram', 'ozy_vc_instagram');
		
		vc_map( array(
			"name" => esc_attr__("*Deprecated* Instagram Feed", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_instagram",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"deprecated" => "6.1",
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Username", "ozy-wedding-planner-essentials"),
					"param_name" => "username",
					"admin_label" => true,
					"value" => "",
					"description" => esc_attr('This is just label, not meaning photos/vidoes will be loaded from this account, this label will be shown on front end only.', 'ozy-wedding-planner-essentials'),
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Number Of Items", "ozy-wedding-planner-essentials"),
					"param_name" => "num_items",
					"admin_label" => true,
					"value" => "10",
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Access Token Key", "ozy-wedding-planner-essentials"),
					"param_name" => "access_token",
					"description" => esc_attr('Please go to https://freevision.me/instagram get your access token key', 'ozy-wedding-planner-essentials'),
					"admin_label" => false,
					"value" => ""
				),$add_css_animation
		   )
		) );	
	}	
	
	/**
	* Instagram Feed NEW
	*/
	if (!function_exists('ozy_vc_instagram_new')) {
		function ozy_vc_instagram_new( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_instagram_new', $atts);
			extract(shortcode_atts(array(
				'user_id' => '',
				'num_items' => '10',
				'access_token' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			return '<div class="ozy-instagram-gallery-wrapper '. $css_animation . '"><ul class="ozy-instagram-gallery new" data-userid="'. esc_attr($user_id) .'" data-numitems="'. esc_attr($num_items) .'" data-accesstoken="'. esc_attr($access_token) .'"></ul></div>';			
		}

		add_shortcode('ozy_vc_instagram_new', 'ozy_vc_instagram_new');
		
		vc_map( array(
			"name" => esc_attr__("*NEW* Instagram Feed", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_instagram_new",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("User ID", "ozy-wedding-planner-essentials"),
					"param_name" => "user_id",
					"admin_label" => true,
					"value" => "",
					"description" => __('Get your credentials manually <a href="https://freevision.me/instagram" class="open_instagram_credentials" target="_blank">get your user id and access token key here</a>.', 'ozy-wedding-planner-essentials'),
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Access Token Key", "ozy-wedding-planner-essentials"),
					"param_name" => "access_token",
					"description" => __('Get your credentials manually <a href="https://freevision.me/instagram" class="open_instagram_credentials" target="_blank">get your user id and access token key here</a>.', 'ozy-wedding-planner-essentials'),
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Number Of Items", "ozy-wedding-planner-essentials"),
					"param_name" => "num_items",
					"admin_label" => true,
					"value" => "10",
				),$add_css_animation
		   )
		) );	
	}	
	
	/**
	* Call To Action Box
	*/
	if (!function_exists('ozy_vc_calltoactionbox')) {
		function ozy_vc_calltoactionbox( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_calltoactionbox', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'caption'		=> '',
				'icon'			=> '',
				'link_caption' 	=> '',
				'link'			=> '',
				'link_target'	=> '_self',
				'box_height'	=> '',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			$image = wp_get_attachment_image_src($image, 'full');
			if(isset($image[0])) {
				$image = ' style="background-image:url('. esc_url($image[0]) .');'. ($box_height ? 'height:' . esc_attr($box_height):'') .'"';
			}else{
				$image = ' style="height:'. ($box_height ? 'height:' . esc_attr($box_height):'') .'"';
			}
			$output = '<div class="ozy-call-to-action-box '. $css_animation .'"'. $image .'>';			
			$output .= '<div class="shadow-wrapper"></div>';
			$output .= '<div class="overlay-wrapper">';
			if($icon) {
				$output .= '<i class="'. esc_attr($icon) .'"></i>';
			}			
			$output .= '<h2>'. $caption .'</h2>';
			$output .= '<span class="shared-border-color"></span>';
			$output .= '<a href="'. esc_url($link) .'" target="'. esc_attr($link_target) .'" class="heading-font">'. $link_caption .'</a>';
			$output .= '</div>';
			$output .= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_calltoactionbox', 'ozy_vc_calltoactionbox');
		
		vc_map( array(
			"name" => esc_attr__("Call To Action Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_calltoactionbox",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),		
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => esc_attr__("Box Title", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Height", "ozy-wedding-planner-essentials"),
					"param_name" => "box_height",
					"admin_label" => true,
					"value" => "640px"
				),
				array(
					"type" => "select_an_icon",
					"heading" => esc_attr__("Icon", "ozy-wedding-planner-essentials"),
					"param_name" => "icon",
					"value" => '',
					"admin_label" => false
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Link Caption", "ozy-wedding-planner-essentials"),
					"param_name" => "link_caption",
					"admin_label" => true,
					"value" => esc_attr__("SHOP USED EQUIPMENT &rarr;", "ozy-wedding-planner-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Link", "ozy-wedding-planner-essentials"),
					"param_name" => "link",
					"admin_label" => true
				),
				array(
					"type" => "dropdown",
					"heading" => esc_attr__("Link Target", "ozy-wedding-planner-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => esc_attr__("Select link target window.", "ozy-wedding-planner-essentials")
				),	
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		) );
	}

	/**
	* Blockquote Box
	*/
	if (!function_exists('ozy_vc_blockquotebox')) {
		function ozy_vc_blockquotebox( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_blockquotebox', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'title'			=> '',
				'sub_title1'	=> '',
				'sub_title2'	=> '',
				'image_align'	=> 'left',
				'extra_css'		=> '',
				'fn_color'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}	

			$image_src = wp_get_attachment_image_src($image, 'full'); $image = ''; $has_image = 'has_image';
			if(isset($image_src[0])) {
				$image = '<span class="img-wrapper" class="shared-border-color" style="background-image:url('. esc_url($image_src[0]) .')">&nbsp;</span>';
			}else{
				$has_image = '';
			}
			
			$style = ($fn_color ? ' style="color:'. esc_attr($fn_color) .'"':'');
			
			$output = '
				<div class="ozy-testimonial-quote group '. $css_animation . ' ' . $extra_css . ' ' . $image_align .'" '. $style .'>
					'. ($image_align === 'left' ? $image : '') .'
					<div class="ozy-quote-container '. $has_image .'">
						<blockquote>
							<p '. $style .'>'. $content .'</p>
						</blockquote>  
						<cite><span>'. $title .'</span><br>
							'. $sub_title1 .'
							'. ($sub_title2 ? '<br>' . $sub_title2 : '') .'
						</cite>
					</div>
					'. ($image_align === 'right' ? $image : '') .'
				</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_blockquotebox', 'ozy_vc_blockquotebox');
		
		vc_map( array(
			"name" => esc_attr__("Blockquote Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_blockquotebox",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_attr__("Image", "ozy-wedding-planner-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),		
				array(
					"type" => "textarea",
					"class" => "",
					"heading" => esc_attr__("Quote", "ozy-wedding-planner-essentials"),
					"param_name" => "content",
					"admin_label" => true
				),				
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Title", "ozy-wedding-planner-essentials"),
					"param_name" => "title",
					"admin_label" => true
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Sub Title #1", "ozy-wedding-planner-essentials"),
					"param_name" => "sub_title1",
					"admin_label" => true
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Sub Title #2", "ozy-wedding-planner-essentials"),
					"param_name" => "sub_title2",
					"admin_label" => true
				),
				array(
					"type" => "dropdown",
					"heading" => esc_attr__("Align", "ozy-wedding-planner-essentials"),
					"param_name" => "image_align",
					"value" => array("left", "right")
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Foreground Color", "ozy-wedding-planner-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => ""
				),	
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => esc_attr__("Extra class name", "ozy-wedding-planner-essentials"),
					"param_name" => "el_class",
					"description" => esc_attr__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-wedding-planner-essentials")
				)			
		   )
		) );
	}	
	
	/**
	* Padding Box
	*/
	if (!function_exists('ozy_vc_anywrapper2')) {
		function ozy_vc_anywrapper2( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_anywrapper2', $atts);
			extract(shortcode_atts(array(
				'width' => '100%',
				'text_align' => 'left',
				'padding_top' => '30px',
				'padding_right' => '30px',
				'padding_bottom' => '30px',
				'padding_left' => '30px',
				'bg_color' => '',
				'border_color' => '',
				'border_width' => '1px',
				'border_style' => 'none'
			), $atts));
					
			$rand_el_id = 'oawx-' . rand(0, 100000);

			global $ozyWeddingPlannerHelper;
			if(!function_exists('wedding_planner_get_option') || !is_object($ozyWeddingPlannerHelper)) return null;

			$inline_style = 'text-align:'. esc_attr($text_align) .';width:'. esc_attr($width) .';padding:'. esc_attr($padding_top) .' '. esc_attr($padding_right) .' '. esc_attr($padding_bottom) .' '. esc_attr($padding_left);
			$ozyWeddingPlannerHelper->set_footer_style('@media only screen and (min-width: 479px) {#'. $rand_el_id .'{'. $inline_style .'}}');
			
			$inline_style = '';
			if($bg_color && $bg_color != 'transparent') { $inline_style.=';background-color:'.esc_attr($bg_color); }
			if($border_color && $border_width && $border_style && $border_style != 'none') { $inline_style.=';border:' . esc_attr($border_width) . ' ' . esc_attr($border_style) . ' ' . esc_attr($border_color); }
						
			$ozyWeddingPlannerHelper->set_footer_style('#'. $rand_el_id .'{'. $inline_style .'}');
			
			return '<div id="'. esc_attr($rand_el_id) .'" class="ozy-anything-wrapper-x">'. do_shortcode($content) .'</div>';

		}
		
		add_shortcode('ozy_vc_anywrapper2', 'ozy_vc_anywrapper2');
		
		vc_map( array(
			"name" => esc_attr__("Padding Box", "ozy-wedding-planner-essentials"),
			"base" => "ozy_vc_anywrapper2",
			"as_parent" => array('except' => 'ozy_vc_iabox,ozy_vc_flipbox'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',			
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Width", "ozy-wedding-planner-essentials"),
					"param_name" => "width",
					"admin_label" => true,
					"value" => "100%"
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Text Align", "ozy-wedding-planner-essentials"),
					"param_name" => "text_align",
					"admin_label" => true,
					"value" => array("left","center","right")
				),						
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Padding Top", "ozy-wedding-planner-essentials"),
					"param_name" => "padding_top",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Padding Right", "ozy-wedding-planner-essentials"),
					"param_name" => "padding_right",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Padding Bottom", "ozy-wedding-planner-essentials"),
					"param_name" => "padding_bottom",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Padding Left", "ozy-wedding-planner-essentials"),
					"param_name" => "padding_left",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Background Color", "ozy-wedding-planner-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "transparent"
				),array(
					"type" => "colorpicker",
					"heading" => esc_attr__("Border Color", "ozy-wedding-planner-essentials"),
					"param_name" => "border_color",
					"admin_label" => false,
					"value" => "#dedede"
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Border Width", "ozy-wedding-planner-essentials"),
					"param_name" => "border_width",
					"admin_label" => true,
					"value" => array("1px","2px","3px","4px","5px","6px","7px","8px","9px","10px","11px","12px","13px","14px","15px")
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_attr__("Border Style", "ozy-wedding-planner-essentials"),
					"param_name" => "border_style",
					"admin_label" => true,
					"value" => array("none","hidden","dotted","dashed","solid","double","groove","ridge","inset","outset","initial","inherit")
				)
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Anywrapper2 extends WPBakeryShortCodesContainer{}		
}
?>