<?php
/*
Plugin Name: Voice Buddy
Description: A plugin which adds specific features to Voice WordPress theme.
Version: 1.0.1
Author: پرشین اسکریپت
Author URI: www.persianscript.ir
Text Domain: voice-buddy
Domain Path: /languages
*/

/* Prevent direct access */
if ( !defined( 'DB_NAME' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	die;
}

/* Define */
define( 'VOICE_BUDDY_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );
define( 'VOICE_BUDDY_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'VOICE_BUDDY_BASENAME', plugin_basename( __FILE__ ) );

define( 'VOICE_BUDDY_VER', '1.0.1' );


/* Compatibility checks */
require_once VOICE_BUDDY_DIR . 'inc/compat.php';

/* Register widgets */
require_once VOICE_BUDDY_DIR . 'inc/widgets.php';


if ( is_admin() ) {

	/* Enqueue */
	require_once VOICE_BUDDY_DIR . 'inc/enqueue.php';

	/* Update API */
	require_once VOICE_BUDDY_DIR . 'inc/update.php';

}

/* Load text domain */
add_action( 'plugins_loaded', 'voice_buddy_text_domain' );

function voice_buddy_text_domain() {
	load_plugin_textdomain( 'voice-buddy', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}

?>