jQuery(document).ready(function ($) {
    if ($('.ecs-countdown').length > 0) {
        var countdown_expiry_date = $('.ecs-countdown').data('expire-date');
        if (countdown_expiry_date != '') {
            $('.ecs-countdown').downCount({
                date: countdown_expiry_date + ' 12:00:00',
            });
        }
    }

    $('.ecs-close').click(function () {
        $(this).closest('.ecs-section').removeClass('ecs-active-section');
    });

    $('.ecs-section-trigger').click(function () {
        var section_id = $(this).data('section-id');
        $('.ecs-template-13 .ecs-' + section_id + '-section').addClass('ecs-active-section');
        if (section_id == 'location') {
            initMap();
        }

    });

    $('#ecs-subscription-form').submit(function (e) {
        e.preventDefault();

        var email_address = $('#ecs-subscription-form input[name="email"]').val();
        if (email_address == '') {
            var error_message = $(this).data('subscription-error-message');
            $('.ecs-subscription-message').html(error_message);
        } else {
            $.ajax({
                type: 'post',
                url: ajax_url,
                data: {
                    email: email_address,
                    _wpnonce: ajax_nonce,
                    action: 'ecs_subscribe_action'
                },
                beforeSend: function (xhr) {
                    $('.ecs-subscribe-loader').show();
                },
                success: function (res) {
                    $('.ecs-subscribe-loader').hide();
                    res = $.parseJSON(res);
                    $('.ecs-subscription-message').html(res.message);
                    if (res.success == 1) {
                        $('#ecs-subscription-form input[name="email"]').val('');
                    }

                }
            });
        }
    });
    $('#ecs-subscription-form input[name="email"]').keyup(function () {
        $('.ecs-subscription-message').html('');
    });

    $('.ecs-email-form').submit(function (e) {
        e.preventDefault();
        var error_flag = 0;
        var required_message = $(this).data('form-error-message');
        var name = $('.ecs-email-form input[name="contact_name"]').val();
        if (name == '') {
            error_flag = 1;
            $('.ecs-name-error').html(required_message);
        }
        var email = $('.ecs-email-form input[name="contact_email"]').val();
        if (email == '') {
            error_flag = 1;
            $('.ecs-email-error').html(required_message);
        }
        var message = $('.ecs-email-form textarea[name="contact_message"]').val();
        if (message == '') {
            error_flag = 1;
            $('.ecs-message-error').html(required_message);
        }

        if (error_flag == 0) {
            $.ajax({
                type: 'post',
                url: ajax_url,
                data: {
                    _wpnonce: ajax_nonce,
                    contact_name: name,
                    contact_email: email,
                    contact_message: message,
                    action: 'ecs_email_action'
                },
                beforeSend: function (xhr) {
                    $('.ecs-email-loader').show();
                },
                success: function (res) {
                    $('.ecs-email-loader').hide();
                    res = $.parseJSON(res);
                    $('.ecs-email-message').html(res.message);
                    if (res.success == 1) {
                        $('.ecs-email-form input[name="contact_name"]').val('');
                        $('.ecs-email-form input[name="contact_email"]').val('');
                        $('.ecs-email-form textarea[name="contact_message"]').val('');

                    }

                }
            });
        }
    });

    $('.ecs-email-form input[type="text"],.ecs-email-form input[type="email"],.ecs-email-form textarea').keyup(function () {
        $(this).next('.ecs-contact-error').html('');
    });
    if ($('.ecs-timer-wrap').length > 0) {
        var day_circle_color = $('.ecs-timer-wrap').data('timer-day-color');
        var hour_circle_color = $('.ecs-timer-wrap').data('timer-hour-color');
        var minute_circle_color = $('.ecs-timer-wrap').data('timer-minute-color');
        var second_circle_color = $('.ecs-timer-wrap').data('timer-second-color');
        var circle_date_countdown_bgcolor = $('.ecs-timer-wrap').data('timer-bgcolor');
        $(".ecs-circle-timer").TimeCircles({
            "animation": "smooth",
            "bg_width": 1,
            "fg_width": 0.03,
            "circle_bg_color": circle_date_countdown_bgcolor,
            "time": {
                "Days": {
                    "text": $(".ecs-circle-timer").data('days-label'),
                    "color": day_circle_color,
                    "show": true
                },
                "Hours": {
                    "text": $(".ecs-circle-timer").data('hours-label'),
                    "color": hour_circle_color,
                    "show": true
                },
                "Minutes": {
                    "text": $(".ecs-circle-timer").data('minutes-label'),
                    "color": minute_circle_color,
                    "show": true
                },
                "Seconds": {
                    "text": $(".ecs-circle-timer").data('seconds-label'),
                    "color": second_circle_color,
                    "show": true
                }
            }
        });
    }




    $('.ecs-id-link').click(function (e) {
        $('.ecs-section').removeClass('ecs-active-section');
        e.preventDefault();
        //  $('.ecs-close').click();
        var id = $(this).attr('href');

        $(id).addClass('ecs-active-section');
        //   $(id).fadeIn(500);
        if ($(id).find('.ecs-google-map-wrap').length > 0) {
            initMap();
        }
    });

    $('.ecs-temp10-close').click(function () {
        var close_id = $(this).data('close-id');
        $(close_id).removeClass('ecs-active-section');
    });

    $('.ecs-template-1 .ecs-navigation-bttn, .ecs-template-1 .ecs-readmore-button').click(function (e) {
        e.preventDefault();
        $('.ecs-template-1 .ecs-templates-wrap').addClass('ecs-active-section');
    });

    $('.ecs-template-1 .ecs-overlay, .ecs-template-1 .ecs-navigation-close-bttn').click(function (e) {
        e.preventDefault();
        $('.ecs-template-1 .ecs-templates-wrap').removeClass('ecs-active-section');
    });

    $('.ecs-scroll-trigger').click(function (e) {
        e.preventDefault();
        var id = $(this).attr('href');
        $('html,body').animate({
            scrollTop: $(id).offset().top},
                'slow');
    });
    if ($('.ecs-sticky-header').length > 0) {
        $(window).scroll(function () {
            var scroll = $(window).scrollTop();
            if (scroll > 150) {
                $('.ecs-sticky-header').addClass('ecs-sticky-on');
            } else {
                $('.ecs-sticky-header').removeClass('ecs-sticky-on');
            }
        });
    }

    var window_width = $(window).width();
    if ($('.ecs-template-15').length > 0 || $('.ecs-template-5').length > 0 || $('.ecs-template-12').length > 0 || $('.ecs-template-8').length > 0) {
        if (window_width > 767) {
            $.scrollify({
                section: ".ecs-section",
                updateHash: false
            });
        }
    }

    if ($('.ecs-template-4').length > 0 || $('.ecs-template-7').length > 0) {
        if (window_width > 860) {
            $('.ecs-templates-inner-wrap').multiscroll({
                menu: '#menu',
                navigation: true,
            });
        } else {
            $('#multiscroll-css').remove();
        }
    }




});


