<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section">
        <div class="ecs-intro-left-section animated slideInLeft">
            <div class="ecs-intro-content-wrap">
                <div class="ecs-countdown-wrap ecs-clearfix animated fadeInDown">
                    <?php
                    include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                    ?>
                </div>
                <?php if ( $site_short_description != '' ) { ?>
                    <div class="ecs-intro-description animated fadeInDown">
                        <?php echo $site_short_description; ?>
                    </div>
                <?php } ?>
                <?php if ( $loader_percentage != '' ) { ?>
                    <div class="ecs-progress-bar animated fadeInDown">
                        <span class="ecs-progress-count"><?php echo $loader_label; ?></span>
                        <div class="ecs-progress-bar-length" style="width:<?php echo $loader_percentage; ?>%"></div>
                    </div>
                <?php } ?>
                <div class="ecs-section-link-wrap ecs-clearfix">
                    <a href="#ecs-subscription-active" class="ecs-subscription-link ecs-id-link animated fadeIn"><?php echo (!empty($template_settings[ 'template_9' ][ 'subscribe_now_label' ])) ? esc_attr($template_settings[ 'template_9' ][ 'subscribe_now_label' ]) : __('Subscribe Now', 'everest-coming-soon'); ?></a>
                    <a href="#ecs-more-info-active" class="ecs-more-info-link ecs-id-link animated fadeIn"><?php echo (!empty($template_settings[ 'template_9' ][ 'more_information_label' ])) ? esc_attr($template_settings[ 'template_9' ][ 'more_information_label' ]) : __('More Information', 'everest-coming-soon'); ?></a>
                </div>
            </div>
            <?php
            if ( !empty($social_networks) ) {
                ?>
                <div class="ecs-social-share-wrap animated fadeInUp">
                    <?php
                    foreach ( $social_networks as $social_network => $url ) {
                        if ( $url != '' ) {
                            ?>
                            <a href="<?php echo $url; ?>" class="ecs-social-icon">
                                <i class="fa fa-<?php echo $social_network; ?>"></i>
                            </a>
                            <?php
                        }
                    }
                    ?>
                </div>
            <?php } ?>
        </div>
        <div class="ecs-intro-right-section animated slideInRight"></div>
    </div>
    <div class="ecs-section ecs-subscription-section" id="ecs-subscription-active">
        <div class="ecs-overlay"></div>
        <div class="ecs-subscription-inner-container">
            <span class="ecs-close"></span>
            <div class="ecs-subscription-content">
                <?php if ( $subscription_title != '' ) { ?><h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3><?php } ?>
                <?php if ( $subscription_description != '' ) { ?>
                    <div class="ecs-content-description">
                        <?php echo $subscription_description; ?>
                    </div>
                <?php } ?>
                <div class="ecs-subscription-form-wrap">
                    <form id="ecs-subscription-form" class="ecs-clearfix" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-more-info-section" id="ecs-more-info-active">
        <span class="ecs-close"></span>
        <div class="ecs-more-info-inner-wrap">
            <div class="ecs-aboutus-content">
                <?php if ( $about_us_title != '' ) { ?>
                    <h3 class="ecs-section-content-title"><?php echo $about_us_title; ?></h3>
                <?php } ?>
                <div class="ecs-content-description">
                    <?php echo $about_us_description; ?>
                </div>
            </div>
            <div class="ecs-location-content">
                <h3 class="ecs-section-content-title"><?php echo $get_in_touch_title; ?></h3>
                <?php if ( $get_in_touch_description != '' ) { ?>
                    <div class="ecs-content-description">
                        <?php echo $get_in_touch_description; ?>
                    </div>
                <?php } ?>
                <div class="ecs-contact-info-wrap ecs-clearfix">
                    <?php if ( $phone_value != '' ) { ?>
                        <div class="ecs-contact-info ecs-phone-details">
                            <div class="ecs-contact-info-inner-wrap ecs-clearfix">
                                <div class="ecs-contact-icon">
                                    <i class="fa fa-phone"></i>
                                </div>
                                <?php
                                $phone_value_array = explode(',', $phone_value);
                                foreach ( $phone_value_array as $phone_value ) {
                                    ?>
                                    <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    <?php } ?>
                    <?php if ( $email_value != '' ) { ?>
                        <div class="ecs-contact-info ecs-mailing-details">
                            <div class="ecs-contact-info-inner-wrap ecs-clearfix">
                                <div class="ecs-contact-icon">
                                    <i class="fa fa-envelope"></i>
                                </div>
                                <p><?php
                                    $email_value_array = explode(',', $email_value);
                                    foreach ( $email_value_array as $email_value ) {
                                        ?>
                                        <a href="mailto:<?php echo $email_value ?>"><?php echo $email_value; ?></a><br/>
                                        <?php
                                    }
                                    ?>

                            </div>
                        </div>
                        <?php
                    }
                    if ( $address_value != '' ) {
                        ?>
                        <div class="ecs-contact-info ecs-address-details">
                            <div class="ecs-contact-info-inner-wrap ecs-clearfix">
                                <div class="ecs-contact-icon">
                                    <i class="fa fa-map-marker"></i>
                                </div>
                                <p><?php echo $address_value; ?></p>
                            </div>
                        </div>
                    <?php } ?>

                </div>
                <div class="ecs-section ecs-location-section">
                    <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
                </div>
            </div>
            <div class="ecs-contact-content">
                <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $contact_us_description; ?>
                </div>
                <div class="ecs-contact-form-wrap">
                    <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                            <div class="ecs-contact-error ecs-name-error"></div>
                        </div>
                        <div class="ecs-input-wrap">
                            <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                            <div class="ecs-contact-error ecs-email-error"></div>
                        </div>
                        <div class="ecs-input-wrap">
                            <textarea  placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                            <div class="ecs-contact-error ecs-message-error"></div>
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $submit_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                        <div class="ecs-email-message"></div>
                    </form>
                </div>
            </div>
            <footer class="ecs-footer ecs-clearfix">
                <?php if ( $footer_text != '' ) { ?>
                    <div class="ecs-copyright-info">
                        <?php echo $footer_text; ?>
                    </div>
                <?php } ?>
                <?php
                if ( !empty($social_networks) ) {
                    ?>
                    <div class="ecs-social-share-wrap">
                        <?php
                        foreach ( $social_networks as $social_network => $url ) {
                            if ( $url != '' ) {
                                ?>
                                <a href="<?php echo $url; ?>" class="ecs-social-icon">
                                    <i class="fa fa-<?php echo $social_network; ?>"></i>
                                </a>
                                <?php
                            }
                        }
                        ?>
                    </div>
                <?php } ?>
            </footer>
        </div>
    </div>
</div>