<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section">
        <div class="ecs-section-content ecs-clearfix">
            <div class="ecs-left-content">
                <div class="ecs-inner-wrapper">
                    <div class="ecs-intro-left-title animated fadeInUp">
                        <?php if ( $countdown_title != '' ) { ?>
                            <h2><?php echo $countdown_title; ?></h2>
                        <?php } ?>
                    </div>
                    <div class="ecs-countdown-wrap animated fadeInUp">
                        <?php
                        include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                        ?>
                    </div>
                </div>
            </div>
            <div class="ecs-right-content">
                <div class="ecs-inner-wrapper">
                    <div class="ecs-logo-wrapper animated fadeInUp">
                        <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                            <div class="ecs-logo-wrapper">
                                <a href="<?php echo site_url(); ?>">
                                    <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="ecs-intro-right-title animated fadeInUp">
                        <?php if ( $header_text != '' ) { ?><h2><?php echo $header_text; ?></h2><?php } ?>
                    </div>
                    <?php if ( $site_short_description != '' ) { ?>
                        <div class="ecs-intro-right-description animated fadeInUp">

                            <?php echo $site_short_description; ?>
                        </div>
                    <?php } ?>
                    <div class="ecs-subscription-form-wrap animated fadeInUp">
                        <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                            <div class="ecs-input-wrap">
                                <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                            </div>
                            <button type="submit" class="ecs-button"><i class="fa fa-paper-plane"></i></button>
                            <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                            <div class="ecs-subscription-message"></div>
                        </form>
                    </div>
                    <?php
                    if ( !empty($social_networks) ) {
                        ?>
                        <div class="ecs-social-share-wrap animated fadeInUp">
                            <?php
                            foreach ( $social_networks as $social_network => $url ) {
                                if ( $url != '' ) {
                                    ?>
                                    <a href="<?php echo $url; ?>" class="ecs-social-icon ecs-<?php echo $social_network; ?>">
                                        <i class="fa fa-<?php echo $social_network; ?>"></i>
                                    </a>
                                    <?php
                                }
                            }
                            ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="ecs-scrolldown">
            <div class="ecs-mouse">
            </div>
            <i class="fa fa-angle-double-down"></i>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section">
        <div class="ecs-section-content ecs-clearfix">
            <div class="ecs-left-content">
                <div class="ecs-inner-wrapper">
                    <div class="ecs-map-wrap">
                        <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
                    </div>
                </div>
            </div>
            <div class="ecs-right-content">
                <div class="ecs-inner-wrapper">
                    <div class="ecs-contact-top-wrap">
                        <?php if ( $contact_us_title != '' ) { ?><h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3><?php } ?>
                        <div class="ecs-content-description">
                            <?php echo $contact_us_description; ?>
                        </div>
                        <div class="ecs-contact-info-outer-wrap ecs-clearfix">
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-title"><?php echo $address_label; ?></div>
                                <div class="ecs-contact-details">
                                    <p>
                                        <?php echo str_replace(',', ',<br/>', $address_value); ?>
                                    </p>
                                </div>
                            </div>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-title"><?php echo $phone_label; ?></div>
                                <div class="ecs-contact-details">
                                    <?php
                                    $phone_value_array = explode(',', $phone_value);
                                    foreach ( $phone_value_array as $phone_value ) {
                                        ?>
                                        <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="ecs-contact-bottom-wrap">
                        <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                            <div class="ecs-input-wrap">
                                <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                                <div class="ecs-contact-error ecs-name-error"></div>
                            </div>
                            <div class="ecs-input-wrap">
                                <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                                <div class="ecs-contact-error ecs-email-error"></div>
                            </div>
                            <div class="ecs-input-wrap">
                                <textarea placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                                <div class="ecs-contact-error ecs-message-error"></div>
                            </div>
                            <button type="submit" class="ecs-button ecs-email-send"><?php echo $submit_button_label; ?></button>
                            <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                            <div class="ecs-email-message"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if ( $footer_text != '' ) { ?>
        <footer class="ecs-footer">
            <div class="ecs-copyright-info">
                <?php echo $footer_text; ?>
            </div>
        </footer>
    <?php } ?>
</div>