<div class="ecs-templates-wrap animated fadeIn">
    <div class="ecs-section ecs-intro-section">
        <div class="ecs-container ecs-clearfix">
            <div class="ecs-intro-left-section">
                <div class="ecs-intro-content-title animated slideInLeft">
                    <?php if ( $header_text != '' ) { ?><h2><?php echo $header_text; ?></h2><?php } ?>
                </div>
                <?php if ( $site_short_description != '' ) { ?>
                    <div class="ecs-intro-description animated slideInLeft">
                        <?php echo $site_short_description; ?>
                    </div>
                <?php } ?>
                <?php if ( $loader_percentage != '' ) { ?>
                    <div class="ecs-progress-bar animated slideInLeft">
                        <div class="ecs-progress-bar-length" style="width:<?php echo $loader_percentage; ?>%">
                            <span class="ecs-progress-count"><?php echo $loader_label; ?></span>
                        </div>
                    </div>
                <?php } ?>
                <div class="ecs-section-link-wrap ecs-clearfix">
                    <a href="#ecs-subscription-active" class="ecs-subscription-link ecs-id-link animated slideInLeft"><?php echo (!empty($template_settings[ 'template_6' ][ 'subscribe_button_label' ])) ? esc_attr($template_settings[ 'template_6' ][ 'subscribe_button_label' ]) : __('Subscribe', 'everest-coming-soon'); ?></a>
                    <a href="#ecs-launch-active" class="ecs-launch-link ecs-id-link animated slideInUp"><?php echo (!empty($template_settings[ 'template_6' ][ 'launch_button_label' ])) ? esc_attr($template_settings[ 'template_6' ][ 'launch_button_label' ]) : __('Launch', 'everest-coming-soon'); ?></a>
                    <a href="#ecs-contact-active" class="ecs-contact-link ecs-id-link animated slideInRight"><?php echo (!empty($template_settings[ 'template_6' ][ 'contact_button_label' ])) ? esc_attr($template_settings[ 'template_6' ][ 'contact_button_label' ]) : __('Contact', 'everest-coming-soon'); ?></a>
                </div>
                <?php
                if ( !empty($social_networks) ) {
                    ?>
                    <div class="ecs-social-share-wrap animated fadeInUp">
                        <?php
                        foreach ( $social_networks as $social_network => $url ) {
                            if ( $url != '' ) {
                                ?>
                                <a href="<?php echo $url; ?>" class="ecs-social-icon ecs-<?php echo $social_network; ?>">
                                    <i class="fa fa-<?php echo $social_network; ?>"></i>
                                </a>
                                <?php
                            }
                        }
                        ?>
                    </div>
                <?php } ?>
            </div>
            <div class="ecs-intro-right-section animated slideInRight">
                <?php if ( !empty($template_settings[ 'template_6' ][ 'mobile_image' ]) ) {
                    ?>
                    <img src="<?php echo esc_url($template_settings[ 'template_6' ][ 'mobile_image' ]); ?>">

                    <?php
                } else {
                    ?>
                    <img src="<?php echo ECS_IMG_DIR; ?>the_mobile.png">

                    <?php
                }
                ?>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-subscription-section" id="ecs-subscription-active">
        <span class="ecs-close"></span>
        <div class="ecs-section-content ecs-subscription-content">
            <?php if ( $subscription_title != '' ) { ?><h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3><?php } ?>
            <?php if ( $subscription_description != '' ) { ?>
                <div class="ecs-content-description">
                    <?php echo $subscription_description; ?>
                </div>
            <?php } ?>
            <div class="ecs-subscription-form-wrap">
                <form id="ecs-subscription-form" class="ecs-clearfix" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                    <div class="ecs-input-wrap">
                        <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                    </div>
                    <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                    <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                    <div class="ecs-subscription-message"></div>
                </form>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-launch-section" id="ecs-launch-active">
        <span class="ecs-close"></span>
        <div class="ecs-section-content ecs-launch-content">
            <?php if ( $countdown_title != '' ) { ?><h3 class="ecs-section-content-title"><?php echo $countdown_title; ?></h3><?php } ?>
            <div class="ecs-countdown-wrap">
                <div class="ecs-timer-wrap" data-timer-day-color="#fff" data-timer-hour-color="#fff" data-timer-minute-color="#fff" data-timer-second-color="#fff" data-timer-bgcolor="rgba(255,255,255,0.3)">
                    <?php include(ECS_PATH . 'inc/views/frontend/components/circle-timer.php'); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section" id="ecs-contact-active">
        <span class="ecs-close"></span>
        <div class="ecs-section-content ecs-contact-content">
            <?php if ( $contact_us_title != '' ) { ?><h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3><?php } ?>
            <?php if ( $contact_us_description != '' ) { ?>
                <div class="ecs-content-description">
                    <?php echo $contact_us_description; ?>
                </div>
            <?php } ?>
            <div class="ecs-contact-info-wrap ecs-clearfix">
                <?php if ( $phone_value != '' ) { ?>
                    <div class="ecs-contact-info ecs-phone-details">
                        <div class="ecs-contact-info-title"><?php echo $phone_label; ?></div>
                        <?php
                        $phone_value_array = explode(',', $phone_value);
                        foreach ( $phone_value_array as $phone_value ) {
                            ?>
                            <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                            <?php
                        }
                        ?>
                    </div>
                <?php } ?>
                <?php if ( $email_value != '' ) { ?>
                    <div class="ecs-contact-info ecs-mailing-details">
                        <div class="ecs-contact-info-title"><?php echo $email_label; ?></div>

                        <?php
                        $email_value_array = explode(',', $email_value);
                        foreach ( $email_value_array as $email_value ) {
                            ?>
                            <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a>
                                <?php
                            }
                            ?>
                        </p>
                    </div>
                    <?php
                }
                if ( $address_value != '' ) {
                    ?>
                    <div class="ecs-contact-info ecs-address-details">
                        <div class="ecs-contact-info-title"><?php echo $address_label; ?></div>
                        <p>
                            <?php echo str_replace(',', ',<br/>', $address_value); ?>

                        </p>
                    </div>
                <?php } ?>
            </div>
            <div class="ecs-contact-form-wrap">
                <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                    <div class="ecs-input-wrap">
                        <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                        <div class="ecs-contact-error ecs-name-error"></div>
                    </div>
                    <div class="ecs-input-wrap">
                        <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                        <div class="ecs-contact-error ecs-email-error"></div>
                    </div>
                    <div class="ecs-input-wrap">
                        <textarea  placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                        <div class="ecs-contact-error ecs-message-error"></div>
                    </div>
                    <button type="submit" class="ecs-button"><?php echo $submit_button_label; ?></button>
                    <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                    <div class="ecs-email-message"></div>
                </form>
            </div>
        </div>
    </div>
</div>



