<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section">
        <div class="ecs-intro-content-wrap">
            <div class="ecs-container">
                <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                    <div class="ecs-logo-wrapper animated fadeInDown">
                        <a href="<?php echo site_url(); ?>">
                            <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                        </a>
                    </div>
                <?php } ?>
                <div class="ecs-intro-content-title animated fadeInDown">
                    <?php if ( $header_text != '' ) { ?><h2><?php echo $header_text; ?></h2><?php } ?>
                </div>
                <div class="ecs-countdown-wrap animated zoomIn">
                    <?php
                    include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                    ?>
                </div>
                <div class="ecs-subscription-form-wrap animated fadeInUp">
                    <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>

                <div class="ecs-scrolldown animated fadeInDown">
                    <div class="ecs-mouse">
                    </div>
                    <i class="fa fa-angle-down"></i>
                </div>

            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section" id="ecs-contact-section">
        <div class="ecs-container ecs-clearfix">
            <div class="ecs-map-wrap">
                <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
            </div>
            <div class="ecs-contact-content">
                <div class="ecs-contact-top-wrap">
                    <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                    <div class="ecs-contact-info-outer-wrap ecs-clearfix">
                        <div class="ecs-contact-info">
                            <div class="ecs-contact-info-title"><?php echo $address_label; ?></div>
                            <div class="ecs-contact-details">
                                <?php echo str_replace(',', ',<br/>', $address_value); ?>
                            </div>
                        </div>
                        <div class="ecs-contact-info">
                            <div class="ecs-contact-info-title"><?php echo $phone_label; ?></div>
                            <div class="ecs-contact-details">
                                <?php
                                $phone_value_array = explode(',', $phone_value);
                                foreach ( $phone_value_array as $phone_value ) {
                                    ?>
                                    <span><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></span>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="ecs-contact-info">
                            <div class="ecs-contact-info-title"><?php echo $email_label; ?></div>
                            <div class="ecs-contact-details">
                                <?php
                                $email_value_array = explode(',', $email_value);
                                foreach ( $email_value_array as $email_value ) {
                                    ?>
                                    <span><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></span>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ecs-contact-bottom-wrap">
                    <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                            <div class="ecs-contact-error ecs-name-error"></div>
                        </div>
                        <div class="ecs-input-wrap">
                            <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                            <div class="ecs-contact-error ecs-email-error"></div>
                        </div>
                        <div class="ecs-input-wrap">
                            <textarea placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                            <div class="ecs-contact-error ecs-message-error"></div>
                        </div>
                        <button type="submit" class="ecs-button ecs-email-send"><?php echo $submit_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                        <div class="ecs-email-message"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>