<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-left-section" id="ecs-temp-3-left">
        <div class="ecs-container">
            <div class="ecs-section-inner-container">
                <h3 class="ecs-section-content-title"><?php echo $about_us_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $about_us_description; ?>
                </div>
            </div>
            <?php
            if ( !empty($social_networks) ) {
                ?>
                <div class="ecs-social-share-wrap">
                    <?php
                    foreach ( $social_networks as $social_network => $url ) {
                        if ( $url != '' ) {
                            ?>
                            <a href="<?php echo $url; ?>" class="ecs-social-icon ecs-<?php echo $social_network; ?>">
                                <i class="fa fa-<?php echo $social_network; ?>"></i>
                            </a>
                            <?php
                        }
                    }
                    ?>
                </div>
            <?php } ?>
        </div>
        <div class="ecs-navigation-wrap">
            <a class="ecs-navigation-arrow ecs-right-arrow ecs-id-link" href="#ecs-temp-3-middle">
                <span><i class="fa fa-angle-right"></i></span>
            </a>
        </div>
    </div>
    <div class="ecs-section ecs-middle-section ecs-active-section" id="ecs-temp-3-middle">
        <div class="ecs-container">
            <div class="ecs-section-inner-container">
                <h2 class="ecs-middle-content-title animated fadeInDown"><?php echo $header_text; ?></h2>
                <div class="ecs-content-description animated fadeInDown">
                    <?php echo $site_short_description; ?>
                </div>
                <div class="ecs-countdown-wrap ecs-clearfix animated fadeIn">
                    <?php
                    include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                    ?>
                </div>
                <div class="ecs-subscription-form-wrap animated slideInUp">
                    <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap ecs-email-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>
            </div>
        </div>
        <div class="ecs-navigation-wrap">
            <a class="ecs-navigation-arrow ecs-left-arrow ecs-id-link animated fadeInRight" href="#ecs-temp-3-left">
                <span><i class="fa fa-info"></i></span>
            </a>
            <a class="ecs-navigation-arrow ecs-right-arrow ecs-id-link animated fadeInLeft" href="#ecs-temp-3-right">
                <span><i class="fa fa-envelope"></i></span>
            </a>
        </div>
    </div>
    <div class="ecs-section ecs-right-section" id="ecs-temp-3-right">
        <div class="ecs-container">
            <div class="ecs-section-inner-container">
                <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $contact_us_description; ?>
                </div>
                <div class="ecs-contact-bottom-wrap ecs-clearfix">
                    <div class="ecs-left-contact-wrap">
                        <?php if ( $email_value != '' ) { ?>
                            <div class="ecs-contact-info ecs-address-details">
                                <div class="ecs-contact-info-inner-wrap ecs-clearfix">
                                    <div class="ecs-contact-icon">
                                        <i class="fa fa-envelope"></i>
                                    </div>
                                    <?php
                                    $email_value_array = explode(',', $email_value);
                                    foreach ( $email_value_array as $email_value ) {
                                        ?>
                                        <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></p>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                            <?php
                        }
                        if ( $phone_value != '' ) {
                            ?>
                            <div class="ecs-contact-info ecs-mailing-details">
                                <div class="ecs-contact-info-inner-wrap ecs-clearfix">
                                    <div class="ecs-contact-icon">
                                        <i class="fa fa-phone"></i>
                                    </div>
                                    <?php
                                    $phone_value_array = explode(',', $phone_value);
                                    foreach ( $phone_value_array as $phone_value ) {
                                        ?>
                                        <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                            <?php
                        }

                        if ( $address_value != '' ) {
                            ?>
                            <div class="ecs-contact-info ecs-phone-details">
                                <div class="ecs-contact-info-inner-wrap ecs-clearfix">
                                    <div class="ecs-contact-icon">
                                        <i class="fa fa-map-marker"></i>
                                    </div>
                                    <p>
                                        <?php echo str_replace(',', '<br/>', $address_value); ?>
                                    </p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="ecs-right-contact-wrap">
                        <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                            <div class="ecs-input-wrap ecs-name-wrap">
                                <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                                <div class="ecs-contact-error ecs-name-error"></div>
                            </div>
                            <div class="ecs-input-wrap ecs-email-wrap">
                                <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                                <div class="ecs-contact-error ecs-email-error"></div>
                            </div>
                            <div class="ecs-input-wrap ecs-message-wrap">
                                <textarea name="contact_message" placeholder="<?php echo $message_field_label; ?>"></textarea>
                                <div class="ecs-contact-error ecs-message-error"></div>
                            </div>
                            <button type="submit" class="ecs-button"><?php echo $submit_button_label; ?></button>
                            <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                            <div class="ecs-email-message"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="ecs-navigation-wrap">
            <a class="ecs-navigation-arrow ecs-left-arrow ecs-id-link" href="#ecs-temp-3-middle">
                <span><i class="fa fa-angle-left"></i></span>
            </a>
        </div>
    </div>
</div>