<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section" id="ecs-intro-active">
        <div class="ecs-intro-content-wrap">
            <div class="ecs-container">
                <div class="ecs-intro-content-title animated zoomIn">
                    <?php if ( $header_text != '' ) { ?>
                        <h2><?php echo $header_text; ?></h2>
                    <?php } ?>
                </div>
                <div class="ecs-countdown-wrap animated fadeIn">
                    <div class="ecs-timer-wrap" data-timer-day-color="#aaa" data-timer-hour-color="#fff" data-timer-minute-color="#bbb" data-timer-second-color="#ccc" data-timer-bgcolor="rgb(255,255,255,0.5)">
                        <?php include(ECS_PATH . 'inc/views/frontend/components/circle-timer.php'); ?>
                    </div>
                </div>
                <nav>
                    <ul class="ecs-menu ecs-clearfix">
                        <?php if ( !empty($template_settings[ 'template_15' ][ 'contact_button_label' ]) ) { ?>
                            <li class="ecs-menu-contact animated fadeIn"><a href="#ecs-contact-active" class="ecs-scroll-trigger"><?php echo esc_attr($template_settings[ 'template_15' ][ 'contact_button_label' ]); ?></a></li>
                            <?php
                        }
                        if ( !empty($template_settings[ 'template_15' ][ 'subscribe_button_label' ]) ) {
                            ?>
                            <li class="ecs-menu-subscribe animated fadeIn"><a href="#ecs-subscription-active" class="ecs-scroll-trigger"><?php echo esc_attr($template_settings[ 'template_15' ][ 'subscribe_button_label' ]); ?></a></li>
                            <?php
                        }
                        if ( !empty($template_settings[ 'template_15' ][ 'location_button_label' ]) ) {
                            ?>
                            <li class="ecs-menu-location animated fadeIn"><a href="#ecs-location-active" class="ecs-scroll-trigger"><?php echo esc_attr($template_settings[ 'template_15' ][ 'location_button_label' ]); ?></a></li>
                        <?php } ?>
                    </ul>
                </nav>

                <div class="ecs-scrolldown animated fadeInDown">
                    <div class="ecs-mouse">
                    </div>
                    <i class="fa fa-angle-down"></i>
                </div>

            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section" id="ecs-contact-active">
        <div class="ecs-contact-content">
            <div class="ecs-contact-top-wrap">
                <div class="ecs-container">
                    <?php if ( $get_in_touch_title != '' ) { ?>
                        <h3 class="ecs-section-content-title"><?php echo $get_in_touch_title; ?></h3>
                    <?php } ?>
                    <div class="ecs-contact-info-outer-wrap ecs-clearfix">
                        <?php if ( $address_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <div class="ecs-contact-icon">
                                        <i class="fa fa-map-marker"></i>
                                        <span><?php echo $address_label; ?></span>
                                    </div>
                                    <div class="ecs-contact-details">
                                        <?php echo str_replace(',', ',<br/>', $address_value); ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        if ( $phone_value != '' ) {
                            ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <div class="ecs-contact-icon">
                                        <i class="fa fa-phone"></i>
                                        <span><?php echo $phone_label; ?></span>
                                    </div>
                                    <div class="ecs-contact-details">
                                        <?php
                                        $phone_value_array = explode(',', $phone_value);
                                        foreach ( $phone_value_array as $phone_value ) {
                                            ?>
                                            <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        if ( $email_value != '' ) {
                            ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <div class="ecs-contact-icon">
                                        <i class="fa fa-envelope"></i>
                                        <span><?php echo $email_label; ?></span>
                                    </div>
                                    <div class="ecs-contact-details">
                                        <?php
                                        $email_value_array = explode(',', $email_value);
                                        foreach ( $email_value_array as $email_value ) {
                                            ?>
                                            <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></p>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="ecs-contact-bottom-wrap">
                <div class="ecs-container ecs-clearfix">
                    <?php if ( $contact_us_title != '' ) { ?>
                        <h3 class="ecs-contact-bottom-title"><?php echo $contact_us_title; ?></h3>
                    <?php } ?>
                    <?php if ( $contact_us_description != '' ) { ?>
                        <div class="ecs-content-bottom-description">
                            <?php echo $contact_us_description; ?>
                        </div>
                    <?php } ?>
                    <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                        <div class="ecs-input-top-wrap">
                            <div class="ecs-input-outer-wrapper ecs-clearfix">
                                <div class="ecs-input-wrap">
                                    <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                                    <div class="ecs-contact-error ecs-name-error"></div>
                                </div>
                                <div class="ecs-input-wrap">
                                    <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                                    <div class="ecs-contact-error ecs-email-error"></div>
                                </div>
                            </div>
                            <div class="ecs-input-wrap">
                                <textarea placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                                <div class="ecs-contact-error ecs-message-error"></div>
                            </div>
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $submit_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                        <div class="ecs-email-message"></div>
                    </form>
                </div>
            </div>
        </div>

    </div>
    <div class="ecs-section ecs-subscription-section" id="ecs-subscription-active">
        <div class="ecs-container">
            <div class="ecs-subscription-content">
                <?php if ( $subscription_title != '' ) { ?>
                    <h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3>
                <?php } ?>
                <?php if ( $subscription_description != '' ) { ?>
                    <div class="ecs-content-description">
                        <?php echo $subscription_description; ?>
                    </div>
                <?php } ?>
                <div class="ecs-subscription-form-wrap">
                    <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-location-section" id="ecs-location-active">
        <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
    </div>
</div>