<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section animated fadeIn" id="ecs-intro-active">
        <div class="ecs-container">
            <header class="main-header ecs-clearfix ecs-sticky-header">
                <div class="ecs-logo-wrapper animated slideInLeft">
                    <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                        <a href="<?php echo site_url(); ?>">
                            <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                        </a>
                    <?php } ?>
                </div>
                <nav class="ecs-menu-wrap">
                    <ul class="ecs-menu ecs-clearfix animated slideInRight">
                        <li><a href="#ecs-intro-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_14' ][ 'home_menu_label' ])) ? esc_attr($template_settings[ 'template_14' ][ 'home_menu_label' ]) : __('Home', 'everest-coming-soon'); ?></a></li>
                        <li><a href="#ecs-counter-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_14' ][ 'counter_menu_label' ])) ? esc_attr($template_settings[ 'template_14' ][ 'counter_menu_label' ]) : __('Counter', 'everest-coming-soon'); ?></a></li>
                        <li><a href="#ecs-subscription-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_14' ][ 'subscribe_menu_label' ])) ? esc_attr($template_settings[ 'template_14' ][ 'subscribe_menu_label' ]) : __('Subscribe', 'everest-coming-soon'); ?></a></li>
                        <li><a href="#ecs-contact-active" class="ecs-scroll-trigger"><?php echo (!empty($template_settings[ 'template_14' ][ 'contact_menu_label' ])) ? esc_attr($template_settings[ 'template_14' ][ 'contact_menu_label' ]) : __('Contact', 'everest-coming-soon'); ?></a></li>
                    </ul>
                </nav>
            </header>
            <div class="ecs-intro-content-wrap">
                <div class="ecs-intro-content-title animated fadeIn">
                    <?php if ( !empty($component_settings[ 'header_text' ]) ) { ?>
                        <h2><?php echo $component_settings[ 'header_text' ]; ?></h2>
                    <?php }
                    ?>
                </div>
                <?php if ( !empty($component_settings[ 'site_short_description' ]) ) { ?>
                    <div class="ecs-intro-description animated fadeIn">
                        <?php echo $component_settings[ 'site_short_description' ]; ?>
                    </div>
                <?php } ?>
                <div class="ecs-progress-bar animated fadeIn">
                    <div class="ecs-progress-bar-length" style="width:<?php echo $loader_percentage; ?>%">
                        <span class="ecs-progress-count"><?php echo $loader_label; ?></span>
                    </div>
                </div>
            </div>
            <footer>
                <?php
                if ( !empty($social_networks) ) {
                    ?>
                    <div class="ecs-social-share-wrap animated slideInUp">
                        <?php
                        foreach ( $social_networks as $social_network => $url ) {
                            if ( $url != '' ) {
                                ?>
                                <a href="<?php echo $url; ?>" class="ecs-social-icon">
                                    <i class="fa fa-<?php echo $social_network; ?>"></i>
                                </a>
                                <?php
                            }
                        }
                        ?>
                    </div>
                <?php } ?>
                <?php if ( $footer_text != '' ) { ?>
                    <div class="ecs-copyright-info animated slideInUp">
                        <?php echo $footer_text; ?>
                    </div>
                <?php } ?>
            </footer>
        </div>
    </div>
    <div class="ecs-section ecs-counter-section" id="ecs-counter-active">
        <div class="ecs-container">
            <h3 class="ecs-section-content-title"><?php echo $countdown_title; ?></h3>
            <div class="ecs-content-description">
                <?php echo $countdown_short_description; ?>
            </div>
            <div class="ecs-countdown-wrap">
                <?php
                include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                ?>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-subscription-section" id="ecs-subscription-active">
        <div class="ecs-container">
            <div class="ecs-subscription-content">
                <h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $subscription_description; ?>
                </div>
                <div class="ecs-subscription-form-wrap">
                    <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><i class="fa fa-envelope-o"></i></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section" id="ecs-contact-active">
        <div class="ecs-contact-content">
            <div class="ecs-contact-top-wrap">
                <div class="ecs-container">
                    <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                    <div class="ecs-content-description">
                        <?php echo $contact_us_description; ?>
                    </div>
                    <div class="ecs-contact-info-outer-wrap  ecs-clearfix">
                        <?php if ( $phone_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <span class="ecs-contact-icon">
                                        <i class="fa fa-phone"></i>
                                    </span>
                                    <div class="ecs-contact-details">
                                        <p><?php echo $phone_label; ?></p>
                                        <?php
                                        $phone_value_array = explode(',', $phone_value);
                                        foreach ( $phone_value_array as $phone_value ) {
                                            ?>
                                            <span><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></span>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if ( $email_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <span class="ecs-contact-icon">
                                        <i class="fa fa-envelope"></i>
                                    </span>
                                    <div class="ecs-contact-details">
                                        <p><?php echo $email_label; ?></p>
                                        <?php
                                        $email_value_array = explode(',', $email_value);
                                        foreach ( $email_value_array as $email_value ) {
                                            ?>
                                            <span><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></span>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if ( $address_value != '' ) { ?>
                            <div class="ecs-contact-info">
                                <div class="ecs-contact-info-wrap ecs-clearfix">
                                    <span class="ecs-contact-icon">
                                        <i class="fa fa-home"></i>
                                    </span>
                                    <div class="ecs-contact-details">
                                        <p><?php echo $address_label; ?></p>
                                        <span><?php echo str_replace(',', '<br/>', $address_value); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="ecs-contact-bottom-wrap">
                <div class="ecs-container ecs-clearfix">
                    <div class="ecs-left-contact-wrap">
                        <?php if ( $social_network_title != '' ) { ?>
                            <h3 class="ecs-contact-bottom-title"><?php echo $social_network_title; ?></h3>
                        <?php } ?>
                        <?php if ( $social_network_short_description != '' ) { ?>
                            <div class="ecs-content-bottom-description">
                                <?php echo $social_network_short_description; ?>
                            </div>
                        <?php } ?>
                        <?php
                        if ( !empty($social_networks) ) {
                            ?>
                            <div class="ecs-social-share-wrap">
                                <?php
                                foreach ( $social_networks as $social_network => $url ) {
                                    if ( $url != '' ) {
                                        ?>
                                        <a href="<?php echo $url; ?>" class="ecs-social-icon">
                                            <i class="fa fa-<?php echo $social_network; ?>"></i>
                                        </a>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="ecs-right-contact-wrap">
                        <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                            <div class="ecs-input-wrap">
                                <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                                <div class="ecs-contact-error ecs-name-error"></div>
                            </div>
                            <div class="ecs-input-wrap">
                                <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                                <div class="ecs-contact-error ecs-email-error"></div>
                            </div>
                            <div class="ecs-input-wrap">
                                <textarea placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                                <div class="ecs-contact-error ecs-message-error"></div>
                            </div>
                            <button type="submit" class="ecs-button"><?php echo $submit_button_label; ?></button>
                            <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                            <div class="ecs-email-message"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>