<div class="ecs-templates-wrap">
    <div class="ecs-section ecs-intro-section" id="ecs-intro-active">
        <header class="main-header ecs-clearfix">
            <div class="ecs-logo-wrapper animated fadeIn">
                <?php if ( !empty($component_settings[ 'logo' ]) ) { ?>
                    <a href="<?php echo site_url(); ?>">
                        <img src="<?php echo esc_url($component_settings[ 'logo' ]); ?>">
                    </a>
                <?php } ?>
            </div>
            <nav>
                <ul class="ecs-menu ecs-clearfix">
                    <li class="ecs-menu-subscribe animated fadeIn"><a href="javascript:void(0);" class="ecs-section-trigger" data-section-id="subscription"><?php echo (!empty($template_settings[ 'template_13' ][ 'subscribe_menu_label' ])) ? esc_attr($template_settings[ 'template_13' ][ 'subscribe_menu_label' ]) : ''; ?></a></li>
                    <li class="ecs-menu-contact animated fadeIn"><a href="javascript:void(0);" class="ecs-section-trigger" data-section-id="contact"><?php echo (!empty($template_settings[ 'template_13' ][ 'contact_label' ])) ? esc_attr($template_settings[ 'template_13' ][ 'contact_label' ]) : ''; ?></a></li>
                    <li class="ecs-menu-location animated fadeIn"><a href="javascript:void(0);" class="ecs-section-trigger" data-section-id="location"><?php echo (!empty($template_settings[ 'template_13' ][ 'location_label' ])) ? esc_attr($template_settings[ 'template_13' ][ 'location_label' ]) : ''; ?></a></li>
                </ul>
            </nav>
        </header>
        <div class="ecs-intro-content-wrap">
            <div class="ecs-intro-content-title animated zoomIn">
                <?php if ( !empty($component_settings[ 'header_text' ]) ) { ?>
                    <h2><?php echo $component_settings[ 'header_text' ]; ?></h2>
                <?php }
                ?>
            </div>
            <?php
            if ( !empty($component_settings[ 'countdown_expiry_date' ]) ) {
                ?>
                <div class="ecs-countdown-wrap animated fadeIn">
                    <?php
                    include(ECS_PATH . 'inc/views/frontend/components/timer.php');
                    ?>
                </div>
                <?php
            }
            if ( $loader_percentage != '' ) {
                ?>
                <div class="ecs-progress-bar animated fadeIn">
                    <div class="ecs-progress-bar-length" style="width:<?php echo $loader_percentage; ?>%">
                        <span class="ecs-progress-count"><?php echo $loader_label; ?></span>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <div class="ecs-section ecs-subscription-section" id="ecs-subscription-active">
        <div class="ecs-container">
            <span class="ecs-close">
            </span>
            <div class="ecs-subscription-content">
                <h3 class="ecs-section-content-title"><?php echo $subscription_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $subscription_description; ?>
                </div>
                <div class="ecs-subscription-form-wrap">
                    <form id="ecs-subscription-form" data-subscription-error-message="<?php echo $subscribe_required_message; ?>">
                        <div class="ecs-input-wrap">
                            <input type="email" name="email" placeholder="<?php echo $subscription_email_field_label; ?>" />
                        </div>
                        <button type="submit" class="ecs-button"><?php echo $subscribe_button_label; ?></button>
                        <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-subscribe-loader" style="display:none;"/>
                        <div class="ecs-subscription-message"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-contact-section" id="ecs-contact-active">
        <div class="ecs-container">
            <span class="ecs-close">
            </span>
            <div class="ecs-contact-content">
                <h3 class="ecs-section-content-title"><?php echo $contact_us_title; ?></h3>
                <div class="ecs-content-description">
                    <?php echo $contact_us_description; ?>
                </div>
                <div class="ecs-contact-bottom-wrap ecs-clearfix">
                    <div class="ecs-left-contact-wrap">
                        <?php if ( $phone_value != '' ) { ?>
                            <div class="ecs-contact-info ecs-clearfix">
                                <span class="ecs-contact-icon">
                                    <i class="fa fa-mobile"></i>
                                </span>
                                <?php
                                $phone_value_array = explode(',', $phone_value);
                                foreach ( $phone_value_array as $phone_value ) {
                                    ?>
                                    <p><a href="tel:<?php echo $phone_value; ?>"><?php echo $phone_value; ?></a></p>
                                    <?php
                                }
                                ?>
                            </div>
                        <?php } ?>
                        <?php if ( $address_value != '' ) { ?>
                            <div class="ecs-contact-info ecs-clearfix">
                                <span class="ecs-contact-icon">
                                    <i class="fa fa-map-marker"></i>
                                </span>
                                <p>
                                    <?php echo str_replace(',', '<br/>', $address_value); ?>
                                </p>
                            </div>
                        <?php } ?>
                        <?php if ( $address_value != '' ) { ?>
                            <div class="ecs-contact-info ecs-clearfix">
                                <span class="ecs-contact-icon">
                                    <i class="fa  fa-envelope-o"></i>
                                </span>
                                <?php
                                $email_value_array = explode(',', $email_value);
                                foreach ( $email_value_array as $email_value ) {
                                    ?>
                                    <p><a href="mailto:<?php echo $email_value; ?>"><?php echo $email_value; ?></a></p>
                                    <?php
                                }
                                ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="ecs-right-contact-wrap">
                        <form class="ecs-email-form" data-form-error-message="<?php echo $contact_required_message; ?>">
                            <div class="ecs-input-wrap">
                                <input type="text" name="contact_name" placeholder="<?php echo $name_field_label; ?>" />
                                <div class="ecs-contact-error ecs-name-error"></div>
                            </div>
                            <div class="ecs-input-wrap">
                                <input type="email" name="contact_email" placeholder="<?php echo $email_field_label; ?>" />
                                <div class="ecs-contact-error ecs-email-error"></div>
                            </div>
                            <div class="ecs-input-wrap">
                                <textarea placeholder="<?php echo $message_field_label; ?>" name="contact_message"></textarea>
                            </div>
                            <div class="ecs-contact-error ecs-message-error"></div>
                            <button type="submit" class="ecs-button ecs-email-send"><?php echo $submit_button_label; ?></button>
                            <img src="<?php echo ECS_IMG_DIR . 'ajax-loader.gif' ?>" class="ecs-email-loader" style="display:none;"/>
                            <div class="ecs-email-message"></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="ecs-section ecs-location-section" id="ecs-location-active">
        <span class="ecs-close">
        </span>
        <?php include(ECS_PATH . 'inc/views/frontend/components/google-map.php'); ?>
    </div>
</div>